
WORLDVIEW_TEMPLATE = """
# 基本信息(Basic Information)
Name: str  # 世界名称
Type: str  # 世界类型(现实/奇幻/科幻等)
Time_Period: str  # 时间背景(远古/中世纪/现代/未来等)
Creation_Myth: Optional[str]  # 创世神话/起源故事
Age: Optional[str]  # 世界年龄/历史长度
Cosmology: Optional[str]  # 宇宙构成(位面/次元/平行宇宙等)
Scale: Optional[str]  # 世界规模(星系/行星/大陆/城市等)

# 物理法则(Physical Laws)
Natural_Laws: Dict[str, str]  # 自然法则(重力/时间等如何运作)
Magic_System: Optional[Dict[str, str]]  # 魔法系统及规则
Technology_Level: str  # 科技水平及特点
Supernatural_Elements: Optional[List[str]]  # 超自然元素(神力/异能等)
Unique_Phenomena: Optional[List[str]]  # 独特现象(特殊天气/异常区域等)
Energy_Sources: Optional[Dict[str, str]]  # 能源形式及其影响

# 地理环境(Geography)
Major_Locations: List[Dict[str, str]]  # 主要地点(国家/城市/特殊区域)
Terrain_Features: List[str]  # 地形特征(山脉/海洋/森林等)
Climate: str  # 气候系统
Notable_Landmarks: Optional[List[str]]  # 著名地标
Resources: Optional[Dict[str, str]]  # 重要资源及分布
Natural_Hazards: Optional[List[Dict]]  # 自然灾害/危险区域
Ecological_Cycles: Optional[Dict]  # 生态循环(季节变化/潮汐等)

# 生物与种族(Species)
Dominant_Species: List[str]  # 主要种族/物种
Species_Relations: Optional[Dict[str, str]]  # 种族间关系
Ecosystem: Optional[str]  # 生态系统特点
Unique_Creatures: Optional[List[Dict]]  # 独特生物/怪物
Sentient_Beings: List[Dict[str, str]]  # 智慧生物特性
Evolution_Patterns: Optional[Dict]  # 进化模式/物种起源
Biological_Hierarchies: Optional[Dict]  # 生物链/食物链

# 社会结构(Society)
Political_Systems: Dict[str, str]  # 政治体系
Economic_Systems: Dict[str, str]  # 经济体系
Social_Classes: List[str]  # 社会阶层
Power_Structures: Dict[str, str]  # 权力结构(谁掌权及如何掌权)
Legal_Systems: Optional[Dict[str, str]]  # 法律体系
Major_Organizations: Optional[List[Dict]]  # 主要组织/机构
Education_Systems: Optional[Dict]  # 教育体系
Healthcare_Systems: Optional[Dict]  # 医疗体系
Family_Structures: Optional[Dict]  # 家庭结构/血缘关系

# 文化与信仰(Culture)
Religions: Optional[List[Dict]]  # 宗教信仰
Philosophies: Optional[List[Dict]]  # 哲学思想
Traditions: List[Dict]  # 传统习俗
Arts: Optional[Dict[str, str]]  # 艺术形式
Languages: List[Dict]  # 语言系统
Values: Dict[str, str]  # 核心价值观
Entertainment: Optional[List[Dict]]  # 娱乐形式
Cuisine: Optional[Dict]  # 饮食文化
Fashion: Optional[Dict]  # 服饰/时尚
Cultural_Taboos: Optional[List[str]]  # 文化禁忌

# 历史背景(History)
Historical_Timeline: Dict[str, List[Dict]]  # 按时间顺序排列的历史事件总览

Eras_And_Ages: List[Dict[str, Any]]  # 历史时期/朝代
    # 每个时代包含:
    # - Name: str  # 时代名称
    # - Time_Span: str  # 时间跨度
    # - Defining_Characteristics: List[str]  # 定义特征
    # - Major_Powers: List[str]  # 主要势力
    # - Cultural_Hallmarks: List[str]  # 文化标志
    # - Technological_Level: str  # 科技水平
    # - Transition_Causes: Optional[str]  # 时代转变原因

Major_Events: List[Dict[str, Any]]  # 重大历史事件
    # 每个事件包含:
    # - Name: str  # 事件名称
    # - Date: str  # 发生日期/时间段
    # - Location: str  # 发生地点
    # - Background: str  # 历史背景/前因
    # - Catalysts: List[str]  # 催化因素/直接原因
    # - Key_Figures: List[Dict]  # 关键人物及其角色
    # - Course_Of_Events: List[Dict]  # 事件经过/发展阶段
    # - Outcome: str  # 直接结果/结局
    # - Short_Term_Impacts: List[Dict]  # 短期影响
    # - Long_Term_Consequences: List[Dict]  # 长期影响
    # - Different_Perspectives: Optional[Dict]  # 不同方的观点
    # - Commemoration: Optional[str]  # 纪念方式
    # - Modern_Relevance: str  # 对当前世界的影响/意义

Conflicts_And_Wars: List[Dict[str, Any]]  # 重大冲突/战争
    # 每场战争包含:
    # - Name: str  # 战争名称
    # - Time_Period: str  # 时间段
    # - Belligerents: Dict[str, List[str]]  # 交战方及盟友
    # - Causes: Dict  # 战争原因(政治/经济/宗教等)
    # - Initial_State: Dict  # 开战时各方状况
    # - Major_Battles: List[Dict]  # 主要战役
    # - Turning_Points: List[Dict]  # 战局转折点
    # - Military_Innovations: Optional[List]  # 军事创新/战术发展
    # - Civilian_Impact: Dict  # 对平民的影响
    # - Peace_Process: Optional[Dict]  # 和平进程
    # - Resolution: Dict  # 战争结局
    # - Territorial_Changes: Optional[Dict]  # 领土变更
    # - Power_Shifts: Dict  # 权力转移
    # - Economic_Consequences: Dict  # 经济后果
    # - Cultural_Impact: Dict  # 文化影响
    # - Historical_Interpretation: Dict  # 历史解读/争议
    # - Legacy: Dict  # 遗留问题/长期影响

Heroes_And_Villains: Optional[List[Dict[str, Any]]]  # 历史英雄与反派
    # 每个人物包含:
    # - Name: str  # 人物名称
    # - Lifetime: str  # 生卒年
    # - Background: str  # 出身背景
    # - Rise_To_Prominence: str  # 崛起过程
    # - Major_Achievements: List[str]  # 主要成就
    # - Controversial_Actions: Optional[List]  # 争议行为
    # - Personal_Philosophy: str  # 个人理念
    # - Allies_And_Enemies: Dict  # 盟友与敌人
    # - Downfall_Or_Death: Optional[str]  # 衰落或死亡
    # - Historical_Impact: Dict  # 历史影响
    # - Legacy_In_Culture: Dict  # 文化传承(如何被后世记住)
    # - Modern_Perception: Dict  # 现代评价

Dynasties_And_Ruling_Houses: Optional[List[Dict[str, Any]]]  # 王朝与统治家族
    # 每个王朝包含:
    # - Name: str  # 王朝/家族名称
    # - Duration: str  # 统治时期
    # - Founders: List[Dict]  # 创建者
    # - Territory: Dict  # 领土范围及变化
    # - Governance_System: Dict  # 治理体系
    # - Notable_Rulers: List[Dict]  # 著名统治者
    # - Major_Policies: List[Dict]  # 重要政策
    # - Succession_Method: str  # 继承方式
    # - Golden_Age: Optional[Dict]  # 鼎盛时期
    # - Decline_Factors: List[str]  # 衰落因素
    # - End_Of_Rule: Dict  # 终结原因
    # - Cultural_Contributions: List  # 文化贡献
    # - Surviving_Lineages: Optional[List]  # 幸存血脉

Technological_Developments: List[Dict[str, Any]]  # 技术发展里程碑
    # 每项技术包含:
    # - Technology: str  # 技术名称
    # - Discovery_Date: str  # 发现/发明时间
    # - Inventor: Optional[Dict]  # 发明者/发现者
    # - Precursor_Technologies: List[str]  # 前置技术
    # - Development_Process: str  # 发展过程
    # - Initial_Applications: List[str]  # 最初应用
    # - Societal_Impact: Dict  # 社会影响
    # - Economic_Effects: Dict  # 经济效应
    # - Military_Applications: Optional[Dict]  # 军事应用
    # - Evolution_Over_Time: List[Dict]  # 技术演变
    # - Current_State: str  # 当前状态

Cultural_And_Intellectual_Movements: List[Dict[str, Any]]  # 文化与思想运动
    # 每个运动包含:
    # - Name: str  # 运动名称
    # - Time_Period: str  # 时间段
    # - Geographic_Center: str  # 地理中心
    # - Key_Thinkers: List[Dict]  # 关键思想家
    # - Core_Ideas: List[str]  # 核心思想
    # - Opposing_Movements: Optional[List]  # 对立运动
    # - Cultural_Expressions: Dict  # 文化表现(艺术/文学等)
    # - Social_Impact: Dict  # 社会影响
    # - Political_Influence: Dict  # 政治影响
    # - Legacy: Dict  # 遗产/影响

Ruins_And_Artifacts: Optional[List[Dict[str, Any]]]  # 古迹与文物
    # 每项包含:
    # - Name: str  # 名称
    # - Age: str  # 年代
    # - Location: str  # 位置
    # - Creators: Optional[str]  # 创造者
    # - Original_Purpose: str  # 原始用途
    # - Historical_Significance: str  # 历史意义
    # - Current_State: str  # 当前状态
    # - Discovery_Story: Optional[str]  # 发现经过
    # - Powers_Or_Properties: Optional[Dict]  # 特殊能力/属性
    # - Cultural_Impact: str  # 文化影响
    # - Scholarly_Disputes: Optional[List]  # 学术争议

Forgotten_Or_Hidden_History: Optional[Dict[str, Any]]  # 被遗忘/隐藏的历史
    # 包含:
    # - Lost_Knowledge: List[Dict]  # 失落的知识
    # - Suppressed_Events: List[Dict]  # 被压制的事件
    # - Alternative_Narratives: Dict  # 另类叙事/非官方历史
    # - Rediscovered_Facts: List[Dict]  # 重新发现的史实
    # - Ongoing_Mysteries: List[Dict]  # 未解之谜

Historical_Patterns_And_Cycles: Optional[Dict[str, Any]]  # 历史模式与循环
    # 包含:
    # - Recurring_Events: List[Dict]  # 重复出现的事件类型
    # - Cyclical_Phenomena: List[Dict]  # 周期性现象
    # - Rise_And_Fall_Patterns: List[Dict]  # 兴衰模式
    # - Historical_Ironies: Optional[List]  # 历史讽刺/巧合

Historiography: Optional[Dict[str, Any]]  # 历史编纂学
    # 包含:
    # - Major_Historical_Sources: List[Dict]  # 主要历史文献
    # - Reliability_Of_Records: Dict  # 记录可靠性
    # - Competing_Narratives: Dict  # 竞争性叙事
    # - Methods_Of_Preservation: Dict  # 历史保存方法
    # - Famous_Historians: Optional[List]  # 著名史学家
    # - Evolution_Of_Historical_Study: Optional[Dict]  # 史学研究演变

# 当前状况(Current State)
Ongoing_Conflicts: Optional[List[Dict]]  # 当前冲突
Major_Threats: Optional[List[Dict]]  # 主要威胁
Power_Balance: str  # 势力平衡状况
Current_Events: List[Dict]  # 当前重要事件
Public_Mood: Optional[str]  # 公众情绪/社会氛围
Emerging_Trends: Optional[List[Dict]]  # 新兴趋势/变革

# 系统交互(System Interactions)
Magic_Technology_Interaction: Optional[Dict]  # 魔法与科技的交互
Environment_Society_Influence: Optional[Dict]  # 环境对社会的影响
Religion_Politics_Relationship: Optional[Dict]  # 宗教与政治的关系
Economic_Cultural_Dependencies: Optional[Dict]  # 经济与文化的依存关系
Species_Environment_Adaptation: Optional[Dict]  # 物种对环境的适应

# 变化与发展(Change and Development)
Future_Trajectories: Optional[List[Dict]]  # 可能的未来发展路径
World_Cycles: Optional[Dict]  # 世界周期/循环模式
Evolutionary_Pressures: Optional[Dict]  # 推动变革的力量
Resistance_To_Change: Optional[Dict]  # 阻碍变革的因素
Tipping_Points: Optional[List[Dict]]  # 可能的临界点/转折点

# 多视角观点(Multiple Perspectives)
Different_Cultural_Viewpoints: Optional[Dict]  # 不同文化的世界观
Minority_Perspectives: Optional[Dict]  # 少数群体的视角
Opposing_Ideologies: Optional[Dict]  # 对立意识形态的世界解读
Historical_Interpretation_Disputes: Optional[Dict]  # 历史解释的争议

# 叙事元素(Narrative Elements)
Themes: List[str]  # 核心主题
Tone: str  # 整体基调(黑暗/希望/荒诞等)
Narrative_Rules: Optional[List[str]]  # 叙事规则(命运/因果等)
Prophecies: Optional[List[str]]  # 预言/命运线索
Mysteries: Optional[List[Dict]]  # 世界之谜
Story_Hooks: Optional[List[Dict]]  # 潜在故事线索

# 元信息(Meta Information)
Genre_Elements: List[str]  # 类型元素
World_Rules: Optional[List[str]]  # 世界运行的核心规则
Extra_Notes: Optional[str]  # 额外补充注释
"""


CHARACTER_PROFILE_TEMPLATE = """
# 基本信息
Name: str  # 角色名字
Full_Name: Optional[str]  # 角色全名
Title: Optional[List[str]]  # 角色头衔/称号
Nick_Name: Optional[List[str]]  # 角色别名
Gender: Optional[str]  # 角色性别，非人类可以是多性别
Age: Optional[int]  # 角色年龄
Birthday: Optional[str]  # 角色生日
Birthplace: Optional[str]  # 角色出生地
Ethnicity: Optional[str]  # 角色种族/民族
Occupation: Optional[str]  # 角色职业/身份

# 外观与特征
Appearance: Optional[str]  # 角色外貌描述
Speech_Pattern: Optional[str]  # 角色说话方式
Tone: Optional[str] # 特殊的用词习惯/口癖
Habits: Optional[List[str]]  # 特殊的行为习惯
Classical_Qoutes: Optional[List[str]] # 经典语录

# 性格与内在
Persona: str  # 角色性格概述
Traits: List[str]  # 角色性格特点列表
Values: Optional[List[str]]  # 角色价值观
Like: Optional[List[str]] # 喜欢的人或事物
Unlike: Optional[List[str]] # 讨厌的人或事物
Confidence: Optional[str]  # 自信/擅长
Weaknesses: Optional[List[str]]  # 弱点/不擅长

# 能力与经历
Abilities: Optional[Dict[str, Dict[str, Any]]]  # 能力和技能
    # 每项能力包含:
    # - Name: str  # 能力名称
    # - Proficiency: str  # 熟练度(初学者/熟练/专家等)
    # - Source: str  # 获得途径(自学/师承/天赋等)
    # - Application: List[str]  # 应用场景
    # - Limitations: Optional[List[str]]  # 限制条件

# 重要经历 (Significant Events)
Significant_Events: Optional[List[Dict[str, Any]]]  # 重要经历
    # 每个事件包含:
    
    # 幼年经历 (Childhood Event)
    Childhood_Event: Dict[str, Any]
        # - Event: str  # 事件描述
        # - Age: int  # 发生年龄
        # - Context: str  # 事件背景
        # - Outcome: str  # 直接结果
        # - Emotional_Response: str  # 情感反应
        # - Lessons_Learned: Optional[str]  # 学到的教训
        # - Current_Impact: str  # 对现在的影响
        # - Related_Trauma_Or_Strength: Optional[str]  # 相关创伤或优势
    
    # 印象最深的事件 (Most Memorable Event)
    Most_Memorable_Event: Dict[str, Any]
        # - Event: str  # 事件描述
        # - When_And_Where: str  # 发生时间和地点
        # - Involved_Persons: List[str]  # 涉及人物
        # - Sequence: str  # 事件经过
        # - Outcome: str  # 结果
        # - Why_Memorable: str  # 为何难忘
        # - Current_Impact: str  # 对现在的影响
        # - Recurring_Thoughts: Optional[str]  # 反复出现的相关想法
    
    # 人生目标影响最大的事件 (Life Goal Defining Event)
    Goal_Defining_Event: Dict[str, Any]
        # - Event: str  # 事件描述
        # - Timing: str  # 人生阶段
        # - Circumstances: str  # 具体情境
        # - Key_Realization: str  # 关键领悟
        # - Outcome: str  # 结果
        # - Goals_Before: Optional[str]  # 事件前的目标
        # - Goals_After: str  # 事件后的目标
        # - Current_Impact: str  # 对现在的影响
        # - Commitment_Level: str  # 对目标的承诺程度
    
    # 对价值观影响最大的事件 (Value Shaping Event)
    Value_Shaping_Event: Dict[str, Any]
        # - Event: str  # 事件描述
        # - Moral_Dilemma: Optional[str]  # 道德困境
        # - Choice_Made: Optional[str]  # 做出的选择
        # - Outcome: str  # 结果
        # - Values_Before: Optional[List[str]]  # 事件前的价值观
        # - Values_After: List[str]  # 事件后的价值观
        # - Current_Impact: str  # 对现在的影响
        # - Related_Principles: List[str]  # 相关原则
    
    # 和性格有关的事件 (Personality Influencing Event)
    Personality_Influencing_Event: Dict[str, Any]
        # - Event: str  # 事件描述
        # - Emotional_State: str  # 当时情绪状态
        # - Behavioral_Response: str  # 行为反应
        # - Outcome: str  # 结果
        # - Personality_Before: Optional[List[str]]  # 事件前的性格特点
        # - Personality_After: List[str]  # 事件后的性格特点
        # - Current_Impact: str  # 对现在的影响
        # - Trigger_Situations: Optional[List[str]]  # 可能触发相关反应的情境
    
    # 其他关键事件 (Other Key Events)
    Other_Key_Events: Optional[List[Dict[str, Any]]]
        # 每个事件同样包含:
        # - Event: str
        # - When: str
        # - Outcome: str
        # - Current_Impact: str

# 重要物品 (Significant Possessions)
Possessions: Optional[List[Dict[str, Any]]]  # 重要物品
    # 每个物品包含:
    # - Name: str  # 物品名称
    # - Description: str  # 详细描述(外观、材质、状态等)
    # - Origin: str  # 来源/获得方式
    # - Age: Optional[str]  # 物品年龄/历史
    # - Significance: str  # 对角色的意义
    # - Powers_Or_Functions: Optional[Dict]  # 功能或特殊能力
    # - Emotional_Attachment: str  # 情感连接
    # - Usage: str  # 使用方式/频率
    # - Condition: Optional[str]  # 当前状态
    # - Associated_Memories: Optional[List[str]]  # 相关记忆
    # - Visible_To_Others: bool  # 是否为他人可见/知晓

# 关系与目标
Relationships: Dict[str, str]  # 与其他角色的关系
Goals: Dict[str, str]  # 短期和长期目标

# 世界与环境
World_Understanding: str  # 对所处世界的理解
Role_In_World: Optional[str]  # 角色在世界中的定位

# 元信息
Extra_Notes: Optional[str]  # 补充注释，如有则填，补充角色主观认知和上述客观信息可能存在不一致的部分
"""

SCENE_TEMPLATE = """
# 基本信息
Scene_Name: str  # 场景名称
Location: str  # 场景具体位置
Time: str  # 时间点/时段
Weather: Optional[str]  # 天气状况
Atmosphere: str  # 氛围描述

# 环境描述
Physical_Environment: str  # 物理环境的详细描述
Sensory_Details: {  # 感官细节
    "Visual": List[str],  # 视觉细节
    "Auditory": List[str],  # 听觉细节
    "Olfactory": Optional[List[str]],  # 嗅觉细节
    "Tactile": Optional[List[str]],  # 触觉细节
    "Taste": Optional[List[str]]  # 味觉细节(如适用)
}
Notable_Objects: Optional[List[Dict[str, Any]]]  # 场景中的重要可交互物品/元素
    # 每个物品包含:
    # - Name: str  # 物品名称
    # - Description: str  # 详细描述(外观、材质、状态等)
    # - Origin: str  # 背景或渊源
    # - Age: Optional[str]  # 物品年龄/历史
    # - Powers_Or_Functions: Optional[Dict]  # 功能或特殊能力
    # - Usage: str  # 交互/使用方式
    # - Condition: Optional[str]  # 当前状态
    # - Visible_To_Others: bool  # 是否为他人可见/知晓
    
Boundaries: str  # 场景的物理边界/限制

# 世界观元素
World_Context: str  # 场景所处的世界背景简述
Local_Rules: Optional[List[str]]  # 此场景特有的规则/法则
Cultural_Context: Optional[str]  # 与场景相关的文化背景

# 角色与互动
Present_Characters: List[Dict]  # 已在场景中的角色
    # 每个角色包含:
    # - "Name": 角色名
    # - "Position": 场景中的位置
    # - "Activity": 正在进行的活动
    # - "How_Got_Here": 角色是如何到达此场景的
    # - "Motivation": 角色来到此场景的动机
    # - "Awareness": 对场景/其他角色的认知程度
Expected_Arrivals: Optional[List[Dict]]  # 预期到达的角色(如适用)
Possible_Interactions: List[str]  # 场景中可能的互动方式

# 情节元素
Current_Situation: str  # 当前场景的状况/背景
Tension_Points: Optional[List[str]]  # 潜在冲突/紧张点
Opportunities: List[str]  # 场景提供的机会/可能性
Time_Constraints: Optional[str]  # 时间限制(如适用)

# 叙事元素
Mood: str  # 场景的情绪基调
Foreshadowing: Optional[List[str]]  # 暗示/伏笔元素

# 元信息
Extra_Notes: Optional[str]  # 关于场景的额外注释
Flexibility: Optional[Dict]  # 场景可变/固定元素说明
"""