#2 GENERATE WORLDVIEW
import os
from datetime import datetime
from utils import get_llm_response, extract_yaml_from_string
from prompt import WORLDVIEW_TEMPLATE
from topic_generation import generate_topic

def generate_worldview(topic: str, model_name: str) -> str:
    """
    Generate worldview
    Args:
        topic: Theme
        model_name: Model name
    Returns:
        Worldview string
    """
    prompt = f"""
    Please generate a complete worldview based on the following theme:
    {topic}
    Please strictly follow the following yaml format:
    ```yaml
    {WORLDVIEW_TEMPLATE}
    ```
    """
    response = get_llm_response(prompt, model_name)
    return extract_yaml_from_string(response)

def save_worldview(worldview: str, filename: str) -> None:
    """
    Save worldview string to file
    Args:
        worldview: Worldview string
        filename: File name
    Returns:
        None
    """
    with open(filename, "w", encoding="utf-8") as f:
        f.write(worldview)

# Generate worldview from scratch
def generate_worldview_from_scratch(model_name: str, temperature: float) -> str:
    """
    Generate worldview from scratch
    Args:
        model_name: Model name
        temperature: Temperature
    Returns:
        worldview_path: Worldview file path
    """
    # Initialize timestamp
    timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
    best_topic = generate_topic(model=model_name, temperature=temperature)
    worldview = generate_worldview(best_topic, model_name)
    print(worldview)
    os.makedirs("worldview", exist_ok=True)
    worldview_path = f"worldview/worldview_{timestamp}.yaml"
    save_worldview(worldview, worldview_path)
    return worldview_path


if __name__ == "__main__":
    worldview = generate_worldview_from_scratch(model_name="claude-3-7-sonnet-20250219", temperature=1.0)
    print(worldview)