from bayopt.aquisitions.go_safe_opt import GoSafeOpt
from bayopt.aquisitions.max_mean import MaxMean
from bayopt.aquisitions.safe_ei import SafeEI
from bayopt.aquisitions.safe_opt_multistage import SafeOptMultiStage
from bayopt.aquisitions.safe_ucb import SafeUCB
from bayopt.aquisitions.safe_opt import SafeOpt
from bayopt.aquisitions.ucb import UCB


def get_aquisition(model, config, context, data):
    if config["aquisition"] == "SafeOpt":
        aquisition = SafeOpt
    elif config["aquisition"] == "SafeUCB" and config["acf_optim"] == "swarm":
        aquisition = SafeOptMultiStage
        config["use_ucb"] = True
    elif config["aquisition"] == "SafeUCB":
        aquisition = SafeUCB
    elif config["aquisition"] == "SafeEI":
        aquisition = SafeEI 
    elif config["aquisition"] == "UCB":
        aquisition = UCB
        config["set_init"] = "random" 
    elif config["aquisition"] == "MaxMean":
        aquisition = MaxMean
    elif config["aquisition"] == "GoSafeOpt":
        aquisition = GoSafeOpt
    elif config["aquisition"] == "SafeOptMultiStage":
        aquisition = SafeOptMultiStage
    else:
        raise Exception("Aquisition not implemented")

    return aquisition(model, config, context, data)
