
# FCL
### Dependencies

If you don't have python 3 environment:
```
conda create -n fcl python=3.8
conda activate fcl
```
Then install the required packages:
```
pip install -r requirements.txt
```

### Run FCL

```
CUDA_VISIBLE_DEVICES=0 python main.py --data_dir PATH-TO-YOUR-DATASET --log_dir PATH-TO-SAVE-YOUR-LOGDIR -c PATH-TO-YOUR-YAMLFILE --ckpt_dir PATH-TO-YOUT-CHECKPOINT-FOLDER --hide_progress
```
The data folder should look like this:
```
➜  ~ tree ../Data/
├── cifar-10-batches-py
│   ├── batches.meta
│   ├── data_batch_1
│   ├── ...
└── stl10_binary
    ├── ...
```
If you want to design your own dataset, please refer to https://pytorch.org/vision/stable/generated/torchvision.datasets.ImageFolder.html

To evaluate separately:

```
CUDA_VISIBLE_DEVICES=1 python linear_eval.py --data_dir PATH-TO-YOUR-DATASET --log_dir PATH-TO-SAVE-YOUT-LOGDIR -c PATH-TO-YOUR-YAMLFILE --ckpt_dir PATH-TO-YOUT-CHECKPOINT-FOLDER --hide_progress --eval_from PATH-TO-YOUR-CHECKPOINT

```