from .q_learner import QLearner
from .q_opt_learner import QLearner as QoptLearner
from .coma_learner import COMALearner
from .qtran_learner import QLearner as QTranLearner
from .cw_q_learner import QLearner as CW_QLearner
from .ow_q_learner import QLearner as OW_QLearner


REGISTRY = {}

REGISTRY["q_learner"] = QLearner
REGISTRY["coma_learner"] = COMALearner
REGISTRY["qtran_learner"] = QTranLearner
REGISTRY["q_opt_learner"] = QoptLearner
REGISTRY["cw_q_learner"] = CW_QLearner
REGISTRY["ow_q_learner"] = OW_QLearner

