import evaluate
import json


rouge = evaluate.load("rouge")

with open('llama_chat.json', 'r') as f:
    examples = json.load(f)


target_list = [example['target'] for example in examples if example['task'] == 'domain/motif']
response_list = [example['response'] for example in examples if example['task'] == 'domain/motif']

results = rouge.compute(predictions=response_list, references=target_list)
print(results)