#!/bin/bash

for i in 4
do
    # Optional: Customize values based on $i
    INDEX_TO_TEST=$i
    RUN_NUMBER=$i  
    MODEL_TOKENIZER="meta-llama/Llama-3.2-3B-Instruct"  
    MODEL_PATH="meta-llama/Llama-3.2-3B-Instruct" 
    SAVING_PATH="../results/llama/"

    echo "🚀 Starting run #$RUN_NUMBER (index_to_test=$INDEX_TO_TEST)"

    python3 fh_attack.py \
        --index-to-test $INDEX_TO_TEST \
        --run-number $RUN_NUMBER \
        --model-tokenizer $MODEL_TOKENIZER \
        --model-path $MODEL_PATH \
        --saving-path $SAVING_PATH \
        --optim-str-size 60

    echo "✅ Finished run #$RUN_NUMBER"
    echo "--------------------------------------"
done

echo "🎉 All runs complete!"