# Navigating Sparsities in High-Dimensional Linear Contextual Bandits


`R_func` **Directory**: This directory contains the necessary R scripts for implementing the PWE method:

- fun_cv.r: Implements cross-validation to select a more accurate estimator for constructing the bases $\Gamma$.
- fun_proj.r: Returns the result of the PWE estimator.

**Python Implementations**: The implementations of Lasso-ETC, Lasso-Bandit, RDL-ETC, and HOPE are located in their respective Python files:

- HOPE.py: Contains the implementation of the HOPE algorithm.
- lasso_etc.py: Contains the implementation of the Lasso-ETC algorithm.
- lasso_bandit.py: Contains the implementation of the Lasso-Bandit algorithm.
- rdl_etc.py: Contains the implementation of the RDL-ETC algorithm.
- ucb_bandit.py: Contains the implementation of the LinearUCB algorithm.

**Parameter Summary**: The parameters used in these files are summarized as follows:

```
-n number of arms
-T number of total rounds
-T0 number of exploration rounds
-case covariance matrix settings
-rho sparsity ratio of arms
-p modal parameter dimension
```

## Scenario 1: Sparse Model Parameters
For Lasso-ETC result
```
python lasso_etc.py -n 5 -T 500 -case 1 -rho 0.1 -p 200
```
For Lasso-Bandit result
```
python lasso_bandit.py -n 5 -T 500 -case 1 -rho 0.1 -p 200
```
For LinearUCB result
```
python ucb_bandit.py -n 5 -T 500 -case 1 -rho 0.1 -p 200
```
For RDL-ETC result
```
python rdl_etc.py -n 5 -T 500 -case 1 -rho 0.1 -p 200
```
For HOPE result
```
python HOPE.py -n 5 -T 500 -case 1 -rho 0.1 -p 200
```
## Scenario 2: (Appr.) Sparse Eigenvalues of Context Covariance Matrices
For Lasso-ETC result
```
python lasso_etc.py -n 5 -T 500 -case 2 -rho 0.9 -p 200
```
For Lasso-Bandit result
```
python lasso_bandit.py -n 5 -T 500 -case 2 -rho 0.9 -p 200
```
For LinearUCB result
```
python ucb_bandit.py -n 5 -T 500 -case 2 -rho 0.9 -p 200
```
For RDL-ETC result
```
python rdl_etc.py -n 5 -T 500 -case 2 -rho 0.9 -p 200
```
For HOPE result
```
python HOPE.py -n 5 -T 500 -case 2 -rho 0.9 -p 200
```
## Scenario 3: Both Sparsities
For Lasso-ETC result
```
python lasso_etc.py -n 5 -T 500 -case 2 -rho 0.1 -p 200
```
For Lasso-Bandit result
```
python lasso_bandit.py -n 5 -T 500 -case 2 -rho 0.1 -p 200
```
For LinearUCB result
```
python ucb_bandit.py -n 5 -T 500 -case 2 -rho 0.1 -p 200
```
For RDL-ETC result
```
python rdl_etc.py -n 5 -T 500 -case 2 -rho 0.1 -p 200
```
For HOPE result
```
python HOPE.py -n 5 -T 500 -case 2 -rho 0.1 -p 200
```
## Scenario 4: Mixed Sparsities
**Mixed Scenario Implementation**: `mixed.py` is the implementation file for this scenario. To output results for all methods, run the following command:

```
python mixed.py -n 5 -T 500 -num_sparse 2 -scase 1 -nscase 2 -p 200
```
**Parameter Summary**: The additional parameters used in this file are summarized as follows:
```
-num_sparse number of sparse arms
-scase sparse setting of covariance matrix
-nscase non-sparse setting of covariance matrix
```


