############################################################
# the main function of Point-wise method
# gen_U is used for construction of Gamma matrix
# score_theta is criterion method for the selection of regularized parameter
# bias is a bias-corrected function to avoid shrinkaging small value of prediction to 0
# 
# there are three initial beta estimations for consideration: lasso, ridge and ridgeless
#
############################################################
fun_proj=function(x,n,p,X,Y,beta_lasso,beta_ridge,beta_ridgeless,naive=0,criterion=2,correct=0) { 
################ Main inputs:
###### x: testing points;  
###### X and Y: data matrix
###### beta_lasso,...,beta_ridgeless: the estimation of beta by existing methods
###### naive: choose whether use the naive estimator
################
################ Main outputs:
###### prediction: prediction errors for different selections of Gamma, and several 
######             naive estimators, see paper for details.

  gen_U=function(beta_est,X,Q.onep,Stda_x) 
  { 
    n=dim(X)[1]
    U=matrix(nrow=n,ncol=n) 
    X.res=X%*%Q.onep%*%t(X)
    X.eig=eigen(X.res)                                
    U0=X.eig$vectors 
    
    if (length(beta_est)==0) 
    {    
      U=U0   
    }
    if (length(beta_est)!=0)
    {
      if (mean(abs(beta_est))==0)
      {
        U=U0
      }
      if (mean(abs(beta_est))!=0)
      {
        gamma_x=(X%*%Q.onep%*%beta_est)/norm(X%*%Q.onep%*%beta_est,'F')
        U=cbind(gamma_x,U0[,-which.max(abs(t(U0)%*%Stda_x))])
      }
    } 
    return(U)  
  }

  score_theta=function(x,y,criterion)  
  {
    if (criterion==0)
    { 
      fit=cv.glmnet(x,y,alpha=1,family='gaussian',nfolds=5)
      score=fit$cvm                      # cv score   
      score.opt=min(score)
      c0=coef(fit,s="lambda.min")
      b=matrix(as.vector(c0),length(c0),1)
    }
    if (criterion==1)
    {
      fit=glmnet(x,y,family='gaussian',alpha=1)
      D=deviance(fit)
      score=D+fit$df*log(n)  # BIC score
      Id=which.min(score)
      b=fit$beta[,Id]
      score.opt=score[Id]
    }
    if (criterion==2)
    {
      fit=glmnet(x,y,family='gaussian',alpha=1,penalty.factor=c(0,rep(1,ncol(x)-1)))
      D=rep(0,length(fit$lambda))
      dev=function(beta,x,y)
      {
        x_n=nrow(x)
        x_p=ncol(x)
        resdual=sum((x%*%beta-y)^2)/x_n
        non_var=length(beta[which(beta!=0)])
        dev=x_n*log(resdual)+non_var*log(x_n) 
        return(dev)
      }
      D=apply(fit$beta,2,dev,x,y)
      Id=which.min(D)
      b=fit$beta[,Id]
      score.opt=D[Id] 
    }
    score_theta=list(score.opt=score.opt,theta=b)
  }

  bias=function(alpha_est,Y,Z.x,Z.theta) 
  {
    id.var_sel=which(abs(alpha_est[-1])>0.01)
    X.ols=cbind(rep(1,n),Z.x,Z.theta[,id.var_sel])
    if (length(id.var_sel)<0.3*n)
    {  
      #alpha_x.ols=(ginv(t(X.ols)%*%X.ols)%*%t(X.ols)%*%Y)[2]
      alpha_x.ols=solve(t(X.ols)%*%X.ols+0.0001*diag(dim(X.ols)[2]),t(X.ols)%*%Y)[2]
    } else {
      alpha_x.ols=alpha_est[1]
    }
    return(alpha_x.ols)
  }

  library(glmnet)
  library(MASS)

  I.p=diag(p)
  I.n=diag(n)
  one.p=matrix(x,ncol=1)  
  a_x=X%*%one.p
  Stda_x=a_x/norm(a_x,"F")
  Q.onep=I.p-one.p%*%t(one.p)/(norm(one.p,'F'))^2      
  Z.x=sqrt(n)*Stda_x               
  rho_x=norm(a_x,"F")/(sqrt(n)*norm(one.p,"F")) 
  
  beta_PCAty=NULL
  meth=c('beta_lasso','beta_ridge','beta_ridgeless','beta_PCAty')
  predict.gamma=rep(0,length(meth))
  
  if (naive==1) {
  X.F.naive=cbind(Z.x,sqrt(n)*I.n)
  X.F.ols=cbind(rep(1,n),X.F.naive)
  alpha.naive=solve(t(X.F.ols)%*%X.F.ols+0.0001*diag(dim(X.F.ols)[2]),t(X.F.ols)%*%Y)[2]
  predict.naive=rep(alpha.naive*norm(one.p,"F")/rho_x,(length(meth)-1))
}
  
  for (k in 1:length(meth))
  { 
    beta_est=get(meth[k])

    if (naive==1) {
    if (length(beta_est)!=0 && mean(abs(beta_est))!=0)
    {
      zeta=X%*%Q.onep%*%beta_est/sqrt(n)
      alpha.naive.correct=2*alpha.naive-t(Stda_x)%*%zeta
      predict.naive[k]=alpha.naive.correct*norm(one.p,"F")/rho_x
    }
  }
    
    U=gen_U(beta_est,X,Q.onep,Stda_x)
    U=as.matrix(U)
    Z.theta=sqrt(n)*U                              
    X.F.gamma=cbind(Z.x,Z.theta)
    
    Score_Theta=score_theta(X.F.gamma,Y,criterion)
    score=Score_Theta$score.opt
    theta=Score_Theta$theta
    
    length_theta=length(theta)
    idx=c((length_theta-ncol(U)):length_theta)
    alpha.gamma=theta[idx] 
    
    if (correct==1)
    {  
      alpha.gamma.correct=bias(alpha.gamma,Y,Z.x,Z.theta)
      predict.gamma[k]=alpha.gamma.correct*norm(one.p,"F")/rho_x  
    }
    if (correct==0)
    {
      predict.gamma[k]=alpha.gamma[1]*norm(one.p,"F")/rho_x 
    }
  }

  if (naive==1) {
  prediction=c(predict.naive,predict.gamma)
} else {
  prediction=predict.gamma
}
  return(prediction)
}
