import os
import numpy as np
from rpy2 import robjects
from rpy2.robjects.packages import importr
from rpy2.robjects import numpy2ri
from joblib import Parallel, delayed
from rpy2.robjects import globalenv
numpy2ri.activate()
# robjects.r('options(warn = -1)')

path = os.getcwd()

robjects.r('library(MASS)')
robjects.r('library(igraph)')
robjects.r('library(glmnet)')
robjects.r('library(parallel)')
robjects.r('library(foreach)')
robjects.r('library(doParallel)')
robjects.r('library(pls)')



robjects.r(f'source("{path}/R_func/fun_proj.r", encoding = "UTF-8")')
robjects.r(f'source("{path}/R_func/fun_cv.r", encoding = "UTF-8")')
robjects.r(f'source("{path}/R_func/fun_data.r", encoding = "UTF-8")')
robjects.r(f'source("{path}/R_func/fun_sigma.r", encoding = "UTF-8")')

def lasso_prediction_result(train_data, test_data):
    robjects.r('options(digits=3)')
    robjects.r('set.seed(42)')

    cl_cores = min(50, os.cpu_count() - 1)

    robjects.r(f'cl = makeCluster({cl_cores})')

    X_train = train_data[:,:-1]
    Y_train = train_data[:,-1].reshape(-1, 1)
    X_test = test_data
    n_test = X_test.shape[0]
    p=X_test.shape[1]

    X_train -= np.mean(X_train, axis=0)
    Y_train -= np.mean(Y_train)
    X_test -= np.mean(X_test, axis=0)

    globalenv['X_train'] = X_train
    globalenv['Y_train'] = Y_train
    globalenv['X_test'] = X_test

    obj_lasso = robjects.r('cv.glmnet')(x=X_train, y=Y_train, family="gaussian", alpha=1, nfolds=5, standardize=True)
    globalenv['obj_lasso'] = obj_lasso
    est_lasso = np.dot(np.column_stack((np.ones(n_test), X_test)), robjects.r(f'coef(obj_lasso, s=obj_lasso$lambda.min)[1:({p} + 1)]'))

    return est_lasso


def rdl_prediction_result(train_data, test_data):
    robjects.r('options(digits=3)')
    robjects.r('set.seed(42)')

    cl_cores = min(50, os.cpu_count() - 1)

    robjects.r(f'cl = makeCluster({cl_cores})')

    X_train = train_data[:,:-1]
    Y_train = train_data[:,-1].reshape(-1, 1)
    X_test = test_data

    X_train -= np.mean(X_train, axis=0)
    Y_train -= np.mean(Y_train)
    X_test -= np.mean(X_test, axis=0)

    globalenv['X_train'] = X_train
    globalenv['Y_train'] = Y_train
    globalenv['X_test'] = X_test

    beta_ridgeless = np.linalg.pinv(np.dot(X_train.T, X_train), rcond=0.05).dot(X_train.T).dot(Y_train)
    est_ridgeless = np.dot(X_test, beta_ridgeless)

    return est_ridgeless

def pwe_prediction_result(train_data, test_data):
    Kfold = 5

    robjects.r('options(digits=3)')
    robjects.r('set.seed(42)')

    cl_cores = min(50, os.cpu_count() - 1)

    robjects.r(f'cl = makeCluster({cl_cores})')
    criterion,correct,naive = 0,1,1

    X_train = train_data[:,:-1]
    Y_train = train_data[:,-1].reshape(-1, 1)
    X_test = test_data
    n_test = X_test.shape[0]
    n_train = X_train.shape[0]
    p=X_test.shape[1]

    X_train -= np.mean(X_train, axis=0)
    Y_train -= np.mean(Y_train)
    X_test -= np.mean(X_test, axis=0)

    globalenv['X_train'] = X_train
    globalenv['Y_train'] = Y_train
    globalenv['X_test'] = X_test



    # Lasso
    obj_lasso = robjects.r('cv.glmnet')(x=X_train, y=Y_train, family="gaussian", alpha=1, nfolds=5, standardize=True)
    globalenv['obj_lasso'] = obj_lasso
    est_lasso = np.dot(np.column_stack((np.ones(n_test), X_test)), robjects.r(f'coef(obj_lasso, s=obj_lasso$lambda.min)[1:({p} + 1)]'))
    beta_lasso = robjects.r(f'coef(obj_lasso, s=obj_lasso$lambda.min)[2:({p} + 1)]')

    # Ridge
    obj_ridge = robjects.r('cv.glmnet')(x=X_train, y=Y_train, family="gaussian", alpha=0, nfolds=5, standardize=True)
    globalenv['obj_ridge'] = obj_ridge
    est_ridge = np.dot(np.column_stack((np.ones(n_test), X_test)), robjects.r(f'coef(obj_ridge, s=obj_ridge$lambda.min)[1:({p} + 1)]'))
    beta_ridge = robjects.r(f'coef(obj_ridge, s=obj_ridge$lambda.min)[2:({p} + 1)]')


    # Adaptive Lasso
    beta_ols = np.linalg.solve(np.dot(X_train.T, X_train) + 0.0001 * np.eye(p), np.dot(X_train.T, Y_train))
    weight = 1 / (np.abs(beta_ols) ** 0.5)

    globalenv['weight'] = weight
    obj_adalasso = robjects.r('cv.glmnet(x=X_train, y=Y_train, family="gaussian", alpha=1, nfolds=5, penalty.factor=weight, standardize=TRUE)')
    globalenv['obj_adalasso'] = obj_adalasso
    est_adalasso = np.dot(np.column_stack((np.ones(n_test), X_test)), robjects.r(f'coef(obj_adalasso, s=obj_adalasso$lambda.min)[1:({p} + 1)]'))

    # PCA
    robjects.r(f'''X.eig = t(X_train)%*%X_train / {n_train}
    r = which(cumsum(eigen(X.eig)$values) / (sum(eigen(X.eig)$values)) > 0.9)[1]
    eigvec = eigen(X.eig)$vectors[, 1:r]
    beta_score = solve(
        t(X_train%*%eigvec)%*%(X_train%*%eigvec) + 0.0001 * diag(dim(X_train%*%eigvec)[2]),
        t(X_train%*%eigvec)%*%Y_train)
    beta_pcr=as.vector(eigvec%*%beta_score)
    est_pcr=X_test%*%eigvec%*%beta_score''')

    # Ridgeless
    beta_ridgeless = np.linalg.pinv(np.dot(X_train.T, X_train), rcond=0.05).dot(X_train.T).dot(Y_train)
    est_ridgeless = np.dot(X_test, beta_ridgeless)

    # PWE
    # print("run PWE")
    id_min = robjects.r(f'fun_cv(X_train, Y_train, {Kfold}, {naive}, {criterion}, {correct})')
    globalenv['beta_lasso'] = beta_lasso
    globalenv['beta_ridge'] = beta_ridge
    globalenv['beta_ridgeless'] = beta_ridgeless
    pred_proj = robjects.r(f'parApply(cl, X_test, 1, fun_proj, {n_train}, {p}, X_train, Y_train, beta_lasso, beta_ridge, beta_ridgeless, {naive}, {criterion}, {correct})')
    pred_loc = np.vstack([pred_proj, pred_proj[(id_min[0:4]-1).astype(int), :]]).T
    pred_glob = np.column_stack((est_lasso, est_ridge, est_ridgeless, est_adalasso))
    pred_glob = np.column_stack((pred_glob, pred_glob[:, (id_min[4:6]-1).astype(int)]))
    pred_all = np.column_stack([pred_loc, pred_glob])
    pred_all = pred_all[:, [8, 11, 12, 13]]  # "PWE","Lasso","Ridge","RDL"


    return pred_all