from Sugar import *
from collections.abc import Iterable

def tutorial():
	s = select(tokens_str,tokens_str,lambda a,b:a==b,name="s = select( (tokens_str,), (tokens_str,), lambda a,b:a==b)")
	y = aggregate(s,indices,lambda i:i+1,name="y = aggregate(s, (indices,), lambda i:i+1)")
	z = zipmap((y,indices),lambda a,b:a+b,name="z = zipmap((y,indices), lambda a,b:a+b)")
	z.draw_comp_flow("hello")

def get_shifted_or_empty_str(n,seq=tokens_str,default="",name=None):
	if None is name:
		name = "shifted by "+str(n)+" or ["+str(default)+"]"
	return aggregate(shift_select(n),seq,default=default,name=name)

def load_ngrams(n):
	ngrams = tokens_str
	for i in range(1,n):
		token_i = get_shifted_or_empty_str(i)
		ngrams += token_i
	ngrams.setname(str(n)+"-grams")
	return ngrams

def reverse(seq=tokens_asis):
	return aggregate(flip_s,seq,name="flipped")


has3as = count(tokens_asis,"a")>2

has3as_2 = frac(tokens_asis,"a") > frac_quality(indices,lambda i:i<2)

def _is_palindrome():
	contains_mismatch = contains_quality((tokens_asis,reverse()),
									lambda t,rt:not t==rt)
	return tplnot( contains_mismatch )
is_palindrome = _is_palindrome()

def histogram(seq=tokens_asis):
	 return asint(count_conditioned(seq,seq,lambda a,b:a==b),name=seq.name+" histogram")

def n_histogram(n):
	ngrams = load_ngrams(n)
	return histogram(ngrams)

def _BP():
	num_opens = count_conditioned(indices,(tokens_asis,indices),lambda i,t,j:(j<=i) and t=="(",name="num earlier opens")
	num_closes = count_conditioned(indices,(tokens_asis,indices),lambda i,t,j:(j<=i) and t==")",name="num earlier closes")

	even_at_end = load_from_target_index(-1,(num_opens - num_closes)==0,False,name="even at end")
	imbalanced_at_some_point = contains_quality((num_opens,num_closes),lambda o,c:o<c,name="more closes than opens at some point")
	BP = tpland(even_at_end, tplnot(imbalanced_at_some_point))
	BP.setname("balanced parentheses ()")
	return BP
BP = _BP()

def most_frequent_ngram(n):
	ngrams = load_ngrams(n)
	ngram_count = histogram(ngrams)
	is_most_frequent = tplnot( 
				conditioned_contains(ngram_count,ngram_count,lambda cq,ck:ck>cq),
							name="is most frequent bigram")
	sel_first_maxfreq_bigram = select_from_first_value(is_most_frequent,True,
							name="select earliest most frequent bigram")
	return aggregate(sel_first_maxfreq_bigram,ngrams,name="(first) most frequent "+str(n)+"-gram")
most_frequent_bigram = most_frequent_ngram(2)

def most_freq_vals(seq=tokens_asis):
	tokens_histogram = histogram(seq)
	val_has_earlier_copy = conditioned_contains((indices,seq),(indices,seq),
									lambda iq,vq,ik,vk:(vq==vk) and (ik<iq),
									name="val has earlier copy in "+seq.name)
	squeezed_histogram = tokens_histogram - (length * val_has_earlier_copy) # send all duplicates into <= 0
	num_uniques = count(val_has_earlier_copy,False,name="num unique values in "+seq.name)
	def todefault(t):
		if isinstance(t,int):
			return 0
		if isinstance(t,float):
			return 0.0
		if isinstance(t,str):
			return ""
		return None # ???
	unique_vals = zipmap((seq,val_has_earlier_copy),
				lambda t,has_earlier:t if not has_earlier else todefault(t),name="unique vals")
	tokens_by_freq, freq_by_freq = sort((unique_vals,squeezed_histogram),key=-squeezed_histogram,
					name="unique vals of "+seq.name+" by decreasing freq") # goes from smallest to biggest so have to go in negative
	freq_by_freq = tplmax(freq_by_freq,0)
	return tokens_by_freq, freq_by_freq

most_freq_tokens, most_freq_tokens_fequencies = most_freq_vals()

def rotate_string(n):
	shifted_left = get_shifted_or_empty_str(n)
	end_source_index = n+indices-length
	end_tokens = load_from_target_indices(end_source_index,tokens_str,"",name="end or empty")
	return (shifted_left + end_tokens).setname(str(n)+"-rotation")

def _codewars_Ch4113ng3():
	replacements = {"a":4,"A":4,"e":3,"E":3,"l":1,"L":1}
	return zipmap(tokens_str,lambda c:str(replacements.get(c,c)),"Ch4ll3ng3")
codewars_Ch4113ng3 = _codewars_Ch4113ng3()
