## NOTE: to use the draw_comp_flow function, you will need to install graphviz, and dot. https://graphviz.readthedocs.io/en/stable/manual.html#installation

from Sugar import *

# simple 'tutorial' program, showing the first 3 base ops:
s = select(tokens_str,tokens_str,lambda a,b:a==b)
y = aggregate(s,indices,lambda i:i+1)
z = zipmap((y,indices),lambda a,b:a+b) # equivalently: z = y+indices
z("hello") # will return Sequence[1.0,3.0,5.5,6.5,9.0]
z.draw_comp_flow("hello") # will draw image, as in paper - albeit with different display names

# can also give s and selectors names for presentation,
# either retroactively (using setname... yes this isnt very functional but....) 
# or on creation
z.setname("z")
z.draw_comp_flow("hello") # this time z will be labeled "z"
w = zipmap(z,lambda v:v==4,name="w") # equivalently: w = (z==4).setname("w")


# can also use a variety of functions made available by Sugar, 
# e.g. conditioned_contains for computing an attention width as 
# described in the paper
w = conditioned_contains(tokens_int,\
			tokens_int,lambda a,b:b<a,"num smaller numbers")
w([5,7,1,9]) # will return Sequence[1,2,0,3]

# there also several example programs that can be run from 
# the examples.py file, eg:
import examples
BP.draw_comp_flow("(())")


# NOTE:
# In practice, tokens comes in five 'flavours', that interpret the input tokens in different ways: 
# tokens_str, tokens_int, tokens_float, tokens_bool, and tokens_asis.
# eg: tokens_int([0.0,1.0]) will return [0,1], 
# while tokens_str([0.0,1.0]) will return ["0.0","1.0"].
# Additionally, all sequences must have uniform type.
# Note that as you build the code, RASP 'compiler' will run things on small inputs, 
# eg to infer the number of return values from a function given to zipmap.  
# If these small runs create a sequence with non-uniform type it will fail. 
# Hence you cannot make any assumptions about the values in your input, e.g., you should not build a 
# program around tokens_asis under the assumption that you will never get a string input.
# Similarly, note that the default value of the optional 'default' parameter to aggregate is None.
# The 'compiler' can then fail if during the dry run it invokes an aggregate on a select that
# has not chosen a focus, e.g. attempting to run 
# >> sel1 = select((),indices,lambda i:i==1) 
# >> t1 = aggregate(sel1,tokens)
# may fail even before any attempt to evaluate t1 on an input sequence (if the compiler tries to
# evaluate it on an input of length 1). Hence, even though it is optional, 
# you do almost always need to set the default value in every aggregate.
# Finally, note that except for the special cases where the selector always 
# choose at most one focus, the output sequence of an aggregate operation contains floats and the
# input sequences have to all contain only integers or floats. The default value should have identical
# type to the aggregate's output value.