# Delay Aware Dreamer-V3


Modification of Dreamer-v3 for addressing random delays.


Example commands:

- The main method (reffered as DA-Dreamer) with uniform delays on a Gym environment:

```sh

  TASK=gym_HalfCheetah-v4
  MAX_LENGTH=20

  python dreamerv3/main.py --logdir ./logdir/$(date "+%Y%m%d-%H%M%S")\
                                --configs gym_proprio latent size7m\
                                --task ${TASK}\
                                --run.steps 1e6\
                                --delay.obs_delay_step False\
                                --replay.save_replay False\
                                --agent.repval_loss False\
                                --delay.maximum_delay ${MAX_LENGTH} --delay.obs_window_size ${MAX_LENGTH}\
                                --delay.delay_distribution Uniform\
                                --delay.delay_Uniform_dist_kwargs.minimum 0 --delay.delay_Uniform_dist_kwargs.minimum ${MAX_LENGTH}
  ```

- Treating delays as a generic input (refferd as Stack-Dreamer) with TruncatedGaussian on a Gym environment:
```sh

  TASK=gym_HalfCheetah-v4
  MAX_LENGTH=40
  mu=10
  scal=1

  python dreamerv3/main.py --logdir ./logdir/$(date "+%Y%m%d-%H%M%S")\
                                --configs gym_proprio extended_obs size7m\
                                --task ${TASK}\
                                --run.steps 1e6\
                               --delay.privilaged_decoder False\
                               --agent.enc.simple.enc_key_prefix ''\
                               --agent.dec.simple.dec_key_prefix ''\
                               --delay.include_actions True\
                                --replay.save_replay False\
                                --agent.repval_loss False\
                                --delay.maximum_delay ${MAX_LENGTH} --delay.obs_window_size ${MAX_LENGTH}\
                                --delay.delay_distribution TruncatedGaussian\
                                --delay.delay_TruncatedGaussiandist_kwargs.minimum 0 --delay.delay_TruncatedGaussian_dist_kwargs.minimum ${MAX_LENGTH}\
                                --delay.delay_TruncatedGaussian_dist_kwargs.mu ${mu} --delay.delay_TruncatedGaussian_dist_kwargs.scale ${scale}
```

- Wait agent on a Meta-Word environment with added action noise. Replace `wait` with `latest_obs` to switch to Memoryless agent:

```sh
TASK=metaworld_drawer-close-v2
STEPS=5e5
LEN=50
MAX_LENGTH=5
NOISE_FRACTION=0.2

python dreamerv3/main.py --logdir ./logdir/$(date "+%Y%m%d-%H%M%S")\
                            --configs metaworld_vision wait size1m log_tb\
                            --task ${TASK}
                            --run.steps ${STEPS}\
                            --env.metaworld.length ${LEN}\
                            --delay.obs_delay_step True\
                            --replay.save_replay False\
                            --env.action_noise.noise_fraction ${NOISE_FRACTION}\
                            --agent.repval_loss False\
                            --delay.maximum_delay ${MAX_LENGTH} --delay.obs_window_size ${MAX_LENGTH}\
                            --delay.delay_distribution Uniform\
                            --delay.delay_Uniform_dist_kwargs.minimum 0 --delay.delay_Uniform_dist_kwargs.minimum ${MAX_LENGTH}
```

To set the number of particles, use `--agent.dyn.rssm.particles number_of_particles`.