import cv2
from PIL import Image
import os
from tqdm import tqdm

abs_file_path = os.path.abspath(__file__)
file_dir = os.path.dirname(abs_file_path)
os.chdir(file_dir)

def read_video(video_path, resize=(512, 512), pngs_path='../data/jpgs'):
    frames = []
    video_name = os.path.basename(video_path)
    cap = cv2.VideoCapture(video_path)
    total_frames = int(cap.get(cv2.CAP_PROP_FRAME_COUNT))
    print(f'start read {video_name}, {total_frames} frames')

    while cap.isOpened():
        ret, frame = cap.read()
        if not ret:
            break
        frame = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
        frame = Image.fromarray(frame)
        frame = frame.resize(resize)
        frames.append(frame)
    cap.release()

    print(f'read {video_name} finish')

    folder_path = os.path.join(pngs_path, video_name.split('.')[0])
    if not os.path.exists(folder_path):
        os.mkdir(folder_path)

    for i, frame in enumerate(tqdm(frames)):
        frame_path = os.path.join(folder_path, str(i).zfill(6) + '.jpg')
        # print(frame_path)
        frame.save(frame_path)
    
    print(f'finish {video_name}, total {total_frames} frames, save {len(frames)} frames, ', 'Error' if len(frames) != total_frames else 'Success')

if __name__ == '__main__':
    videos_folder = '../data/videos'
    videos_name = sorted(os.listdir(videos_folder))
    for i, video_name in enumerate(videos_name):
        video_path = os.path.join(videos_folder, video_name)
        print(f'start process {video_name}')
        read_video(video_path)
        print(f'finish {i + 1} / {len(videos_name)}')