# Denoising Augmented Guidance Classifiers: Score-matching SDEs

This repository heavily builds upon:
- https://github.com/yang-song/score_sde_pytorch
- https://github.com/chen-hao-chao/dlsm

This repository includes the follows:
- Pytorch Lightning implementation of Score-matching SDEs
- Denoising-assistance training and sampling
- Semi-supervised training of CIFAR10, MNIST and SVHN. 
- Positive Unlabeled training of MNIST and SVHN.

In the following, we include some sample commands for illustrating the available command-line-options:
- Noisy CIFAR10 Classifier
>python main.py --workdir workdirs/cifar_noisy --config=configs/ve/cifar10_ncsnpp_deep_continuous.py --config.training.denoise_augment=False --config.data.labels_per_class=-1 --config.training.score_model=False --config.training.clf_model=True --config.training.n_iters=150000
- Denoising Augmented CIFAR10 Classifier. Download the CIFAR10 NCSNpp checkpoints released by [Score-sde-pytorch](https://github.com/yang-song/score_sde_pytorch) amd use that path in the command below:
>python main.py --workdir workdirs/cifar_da --config=configs/ve/cifar10_ncsnpp_deep_continuous.py --config.training.denoise_augment=True --config.data.labels_per_class=-1 --config.training.score_model=False --config.training.clf_model=True --config.training.n_iters=150000 --config.training.score_path="PATH/TO/CKPT"

After training a classifer, if you want to generate 1024 samples per class, you can use:
> python generate_samples.py --workdir cifar_da --num_samples 1024 --bs 256 --id 0

For running the sampling job in parallel, you can use the ```id``` argument: this will ensure that the npz files are not overwritten. The generated samples can be found inside ```workdir/samples```. All of the above support preemption and can resume execution. 

For the evaluation of generated CIFAR10 samples, you can run:
> python run_lib_evaluation.py --config configs/eval/eval_cifar10_configs.py --mode full --workdir cifar_da --stat --latent --fidis --prdc
