set -euo pipefail
WANDB_NAME="gpt_medium_openwebtext"
lrs=(5e-3)
for lr in "${lrs[@]}"; do
    echo "▶ running lr=$lr" 
    torchrun --standalone --nproc_per_node=4 train_gpt.py \
    --model gpt2-medium \
    --optimizer LANTON \
    --dataset openwebtext-100k \
    --batch_size 16 \
    --num_epochs 1 \
    --hidden_size 768 \
    --max_lr $lr \
    --warmup_steps=300 \
    --wandb_log \
    --wandb_project "${WANDB_NAME}" \
    --val_interval 50 \
    --val_max_batches 100 \
    --save_interval 500 \
    --noise_momentum=0.9 \
    --scale1 300\
    --scale2 1.0
done
