#!/usr/bin/env bash
set -euo pipefail
# <<< tune these as needed >>>
lr=5e-3 
WANDB_NAME="llama_1B"
SEED=42

echo "=== Running lr=${lr} ==="
python -m torch.distributed.run --standalone --nproc_per_node=4 train_c4.py \
    --batch_size=64 \
    --grad_micro_steps=16 \
    --total_bs=1024 \
    --max_lr=$lr \
    --weight_decay=0.1 \
    --warmup_iters=1000 \
    --max_iters=10000 \
    --eval_interval=200 \
    --model_name=TinyLlama \
    --n_layer=12 \
    --save_interval=100 \
    --seed="${SEED}" \
    --wandb_run_name="llama_C4" \
    --wandb_project="${WANDB_NAME}" \
    --wandb_log \
    --optimizer=LANTON \
    --noise_momentum=0.9 \
    --scale1=300 \
    --scale2=1.0
echo "=== Done lr=${lr} ==="
