from lightning.pytorch.callbacks import ModelCheckpoint


class RunningCheckpoint(ModelCheckpoint):
    """Simply stores checkpoint as the name of the running counter of the checkpoint."""

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.checkpoint_count = 0  # Initialize the counter within the class

    def _format_checkpoint_name(self, *args, **kwargs) -> str:
        filename = f"{self.checkpoint_count}"
        self.checkpoint_count += 1
        return filename
