# Copyright 2022 MosaicML LLM Foundry authors
# SPDX-License-Identifier: Apache-2.0
import sys

import llmfoundry

from checkpoint import HQHFCheckpointer
llmfoundry.registry.callbacks.register('hq_hf_checkpointer', func=HQHFCheckpointer)

from seed import DataSeedAlgorithm
llmfoundry.registry.algorithms.register('data_seeder', func=DataSeedAlgorithm)

from loss_weighter import LossWeighter
llmfoundry.registry.algorithms.register('loss_weighter', func=LossWeighter)

from llmfoundry.command_utils import train_from_yaml
if __name__ == '__main__':
    yaml_path, args_list = sys.argv[1], sys.argv[2:]
    train_from_yaml(yaml_path, args_list)