import time
import click
import socket
import multiprocessing as mp
from chester.run_exp import run_experiment_lite, VariantGenerator
from GNS.fabric_vsf.scripts.run_softgym_original import run_task as run_single
from GNS.fabric_vsf.scripts.run_softgym_original_multiple import run_task as run_multiple
import json

@click.command()
@click.argument('mode', type=str, default='local')
@click.option('--debug/--no-debug', default=True)
@click.option('--dry/--no-dry', default=False)
def main(mode, debug, dry):
    # exp_prefix = '0623-vsf-evaluate-new-model-supp-multi-dual-same-direction'
    exp_prefix = '0624-vsf-final-evaluate-supp-multi-square'
    exp_prefix = '0624-vsf-final-evaluate-supp-single-square'
    # exp_prefix = '0624-vsf-final-evaluate-supp-single-square-time'
    exp_prefix = '0624-vsf-final-evaluate-supp-multi-rectangular'
    exp_prefix = '0624-vsf-final-evaluate-supp-multi-tshirt'

    
    def get_action_dim(single_arm):
        if single_arm:
            return 4
        else:
            return 8

    def get_data_path(model_path):
        return model_path[:-len('output_data')] + 'train_data'

    def get_single_arm(model_path):
        beg = len('/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-')
        end = model_path.find('-biasing')
        s = model_path[beg:end]

        if s == 'True':
            return True
        else:
            return False

    def get_small_action(model_path):
        beg = model_path.find('small-') + len('small-')
        end = model_path.find('e/0618') + 1
        s = model_path[beg:end]
        if s == 'True':
            return True
        else:
            return False

    vg = VariantGenerator()
    if not debug:
        vg.add('test_episodes', [
            # [i for i in range(40)], 
            # [i for i in range(13)], 
            # [i for i in range(13, 26)], 
            [i for i in range(26, 40)], 
        ])

        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-True-small-True/0618-vsf-train-single-True-biasing-True-small-True_2021_06_19_12_19_45_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-True-small-True/0618-vsf-train-single-True-biasing-True-small-True_2021_06_19_12_19_45_0001/train_data'])
        ####
        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-False-small-True/0618-vsf-train-single-True-biasing-False-small-True_2021_06_19_12_20_46_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-False-small-True/0618-vsf-train-single-True-biasing-False-small-True_2021_06_19_12_20_46_0001/train_data'])
        #### 
        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-False-small-False/0618-vsf-train-single-True-biasing-False-small-False_2021_06_19_12_24_06_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-False-small-False/0618-vsf-train-single-True-biasing-False-small-False_2021_06_19_12_24_06_0001/train_data'])
        ####
        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-True-small-True/0618-vsf-train-single-False-biasing-True-small-True_2021_06_19_12_33_47_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-True-small-True/0618-vsf-train-single-False-biasing-True-small-True_2021_06_19_12_33_47_0001/train_data'])
        #### 
        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-True-small-False/0618-vsf-train-single-False-biasing-True-small-False_2021_06_19_12_34_45_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-True-small-False/0618-vsf-train-single-False-biasing-True-small-False_2021_06_19_12_34_45_0001/train_data'])
        #### 
        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-False-small-True/0618-vsf-train-single-False-biasing-False-small-True_2021_06_19_12_35_59_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-False-small-True/0618-vsf-train-single-False-biasing-False-small-True_2021_06_19_12_35_59_0001/train_data'])
        ####
        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-False-small-False/0618-vsf-train-single-False-biasing-False-small-False_2021_06_19_12_36_43_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-False-small-False/0618-vsf-train-single-False-biasing-False-small-False_2021_06_19_12_36_43_0001/train_data'])
        ####
        # vg.add('model_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-True-small-False/0618-vsf-train-single-True-biasing-True-small-False_2021_06_20_00_23_28_0001/output_data'])
        # vg.add('data_path', ['/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-True-small-False/0618-vsf-train-single-True-biasing-True-small-False_2021_06_20_00_23_28_0001/train_data'])

        vg.add('model_path', [
            # '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-True-small-True/0618-vsf-train-single-True-biasing-True-small-True_2021_06_19_12_19_45_0001/output_data',
            '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-True-small-False/0618-vsf-train-single-True-biasing-True-small-False_2021_06_20_00_23_28_0001/output_data',
            # '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-False-small-True/0618-vsf-train-single-True-biasing-False-small-True_2021_06_19_12_20_46_0001/output_data',
            # '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-True-biasing-False-small-False/0618-vsf-train-single-True-biasing-False-small-False_2021_06_19_12_24_06_0001/output_data',
            # '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-True-small-True/0618-vsf-train-single-False-biasing-True-small-True_2021_06_19_12_33_47_0001/output_data',
            # '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-True-small-False/0618-vsf-train-single-False-biasing-True-small-False_2021_06_19_12_34_45_0001/output_data',
            # '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-False-small-True/0618-vsf-train-single-False-biasing-False-small-True_2021_06_19_12_35_59_0001/output_data',
            # '/data/user2w2/VCD_policy/data/local/0618-vsf-train-single-False-biasing-False-small-False/0618-vsf-train-single-False-biasing-False-small-False_2021_06_19_12_36_43_0001/output_data',
        ])
        vg.add('data_path', lambda model_path: [get_data_path(model_path)])
        

        vg.add('single_arm', lambda model_path: [get_single_arm(model_path)])
        vg.add('small_action', lambda model_path: [get_small_action(model_path)])
        vg.add('multiple_goal', [True])

        vg.add('cloth', ['tshirt'])

        vg.add('num_elites', [400])
        vg.add('population_size', [2000])
        vg.add('num_iters', [10])

        # vg.add('num_elites', [10])
        # vg.add('population_size', [50])
        # vg.add('num_iters', [2])

        vg.add('pick_and_place_num', [1])
        vg.add('planning_method', ['cem_original'])
        vg.add('depth_max', [0.45])
        vg.add('camera_param_height', [0.45])
        vg.add('adim', lambda single_arm: [get_action_dim(single_arm)])
        vg.add('seed', [100])

    else:
        vg.add('env_name', ['ClothFlatten'])
        vg.add('test_episodes', [[0]])
        # vg.add('max_episodes', [2])
        # vg.add('cached_states_path', ['tshirt_flatten_init_states_2021_05_23_11_28.pkl'])
        vg.add('cached_states_path', ['cloth_flatten_test_rectangular_1.pkl'])
        vg.add('model_path', ['GNS/fabric_vsf/data/output_data'])
        vg.add('data_path', ['GNS/fabric_vsf/data/train_data'])
        # vg.add('model_path', ['data/local/0206-vsf-train/0206-vsf-train_2021_02_06_16_20_28_0001/output_data'])
        # vg.add('data_path', ['data/local/0206-vsf-train/0206-vsf-train_2021_02_06_16_20_28_0001/train_data'])
        vg.add('num_elites', [2])
        vg.add('population_size', [10])
        vg.add('num_iters', [2])
        vg.add('planning_method', ['cem'])

        exp_prefix += '_debug'

    print('Number of configurations: ', len(vg.variants()))
    print("exp_prefix: ", exp_prefix)

    # for idx, vv in enumerate(vg.variants()):
    #     with open("tmp_{}.json".format(idx), 'w') as f:
    #         json.dump(vv, f, indent=2, sort_keys=True)

    hostname = socket.gethostname()

    sub_process_popens = []
    for idx, vv in enumerate(vg.variants()):
        if vv['multiple_goal']:
            run_task = run_multiple
        else:
            run_task = run_single
        while len(sub_process_popens) >= 10:
            sub_process_popens = [x for x in sub_process_popens if x.poll() is None]
            time.sleep(10)
        if mode in ['seuss', 'autobot']:
            if idx == 0:
                # compile_script = 'compile.sh'  # For the first experiment, compile the current softgym
                compile_script = None  # For the first experiment, compile the current softgym
                wait_compile = None
            else:
                compile_script = None
                wait_compile = 500  # Wait 30 seconds for the compilation to finish
        elif mode == 'ec2':
            compile_script = 'compile_1.0.sh'
            wait_compile = None
        else:
            compile_script = wait_compile = None
        if hostname.startswith('autobot') and gpu_num > 0:
            env_var = {'CUDA_VISIBLE_DEVICES': str(idx % gpu_num)}
        else:
            env_var = None
        cur_popen = run_experiment_lite(
            stub_method_call=run_task,
            variant=vv,
            mode=mode,
            dry=dry,
            use_gpu=True,
            exp_prefix=exp_prefix,
            wait_subprocess=debug,
            compile_script=compile_script,
            wait_compile=wait_compile,
            env=env_var
        )
        if cur_popen is not None:
            sub_process_popens.append(cur_popen)
        if debug:
            break


if __name__ == '__main__':
    main()
