import time
import torch
import click
import socket
import multiprocessing as mp
from chester.run_exp import run_experiment_lite, VariantGenerator
from GNS.fabric_vsf.scripts.format_hdf5_softgym import run_task


@click.command()
@click.argument('mode', type=str, default='local')
@click.option('--debug/--no-debug', default=True)
@click.option('--dry/--no-dry', default=False)
def main(mode, debug, dry):
    exp_prefix = '0618-vsf-format-data'
    vg = VariantGenerator()

    vg.add('data_dir', [
        # '0618-vsf-collect-data-single-True-biasing-True-small-True',
        # '0618-vsf-collect-data-single-True-biasing-False-small-True',
        # '0618-vsf-collect-data-single-True-biasing-False-small-False',
        # '0618-vsf-collect-data-single-False-biasing-True-small-True',
        # '0618-vsf-collect-data-single-False-biasing-True-small-False',
        # '0618-vsf-collect-data-single-False-biasing-False-small-True',
        # '0618-vsf-collect-data-single-False-biasing-False-small-False',
        '0618-vsf-collect-data-single-True-biasing-True-small-False',
    ])
    if not debug:
        pass
        # vg.add('num_traj', [10000])
    else:
        # vg.add('num_traj', [20])
        # vg.add('num_traj_pick', [15])
        exp_prefix += '_debug'

    print('Number of configurations: ', len(vg.variants()))
    print("exp_prefix: ", exp_prefix)

    hostname = socket.gethostname()
    gpu_num = torch.cuda.device_count()

    sub_process_popens = []
    for idx, vv in enumerate(vg.variants()):
        while len(sub_process_popens) >= 10:
            sub_process_popens = [x for x in sub_process_popens if x.poll() is None]
            time.sleep(10)
        if mode in ['seuss', 'autobot']:
            if idx == 0:
                # compile_script = 'compile.sh'  # For the first experiment, compile the current softgym
                compile_script = None  # For the first experiment, compile the current softgym
                wait_compile = None
            else:
                compile_script = None
                wait_compile = 120  # Wait 30 seconds for the compilation to finish
        elif mode == 'ec2':
            compile_script = 'compile_1.0.sh'
            wait_compile = None
        else:
            compile_script = wait_compile = None
        if hostname.startswith('autobot') and gpu_num > 0:
            env_var = {'CUDA_VISIBLE_DEVICES': str(idx % gpu_num)}
        else:
            env_var = None
        cur_popen = run_experiment_lite(
            stub_method_call=run_task,
            variant=vv,
            mode=mode,
            dry=dry,
            use_gpu=True,
            exp_prefix=exp_prefix,
            wait_subprocess=debug,
            compile_script=compile_script,
            wait_compile=wait_compile,
            env=env_var
        )
        if cur_popen is not None:
            sub_process_popens.append(cur_popen)
        if debug:
            break


if __name__ == '__main__':
    main()
