import csv
import os
import os.path as osp
import numpy as np
import json
import argparse

def filter_failed(dir, result, metric):
    performance = result[metric]
    filter_idx = []
    if dir == '0225-vsf-evaluate-model_2021_02_25_01_27_40_0002': # done
        filter_idx = [6]
    elif dir == '0225-vsf-evaluate-model_2021_02_25_01_27_40_0003': # done
        filter_idx = [1, 2]
    elif dir == '0225-vsf-evaluate-model_2021_02_25_01_27_40_0005': # done
        filter_idx = [0]
    elif dir == '0225-vsf-evaluate-model_2021_02_25_01_27_40_0006': # done
        filter_idx = [15]
    elif dir == '0225-vsf-evaluate-model_2021_02_25_01_27_40_0007': # till 18
        filter_idx = [18,14,10,8]
    elif dir == '0225-vsf-evaluate-model_2021_02_25_01_27_40_0008': # done
        filter_idx = [5,6,8,11]

    res = []
    for idx in range(len(performance)):
        if idx not in filter_idx:
            res.append(performance[idx])

    return res


parser = argparse.ArgumentParser()
parser.add_argument('data_path')
args = parser.parse_args()
data_path = args.data_path

sub_dirs = os.listdir(data_path)

print("sub_dirs: ", sub_dirs)

metrics = ['normalized_performance', 'normalized_performance_2']

for metric in metrics:

    performance_table = {}

    all_performances = []
    for dir in sub_dirs:
        print(dir)
        all_res = []
        path = osp.join(data_path, dir)
        result_path = osp.join(path, 'eval_result.json')
        if not os.path.exists(result_path):
            continue
        result_file = open(result_path, 'r')
        result = json.load(result_file)

        variant_path = osp.join(path, 'variant.json')
        variant = json.load(open(variant_path, 'r'))
        n_action = variant['pick_and_place_num']
        if performance_table.get(n_action, None) is None:
            performance_table[n_action] = []
            
        performance = filter_failed(dir, result, metric)
        # performance = [x for x in performance if x > 0]
        # all_performances += performance
        print(len(performance))

        performance_table[n_action] += performance

    print("#####  ", metric)
    for key, val in performance_table.items():
        print("n_action: ", key)
        print("number of runs: ", len(val))
        print("median of runs: ", np.median(val))
        print("mean of runs: ", np.mean(val))
        print("std of runs: ", np.std(val))

    # print("meidan of runs: ", np.median(val))
    # print("25 percentile of runs: ", np.quantile(val, 0.25))
    # print("75 percentile of runs: ", np.quantile(val, 0.75))
    # print("=======================================")

# print("performances: ", all_performances)
# print("num: ", len(all_performances))
# print("mean: ", np.mean(all_performances))
# print("median: ", np.median(all_performances))
# print("std: ", np.std(all_performances))


