import os
from chester import logger
import os.path as osp
import json

def run_task(vv, log_dir, exp_name):
    if not os.path.exists(log_dir):
        os.makedirs(log_dir, exist_ok=True)

    with open(osp.join(log_dir, 'variant.json'), 'w') as f:
        json.dump(vv, f, indent=2, sort_keys=True)

    # print("here")
    # if vv['debug']:
    #     exit()

    # print("here")

    # os.system("""
    # /bin/bash -c " source ./prepare.sh && conda activate softgym_t2t && \
    # echo "hh" "
    # """)

    # print("update t2t")

    # os.system("""
    # conda activate softgym_t2t && \
    # pip install -e GNS/fabric_vsf/vismpc/t2t && \
    # """)

    os.system("""
    /bin/bash -c ' source ./prepare.sh && conda activate softgym_t2t && \
    t2t-trainer --schedule=train --alsologtostderr --generate_data --tmp_dir {} \
    --data_dir={} --output_dir={} --problem=cloth \
    --model=next_frame_sv2p --hparams_set=next_frame_sv2p --train_steps={} --eval_steps=100 \
    --hparams="video_num_input_frames=3, video_num_target_frames=7" ' > {} 2> {}
    """.format(
        osp.join(log_dir, 'tmp_data'),
        osp.join(log_dir, 'train_data'), osp.join(log_dir, 'output_data'), 
        vv['train_steps'], osp.join(log_dir, 'vsf.out'), osp.join(log_dir, 'vsf.err')
    ))

    print("hahahah")

    # t2t-trainer --schedule=train --alsologtostderr --generate_data --tmp_dir ./GNS/fabric_vsf/data/sv2p_tmp_cloth \
    # --data_dir=./GNS/fabric_vsf/data/train_data --output_dir=./GNS/fabric_vsf/data/output_data --problem=cloth \
    # --model=next_frame_sv2p --hparams_set=next_frame_sv2p --train_steps=1000 —eval_steps=100 \
    # --hparams="video_num_input_frames=7, video_num_target_frames=3"


if __name__ == '__main__':
    vv = dict(
        data_dir='./GNS/fabric_vsf/data/train_data',
        output_dir='./GNS/fabric_vsf/data/output_data',
        train_steps=1000,
    )
    run_task(vv, None, exp_name='local_train')