import numpy as np
from scipy.signal import savgol_filter 
import matplotlib.pyplot as plt
import os

def plot_loss(loss,ev,eval_interval=100,savepath=None,showfig=True):
	loss_smooth = np.convolve(loss, np.ones(eval_interval)/eval_interval, mode='valid')
	x_smooth = np.arange(loss_smooth.shape[0]) + eval_interval
	fig,(ax1,ax2,ax3) = plt.subplots(3,1,figsize=(8,10))
	ax1.plot(loss,c='b',alpha=0.5)
	ax1.plot(x_smooth,loss_smooth,c='b')
	ax1.set_ylim(0,0.4)
	ax1.set_xlabel("train steps")
	ax1.set_ylabel("loss")
	ax1.set_title("training loss")

	plt.tight_layout()

	if savepath is not None:
		plt.savefig(savepath)
	if showfig:
		plt.show()