import os
import sys
import traceback
import time
import pandas as pd
import re
import datasets
import json
import statistics

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))
from epic import *
from utils import (
    create_dir_w_timestamp,
    get_txt_filepaths_from_dirs,
    read_txt,
    write_jsonl,
    write_epics,
    write_txt,
    write_json,
    load_json
)

# Directory for vipergpt programs
DATASET_NAME = "gqa_py_2025-02-22_02-20-53"
DIRNAME = f"datasets/{DATASET_NAME}"

RUN_RECORD_PY = "eval_2025-04-14_recording"
RUN_REPLAY_PY = "eval_2025-04-14_replay_python"
# RUN_REPLAY_EPIC_SYNC = "eval_2025-04-12_15-33-00"
RUN_REPLAY_EPIC_SYNC = "eval_2025-04-14_epic_sync"
RUN_REPLAY_EPIC_ASYNC = "eval_2025-04-14_epic_async"


RUN_A = RUN_RECORD_PY
EVAL_DIRNAME_A = f"{DIRNAME}/{RUN_A}"
RUN_B = RUN_REPLAY_PY
EVAL_DIRNAME_B = f"{DIRNAME}/{RUN_B}"

# Load vipergpt programs
PROGDIR = f"{DIRNAME}/orig_gen"
filepaths = get_txt_filepaths_from_dirs([PROGDIR])

factors = []
missing_progs_a = []
missing_progs_b = []
wrong_answer_progs = []
error_progs = []
for i, fn_path in enumerate(filepaths, 1):
    filename = os.path.basename(fn_path)
    print(f"[{i}/{len(filepaths)}] Processing: {filename}")
    
    filename_no_ext = os.path.splitext(filename)[0]
    
    res_a_path = os.path.join(EVAL_DIRNAME_A, f"{filename_no_ext}_exec.txt")
    res_b_path = os.path.join(EVAL_DIRNAME_B, f"{filename_no_ext}_exec.txt")

    try:
        try:
            with open(res_a_path, "r") as f:
                res_a = json.load(f)
        except FileNotFoundError:
            print(f"WARN: A missing {res_a_path}")
            missing_progs_a.append(filename_no_ext)
            continue
        
        try:
            with open(res_b_path, "r") as f:
                res_b = json.load(f)
        except FileNotFoundError:
            print(f"WARN: B missing {res_a_path}")
            missing_progs_b.append(filename_no_ext)
            continue
        
        if res_a["result"] == res_b["result"]:
            factors.append(res_b["time_ns"]/res_a["time_ns"])
        else:
            wrong_answer_progs.append((filename_no_ext, res_a["result"], res_b["result"]))
    except Exception:
        error_progs.append(filename_no_ext)


print(statistics.mean(factors), statistics.variance(factors))
print(min(factors), statistics.quantiles(factors), max(factors))
print(len(factors), len(missing_progs_a), len(missing_progs_b), len(wrong_answer_progs), len(error_progs))