import os
import datetime
import csv
import json

def create_dir_w_timestamp(dir_prefix):
    timestamp = datetime.datetime.now().strftime("%Y-%m-%d_%H-%M-%S")
    save_dir = f"{dir_prefix}_{timestamp}"
    os.makedirs(save_dir, exist_ok=True)
    return save_dir

def write_csv(filepath, data, header):
    with open(filepath, mode="w", newline="") as f:
        writer = csv.writer(f)
        writer.writerow(header)
        writer.writerows(data)

def write_dicts_to_csv(filepath, data, fieldnames=None):
    if fieldnames is None:
        fieldnames = list(data[0].keys())  # Infer from first dict
    with open(filepath, mode="w", newline="") as f:
        writer = csv.DictWriter(f, fieldnames=fieldnames)
        writer.writeheader()
        writer.writerows(data)

def write_txt(filepath, data):
    with open(filepath, "w") as f:
        f.write(data)

def read_txt(filepath):
    with open(filepath, "r") as f:
        data = f.read()
    return data

def write_jsonl(filepath, data):
    with open(filepath, "w") as f:
        for data_entry in data:
            f.write(json.dumps(data_entry) + "\n")

def load_json(filepath):
    with open(filepath, 'r') as f:
        data = json.load(f)
    return data

def write_json(filepath, data):
    with open(filepath, "w") as f:
        json.dump(data, f, indent=2)

def read_epics(filepath):
    with open(filepath, "r") as f:
        data = f.read()
    return data

def write_epics(filepath, data):
    from epic.epics_syntax import to_str
    filepath = os.path.splitext(filepath)[0] + ".epics"
    with open(filepath, "w") as f:
        f.write(to_str(data))

def load_prompt(prompt_path):
    with open(prompt_path, "r") as f:
        prompt = f.read()
    return prompt
    
# ==============================

def get_txt_filepaths_from_dirs(dirs):
    txt_files = []
    for dir in dirs:
        if os.path.isdir(dir):
            txt_files.extend(
                [os.path.join(dir, f) for f in os.listdir(dir) if f.endswith(".txt")]
            )
    return txt_files

def get_python_filepaths_from_dirs(dirs):
    python_files = []
    for dir in dirs:
        if os.path.isdir(dir):
            python_files.extend(
                [os.path.join(dir, f) for f in os.listdir(dir) if f.endswith(".py")]
            )
    return python_files

def get_epic_filepaths_from_dirs(dirs):
    epic_files = []
    for dir in dirs:
        if os.path.isdir(dir):
            epic_files.extend(
                [os.path.join(dir, f) for f in os.listdir(dir) if f.endswith(".epic-s-exp")]
            )
    return epic_files

def get_prog_filepaths_from_dirs(dirs):
    txt_files = []
    for dir in dirs:
        if os.path.isdir(dir):
            txt_files.extend(
                [os.path.join(dir, f) for f in os.listdir(dir) if f.endswith(".prog")]
            )
    return txt_files
