import base64
from io import BytesIO
import re

def encode_image(image_pil):
    buffer = BytesIO()
    try:
        image_pil.save(buffer, format="JPEG")
        buffer.seek(0)
        return base64.b64encode(buffer.read()).decode("utf-8")
    finally:
        buffer.close()

# def get_chat_response_for_image(client, model_name, prompt, base64_image):
#     try:
#         response = client.chat.completions.create(
#             model=model_name,
#             messages=[
#                 {
#                     "role": "user",
#                     "content": [
#                         {
#                             "type": "text",
#                             "text": prompt,
#                         },
#                         {
#                             "type": "image_url",
#                             "image_url": {"url": f"data:image/jpeg;base64,{base64_image}"},
#                         }
#                     ]
#                 }
#             ]
#         )
#         return response.choices[0].message.content.strip()
#     except Exception as e:
#         print(f"Error in ChatGPT response: {e}")
#         return None

def response_to_py_program(response, question):
    program = re.findall(r"```python(.*)```", response, re.DOTALL)[0].strip()
    program = re.sub(r"^#+.*\n+", "", program).strip()
    program = f"### {question}\n\n{program}"
    return program

def response_to_epics_program(response, question=None):
    program = re.findall(r"```epic(.*)```", response, re.DOTALL)[0].strip()
    program = re.sub(r"^#+.*\n+", "", program).strip()
    # program = f"### {question}\n\n{program}"
    return program