from avici import simulate_data

data_distributions = {
    'lin-gauss': "./environments/lin-gauss.yaml",
    'lin-gauss-heterosked': "./environments/lin-gauss-heterosked.yaml",
    'lin-laplace': "./environments/lin-laplace.yaml",
    'rff-gauss': "./environments/rff-gauss.yaml",
    'rff-gauss-heterosked': "./environments/rff-gauss-heterosked.yaml",
    'rff-laplace': "./environments/rff-laplace.yaml",
    'gene-ecoli': "./environments/gene-ecoli.yaml"
}

data_distributions_sf = {
    'lin-gauss': "./environments_sf/lin-gauss.yaml",
    'lin-gauss-heterosked': "./environments_sf/lin-gauss-heterosked.yaml",
    'lin-laplace': "./environments_sf/lin-laplace.yaml",
    'rff-gauss': "./environments_sf/rff-gauss.yaml",
    'rff-gauss-heterosked': "./environments_sf/rff-gauss-heterosked.yaml",
    'rff-laplace': "./environments_sf/rff-laplace.yaml",
    'gene-ecoli': "./environments_sf/gene-ecoli.yaml"
}

def generate_synthetic_data(d, n, n_interv, distribution="lin-gauss", seed=0,sf=False):
    if distribution not in data_distributions:
        raise NotImplementedError("Distrubution not available")
    if sf:
        distribution_path = data_distributions_sf[distribution]
    else:
        distribution_path = data_distributions[distribution]
    g, expr, I = simulate_data(d=d, n=n, path=distribution_path, n_interv=n_interv * d, seed=seed)


    return g, expr, I
