#include "dynamics_gpu.h"
#include <iostream>

#define GPU_1D_KERNEL_LOOP(i, n) \
  for (size_t i = blockIdx.x * blockDim.x + threadIdx.x; i < n; i += blockDim.x * gridDim.x)

#define NUM_THREADS 256
#define NUM_BLOCKS(batch_size) ((batch_size + NUM_THREADS - 1) / NUM_THREADS)

#define casadi_sq(x) (x*x)

// Cleaner wrapper for the generated dynamics
__device__ void _dynamics_gpu(const double *q_in, const double *qdot_in, const double *tau_in, const double *h_in,
                              double *q_out, double *qdot_out)
{
  const double *arg[4] = {q_in, qdot_in, tau_in, h_in};
  double *res[2] = {q_out, qdot_out};

  double a0, a1, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a2, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a3, a30, a31, a32, a33, a34, a35, a36, a37, a38, a39, a4, a40, a41, a42, a43, a44, a45, a46, a47, a48, a5, a6, a7, a8, a9;
  a0=arg[0]? arg[0][0] : 0;
  a1=arg[3]? arg[3][0] : 0;
  a2=arg[1]? arg[1][0] : 0;
  a3=2.;
  a4=(a1/a3);
  a5=arg[2]? arg[2][0] : 0;
  a6=arg[0]? arg[0][1] : 0;
  a7=cos(a6);
  a8=arg[1]? arg[1][1] : 0;
  a9=sin(a6);
  a10=(a9*a2);
  a11=(a8*a10);
  a12=arg[0]? arg[0][2] : 0;
  a13=cos(a12);
  a14=arg[1]? arg[1][2] : 0;
  a15=(a14+a8);
  a16=sin(a12);
  a17=(a7*a2);
  a18=(a17-a8);
  a19=(a16*a18);
  a20=(a13*a10);
  a19=(a19+a20);
  a20=(a15*a19);
  a21=-5.0000000000000000e-01;
  a22=arg[2]? arg[2][2] : 0;
  a23=(a19*a15);
  a23=(a22+a23);
  a24=(a21*a23);
  a25=5.0000000000000000e-01;
  a19=(a14*a19);
  a26=(a25*a19);
  a24=(a24-a26);
  a20=(a20+a24);
  a24=(a13*a20);
  a18=(a13*a18);
  a26=(a16*a10);
  a18=(a18-a26);
  a26=(a18-a15);
  a15=(a15*a26);
  a18=(a14*a18);
  a15=(a15-a18);
  a18=(a16*a15);
  a24=(a24-a18);
  a11=(a11+a24);
  a18=-1.;
  a26=(a25*a13);
  a27=(a26*a13);
  a28=casadi_sq(a16);
  a27=(a27+a28);
  a28=(a18-a27);
  a29=(a3+a27);
  a30=(a28/a29);
  a31=arg[2]? arg[2][1] : 0;
  a24=(a22-a24);
  a32=(a10*a8);
  a24=(a24-a32);
  a24=(a31-a24);
  a32=(a30*a24);
  a33=1.;
  a27=(a33+a27);
  a34=(a30*a28);
  a27=(a27-a34);
  a10=(a8*a10);
  a34=(a27*a10);
  a26=(a26*a16);
  a35=(a16*a13);
  a26=(a26-a35);
  a35=(a30*a26);
  a35=(a26+a35);
  a36=(a8*a17);
  a37=(a35*a36);
  a34=(a34+a37);
  a32=(a32-a34);
  a11=(a11+a32);
  a11=(a7*a11);
  a17=(a17-a8);
  a17=(a8*a17);
  a20=(a16*a20);
  a15=(a13*a15);
  a20=(a20+a15);
  a17=(a17+a20);
  a20=(a25*a16);
  a15=(a20*a13);
  a32=(a13*a16);
  a15=(a15-a32);
  a32=(a26/a29);
  a28=(a32*a28);
  a15=(a15+a28);
  a28=(a15*a10);
  a20=(a20*a16);
  a34=casadi_sq(a13);
  a20=(a20+a34);
  a20=(a33+a20);
  a26=(a32*a26);
  a20=(a20-a26);
  a26=(a20*a36);
  a28=(a28+a26);
  a26=(a32*a24);
  a28=(a28+a26);
  a17=(a17-a28);
  a17=(a9*a17);
  a11=(a11-a17);
  a11=(a5-a11);
  a17=10.;
  a28=(a7*a27);
  a26=(a9*a15);
  a28=(a28-a26);
  a28=(a28*a7);
  a26=(a7*a35);
  a34=(a9*a20);
  a26=(a26-a34);
  a26=(a26*a9);
  a28=(a28-a26);
  a28=(a17+a28);
  a11=(a11/a28);
  a26=9.8100000000000005e+00;
  a27=(a9*a27);
  a15=(a7*a15);
  a27=(a27+a15);
  a27=(a27*a7);
  a35=(a9*a35);
  a20=(a7*a20);
  a35=(a35+a20);
  a35=(a35*a9);
  a27=(a27-a35);
  a27=(a27/a28);
  a27=(a26*a27);
  a11=(a11-a27);
  a27=(a4*a11);
  a27=(a2+a27);
  a27=(a3*a27);
  a27=(a2+a27);
  a28=(a1/a3);
  a35=(a1/a3);
  a20=(a35*a8);
  a20=(a6+a20);
  a15=cos(a20);
  a34=(a1/a3);
  a24=(a24/a29);
  a29=(a7*a11);
  a37=(a26*a9);
  a29=(a29+a37);
  a29=(a29-a10);
  a30=(a30*a29);
  a7=(a26*a7);
  a9=(a9*a11);
  a7=(a7-a9);
  a7=(a7-a36);
  a32=(a32*a7);
  a30=(a30-a32);
  a24=(a24-a30);
  a30=(a34*a24);
  a30=(a8+a30);
  a20=sin(a20);
  a32=(a34*a11);
  a32=(a2+a32);
  a36=(a20*a32);
  a9=(a30*a36);
  a35=(a35*a14);
  a35=(a12+a35);
  a10=cos(a35);
  a23=(a25*a23);
  a29=(a29-a24);
  a13=(a13*a29);
  a16=(a16*a7);
  a13=(a13+a16);
  a13=(a13-a19);
  a13=(a21*a13);
  a13=(a13+a24);
  a23=(a23-a13);
  a34=(a34*a23);
  a34=(a14+a34);
  a13=(a34+a30);
  a35=sin(a35);
  a32=(a15*a32);
  a19=(a32-a30);
  a16=(a35*a19);
  a7=(a10*a36);
  a16=(a16+a7);
  a7=(a13*a16);
  a29=(a16*a13);
  a29=(a22+a29);
  a37=(a21*a29);
  a16=(a34*a16);
  a38=(a25*a16);
  a37=(a37-a38);
  a7=(a7+a37);
  a37=(a10*a7);
  a19=(a10*a19);
  a38=(a35*a36);
  a19=(a19-a38);
  a38=(a19-a13);
  a13=(a13*a38);
  a34=(a34*a19);
  a13=(a13-a34);
  a34=(a35*a13);
  a37=(a37-a34);
  a9=(a9+a37);
  a34=(a25*a10);
  a19=(a34*a10);
  a38=casadi_sq(a35);
  a19=(a19+a38);
  a38=(a18-a19);
  a39=(a3+a19);
  a40=(a38/a39);
  a37=(a22-a37);
  a41=(a36*a30);
  a37=(a37-a41);
  a37=(a31-a37);
  a41=(a40*a37);
  a19=(a33+a19);
  a42=(a40*a38);
  a19=(a19-a42);
  a36=(a30*a36);
  a42=(a19*a36);
  a34=(a34*a35);
  a43=(a35*a10);
  a34=(a34-a43);
  a43=(a40*a34);
  a43=(a34+a43);
  a44=(a30*a32);
  a45=(a43*a44);
  a42=(a42+a45);
  a41=(a41-a42);
  a9=(a9+a41);
  a9=(a15*a9);
  a32=(a32-a30);
  a30=(a30*a32);
  a7=(a35*a7);
  a13=(a10*a13);
  a7=(a7+a13);
  a30=(a30+a7);
  a7=(a25*a35);
  a13=(a7*a10);
  a32=(a10*a35);
  a13=(a13-a32);
  a32=(a34/a39);
  a38=(a32*a38);
  a13=(a13+a38);
  a38=(a13*a36);
  a7=(a7*a35);
  a41=casadi_sq(a10);
  a7=(a7+a41);
  a7=(a33+a7);
  a34=(a32*a34);
  a7=(a7-a34);
  a34=(a7*a44);
  a38=(a38+a34);
  a34=(a32*a37);
  a38=(a38+a34);
  a30=(a30-a38);
  a30=(a20*a30);
  a9=(a9-a30);
  a9=(a5-a9);
  a30=(a15*a19);
  a38=(a20*a13);
  a30=(a30-a38);
  a30=(a30*a15);
  a38=(a15*a43);
  a34=(a20*a7);
  a38=(a38-a34);
  a38=(a38*a20);
  a30=(a30-a38);
  a30=(a17+a30);
  a9=(a9/a30);
  a19=(a20*a19);
  a13=(a15*a13);
  a19=(a19+a13);
  a19=(a19*a15);
  a43=(a20*a43);
  a7=(a15*a7);
  a43=(a43+a7);
  a43=(a43*a20);
  a19=(a19-a43);
  a19=(a19/a30);
  a19=(a26*a19);
  a9=(a9-a19);
  a19=(a28*a9);
  a19=(a2+a19);
  a19=(a3*a19);
  a27=(a27+a19);
  a19=(a1/a3);
  a30=(a4*a24);
  a30=(a8+a30);
  a30=(a19*a30);
  a30=(a6+a30);
  a43=cos(a30);
  a7=(a1/a3);
  a37=(a37/a39);
  a39=(a15*a9);
  a13=(a26*a20);
  a39=(a39+a13);
  a39=(a39-a36);
  a40=(a40*a39);
  a15=(a26*a15);
  a20=(a20*a9);
  a15=(a15-a20);
  a15=(a15-a44);
  a32=(a32*a15);
  a40=(a40-a32);
  a37=(a37-a40);
  a40=(a7*a37);
  a40=(a8+a40);
  a30=sin(a30);
  a32=(a7*a9);
  a32=(a2+a32);
  a44=(a30*a32);
  a20=(a40*a44);
  a36=(a4*a23);
  a36=(a14+a36);
  a19=(a19*a36);
  a19=(a12+a19);
  a36=cos(a19);
  a29=(a25*a29);
  a39=(a39-a37);
  a10=(a10*a39);
  a35=(a35*a15);
  a10=(a10+a35);
  a10=(a10-a16);
  a10=(a21*a10);
  a10=(a10+a37);
  a29=(a29-a10);
  a7=(a7*a29);
  a7=(a14+a7);
  a10=(a7+a40);
  a19=sin(a19);
  a32=(a43*a32);
  a16=(a32-a40);
  a35=(a19*a16);
  a15=(a36*a44);
  a35=(a35+a15);
  a15=(a10*a35);
  a39=(a35*a10);
  a39=(a22+a39);
  a13=(a21*a39);
  a35=(a7*a35);
  a38=(a25*a35);
  a13=(a13-a38);
  a15=(a15+a13);
  a13=(a36*a15);
  a16=(a36*a16);
  a38=(a19*a44);
  a16=(a16-a38);
  a38=(a16-a10);
  a10=(a10*a38);
  a7=(a7*a16);
  a10=(a10-a7);
  a7=(a19*a10);
  a13=(a13-a7);
  a20=(a20+a13);
  a7=(a25*a36);
  a16=(a7*a36);
  a38=casadi_sq(a19);
  a16=(a16+a38);
  a38=(a18-a16);
  a34=(a3+a16);
  a41=(a38/a34);
  a13=(a22-a13);
  a42=(a44*a40);
  a13=(a13-a42);
  a13=(a31-a13);
  a42=(a41*a13);
  a16=(a33+a16);
  a45=(a41*a38);
  a16=(a16-a45);
  a44=(a40*a44);
  a45=(a16*a44);
  a7=(a7*a19);
  a46=(a19*a36);
  a7=(a7-a46);
  a46=(a41*a7);
  a46=(a7+a46);
  a47=(a40*a32);
  a48=(a46*a47);
  a45=(a45+a48);
  a42=(a42-a45);
  a20=(a20+a42);
  a20=(a43*a20);
  a32=(a32-a40);
  a40=(a40*a32);
  a15=(a19*a15);
  a10=(a36*a10);
  a15=(a15+a10);
  a40=(a40+a15);
  a15=(a25*a19);
  a10=(a15*a36);
  a32=(a36*a19);
  a10=(a10-a32);
  a32=(a7/a34);
  a38=(a32*a38);
  a10=(a10+a38);
  a38=(a10*a44);
  a15=(a15*a19);
  a42=casadi_sq(a36);
  a15=(a15+a42);
  a15=(a33+a15);
  a7=(a32*a7);
  a15=(a15-a7);
  a7=(a15*a47);
  a38=(a38+a7);
  a7=(a32*a13);
  a38=(a38+a7);
  a40=(a40-a38);
  a40=(a30*a40);
  a20=(a20-a40);
  a20=(a5-a20);
  a40=(a43*a16);
  a38=(a30*a10);
  a40=(a40-a38);
  a40=(a40*a43);
  a38=(a43*a46);
  a7=(a30*a15);
  a38=(a38-a7);
  a38=(a38*a30);
  a40=(a40-a38);
  a40=(a17+a40);
  a20=(a20/a40);
  a16=(a30*a16);
  a10=(a43*a10);
  a16=(a16+a10);
  a16=(a16*a43);
  a46=(a30*a46);
  a15=(a43*a15);
  a46=(a46+a15);
  a46=(a46*a30);
  a16=(a16-a46);
  a16=(a16/a40);
  a16=(a26*a16);
  a20=(a20-a16);
  a16=(a1*a20);
  a16=(a2+a16);
  a27=(a27+a16);
  a16=6.;
  a27=(a27/a16);
  a27=(a1*a27);
  a0=(a0+a27);
  if (res[0]!=0) res[0][0]=a0;
  a0=(a4*a24);
  a0=(a8+a0);
  a0=(a3*a0);
  a0=(a8+a0);
  a27=(a28*a37);
  a27=(a8+a27);
  a27=(a3*a27);
  a0=(a0+a27);
  a13=(a13/a34);
  a34=(a43*a20);
  a27=(a26*a30);
  a34=(a34+a27);
  a34=(a34-a44);
  a41=(a41*a34);
  a43=(a26*a43);
  a30=(a30*a20);
  a43=(a43-a30);
  a43=(a43-a47);
  a32=(a32*a43);
  a41=(a41-a32);
  a13=(a13-a41);
  a41=(a1*a13);
  a41=(a8+a41);
  a0=(a0+a41);
  a0=(a0/a16);
  a0=(a1*a0);
  a0=(a6+a0);
  if (res[0]!=0) res[0][1]=a0;
  a4=(a4*a23);
  a4=(a14+a4);
  a4=(a3*a4);
  a4=(a14+a4);
  a0=(a28*a29);
  a0=(a14+a0);
  a0=(a3*a0);
  a4=(a4+a0);
  a39=(a25*a39);
  a34=(a34-a13);
  a36=(a36*a34);
  a19=(a19*a43);
  a36=(a36+a19);
  a36=(a36-a35);
  a36=(a21*a36);
  a36=(a36+a13);
  a39=(a39-a36);
  a36=(a1*a39);
  a36=(a14+a36);
  a4=(a4+a36);
  a4=(a4/a16);
  a4=(a1*a4);
  a4=(a12+a4);
  if (res[0]!=0) res[0][2]=a4;
  a9=(a3*a9);
  a11=(a11+a9);
  a9=(a3*a20);
  a11=(a11+a9);
  a9=(a28*a37);
  a9=(a8+a9);
  a9=(a1*a9);
  a6=(a6+a9);
  a9=cos(a6);
  a4=(a1*a13);
  a4=(a8+a4);
  a6=sin(a6);
  a20=(a1*a20);
  a20=(a2+a20);
  a36=(a6*a20);
  a35=(a4*a36);
  a28=(a28*a29);
  a28=(a14+a28);
  a28=(a1*a28);
  a12=(a12+a28);
  a28=cos(a12);
  a19=(a1*a39);
  a19=(a14+a19);
  a43=(a19+a4);
  a12=sin(a12);
  a20=(a9*a20);
  a34=(a20-a4);
  a0=(a12*a34);
  a41=(a28*a36);
  a0=(a0+a41);
  a41=(a43*a0);
  a32=(a0*a43);
  a32=(a22+a32);
  a47=(a21*a32);
  a0=(a19*a0);
  a30=(a25*a0);
  a47=(a47-a30);
  a41=(a41+a47);
  a47=(a28*a41);
  a34=(a28*a34);
  a30=(a12*a36);
  a34=(a34-a30);
  a30=(a34-a43);
  a43=(a43*a30);
  a19=(a19*a34);
  a43=(a43-a19);
  a19=(a12*a43);
  a47=(a47-a19);
  a35=(a35+a47);
  a19=(a25*a28);
  a34=(a19*a28);
  a30=casadi_sq(a12);
  a34=(a34+a30);
  a18=(a18-a34);
  a30=(a3+a34);
  a44=(a18/a30);
  a22=(a22-a47);
  a47=(a36*a4);
  a22=(a22-a47);
  a31=(a31-a22);
  a22=(a44*a31);
  a34=(a33+a34);
  a47=(a44*a18);
  a34=(a34-a47);
  a36=(a4*a36);
  a47=(a34*a36);
  a19=(a19*a12);
  a27=(a12*a28);
  a19=(a19-a27);
  a27=(a44*a19);
  a27=(a19+a27);
  a40=(a4*a20);
  a46=(a27*a40);
  a47=(a47+a46);
  a22=(a22-a47);
  a35=(a35+a22);
  a35=(a9*a35);
  a20=(a20-a4);
  a4=(a4*a20);
  a41=(a12*a41);
  a43=(a28*a43);
  a41=(a41+a43);
  a4=(a4+a41);
  a41=(a25*a12);
  a43=(a41*a28);
  a20=(a28*a12);
  a43=(a43-a20);
  a20=(a19/a30);
  a18=(a20*a18);
  a43=(a43+a18);
  a18=(a43*a36);
  a41=(a41*a12);
  a22=casadi_sq(a28);
  a41=(a41+a22);
  a33=(a33+a41);
  a19=(a20*a19);
  a33=(a33-a19);
  a19=(a33*a40);
  a18=(a18+a19);
  a19=(a20*a31);
  a18=(a18+a19);
  a4=(a4-a18);
  a4=(a6*a4);
  a35=(a35-a4);
  a5=(a5-a35);
  a35=(a9*a34);
  a4=(a6*a43);
  a35=(a35-a4);
  a35=(a35*a9);
  a4=(a9*a27);
  a18=(a6*a33);
  a4=(a4-a18);
  a4=(a4*a6);
  a35=(a35-a4);
  a17=(a17+a35);
  a5=(a5/a17);
  a34=(a6*a34);
  a43=(a9*a43);
  a34=(a34+a43);
  a34=(a34*a9);
  a27=(a6*a27);
  a33=(a9*a33);
  a27=(a27+a33);
  a27=(a27*a6);
  a34=(a34-a27);
  a34=(a34/a17);
  a34=(a26*a34);
  a5=(a5-a34);
  a11=(a11+a5);
  a11=(a11/a16);
  a11=(a1*a11);
  a2=(a2+a11);
  if (res[1]!=0) res[1][0]=a2;
  a37=(a3*a37);
  a24=(a24+a37);
  a13=(a3*a13);
  a24=(a24+a13);
  a31=(a31/a30);
  a30=(a9*a5);
  a13=(a26*a6);
  a30=(a30+a13);
  a30=(a30-a36);
  a44=(a44*a30);
  a26=(a26*a9);
  a6=(a6*a5);
  a26=(a26-a6);
  a26=(a26-a40);
  a20=(a20*a26);
  a44=(a44-a20);
  a31=(a31-a44);
  a24=(a24+a31);
  a24=(a24/a16);
  a24=(a1*a24);
  a8=(a8+a24);
  if (res[1]!=0) res[1][1]=a8;
  a29=(a3*a29);
  a23=(a23+a29);
  a3=(a3*a39);
  a23=(a23+a3);
  a25=(a25*a32);
  a30=(a30-a31);
  a28=(a28*a30);
  a12=(a12*a26);
  a28=(a28+a12);
  a28=(a28-a0);
  a21=(a21*a28);
  a21=(a21+a31);
  a25=(a25-a21);
  a23=(a23+a25);
  a23=(a23/a16);
  a1=(a1*a23);
  a14=(a14+a1);
  if (res[1]!=0) res[1][2]=a14;
}

__device__ void _derivatives_gpu(const double *q_in, const double *qdot_in, const double *tau_in, const double *h_in,
                                 double *q_jac_qout, double *q_jac_qdotout, double *q_jac_uout,
                                 double *qdot_jac_qout, double *qdot_jac_qdotout, double *qdot_jac_tauout)
{
  const double *arg[4] = {q_in, qdot_in, tau_in, h_in};
  double *res[6] = {q_jac_qout, q_jac_qdotout, q_jac_uout, qdot_jac_qout, qdot_jac_qdotout, qdot_jac_tauout};

  double a0, a1, a10, a100, a101, a102, a103, a104, a105, a106, a107, a108, a109, a11, a110, a111, a112, a113, a114, a115, a116, a117, a118, a119, a12, a120, a121, a122, a123, a124, a125, a126, a127, a128, a129, a13, a130, a131, a132, a133, a134, a135, a136, a137, a138, a139, a14, a140, a141, a142, a143, a144, a145, a146, a147, a148, a149, a15, a150, a151, a152, a153, a154, a155, a156, a157, a158, a159, a16, a160, a161, a162, a163, a164, a165, a166, a167, a168, a169, a17, a170, a171, a172, a173, a174, a175, a176, a177, a178, a179, a18, a180, a181, a182, a183, a184, a185, a186, a187, a188, a189, a19, a190, a191, a192, a193, a194, a195, a196, a197, a198, a199, a2, a20, a200, a201, a202, a203, a204, a205, a206, a207, a208, a209, a21, a210, a211, a212, a213, a214, a215, a216, a217, a218, a219, a22, a220, a221, a222, a223, a224, a225, a226, a227, a228, a229, a23, a230, a231, a232, a233, a234, a24, a25, a26, a27, a28, a29, a3, a30, a31, a32, a33, a34, a35, a36, a37, a38, a39, a4, a40, a41, a42, a43, a44, a45, a46, a47, a48, a49, a5, a50, a51, a52, a53, a54, a55, a56, a57, a58, a59, a6, a60, a61, a62, a63, a64, a65, a66, a67, a68, a69, a7, a70, a71, a72, a73, a74, a75, a76, a77, a78, a79, a8, a80, a81, a82, a83, a84, a85, a86, a87, a88, a89, a9, a90, a91, a92, a93, a94, a95, a96, a97, a98, a99;
  a0=1.;
  if (res[0]!=0) res[0][0]=a0;
  a1=0.;
  if (res[0]!=0) res[0][1]=a1;
  if (res[0]!=0) res[0][2]=a1;
  a2=arg[3]? arg[3][0] : 0;
  a3=1.6666666666666666e-01;
  a4=2.;
  a5=(a2/a4);
  a6=arg[2]? arg[2][0] : 0;
  a7=arg[0]? arg[0][1] : 0;
  a8=cos(a7);
  a9=arg[1]? arg[1][1] : 0;
  a10=sin(a7);
  a11=arg[1]? arg[1][0] : 0;
  a12=(a10*a11);
  a13=(a9*a12);
  a14=arg[0]? arg[0][2] : 0;
  a15=cos(a14);
  a16=arg[1]? arg[1][2] : 0;
  a17=(a16+a9);
  a18=sin(a14);
  a19=(a8*a11);
  a20=(a19-a9);
  a21=(a18*a20);
  a22=(a15*a12);
  a21=(a21+a22);
  a22=(a17*a21);
  a23=-5.0000000000000000e-01;
  a24=arg[2]? arg[2][2] : 0;
  a25=(a21*a17);
  a25=(a24+a25);
  a26=(a23*a25);
  a27=5.0000000000000000e-01;
  a28=(a16*a21);
  a29=(a27*a28);
  a26=(a26-a29);
  a22=(a22+a26);
  a26=(a15*a22);
  a29=(a15*a20);
  a30=(a18*a12);
  a29=(a29-a30);
  a30=(a29-a17);
  a31=(a17*a30);
  a32=(a16*a29);
  a31=(a31-a32);
  a32=(a18*a31);
  a26=(a26-a32);
  a13=(a13+a26);
  a32=-1.;
  a33=(a27*a15);
  a34=(a33*a15);
  a35=casadi_sq(a18);
  a34=(a34+a35);
  a35=(a32-a34);
  a36=(a4+a34);
  a37=(a35/a36);
  a38=arg[2]? arg[2][1] : 0;
  a26=(a24-a26);
  a39=(a12*a9);
  a26=(a26-a39);
  a26=(a38-a26);
  a39=(a37*a26);
  a34=(a0+a34);
  a40=(a37*a35);
  a34=(a34-a40);
  a40=(a9*a12);
  a41=(a34*a40);
  a42=(a33*a18);
  a43=(a18*a15);
  a42=(a42-a43);
  a43=(a37*a42);
  a43=(a42+a43);
  a44=(a9*a19);
  a45=(a43*a44);
  a41=(a41+a45);
  a39=(a39-a41);
  a13=(a13+a39);
  a39=(a8*a13);
  a41=(a19-a9);
  a45=(a9*a41);
  a46=(a18*a22);
  a47=(a15*a31);
  a46=(a46+a47);
  a45=(a45+a46);
  a46=(a27*a18);
  a47=(a46*a15);
  a48=(a15*a18);
  a47=(a47-a48);
  a48=(a42/a36);
  a49=(a48*a35);
  a47=(a47+a49);
  a49=(a47*a40);
  a50=(a46*a18);
  a51=casadi_sq(a15);
  a50=(a50+a51);
  a50=(a0+a50);
  a51=(a48*a42);
  a50=(a50-a51);
  a51=(a50*a44);
  a49=(a49+a51);
  a51=(a48*a26);
  a49=(a49+a51);
  a45=(a45-a49);
  a49=(a10*a45);
  a39=(a39-a49);
  a39=(a6-a39);
  a49=10.;
  a51=(a8*a34);
  a52=(a10*a47);
  a51=(a51-a52);
  a52=(a51*a8);
  a53=(a8*a43);
  a54=(a10*a50);
  a53=(a53-a54);
  a54=(a53*a10);
  a52=(a52-a54);
  a52=(a49+a52);
  a39=(a39/a52);
  a54=(a39/a52);
  a55=sin(a7);
  a56=(a34*a55);
  a57=cos(a7);
  a58=(a47*a57);
  a56=(a56+a58);
  a56=(a8*a56);
  a58=(a51*a55);
  a56=(a56+a58);
  a58=(a53*a57);
  a59=(a43*a55);
  a60=(a50*a57);
  a59=(a59+a60);
  a59=(a10*a59);
  a58=(a58-a59);
  a56=(a56+a58);
  a58=(a54*a56);
  a59=(a11*a57);
  a60=(a9*a59);
  a61=(a15*a59);
  a62=(a11*a55);
  a63=(a18*a62);
  a61=(a61-a63);
  a63=(a17*a61);
  a64=(a17*a61);
  a65=(a23*a64);
  a61=(a16*a61);
  a66=(a27*a61);
  a65=(a65-a66);
  a63=(a63+a65);
  a65=(a15*a63);
  a66=(a15*a62);
  a67=(a18*a59);
  a66=(a66+a67);
  a67=(a16*a66);
  a66=(a17*a66);
  a67=(a67-a66);
  a66=(a18*a67);
  a65=(a65-a66);
  a60=(a60+a65);
  a66=(a9*a59);
  a65=(a65+a66);
  a66=(a37*a65);
  a59=(a9*a59);
  a68=(a34*a59);
  a69=(a9*a62);
  a70=(a43*a69);
  a68=(a68-a70);
  a66=(a66-a68);
  a60=(a60+a66);
  a60=(a8*a60);
  a66=(a13*a55);
  a60=(a60-a66);
  a66=(a45*a57);
  a63=(a18*a63);
  a67=(a15*a67);
  a63=(a63+a67);
  a62=(a9*a62);
  a63=(a63-a62);
  a62=(a47*a59);
  a67=(a50*a69);
  a62=(a62-a67);
  a67=(a48*a65);
  a62=(a62+a67);
  a63=(a63-a62);
  a63=(a10*a63);
  a66=(a66+a63);
  a60=(a60-a66);
  a60=(a60/a52);
  a58=(a58-a60);
  a60=9.8100000000000005e+00;
  a66=(a34*a57);
  a63=(a47*a55);
  a66=(a66-a63);
  a66=(a8*a66);
  a63=(a10*a34);
  a62=(a8*a47);
  a63=(a63+a62);
  a62=(a63*a55);
  a66=(a66-a62);
  a62=(a43*a57);
  a67=(a50*a55);
  a62=(a62-a67);
  a62=(a10*a62);
  a67=(a10*a43);
  a68=(a8*a50);
  a67=(a67+a68);
  a68=(a67*a57);
  a62=(a62+a68);
  a66=(a66-a62);
  a66=(a66/a52);
  a62=(a63*a8);
  a68=(a67*a10);
  a62=(a62-a68);
  a62=(a62/a52);
  a68=(a62/a52);
  a56=(a68*a56);
  a66=(a66+a56);
  a66=(a60*a66);
  a58=(a58-a66);
  a66=(a5*a58);
  a66=(a4*a66);
  a56=(a2/a4);
  a70=(a2/a4);
  a71=(a70*a9);
  a71=(a7+a71);
  a72=cos(a71);
  a73=(a2/a4);
  a74=(a26/a36);
  a75=(a60*a62);
  a75=(a39-a75);
  a76=(a8*a75);
  a77=(a60*a10);
  a76=(a76+a77);
  a76=(a76-a40);
  a77=(a37*a76);
  a78=(a60*a8);
  a79=(a10*a75);
  a78=(a78-a79);
  a78=(a78-a44);
  a79=(a48*a78);
  a77=(a77-a79);
  a77=(a74-a77);
  a79=(a73*a77);
  a79=(a9+a79);
  a80=sin(a71);
  a81=(a73*a75);
  a81=(a11+a81);
  a82=(a80*a81);
  a83=(a79*a82);
  a84=(a70*a16);
  a84=(a14+a84);
  a85=cos(a84);
  a25=(a27*a25);
  a86=(a76-a77);
  a87=(a15*a86);
  a88=(a18*a78);
  a87=(a87+a88);
  a87=(a87-a28);
  a87=(a23*a87);
  a87=(a87+a77);
  a25=(a25-a87);
  a87=(a73*a25);
  a87=(a16+a87);
  a28=(a87+a79);
  a88=sin(a84);
  a89=(a72*a81);
  a90=(a89-a79);
  a91=(a88*a90);
  a92=(a85*a82);
  a91=(a91+a92);
  a92=(a28*a91);
  a93=(a91*a28);
  a93=(a24+a93);
  a94=(a23*a93);
  a95=(a87*a91);
  a96=(a27*a95);
  a94=(a94-a96);
  a92=(a92+a94);
  a94=(a85*a92);
  a96=(a85*a90);
  a97=(a88*a82);
  a96=(a96-a97);
  a97=(a96-a28);
  a98=(a28*a97);
  a99=(a87*a96);
  a98=(a98-a99);
  a99=(a88*a98);
  a94=(a94-a99);
  a83=(a83+a94);
  a99=(a27*a85);
  a100=(a99*a85);
  a101=casadi_sq(a88);
  a100=(a100+a101);
  a101=(a32-a100);
  a102=(a4+a100);
  a103=(a101/a102);
  a94=(a24-a94);
  a104=(a82*a79);
  a94=(a94-a104);
  a94=(a38-a94);
  a104=(a103*a94);
  a100=(a0+a100);
  a105=(a103*a101);
  a100=(a100-a105);
  a105=(a79*a82);
  a106=(a100*a105);
  a107=(a99*a88);
  a108=(a88*a85);
  a107=(a107-a108);
  a108=(a103*a107);
  a108=(a107+a108);
  a109=(a79*a89);
  a110=(a108*a109);
  a106=(a106+a110);
  a104=(a104-a106);
  a83=(a83+a104);
  a104=(a72*a83);
  a106=(a89-a79);
  a110=(a79*a106);
  a111=(a88*a92);
  a112=(a85*a98);
  a111=(a111+a112);
  a110=(a110+a111);
  a111=(a27*a88);
  a112=(a111*a85);
  a113=(a85*a88);
  a112=(a112-a113);
  a113=(a107/a102);
  a114=(a113*a101);
  a112=(a112+a114);
  a114=(a112*a105);
  a115=(a111*a88);
  a116=casadi_sq(a85);
  a115=(a115+a116);
  a115=(a0+a115);
  a116=(a113*a107);
  a115=(a115-a116);
  a116=(a115*a109);
  a114=(a114+a116);
  a116=(a113*a94);
  a114=(a114+a116);
  a110=(a110-a114);
  a114=(a80*a110);
  a104=(a104-a114);
  a104=(a6-a104);
  a114=(a72*a100);
  a116=(a80*a112);
  a114=(a114-a116);
  a116=(a114*a72);
  a117=(a72*a108);
  a118=(a80*a115);
  a117=(a117-a118);
  a118=(a117*a80);
  a116=(a116-a118);
  a116=(a49+a116);
  a104=(a104/a116);
  a118=(a104/a116);
  a119=sin(a71);
  a120=(a100*a119);
  a121=cos(a71);
  a122=(a112*a121);
  a120=(a120+a122);
  a120=(a72*a120);
  a122=(a114*a119);
  a120=(a120+a122);
  a122=(a117*a121);
  a123=(a108*a119);
  a124=(a115*a121);
  a123=(a123+a124);
  a123=(a80*a123);
  a122=(a122-a123);
  a120=(a120+a122);
  a122=(a118*a120);
  a65=(a65/a36);
  a123=(a8*a58);
  a124=(a75*a55);
  a123=(a123-a124);
  a124=(a60*a57);
  a123=(a123+a124);
  a123=(a123-a59);
  a59=(a37*a123);
  a55=(a60*a55);
  a57=(a75*a57);
  a124=(a10*a58);
  a57=(a57+a124);
  a55=(a55+a57);
  a69=(a69-a55);
  a55=(a48*a69);
  a59=(a59-a55);
  a65=(a65-a59);
  a59=(a73*a65);
  a55=(a82*a59);
  a57=(a81*a121);
  a58=(a73*a58);
  a124=(a80*a58);
  a57=(a57+a124);
  a124=(a79*a57);
  a55=(a55+a124);
  a64=(a27*a64);
  a123=(a123-a65);
  a123=(a15*a123);
  a69=(a18*a69);
  a123=(a123+a69);
  a123=(a123-a61);
  a123=(a23*a123);
  a123=(a123+a65);
  a64=(a64-a123);
  a123=(a73*a64);
  a61=(a123+a59);
  a69=(a91*a61);
  a58=(a72*a58);
  a124=(a81*a119);
  a58=(a58-a124);
  a124=(a58-a59);
  a125=(a88*a124);
  a126=(a85*a57);
  a125=(a125+a126);
  a126=(a28*a125);
  a69=(a69+a126);
  a126=(a28*a125);
  a127=(a91*a61);
  a126=(a126+a127);
  a127=(a23*a126);
  a128=(a91*a123);
  a125=(a87*a125);
  a128=(a128+a125);
  a125=(a27*a128);
  a127=(a127-a125);
  a69=(a69+a127);
  a127=(a85*a69);
  a125=(a97*a61);
  a124=(a85*a124);
  a129=(a88*a57);
  a124=(a124-a129);
  a61=(a124-a61);
  a61=(a28*a61);
  a125=(a125+a61);
  a123=(a96*a123);
  a124=(a87*a124);
  a123=(a123+a124);
  a125=(a125-a123);
  a123=(a88*a125);
  a127=(a127-a123);
  a55=(a55+a127);
  a123=(a79*a57);
  a124=(a82*a59);
  a123=(a123+a124);
  a127=(a127+a123);
  a123=(a103*a127);
  a124=(a82*a59);
  a57=(a79*a57);
  a124=(a124+a57);
  a57=(a100*a124);
  a61=(a89*a59);
  a129=(a79*a58);
  a61=(a61+a129);
  a129=(a108*a61);
  a57=(a57+a129);
  a123=(a123-a57);
  a55=(a55+a123);
  a55=(a72*a55);
  a123=(a83*a119);
  a55=(a55-a123);
  a123=(a110*a121);
  a57=(a106*a59);
  a58=(a58-a59);
  a58=(a79*a58);
  a57=(a57+a58);
  a69=(a88*a69);
  a125=(a85*a125);
  a69=(a69+a125);
  a57=(a57+a69);
  a69=(a112*a124);
  a125=(a115*a61);
  a69=(a69+a125);
  a125=(a113*a127);
  a69=(a69+a125);
  a57=(a57-a69);
  a57=(a80*a57);
  a123=(a123+a57);
  a55=(a55-a123);
  a55=(a55/a116);
  a122=(a122-a55);
  a55=(a100*a121);
  a123=(a112*a119);
  a55=(a55-a123);
  a55=(a72*a55);
  a123=(a80*a100);
  a57=(a72*a112);
  a123=(a123+a57);
  a57=(a123*a119);
  a55=(a55-a57);
  a57=(a108*a121);
  a69=(a115*a119);
  a57=(a57-a69);
  a57=(a80*a57);
  a69=(a80*a108);
  a125=(a72*a115);
  a69=(a69+a125);
  a125=(a69*a121);
  a57=(a57+a125);
  a55=(a55-a57);
  a55=(a55/a116);
  a57=(a123*a72);
  a125=(a69*a80);
  a57=(a57-a125);
  a57=(a57/a116);
  a125=(a57/a116);
  a120=(a125*a120);
  a55=(a55+a120);
  a55=(a60*a55);
  a122=(a122-a55);
  a55=(a56*a122);
  a55=(a4*a55);
  a66=(a66+a55);
  a55=(a2/a4);
  a77=(a5*a77);
  a77=(a9+a77);
  a77=(a55*a77);
  a77=(a7+a77);
  a120=cos(a77);
  a58=sin(a77);
  a59=(a2/a4);
  a129=(a60*a57);
  a129=(a104-a129);
  a130=(a59*a129);
  a130=(a11+a130);
  a131=(a58*a130);
  a127=(a127/a102);
  a132=(a72*a122);
  a133=(a129*a119);
  a132=(a132-a133);
  a133=(a60*a121);
  a132=(a132+a133);
  a132=(a132-a124);
  a124=(a103*a132);
  a119=(a60*a119);
  a121=(a129*a121);
  a133=(a80*a122);
  a121=(a121+a133);
  a119=(a119+a121);
  a119=(a119+a61);
  a61=(a113*a119);
  a124=(a124+a61);
  a127=(a127-a124);
  a124=(a59*a127);
  a61=(a131*a124);
  a121=(a94/a102);
  a133=(a72*a129);
  a134=(a60*a80);
  a133=(a133+a134);
  a133=(a133-a105);
  a134=(a103*a133);
  a135=(a60*a72);
  a136=(a80*a129);
  a135=(a135-a136);
  a135=(a135-a109);
  a136=(a113*a135);
  a134=(a134-a136);
  a134=(a121-a134);
  a136=(a59*a134);
  a136=(a9+a136);
  a137=cos(a77);
  a138=(a5*a65);
  a138=(a55*a138);
  a138=(a0+a138);
  a139=(a137*a138);
  a140=(a130*a139);
  a122=(a59*a122);
  a141=(a58*a122);
  a140=(a140+a141);
  a141=(a136*a140);
  a61=(a61+a141);
  a25=(a5*a25);
  a25=(a16+a25);
  a25=(a55*a25);
  a25=(a14+a25);
  a141=cos(a25);
  a142=sin(a25);
  a143=(a120*a130);
  a144=(a143-a136);
  a145=(a142*a144);
  a146=(a141*a131);
  a145=(a145+a146);
  a126=(a27*a126);
  a132=(a132-a127);
  a132=(a85*a132);
  a119=(a88*a119);
  a132=(a132-a119);
  a132=(a132-a128);
  a132=(a23*a132);
  a132=(a132+a127);
  a126=(a126-a132);
  a132=(a59*a126);
  a128=(a132+a124);
  a119=(a145*a128);
  a93=(a27*a93);
  a146=(a133-a134);
  a147=(a85*a146);
  a148=(a88*a135);
  a147=(a147+a148);
  a147=(a147-a95);
  a147=(a23*a147);
  a147=(a147+a134);
  a93=(a93-a147);
  a147=(a59*a93);
  a147=(a16+a147);
  a95=(a147+a136);
  a148=cos(a25);
  a149=(a5*a64);
  a149=(a55*a149);
  a150=(a148*a149);
  a151=(a144*a150);
  a122=(a120*a122);
  a152=sin(a77);
  a138=(a152*a138);
  a153=(a130*a138);
  a122=(a122-a153);
  a153=(a122-a124);
  a154=(a142*a153);
  a151=(a151+a154);
  a154=(a141*a140);
  a155=sin(a25);
  a149=(a155*a149);
  a156=(a131*a149);
  a154=(a154-a156);
  a151=(a151+a154);
  a154=(a95*a151);
  a119=(a119+a154);
  a154=(a95*a151);
  a156=(a145*a128);
  a154=(a154+a156);
  a156=(a23*a154);
  a157=(a145*a132);
  a151=(a147*a151);
  a157=(a157+a151);
  a151=(a27*a157);
  a156=(a156-a151);
  a119=(a119+a156);
  a156=(a141*a119);
  a151=(a95*a145);
  a158=(a145*a95);
  a158=(a24+a158);
  a159=(a23*a158);
  a160=(a147*a145);
  a161=(a27*a160);
  a159=(a159-a161);
  a151=(a151+a159);
  a159=(a151*a149);
  a156=(a156-a159);
  a159=(a141*a144);
  a161=(a142*a131);
  a159=(a159-a161);
  a161=(a159-a95);
  a162=(a95*a161);
  a163=(a147*a159);
  a162=(a162-a163);
  a163=(a162*a150);
  a164=(a161*a128);
  a153=(a141*a153);
  a165=(a144*a149);
  a153=(a153-a165);
  a165=(a131*a150);
  a166=(a142*a140);
  a165=(a165+a166);
  a153=(a153-a165);
  a128=(a153-a128);
  a128=(a95*a128);
  a164=(a164+a128);
  a132=(a159*a132);
  a153=(a147*a153);
  a132=(a132+a153);
  a164=(a164-a132);
  a132=(a142*a164);
  a163=(a163+a132);
  a156=(a156-a163);
  a61=(a61+a156);
  a163=(a27*a141);
  a132=(a163*a141);
  a153=casadi_sq(a142);
  a132=(a132+a153);
  a153=(a32-a132);
  a128=(a4+a132);
  a165=(a153/a128);
  a166=(a136*a140);
  a167=(a131*a124);
  a166=(a166+a167);
  a156=(a156+a166);
  a166=(a165*a156);
  a167=(a141*a151);
  a168=(a142*a162);
  a167=(a167-a168);
  a168=(a24-a167);
  a169=(a131*a136);
  a168=(a168-a169);
  a168=(a38-a168);
  a169=(a142+a142);
  a170=(a169*a150);
  a171=(a27*a149);
  a172=(a141*a171);
  a173=(a163*a149);
  a172=(a172+a173);
  a170=(a170-a172);
  a172=(a170/a128);
  a173=(a165/a128);
  a174=(a173*a170);
  a172=(a172+a174);
  a174=(a168*a172);
  a166=(a166-a174);
  a174=(a136*a131);
  a175=(a153*a172);
  a176=(a165*a170);
  a175=(a175+a176);
  a175=(a170+a175);
  a176=(a174*a175);
  a132=(a0+a132);
  a177=(a165*a153);
  a132=(a132-a177);
  a177=(a131*a124);
  a140=(a136*a140);
  a177=(a177+a140);
  a140=(a132*a177);
  a176=(a176+a140);
  a140=(a136*a143);
  a178=(a163*a150);
  a171=(a142*a171);
  a178=(a178-a171);
  a171=(a141*a150);
  a179=(a142*a149);
  a171=(a171-a179);
  a178=(a178-a171);
  a171=(a165*a178);
  a179=(a163*a142);
  a180=(a142*a141);
  a179=(a179-a180);
  a180=(a179*a172);
  a171=(a171-a180);
  a171=(a178+a171);
  a180=(a140*a171);
  a181=(a165*a179);
  a181=(a179+a181);
  a182=(a143*a124);
  a183=(a136*a122);
  a182=(a182+a183);
  a183=(a181*a182);
  a180=(a180+a183);
  a176=(a176+a180);
  a166=(a166-a176);
  a61=(a61+a166);
  a61=(a120*a61);
  a166=(a136*a131);
  a166=(a166+a167);
  a167=(a165*a168);
  a176=(a132*a174);
  a180=(a181*a140);
  a176=(a176+a180);
  a167=(a167-a176);
  a166=(a166+a167);
  a167=(a166*a138);
  a61=(a61-a167);
  a167=(a143-a136);
  a176=(a136*a167);
  a180=(a142*a151);
  a183=(a141*a162);
  a180=(a180+a183);
  a176=(a176+a180);
  a180=(a27*a142);
  a183=(a180*a141);
  a184=(a141*a142);
  a183=(a183-a184);
  a184=(a179/a128);
  a185=(a184*a153);
  a183=(a183+a185);
  a185=(a183*a174);
  a186=(a180*a142);
  a187=casadi_sq(a141);
  a186=(a186+a187);
  a186=(a0+a186);
  a187=(a184*a179);
  a186=(a186-a187);
  a187=(a186*a140);
  a185=(a185+a187);
  a187=(a184*a168);
  a185=(a185+a187);
  a176=(a176-a185);
  a185=(a176*a139);
  a187=(a167*a124);
  a122=(a122-a124);
  a122=(a136*a122);
  a187=(a187+a122);
  a122=(a151*a150);
  a119=(a142*a119);
  a122=(a122+a119);
  a164=(a141*a164);
  a119=(a162*a149);
  a164=(a164-a119);
  a122=(a122+a164);
  a187=(a187+a122);
  a122=(a27*a150);
  a164=(a141*a122);
  a119=(a180*a149);
  a164=(a164-a119);
  a119=(a141*a150);
  a124=(a142*a149);
  a119=(a119-a124);
  a164=(a164-a119);
  a119=(a178/a128);
  a124=(a184/a128);
  a188=(a124*a170);
  a119=(a119-a188);
  a188=(a153*a119);
  a189=(a184*a170);
  a188=(a188-a189);
  a164=(a164+a188);
  a188=(a174*a164);
  a189=(a183*a177);
  a188=(a188+a189);
  a122=(a142*a122);
  a189=(a180*a150);
  a122=(a122+a189);
  a189=(a141+a141);
  a190=(a189*a149);
  a122=(a122-a190);
  a190=(a179*a119);
  a178=(a184*a178);
  a190=(a190+a178);
  a122=(a122-a190);
  a190=(a140*a122);
  a178=(a186*a182);
  a190=(a190+a178);
  a188=(a188+a190);
  a190=(a168*a119);
  a178=(a184*a156);
  a190=(a190+a178);
  a188=(a188+a190);
  a187=(a187-a188);
  a187=(a58*a187);
  a185=(a185+a187);
  a61=(a61-a185);
  a185=(a120*a132);
  a187=(a58*a183);
  a185=(a185-a187);
  a187=(a185*a120);
  a188=(a120*a181);
  a190=(a58*a186);
  a188=(a188-a190);
  a190=(a188*a58);
  a187=(a187-a190);
  a187=(a49+a187);
  a61=(a61/a187);
  a190=(a120*a166);
  a178=(a58*a176);
  a190=(a190-a178);
  a190=(a6-a190);
  a190=(a190/a187);
  a178=(a190/a187);
  a191=(a120*a175);
  a192=(a132*a138);
  a191=(a191-a192);
  a192=(a183*a139);
  a193=(a58*a164);
  a192=(a192+a193);
  a191=(a191-a192);
  a191=(a120*a191);
  a192=(a185*a138);
  a191=(a191-a192);
  a192=(a120*a171);
  a193=(a181*a138);
  a192=(a192-a193);
  a193=(a186*a139);
  a194=(a58*a122);
  a193=(a193+a194);
  a192=(a192-a193);
  a192=(a58*a192);
  a193=(a188*a139);
  a192=(a192+a193);
  a191=(a191-a192);
  a192=(a178*a191);
  a61=(a61+a192);
  a192=(a132*a139);
  a175=(a58*a175);
  a192=(a192+a175);
  a164=(a120*a164);
  a175=(a183*a138);
  a164=(a164-a175);
  a192=(a192+a164);
  a192=(a120*a192);
  a164=(a58*a132);
  a175=(a120*a183);
  a164=(a164+a175);
  a175=(a164*a138);
  a192=(a192-a175);
  a175=(a181*a139);
  a171=(a58*a171);
  a175=(a175+a171);
  a122=(a120*a122);
  a171=(a186*a138);
  a122=(a122-a171);
  a175=(a175+a122);
  a175=(a58*a175);
  a122=(a58*a181);
  a171=(a120*a186);
  a122=(a122+a171);
  a171=(a122*a139);
  a175=(a175+a171);
  a192=(a192-a175);
  a192=(a192/a187);
  a175=(a164*a120);
  a171=(a122*a58);
  a175=(a175-a171);
  a175=(a175/a187);
  a171=(a175/a187);
  a191=(a171*a191);
  a192=(a192-a191);
  a192=(a60*a192);
  a61=(a61+a192);
  a192=(a2*a61);
  a66=(a66-a192);
  a66=(a3*a66);
  a66=(a2*a66);
  if (res[0]!=0) res[0][3]=a66;
  a65=(a5*a65);
  a65=(a4*a65);
  a127=(a56*a127);
  a127=(a4*a127);
  a65=(a65+a127);
  a156=(a156/a128);
  a127=(a168/a128);
  a66=(a127/a128);
  a170=(a66*a170);
  a156=(a156-a170);
  a170=(a60*a139);
  a192=(a60*a175);
  a192=(a190-a192);
  a191=(a192*a138);
  a193=(a120*a61);
  a191=(a191+a193);
  a170=(a170-a191);
  a170=(a170-a177);
  a177=(a165*a170);
  a191=(a120*a192);
  a193=(a60*a58);
  a191=(a191+a193);
  a191=(a191-a174);
  a172=(a191*a172);
  a177=(a177-a172);
  a172=(a60*a120);
  a193=(a58*a192);
  a172=(a172-a193);
  a172=(a172-a140);
  a119=(a172*a119);
  a138=(a60*a138);
  a139=(a192*a139);
  a61=(a58*a61);
  a139=(a139-a61);
  a138=(a138+a139);
  a138=(a138+a182);
  a182=(a184*a138);
  a119=(a119-a182);
  a177=(a177-a119);
  a156=(a156-a177);
  a177=(a2*a156);
  a65=(a65+a177);
  a65=(a3*a65);
  a65=(a2*a65);
  a65=(a0+a65);
  if (res[0]!=0) res[0][4]=a65;
  a64=(a5*a64);
  a64=(a4*a64);
  a126=(a56*a126);
  a126=(a4*a126);
  a64=(a64+a126);
  a154=(a27*a154);
  a170=(a170-a156);
  a170=(a141*a170);
  a126=(a165*a191);
  a65=(a184*a172);
  a126=(a126-a65);
  a126=(a127-a126);
  a65=(a191-a126);
  a149=(a65*a149);
  a170=(a170-a149);
  a150=(a172*a150);
  a138=(a142*a138);
  a150=(a150-a138);
  a170=(a170+a150);
  a170=(a170-a157);
  a170=(a23*a170);
  a170=(a170+a156);
  a154=(a154-a170);
  a154=(a2*a154);
  a64=(a64+a154);
  a64=(a3*a64);
  a64=(a2*a64);
  if (res[0]!=0) res[0][5]=a64;
  a64=cos(a14);
  a154=(a20*a64);
  a170=sin(a14);
  a156=(a12*a170);
  a154=(a154-a156);
  a156=(a17*a154);
  a157=(a17*a154);
  a150=(a23*a157);
  a154=(a16*a154);
  a138=(a27*a154);
  a150=(a150-a138);
  a156=(a156+a150);
  a150=(a15*a156);
  a138=(a22*a170);
  a150=(a150-a138);
  a138=(a31*a64);
  a149=(a20*a170);
  a177=(a12*a64);
  a149=(a149+a177);
  a177=(a16*a149);
  a149=(a17*a149);
  a177=(a177-a149);
  a149=(a18*a177);
  a138=(a138+a149);
  a150=(a150-a138);
  a138=(a37*a150);
  a149=(a18+a18);
  a149=(a149*a64);
  a119=(a27*a170);
  a182=(a15*a119);
  a139=(a33*a170);
  a182=(a182+a139);
  a149=(a149-a182);
  a182=(a149/a36);
  a139=(a37/a36);
  a139=(a139*a149);
  a182=(a182+a139);
  a139=(a26*a182);
  a138=(a138-a139);
  a139=(a35*a182);
  a61=(a37*a149);
  a139=(a139+a61);
  a139=(a149+a139);
  a61=(a40*a139);
  a193=(a33*a64);
  a119=(a18*a119);
  a193=(a193-a119);
  a119=casadi_sq(a15);
  a194=casadi_sq(a18);
  a119=(a119-a194);
  a193=(a193-a119);
  a119=(a37*a193);
  a194=(a42*a182);
  a119=(a119-a194);
  a119=(a193+a119);
  a194=(a44*a119);
  a61=(a61+a194);
  a138=(a138-a61);
  a138=(a150+a138);
  a138=(a8*a138);
  a61=(a22*a64);
  a156=(a18*a156);
  a61=(a61+a156);
  a177=(a15*a177);
  a156=(a31*a170);
  a177=(a177-a156);
  a61=(a61+a177);
  a177=(a27*a64);
  a156=(a15*a177);
  a194=(a46*a170);
  a156=(a156-a194);
  a194=casadi_sq(a15);
  a195=casadi_sq(a18);
  a194=(a194-a195);
  a156=(a156-a194);
  a194=(a193/a36);
  a195=(a48/a36);
  a195=(a195*a149);
  a194=(a194-a195);
  a195=(a35*a194);
  a196=(a48*a149);
  a195=(a195-a196);
  a156=(a156+a195);
  a195=(a40*a156);
  a177=(a18*a177);
  a196=(a46*a64);
  a177=(a177+a196);
  a196=(a15+a15);
  a196=(a196*a170);
  a177=(a177-a196);
  a196=(a42*a194);
  a193=(a48*a193);
  a196=(a196+a193);
  a177=(a177-a196);
  a196=(a44*a177);
  a195=(a195+a196);
  a196=(a26*a194);
  a193=(a48*a150);
  a196=(a196+a193);
  a195=(a195+a196);
  a61=(a61-a195);
  a61=(a10*a61);
  a138=(a138-a61);
  a138=(a138/a52);
  a61=(a8*a139);
  a195=(a10*a156);
  a61=(a61-a195);
  a61=(a8*a61);
  a195=(a8*a119);
  a196=(a10*a177);
  a195=(a195-a196);
  a195=(a10*a195);
  a61=(a61-a195);
  a54=(a54*a61);
  a138=(a138+a54);
  a139=(a10*a139);
  a156=(a8*a156);
  a139=(a139+a156);
  a139=(a8*a139);
  a119=(a10*a119);
  a177=(a8*a177);
  a119=(a119+a177);
  a119=(a10*a119);
  a139=(a139-a119);
  a139=(a139/a52);
  a68=(a68*a61);
  a139=(a139-a68);
  a139=(a60*a139);
  a138=(a138+a139);
  a139=(a5*a138);
  a139=(a4*a139);
  a150=(a150/a36);
  a68=(a74/a36);
  a68=(a68*a149);
  a150=(a150-a68);
  a182=(a76*a182);
  a68=(a8*a138);
  a149=(a37*a68);
  a182=(a182+a149);
  a194=(a78*a194);
  a149=(a10*a138);
  a61=(a48*a149);
  a194=(a194+a61);
  a182=(a182+a194);
  a150=(a150+a182);
  a182=(a73*a150);
  a194=(a82*a182);
  a138=(a73*a138);
  a61=(a80*a138);
  a119=(a79*a61);
  a194=(a194-a119);
  a157=(a27*a157);
  a64=(a78*a64);
  a149=(a18*a149);
  a64=(a64+a149);
  a170=(a86*a170);
  a68=(a68+a150);
  a68=(a15*a68);
  a170=(a170+a68);
  a64=(a64-a170);
  a64=(a64-a154);
  a64=(a23*a64);
  a64=(a64+a150);
  a157=(a157-a64);
  a64=(a73*a157);
  a154=(a64+a182);
  a170=(a91*a154);
  a68=cos(a84);
  a149=(a90*a68);
  a138=(a72*a138);
  a119=(a138+a182);
  a177=(a88*a119);
  a149=(a149-a177);
  a177=sin(a84);
  a156=(a82*a177);
  a54=(a85*a61);
  a156=(a156+a54);
  a149=(a149-a156);
  a156=(a28*a149);
  a170=(a170+a156);
  a156=(a28*a149);
  a54=(a91*a154);
  a156=(a156+a54);
  a54=(a23*a156);
  a195=(a91*a64);
  a149=(a87*a149);
  a195=(a195+a149);
  a149=(a27*a195);
  a54=(a54-a149);
  a170=(a170+a54);
  a54=(a85*a170);
  a149=(a92*a177);
  a54=(a54-a149);
  a149=(a98*a68);
  a196=(a97*a154);
  a193=(a90*a177);
  a119=(a85*a119);
  a193=(a193+a119);
  a119=(a82*a68);
  a197=(a88*a61);
  a119=(a119-a197);
  a193=(a193+a119);
  a154=(a193+a154);
  a154=(a28*a154);
  a196=(a196-a154);
  a64=(a96*a64);
  a193=(a87*a193);
  a64=(a64-a193);
  a196=(a196-a64);
  a64=(a88*a196);
  a149=(a149+a64);
  a54=(a54-a149);
  a194=(a194+a54);
  a149=(a82*a182);
  a64=(a79*a61);
  a149=(a149-a64);
  a54=(a54+a149);
  a149=(a103*a54);
  a64=(a88+a88);
  a64=(a64*a68);
  a193=(a27*a177);
  a154=(a85*a193);
  a119=(a99*a177);
  a154=(a154+a119);
  a64=(a64-a154);
  a154=(a64/a102);
  a119=(a103/a102);
  a119=(a119*a64);
  a154=(a154+a119);
  a119=(a94*a154);
  a149=(a149-a119);
  a119=(a101*a154);
  a197=(a103*a64);
  a119=(a119+a197);
  a119=(a64+a119);
  a197=(a105*a119);
  a198=(a82*a182);
  a61=(a79*a61);
  a198=(a198-a61);
  a61=(a100*a198);
  a197=(a197+a61);
  a61=(a99*a68);
  a193=(a88*a193);
  a61=(a61-a193);
  a193=casadi_sq(a85);
  a199=casadi_sq(a88);
  a193=(a193-a199);
  a61=(a61-a193);
  a193=(a103*a61);
  a199=(a107*a154);
  a193=(a193-a199);
  a193=(a61+a193);
  a199=(a109*a193);
  a200=(a89*a182);
  a201=(a79*a138);
  a200=(a200-a201);
  a201=(a108*a200);
  a199=(a199+a201);
  a197=(a197+a199);
  a149=(a149-a197);
  a194=(a194+a149);
  a194=(a72*a194);
  a149=(a106*a182);
  a138=(a138+a182);
  a138=(a79*a138);
  a149=(a149-a138);
  a138=(a92*a68);
  a170=(a88*a170);
  a138=(a138+a170);
  a196=(a85*a196);
  a170=(a98*a177);
  a196=(a196-a170);
  a138=(a138+a196);
  a149=(a149+a138);
  a138=(a27*a68);
  a196=(a85*a138);
  a170=(a111*a177);
  a196=(a196-a170);
  a170=casadi_sq(a85);
  a182=casadi_sq(a88);
  a170=(a170-a182);
  a196=(a196-a170);
  a170=(a61/a102);
  a182=(a113/a102);
  a182=(a182*a64);
  a170=(a170-a182);
  a182=(a101*a170);
  a197=(a113*a64);
  a182=(a182-a197);
  a196=(a196+a182);
  a182=(a105*a196);
  a197=(a112*a198);
  a182=(a182+a197);
  a138=(a88*a138);
  a197=(a111*a68);
  a138=(a138+a197);
  a197=(a85+a85);
  a197=(a197*a177);
  a138=(a138-a197);
  a197=(a107*a170);
  a61=(a113*a61);
  a197=(a197+a61);
  a138=(a138-a197);
  a197=(a109*a138);
  a61=(a115*a200);
  a197=(a197+a61);
  a182=(a182+a197);
  a197=(a94*a170);
  a61=(a113*a54);
  a197=(a197+a61);
  a182=(a182+a197);
  a149=(a149-a182);
  a149=(a80*a149);
  a194=(a194-a149);
  a194=(a194/a116);
  a149=(a72*a119);
  a182=(a80*a196);
  a149=(a149-a182);
  a149=(a72*a149);
  a182=(a72*a193);
  a197=(a80*a138);
  a182=(a182-a197);
  a182=(a80*a182);
  a149=(a149-a182);
  a118=(a118*a149);
  a194=(a194+a118);
  a119=(a80*a119);
  a196=(a72*a196);
  a119=(a119+a196);
  a119=(a72*a119);
  a193=(a80*a193);
  a138=(a72*a138);
  a193=(a193+a138);
  a193=(a80*a193);
  a119=(a119-a193);
  a119=(a119/a116);
  a125=(a125*a149);
  a119=(a119-a125);
  a119=(a60*a119);
  a194=(a194+a119);
  a119=(a56*a194);
  a119=(a4*a119);
  a139=(a139+a119);
  a54=(a54/a102);
  a119=(a121/a102);
  a119=(a119*a64);
  a54=(a54-a119);
  a154=(a133*a154);
  a119=(a72*a194);
  a119=(a119+a198);
  a198=(a103*a119);
  a154=(a154+a198);
  a170=(a135*a170);
  a198=(a80*a194);
  a198=(a198-a200);
  a200=(a113*a198);
  a170=(a170+a200);
  a154=(a154+a170);
  a54=(a54+a154);
  a154=(a59*a54);
  a170=(a131*a154);
  a200=(a5*a150);
  a200=(a55*a200);
  a137=(a137*a200);
  a64=(a130*a137);
  a194=(a59*a194);
  a125=(a58*a194);
  a64=(a64-a125);
  a125=(a136*a64);
  a170=(a170+a125);
  a156=(a27*a156);
  a68=(a135*a68);
  a198=(a88*a198);
  a68=(a68+a198);
  a177=(a146*a177);
  a119=(a119+a54);
  a119=(a85*a119);
  a177=(a177+a119);
  a68=(a68-a177);
  a68=(a68-a195);
  a68=(a23*a68);
  a68=(a68+a54);
  a156=(a156-a68);
  a68=(a59*a156);
  a195=(a68+a154);
  a177=(a145*a195);
  a119=(a5*a157);
  a119=(a55*a119);
  a119=(a0+a119);
  a148=(a148*a119);
  a198=(a144*a148);
  a152=(a152*a200);
  a200=(a130*a152);
  a194=(a120*a194);
  a200=(a200+a194);
  a194=(a200+a154);
  a125=(a142*a194);
  a198=(a198-a125);
  a125=(a141*a64);
  a155=(a155*a119);
  a119=(a131*a155);
  a125=(a125-a119);
  a198=(a198+a125);
  a125=(a95*a198);
  a177=(a177+a125);
  a125=(a95*a198);
  a119=(a145*a195);
  a125=(a125+a119);
  a119=(a23*a125);
  a149=(a145*a68);
  a198=(a147*a198);
  a149=(a149+a198);
  a198=(a27*a149);
  a119=(a119-a198);
  a177=(a177+a119);
  a119=(a141*a177);
  a198=(a151*a155);
  a119=(a119-a198);
  a198=(a162*a148);
  a193=(a161*a195);
  a138=(a144*a155);
  a194=(a141*a194);
  a138=(a138+a194);
  a194=(a131*a148);
  a196=(a142*a64);
  a194=(a194+a196);
  a138=(a138+a194);
  a195=(a138+a195);
  a195=(a95*a195);
  a193=(a193-a195);
  a68=(a159*a68);
  a138=(a147*a138);
  a68=(a68-a138);
  a193=(a193-a68);
  a68=(a142*a193);
  a198=(a198+a68);
  a119=(a119-a198);
  a170=(a170+a119);
  a198=(a136*a64);
  a68=(a131*a154);
  a198=(a198+a68);
  a119=(a119+a198);
  a198=(a165*a119);
  a169=(a169*a148);
  a68=(a27*a155);
  a138=(a141*a68);
  a195=(a163*a155);
  a138=(a138+a195);
  a169=(a169-a138);
  a138=(a169/a128);
  a173=(a173*a169);
  a138=(a138+a173);
  a173=(a168*a138);
  a198=(a198-a173);
  a173=(a153*a138);
  a195=(a165*a169);
  a173=(a173+a195);
  a173=(a169+a173);
  a195=(a174*a173);
  a194=(a131*a154);
  a64=(a136*a64);
  a194=(a194+a64);
  a64=(a132*a194);
  a195=(a195+a64);
  a64=(a163*a148);
  a68=(a142*a68);
  a64=(a64-a68);
  a68=(a141*a148);
  a196=(a142*a155);
  a68=(a68-a196);
  a64=(a64-a68);
  a68=(a165*a64);
  a196=(a179*a138);
  a68=(a68-a196);
  a68=(a64+a68);
  a196=(a140*a68);
  a118=(a143*a154);
  a182=(a136*a200);
  a118=(a118-a182);
  a182=(a181*a118);
  a196=(a196+a182);
  a195=(a195+a196);
  a198=(a198-a195);
  a170=(a170+a198);
  a170=(a120*a170);
  a198=(a166*a152);
  a170=(a170-a198);
  a198=(a176*a137);
  a195=(a167*a154);
  a200=(a200+a154);
  a200=(a136*a200);
  a195=(a195-a200);
  a200=(a151*a148);
  a177=(a142*a177);
  a200=(a200+a177);
  a193=(a141*a193);
  a177=(a162*a155);
  a193=(a193-a177);
  a200=(a200+a193);
  a195=(a195+a200);
  a200=(a27*a148);
  a193=(a141*a200);
  a177=(a180*a155);
  a193=(a193-a177);
  a177=(a141*a148);
  a154=(a142*a155);
  a177=(a177-a154);
  a193=(a193-a177);
  a177=(a64/a128);
  a124=(a124*a169);
  a177=(a177-a124);
  a124=(a153*a177);
  a154=(a184*a169);
  a124=(a124-a154);
  a193=(a193+a124);
  a124=(a174*a193);
  a154=(a183*a194);
  a124=(a124+a154);
  a200=(a142*a200);
  a154=(a180*a148);
  a200=(a200+a154);
  a189=(a189*a155);
  a200=(a200-a189);
  a189=(a179*a177);
  a64=(a184*a64);
  a189=(a189+a64);
  a200=(a200-a189);
  a189=(a140*a200);
  a64=(a186*a118);
  a189=(a189+a64);
  a124=(a124+a189);
  a189=(a168*a177);
  a64=(a184*a119);
  a189=(a189+a64);
  a124=(a124+a189);
  a195=(a195-a124);
  a195=(a58*a195);
  a198=(a198+a195);
  a170=(a170-a198);
  a170=(a170/a187);
  a198=(a120*a173);
  a195=(a132*a152);
  a198=(a198-a195);
  a195=(a183*a137);
  a124=(a58*a193);
  a195=(a195+a124);
  a198=(a198-a195);
  a198=(a120*a198);
  a195=(a185*a152);
  a198=(a198-a195);
  a195=(a120*a68);
  a124=(a181*a152);
  a195=(a195-a124);
  a124=(a186*a137);
  a189=(a58*a200);
  a124=(a124+a189);
  a195=(a195-a124);
  a195=(a58*a195);
  a124=(a188*a137);
  a195=(a195+a124);
  a198=(a198-a195);
  a178=(a178*a198);
  a170=(a170+a178);
  a178=(a132*a137);
  a173=(a58*a173);
  a178=(a178+a173);
  a193=(a120*a193);
  a173=(a183*a152);
  a193=(a193-a173);
  a178=(a178+a193);
  a178=(a120*a178);
  a193=(a164*a152);
  a178=(a178-a193);
  a193=(a181*a137);
  a68=(a58*a68);
  a193=(a193+a68);
  a200=(a120*a200);
  a68=(a186*a152);
  a200=(a200-a68);
  a193=(a193+a200);
  a193=(a58*a193);
  a200=(a122*a137);
  a193=(a193+a200);
  a178=(a178-a193);
  a178=(a178/a187);
  a171=(a171*a198);
  a178=(a178-a171);
  a178=(a60*a178);
  a170=(a170+a178);
  a178=(a2*a170);
  a139=(a139+a178);
  a139=(a3*a139);
  a139=(a2*a139);
  a139=(-a139);
  if (res[0]!=0) res[0][6]=a139;
  a150=(a5*a150);
  a150=(a4*a150);
  a54=(a56*a54);
  a54=(a4*a54);
  a150=(a150+a54);
  a119=(a119/a128);
  a66=(a66*a169);
  a119=(a119-a66);
  a66=(a60*a137);
  a169=(a192*a152);
  a54=(a120*a170);
  a169=(a169+a54);
  a66=(a66-a169);
  a66=(a66-a194);
  a194=(a165*a66);
  a138=(a191*a138);
  a194=(a194-a138);
  a177=(a172*a177);
  a152=(a60*a152);
  a137=(a192*a137);
  a170=(a58*a170);
  a137=(a137-a170);
  a152=(a152+a137);
  a152=(a152+a118);
  a118=(a184*a152);
  a177=(a177-a118);
  a194=(a194-a177);
  a119=(a119-a194);
  a194=(a2*a119);
  a150=(a150+a194);
  a150=(a3*a150);
  a150=(a2*a150);
  if (res[0]!=0) res[0][7]=a150;
  a157=(a5*a157);
  a157=(a4*a157);
  a156=(a56*a156);
  a156=(a4*a156);
  a157=(a157+a156);
  a125=(a27*a125);
  a66=(a66-a119);
  a66=(a141*a66);
  a155=(a65*a155);
  a66=(a66-a155);
  a148=(a172*a148);
  a152=(a142*a152);
  a148=(a148-a152);
  a66=(a66+a148);
  a66=(a66-a149);
  a66=(a23*a66);
  a66=(a66+a119);
  a125=(a125-a66);
  a125=(a2*a125);
  a157=(a157+a125);
  a157=(a3*a157);
  a157=(a2*a157);
  a157=(a0+a157);
  if (res[0]!=0) res[0][8]=a157;
  a157=(a9*a10);
  a125=(a18*a8);
  a66=(a15*a10);
  a125=(a125+a66);
  a66=(a17*a125);
  a119=(a17*a125);
  a149=(a23*a119);
  a125=(a16*a125);
  a148=(a27*a125);
  a149=(a149-a148);
  a66=(a66+a149);
  a149=(a15*a66);
  a148=(a15*a8);
  a152=(a18*a10);
  a148=(a148-a152);
  a152=(a17*a148);
  a148=(a16*a148);
  a152=(a152-a148);
  a148=(a18*a152);
  a149=(a149-a148);
  a157=(a157+a149);
  a148=(a9*a10);
  a149=(a149+a148);
  a148=(a37*a149);
  a155=(a9*a10);
  a156=(a34*a155);
  a150=(a9*a8);
  a194=(a43*a150);
  a156=(a156+a194);
  a148=(a148-a156);
  a157=(a157+a148);
  a157=(a8*a157);
  a148=(a9*a8);
  a66=(a18*a66);
  a152=(a15*a152);
  a66=(a66+a152);
  a148=(a148+a66);
  a66=(a47*a155);
  a152=(a50*a150);
  a66=(a66+a152);
  a152=(a48*a149);
  a66=(a66+a152);
  a148=(a148-a66);
  a148=(a10*a148);
  a157=(a157-a148);
  a157=(a157/a52);
  a148=(a5*a157);
  a148=(a0-a148);
  a148=(a4*a148);
  a148=(a0+a148);
  a149=(a149/a36);
  a66=(a8*a157);
  a66=(a66+a155);
  a155=(a37*a66);
  a152=(a10*a157);
  a152=(a152-a150);
  a150=(a48*a152);
  a155=(a155+a150);
  a149=(a149+a155);
  a155=(a73*a149);
  a150=(a82*a155);
  a157=(a73*a157);
  a157=(a0-a157);
  a156=(a80*a157);
  a194=(a79*a156);
  a150=(a150+a194);
  a119=(a27*a119);
  a152=(a18*a152);
  a66=(a66+a149);
  a66=(a15*a66);
  a152=(a152-a66);
  a152=(a152-a125);
  a152=(a23*a152);
  a152=(a152+a149);
  a119=(a119-a152);
  a152=(a73*a119);
  a125=(a152+a155);
  a66=(a91*a125);
  a157=(a72*a157);
  a194=(a157-a155);
  a177=(a88*a194);
  a118=(a85*a156);
  a177=(a177+a118);
  a118=(a28*a177);
  a66=(a66+a118);
  a118=(a28*a177);
  a137=(a91*a125);
  a118=(a118+a137);
  a137=(a23*a118);
  a170=(a91*a152);
  a177=(a87*a177);
  a170=(a170+a177);
  a177=(a27*a170);
  a137=(a137-a177);
  a66=(a66+a137);
  a137=(a85*a66);
  a177=(a97*a125);
  a194=(a85*a194);
  a138=(a88*a156);
  a194=(a194-a138);
  a125=(a194-a125);
  a125=(a28*a125);
  a177=(a177+a125);
  a152=(a96*a152);
  a194=(a87*a194);
  a152=(a152+a194);
  a177=(a177-a152);
  a152=(a88*a177);
  a137=(a137-a152);
  a150=(a150+a137);
  a152=(a79*a156);
  a194=(a82*a155);
  a152=(a152+a194);
  a137=(a137+a152);
  a152=(a103*a137);
  a194=(a82*a155);
  a156=(a79*a156);
  a194=(a194+a156);
  a156=(a100*a194);
  a125=(a89*a155);
  a138=(a79*a157);
  a125=(a125+a138);
  a138=(a108*a125);
  a156=(a156+a138);
  a152=(a152-a156);
  a150=(a150+a152);
  a150=(a72*a150);
  a152=(a106*a155);
  a157=(a157-a155);
  a157=(a79*a157);
  a152=(a152+a157);
  a66=(a88*a66);
  a177=(a85*a177);
  a66=(a66+a177);
  a152=(a152+a66);
  a66=(a112*a194);
  a177=(a115*a125);
  a66=(a66+a177);
  a177=(a113*a137);
  a66=(a66+a177);
  a152=(a152-a66);
  a152=(a80*a152);
  a150=(a150-a152);
  a150=(a150/a116);
  a152=(a56*a150);
  a152=(a0-a152);
  a152=(a4*a152);
  a148=(a148+a152);
  a137=(a137/a102);
  a152=(a72*a150);
  a152=(a152+a194);
  a194=(a103*a152);
  a66=(a80*a150);
  a66=(a66-a125);
  a125=(a113*a66);
  a194=(a194+a125);
  a137=(a137+a194);
  a194=(a59*a137);
  a125=(a131*a194);
  a177=cos(a77);
  a157=(a5*a149);
  a157=(a55*a157);
  a155=(a177*a157);
  a156=(a130*a155);
  a150=(a59*a150);
  a150=(a0-a150);
  a138=(a58*a150);
  a156=(a156+a138);
  a138=(a136*a156);
  a125=(a125+a138);
  a118=(a27*a118);
  a66=(a88*a66);
  a152=(a152+a137);
  a152=(a85*a152);
  a66=(a66-a152);
  a66=(a66-a170);
  a66=(a23*a66);
  a66=(a66+a137);
  a118=(a118-a66);
  a66=(a59*a118);
  a170=(a66+a194);
  a152=(a145*a170);
  a138=cos(a25);
  a169=(a5*a119);
  a169=(a55*a169);
  a54=(a138*a169);
  a139=(a144*a54);
  a150=(a120*a150);
  a178=sin(a77);
  a157=(a178*a157);
  a171=(a130*a157);
  a150=(a150-a171);
  a171=(a150-a194);
  a198=(a142*a171);
  a139=(a139+a198);
  a198=(a141*a156);
  a193=sin(a25);
  a169=(a193*a169);
  a200=(a131*a169);
  a198=(a198-a200);
  a139=(a139+a198);
  a198=(a95*a139);
  a152=(a152+a198);
  a198=(a95*a139);
  a200=(a145*a170);
  a198=(a198+a200);
  a200=(a23*a198);
  a68=(a145*a66);
  a139=(a147*a139);
  a68=(a68+a139);
  a139=(a27*a68);
  a200=(a200-a139);
  a152=(a152+a200);
  a200=(a141*a152);
  a139=(a151*a169);
  a200=(a200-a139);
  a139=(a162*a54);
  a173=(a161*a170);
  a171=(a141*a171);
  a195=(a144*a169);
  a171=(a171-a195);
  a195=(a131*a54);
  a124=(a142*a156);
  a195=(a195+a124);
  a171=(a171-a195);
  a170=(a171-a170);
  a170=(a95*a170);
  a173=(a173+a170);
  a66=(a159*a66);
  a171=(a147*a171);
  a66=(a66+a171);
  a173=(a173-a66);
  a66=(a142*a173);
  a139=(a139+a66);
  a200=(a200-a139);
  a125=(a125+a200);
  a139=(a136*a156);
  a66=(a131*a194);
  a139=(a139+a66);
  a200=(a200+a139);
  a139=(a165*a200);
  a66=(a142+a142);
  a171=(a66*a54);
  a170=(a27*a169);
  a195=(a141*a170);
  a124=(a163*a169);
  a195=(a195+a124);
  a171=(a171-a195);
  a195=(a171/a128);
  a124=(a165/a128);
  a189=(a124*a171);
  a195=(a195+a189);
  a189=(a168*a195);
  a139=(a139-a189);
  a189=(a153*a195);
  a64=(a165*a171);
  a189=(a189+a64);
  a189=(a171+a189);
  a64=(a174*a189);
  a154=(a131*a194);
  a156=(a136*a156);
  a154=(a154+a156);
  a156=(a132*a154);
  a64=(a64+a156);
  a156=(a163*a54);
  a170=(a142*a170);
  a156=(a156-a170);
  a170=(a141*a54);
  a196=(a142*a169);
  a170=(a170-a196);
  a156=(a156-a170);
  a170=(a165*a156);
  a196=(a179*a195);
  a170=(a170-a196);
  a170=(a156+a170);
  a196=(a140*a170);
  a182=(a143*a194);
  a197=(a136*a150);
  a182=(a182+a197);
  a197=(a181*a182);
  a196=(a196+a197);
  a64=(a64+a196);
  a139=(a139-a64);
  a125=(a125+a139);
  a125=(a120*a125);
  a139=(a166*a157);
  a125=(a125-a139);
  a139=(a176*a155);
  a64=(a167*a194);
  a150=(a150-a194);
  a150=(a136*a150);
  a64=(a64+a150);
  a150=(a151*a54);
  a152=(a142*a152);
  a150=(a150+a152);
  a173=(a141*a173);
  a152=(a162*a169);
  a173=(a173-a152);
  a150=(a150+a173);
  a64=(a64+a150);
  a150=(a27*a54);
  a173=(a141*a150);
  a152=(a180*a169);
  a173=(a173-a152);
  a152=(a141*a54);
  a194=(a142*a169);
  a152=(a152-a194);
  a173=(a173-a152);
  a152=(a156/a128);
  a194=(a184/a128);
  a196=(a194*a171);
  a152=(a152-a196);
  a196=(a153*a152);
  a197=(a184*a171);
  a196=(a196-a197);
  a173=(a173+a196);
  a196=(a174*a173);
  a197=(a183*a154);
  a196=(a196+a197);
  a150=(a142*a150);
  a197=(a180*a54);
  a150=(a150+a197);
  a197=(a141+a141);
  a61=(a197*a169);
  a150=(a150-a61);
  a61=(a179*a152);
  a156=(a184*a156);
  a61=(a61+a156);
  a150=(a150-a61);
  a61=(a140*a150);
  a156=(a186*a182);
  a61=(a61+a156);
  a196=(a196+a61);
  a61=(a168*a152);
  a156=(a184*a200);
  a61=(a61+a156);
  a196=(a196+a61);
  a64=(a64-a196);
  a64=(a58*a64);
  a139=(a139+a64);
  a125=(a125-a139);
  a125=(a125/a187);
  a139=(a190/a187);
  a64=(a120*a189);
  a196=(a132*a157);
  a64=(a64-a196);
  a196=(a183*a155);
  a61=(a58*a173);
  a196=(a196+a61);
  a64=(a64-a196);
  a64=(a120*a64);
  a196=(a185*a157);
  a64=(a64-a196);
  a196=(a120*a170);
  a61=(a181*a157);
  a196=(a196-a61);
  a61=(a186*a155);
  a156=(a58*a150);
  a61=(a61+a156);
  a196=(a196-a61);
  a196=(a58*a196);
  a61=(a188*a155);
  a196=(a196+a61);
  a64=(a64-a196);
  a196=(a139*a64);
  a125=(a125+a196);
  a196=(a132*a155);
  a189=(a58*a189);
  a196=(a196+a189);
  a173=(a120*a173);
  a189=(a183*a157);
  a173=(a173-a189);
  a196=(a196+a173);
  a196=(a120*a196);
  a173=(a164*a157);
  a196=(a196-a173);
  a173=(a181*a155);
  a170=(a58*a170);
  a173=(a173+a170);
  a150=(a120*a150);
  a170=(a186*a157);
  a150=(a150-a170);
  a173=(a173+a150);
  a173=(a58*a173);
  a150=(a122*a155);
  a173=(a173+a150);
  a196=(a196-a173);
  a196=(a196/a187);
  a173=(a175/a187);
  a64=(a173*a64);
  a196=(a196-a64);
  a196=(a60*a196);
  a125=(a125+a196);
  a196=(a2*a125);
  a196=(a0-a196);
  a148=(a148+a196);
  a148=(a3*a148);
  a148=(a2*a148);
  if (res[1]!=0) res[1][0]=a148;
  a149=(a5*a149);
  a149=(a4*a149);
  a137=(a56*a137);
  a137=(a4*a137);
  a149=(a149+a137);
  a200=(a200/a128);
  a137=(a127/a128);
  a171=(a137*a171);
  a200=(a200-a171);
  a171=(a60*a155);
  a148=(a192*a157);
  a196=(a120*a125);
  a148=(a148+a196);
  a171=(a171-a148);
  a171=(a171-a154);
  a154=(a165*a171);
  a195=(a191*a195);
  a154=(a154-a195);
  a152=(a172*a152);
  a157=(a60*a157);
  a155=(a192*a155);
  a125=(a58*a125);
  a155=(a155-a125);
  a157=(a157+a155);
  a157=(a157+a182);
  a182=(a184*a157);
  a152=(a152-a182);
  a154=(a154-a152);
  a200=(a200-a154);
  a154=(a2*a200);
  a149=(a149+a154);
  a149=(a3*a149);
  a149=(a2*a149);
  if (res[1]!=0) res[1][1]=a149;
  a119=(a5*a119);
  a119=(a4*a119);
  a118=(a56*a118);
  a118=(a4*a118);
  a119=(a119+a118);
  a198=(a27*a198);
  a171=(a171-a200);
  a171=(a141*a171);
  a169=(a65*a169);
  a171=(a171-a169);
  a54=(a172*a54);
  a157=(a142*a157);
  a54=(a54-a157);
  a171=(a171+a54);
  a171=(a171-a68);
  a171=(a23*a171);
  a171=(a171+a200);
  a198=(a198-a171);
  a198=(a2*a198);
  a119=(a119+a198);
  a119=(a3*a119);
  a119=(a2*a119);
  if (res[1]!=0) res[1][2]=a119;
  a119=(a104/a116);
  a198=sin(a71);
  a198=(a198*a70);
  a171=(a100*a198);
  a200=cos(a71);
  a200=(a200*a70);
  a68=(a112*a200);
  a171=(a171+a68);
  a171=(a72*a171);
  a68=(a114*a198);
  a171=(a171+a68);
  a68=(a117*a200);
  a54=(a108*a198);
  a157=(a115*a200);
  a54=(a54+a157);
  a54=(a80*a54);
  a68=(a68-a54);
  a171=(a171+a68);
  a68=(a119*a171);
  a54=(a17*a18);
  a54=(a21-a54);
  a157=(a17*a18);
  a157=(a21-a157);
  a169=(a23*a157);
  a118=(a16*a18);
  a149=(a27*a118);
  a169=(a169+a149);
  a54=(a54+a169);
  a169=(a15*a54);
  a149=(a32-a15);
  a149=(a17*a149);
  a149=(a30+a149);
  a154=(a16*a15);
  a149=(a149+a154);
  a154=(a18*a149);
  a169=(a169-a154);
  a154=(a169+a12);
  a152=(a154/a36);
  a169=(a12+a169);
  a182=(a37*a154);
  a155=(a34*a12);
  a125=(a43*a19);
  a155=(a155+a125);
  a182=(a182-a155);
  a169=(a169+a182);
  a169=(a8*a169);
  a182=(a41-a9);
  a54=(a18*a54);
  a149=(a15*a149);
  a54=(a54+a149);
  a182=(a182+a54);
  a54=(a47*a12);
  a149=(a50*a19);
  a54=(a54+a149);
  a154=(a48*a154);
  a54=(a54+a154);
  a182=(a182-a54);
  a182=(a10*a182);
  a169=(a169-a182);
  a169=(a169/a52);
  a182=(a8*a169);
  a182=(a182+a12);
  a54=(a37*a182);
  a154=(a10*a169);
  a154=(a154-a19);
  a149=(a48*a154);
  a54=(a54+a149);
  a152=(a152+a54);
  a54=(a73*a152);
  a54=(a0+a54);
  a149=(a82*a54);
  a155=(a81*a200);
  a125=(a73*a169);
  a195=(a80*a125);
  a155=(a155-a195);
  a195=(a79*a155);
  a149=(a149+a195);
  a157=(a27*a157);
  a154=(a18*a154);
  a182=(a182+a152);
  a182=(a15*a182);
  a154=(a154-a182);
  a154=(a154+a118);
  a154=(a23*a154);
  a154=(a154+a152);
  a157=(a157-a154);
  a154=(a73*a157);
  a118=(a154+a54);
  a182=(a91*a118);
  a195=(a85*a155);
  a148=(a81*a198);
  a125=(a72*a125);
  a148=(a148+a125);
  a125=(a148+a54);
  a196=(a88*a125);
  a195=(a195-a196);
  a196=(a28*a195);
  a182=(a182+a196);
  a196=(a28*a195);
  a64=(a91*a118);
  a196=(a196+a64);
  a64=(a23*a196);
  a150=(a91*a154);
  a195=(a87*a195);
  a150=(a150+a195);
  a195=(a27*a150);
  a64=(a64-a195);
  a182=(a182+a64);
  a64=(a85*a182);
  a195=(a97*a118);
  a125=(a85*a125);
  a170=(a88*a155);
  a125=(a125+a170);
  a118=(a125+a118);
  a118=(a28*a118);
  a195=(a195-a118);
  a154=(a96*a154);
  a125=(a87*a125);
  a154=(a154-a125);
  a195=(a195-a154);
  a154=(a88*a195);
  a64=(a64-a154);
  a149=(a149+a64);
  a154=(a79*a155);
  a125=(a82*a54);
  a154=(a154+a125);
  a64=(a64+a154);
  a154=(a103*a64);
  a125=(a82*a54);
  a155=(a79*a155);
  a125=(a125+a155);
  a155=(a100*a125);
  a118=(a89*a54);
  a170=(a79*a148);
  a118=(a118-a170);
  a170=(a108*a118);
  a155=(a155+a170);
  a154=(a154-a155);
  a149=(a149+a154);
  a149=(a72*a149);
  a154=(a83*a198);
  a149=(a149-a154);
  a154=(a110*a200);
  a155=(a106*a54);
  a148=(a148+a54);
  a148=(a79*a148);
  a155=(a155-a148);
  a182=(a88*a182);
  a195=(a85*a195);
  a182=(a182+a195);
  a155=(a155+a182);
  a182=(a112*a125);
  a195=(a115*a118);
  a182=(a182+a195);
  a195=(a113*a64);
  a182=(a182+a195);
  a155=(a155-a182);
  a155=(a80*a155);
  a154=(a154+a155);
  a149=(a149-a154);
  a149=(a149/a116);
  a68=(a68-a149);
  a149=(a100*a200);
  a154=(a112*a198);
  a149=(a149-a154);
  a149=(a72*a149);
  a154=(a123*a198);
  a149=(a149-a154);
  a154=(a108*a200);
  a155=(a115*a198);
  a154=(a154-a155);
  a154=(a80*a154);
  a155=(a69*a200);
  a154=(a154+a155);
  a149=(a149-a154);
  a149=(a149/a116);
  a154=(a57/a116);
  a171=(a154*a171);
  a149=(a149+a171);
  a149=(a60*a149);
  a68=(a68-a149);
  a149=(a56*a68);
  a149=(a4*a149);
  a169=(a5*a169);
  a169=(a4*a169);
  a149=(a149-a169);
  a64=(a64/a102);
  a169=(a72*a68);
  a171=(a129*a198);
  a169=(a169-a171);
  a171=(a60*a200);
  a169=(a169+a171);
  a169=(a169-a125);
  a125=(a103*a169);
  a198=(a60*a198);
  a200=(a129*a200);
  a171=(a80*a68);
  a200=(a200+a171);
  a198=(a198+a200);
  a198=(a198+a118);
  a118=(a113*a198);
  a125=(a125+a118);
  a64=(a64-a125);
  a125=(a59*a64);
  a125=(a0+a125);
  a118=(a131*a125);
  a200=(a5*a152);
  a200=(a0+a200);
  a200=(a55*a200);
  a171=(a177*a200);
  a155=(a130*a171);
  a68=(a59*a68);
  a182=(a58*a68);
  a155=(a155+a182);
  a182=(a136*a155);
  a118=(a118+a182);
  a196=(a27*a196);
  a169=(a169-a64);
  a169=(a85*a169);
  a198=(a88*a198);
  a169=(a169-a198);
  a169=(a169-a150);
  a169=(a23*a169);
  a169=(a169+a64);
  a196=(a196-a169);
  a169=(a59*a196);
  a150=(a169+a125);
  a198=(a145*a150);
  a182=(a5*a157);
  a182=(a55*a182);
  a195=(a138*a182);
  a148=(a144*a195);
  a68=(a120*a68);
  a200=(a178*a200);
  a54=(a130*a200);
  a68=(a68-a54);
  a54=(a68-a125);
  a170=(a142*a54);
  a148=(a148+a170);
  a170=(a141*a155);
  a182=(a193*a182);
  a189=(a131*a182);
  a170=(a170-a189);
  a148=(a148+a170);
  a170=(a95*a148);
  a198=(a198+a170);
  a170=(a95*a148);
  a189=(a145*a150);
  a170=(a170+a189);
  a189=(a23*a170);
  a61=(a145*a169);
  a148=(a147*a148);
  a61=(a61+a148);
  a148=(a27*a61);
  a189=(a189-a148);
  a198=(a198+a189);
  a189=(a141*a198);
  a148=(a151*a182);
  a189=(a189-a148);
  a148=(a162*a195);
  a156=(a161*a150);
  a54=(a141*a54);
  a199=(a144*a182);
  a54=(a54-a199);
  a199=(a131*a195);
  a201=(a142*a155);
  a199=(a199+a201);
  a54=(a54-a199);
  a150=(a54-a150);
  a150=(a95*a150);
  a156=(a156+a150);
  a169=(a159*a169);
  a54=(a147*a54);
  a169=(a169+a54);
  a156=(a156-a169);
  a169=(a142*a156);
  a148=(a148+a169);
  a189=(a189-a148);
  a118=(a118+a189);
  a148=(a136*a155);
  a169=(a131*a125);
  a148=(a148+a169);
  a189=(a189+a148);
  a148=(a165*a189);
  a169=(a66*a195);
  a54=(a27*a182);
  a150=(a141*a54);
  a199=(a163*a182);
  a150=(a150+a199);
  a169=(a169-a150);
  a150=(a169/a128);
  a199=(a124*a169);
  a150=(a150+a199);
  a199=(a168*a150);
  a148=(a148-a199);
  a199=(a153*a150);
  a201=(a165*a169);
  a199=(a199+a201);
  a199=(a169+a199);
  a201=(a174*a199);
  a202=(a131*a125);
  a155=(a136*a155);
  a202=(a202+a155);
  a155=(a132*a202);
  a201=(a201+a155);
  a155=(a163*a195);
  a54=(a142*a54);
  a155=(a155-a54);
  a54=(a141*a195);
  a203=(a142*a182);
  a54=(a54-a203);
  a155=(a155-a54);
  a54=(a165*a155);
  a203=(a179*a150);
  a54=(a54-a203);
  a54=(a155+a54);
  a203=(a140*a54);
  a204=(a143*a125);
  a205=(a136*a68);
  a204=(a204+a205);
  a205=(a181*a204);
  a203=(a203+a205);
  a201=(a201+a203);
  a148=(a148-a201);
  a118=(a118+a148);
  a118=(a120*a118);
  a148=(a166*a200);
  a118=(a118-a148);
  a148=(a176*a171);
  a201=(a167*a125);
  a68=(a68-a125);
  a68=(a136*a68);
  a201=(a201+a68);
  a68=(a151*a195);
  a198=(a142*a198);
  a68=(a68+a198);
  a156=(a141*a156);
  a198=(a162*a182);
  a156=(a156-a198);
  a68=(a68+a156);
  a201=(a201+a68);
  a68=(a27*a195);
  a156=(a141*a68);
  a198=(a180*a182);
  a156=(a156-a198);
  a198=(a141*a195);
  a125=(a142*a182);
  a198=(a198-a125);
  a156=(a156-a198);
  a198=(a155/a128);
  a125=(a194*a169);
  a198=(a198-a125);
  a125=(a153*a198);
  a203=(a184*a169);
  a125=(a125-a203);
  a156=(a156+a125);
  a125=(a174*a156);
  a203=(a183*a202);
  a125=(a125+a203);
  a68=(a142*a68);
  a203=(a180*a195);
  a68=(a68+a203);
  a203=(a197*a182);
  a68=(a68-a203);
  a203=(a179*a198);
  a155=(a184*a155);
  a203=(a203+a155);
  a68=(a68-a203);
  a203=(a140*a68);
  a155=(a186*a204);
  a203=(a203+a155);
  a125=(a125+a203);
  a203=(a168*a198);
  a155=(a184*a189);
  a203=(a203+a155);
  a125=(a125+a203);
  a201=(a201-a125);
  a201=(a58*a201);
  a148=(a148+a201);
  a118=(a118-a148);
  a118=(a118/a187);
  a148=(a120*a199);
  a201=(a132*a200);
  a148=(a148-a201);
  a201=(a183*a171);
  a125=(a58*a156);
  a201=(a201+a125);
  a148=(a148-a201);
  a148=(a120*a148);
  a201=(a185*a200);
  a148=(a148-a201);
  a201=(a120*a54);
  a125=(a181*a200);
  a201=(a201-a125);
  a125=(a186*a171);
  a203=(a58*a68);
  a125=(a125+a203);
  a201=(a201-a125);
  a201=(a58*a201);
  a125=(a188*a171);
  a201=(a201+a125);
  a148=(a148-a201);
  a201=(a139*a148);
  a118=(a118+a201);
  a201=(a132*a171);
  a199=(a58*a199);
  a201=(a201+a199);
  a156=(a120*a156);
  a199=(a183*a200);
  a156=(a156-a199);
  a201=(a201+a156);
  a201=(a120*a201);
  a156=(a164*a200);
  a201=(a201-a156);
  a156=(a181*a171);
  a54=(a58*a54);
  a156=(a156+a54);
  a68=(a120*a68);
  a54=(a186*a200);
  a68=(a68-a54);
  a156=(a156+a68);
  a156=(a58*a156);
  a68=(a122*a171);
  a156=(a156+a68);
  a201=(a201-a156);
  a201=(a201/a187);
  a148=(a173*a148);
  a201=(a201-a148);
  a201=(a60*a201);
  a118=(a118+a201);
  a201=(a2*a118);
  a149=(a149-a201);
  a149=(a3*a149);
  a149=(a2*a149);
  if (res[1]!=0) res[1][3]=a149;
  a152=(a5*a152);
  a152=(a0+a152);
  a152=(a4*a152);
  a152=(a0+a152);
  a64=(a56*a64);
  a64=(a0+a64);
  a64=(a4*a64);
  a152=(a152+a64);
  a189=(a189/a128);
  a169=(a137*a169);
  a189=(a189-a169);
  a169=(a60*a171);
  a64=(a192*a200);
  a149=(a120*a118);
  a64=(a64+a149);
  a169=(a169-a64);
  a169=(a169-a202);
  a202=(a165*a169);
  a150=(a191*a150);
  a202=(a202-a150);
  a198=(a172*a198);
  a200=(a60*a200);
  a171=(a192*a171);
  a118=(a58*a118);
  a171=(a171-a118);
  a200=(a200+a171);
  a200=(a200+a204);
  a204=(a184*a200);
  a198=(a198-a204);
  a202=(a202-a198);
  a189=(a189-a202);
  a202=(a2*a189);
  a202=(a0+a202);
  a152=(a152+a202);
  a152=(a3*a152);
  a152=(a2*a152);
  if (res[1]!=0) res[1][4]=a152;
  a157=(a5*a157);
  a157=(a4*a157);
  a196=(a56*a196);
  a196=(a4*a196);
  a157=(a157+a196);
  a170=(a27*a170);
  a169=(a169-a189);
  a169=(a141*a169);
  a182=(a65*a182);
  a169=(a169-a182);
  a195=(a172*a195);
  a200=(a142*a200);
  a195=(a195-a200);
  a169=(a169+a195);
  a169=(a169-a61);
  a169=(a23*a169);
  a169=(a169+a189);
  a170=(a170-a169);
  a170=(a2*a170);
  a157=(a157+a170);
  a157=(a3*a157);
  a157=(a2*a157);
  if (res[1]!=0) res[1][5]=a157;
  a157=(a23*a21);
  a170=(a27*a21);
  a157=(a157-a170);
  a157=(a21+a157);
  a170=(a15*a157);
  a169=(a30-a17);
  a169=(a169-a29);
  a189=(a18*a169);
  a170=(a170-a189);
  a189=(a37*a170);
  a189=(a170+a189);
  a189=(a8*a189);
  a157=(a18*a157);
  a169=(a15*a169);
  a157=(a157+a169);
  a169=(a48*a170);
  a157=(a157-a169);
  a157=(a10*a157);
  a189=(a189-a157);
  a189=(a189/a52);
  a157=(a5*a189);
  a157=(a4*a157);
  a170=(a170/a36);
  a169=(a8*a189);
  a61=(a37*a169);
  a195=(a10*a189);
  a200=(a48*a195);
  a61=(a61+a200);
  a170=(a170+a61);
  a61=(a73*a170);
  a200=(a82*a61);
  a189=(a73*a189);
  a182=(a80*a189);
  a196=(a79*a182);
  a200=(a200-a196);
  a196=(a27*a21);
  a195=(a18*a195);
  a169=(a169+a170);
  a169=(a15*a169);
  a195=(a195-a169);
  a195=(a195-a21);
  a195=(a23*a195);
  a195=(a195+a170);
  a196=(a196-a195);
  a195=(a73*a196);
  a195=(a0+a195);
  a169=(a195+a61);
  a152=(a91*a169);
  a202=cos(a84);
  a202=(a202*a70);
  a198=(a90*a202);
  a189=(a72*a189);
  a204=(a189+a61);
  a171=(a88*a204);
  a198=(a198-a171);
  a171=sin(a84);
  a171=(a171*a70);
  a118=(a82*a171);
  a150=(a85*a182);
  a118=(a118+a150);
  a198=(a198-a118);
  a118=(a28*a198);
  a152=(a152+a118);
  a118=(a28*a198);
  a150=(a91*a169);
  a118=(a118+a150);
  a150=(a23*a118);
  a64=(a91*a195);
  a198=(a87*a198);
  a64=(a64+a198);
  a198=(a27*a64);
  a150=(a150-a198);
  a152=(a152+a150);
  a150=(a85*a152);
  a198=(a92*a171);
  a150=(a150-a198);
  a198=(a98*a202);
  a149=(a97*a169);
  a201=(a90*a171);
  a204=(a85*a204);
  a201=(a201+a204);
  a204=(a82*a202);
  a148=(a88*a182);
  a204=(a204-a148);
  a201=(a201+a204);
  a169=(a201+a169);
  a169=(a28*a169);
  a149=(a149-a169);
  a195=(a96*a195);
  a201=(a87*a201);
  a195=(a195-a201);
  a149=(a149-a195);
  a195=(a88*a149);
  a198=(a198+a195);
  a150=(a150-a198);
  a200=(a200+a150);
  a198=(a82*a61);
  a195=(a79*a182);
  a198=(a198-a195);
  a150=(a150+a198);
  a198=(a103*a150);
  a195=(a88+a88);
  a195=(a195*a202);
  a201=(a27*a171);
  a169=(a85*a201);
  a204=(a99*a171);
  a169=(a169+a204);
  a195=(a195-a169);
  a169=(a195/a102);
  a204=(a103/a102);
  a204=(a204*a195);
  a169=(a169+a204);
  a204=(a94*a169);
  a198=(a198-a204);
  a204=(a101*a169);
  a148=(a103*a195);
  a204=(a204+a148);
  a204=(a195+a204);
  a148=(a105*a204);
  a156=(a82*a61);
  a182=(a79*a182);
  a156=(a156-a182);
  a182=(a100*a156);
  a148=(a148+a182);
  a182=(a99*a202);
  a201=(a88*a201);
  a182=(a182-a201);
  a201=(a85*a202);
  a68=(a88*a171);
  a201=(a201-a68);
  a182=(a182-a201);
  a201=(a103*a182);
  a68=(a107*a169);
  a201=(a201-a68);
  a201=(a182+a201);
  a68=(a109*a201);
  a54=(a89*a61);
  a199=(a79*a189);
  a54=(a54-a199);
  a199=(a108*a54);
  a68=(a68+a199);
  a148=(a148+a68);
  a198=(a198-a148);
  a200=(a200+a198);
  a200=(a72*a200);
  a198=(a106*a61);
  a189=(a189+a61);
  a189=(a79*a189);
  a198=(a198-a189);
  a189=(a92*a202);
  a152=(a88*a152);
  a189=(a189+a152);
  a149=(a85*a149);
  a152=(a98*a171);
  a149=(a149-a152);
  a189=(a189+a149);
  a198=(a198+a189);
  a189=(a27*a202);
  a149=(a85*a189);
  a152=(a111*a171);
  a149=(a149-a152);
  a152=(a85*a202);
  a61=(a88*a171);
  a152=(a152-a61);
  a149=(a149-a152);
  a152=(a182/a102);
  a61=(a113/a102);
  a61=(a61*a195);
  a152=(a152-a61);
  a61=(a101*a152);
  a148=(a113*a195);
  a61=(a61-a148);
  a149=(a149+a61);
  a61=(a105*a149);
  a148=(a112*a156);
  a61=(a61+a148);
  a189=(a88*a189);
  a148=(a111*a202);
  a189=(a189+a148);
  a148=(a85+a85);
  a148=(a148*a171);
  a189=(a189-a148);
  a148=(a107*a152);
  a182=(a113*a182);
  a148=(a148+a182);
  a189=(a189-a148);
  a148=(a109*a189);
  a182=(a115*a54);
  a148=(a148+a182);
  a61=(a61+a148);
  a148=(a94*a152);
  a182=(a113*a150);
  a148=(a148+a182);
  a61=(a61+a148);
  a198=(a198-a61);
  a198=(a80*a198);
  a200=(a200-a198);
  a200=(a200/a116);
  a198=(a72*a204);
  a61=(a80*a149);
  a198=(a198-a61);
  a198=(a72*a198);
  a61=(a72*a201);
  a148=(a80*a189);
  a61=(a61-a148);
  a61=(a80*a61);
  a198=(a198-a61);
  a119=(a119*a198);
  a200=(a200+a119);
  a204=(a80*a204);
  a149=(a72*a149);
  a204=(a204+a149);
  a204=(a72*a204);
  a201=(a80*a201);
  a189=(a72*a189);
  a201=(a201+a189);
  a201=(a80*a201);
  a204=(a204-a201);
  a204=(a204/a116);
  a154=(a154*a198);
  a204=(a204-a154);
  a204=(a60*a204);
  a200=(a200+a204);
  a204=(a56*a200);
  a204=(a4*a204);
  a157=(a157+a204);
  a150=(a150/a102);
  a204=(a121/a102);
  a204=(a204*a195);
  a150=(a150-a204);
  a169=(a133*a169);
  a204=(a72*a200);
  a204=(a204+a156);
  a156=(a103*a204);
  a169=(a169+a156);
  a152=(a135*a152);
  a156=(a80*a200);
  a156=(a156-a54);
  a54=(a113*a156);
  a152=(a152+a54);
  a169=(a169+a152);
  a150=(a150+a169);
  a169=(a59*a150);
  a152=(a131*a169);
  a54=(a5*a170);
  a54=(a55*a54);
  a177=(a177*a54);
  a195=(a130*a177);
  a200=(a59*a200);
  a154=(a58*a200);
  a195=(a195-a154);
  a154=(a136*a195);
  a152=(a152+a154);
  a118=(a27*a118);
  a202=(a135*a202);
  a156=(a88*a156);
  a202=(a202+a156);
  a171=(a146*a171);
  a204=(a204+a150);
  a204=(a85*a204);
  a171=(a171+a204);
  a202=(a202-a171);
  a202=(a202-a64);
  a202=(a23*a202);
  a202=(a202+a150);
  a118=(a118-a202);
  a202=(a59*a118);
  a202=(a0+a202);
  a64=(a202+a169);
  a171=(a145*a64);
  a204=(a5*a196);
  a204=(a0+a204);
  a204=(a55*a204);
  a138=(a138*a204);
  a156=(a144*a138);
  a178=(a178*a54);
  a54=(a130*a178);
  a200=(a120*a200);
  a54=(a54+a200);
  a200=(a54+a169);
  a154=(a142*a200);
  a156=(a156-a154);
  a154=(a141*a195);
  a193=(a193*a204);
  a204=(a131*a193);
  a154=(a154-a204);
  a156=(a156+a154);
  a154=(a95*a156);
  a171=(a171+a154);
  a154=(a95*a156);
  a204=(a145*a64);
  a154=(a154+a204);
  a204=(a23*a154);
  a198=(a145*a202);
  a156=(a147*a156);
  a198=(a198+a156);
  a156=(a27*a198);
  a204=(a204-a156);
  a171=(a171+a204);
  a204=(a141*a171);
  a156=(a151*a193);
  a204=(a204-a156);
  a156=(a162*a138);
  a201=(a161*a64);
  a189=(a144*a193);
  a200=(a141*a200);
  a189=(a189+a200);
  a200=(a131*a138);
  a149=(a142*a195);
  a200=(a200+a149);
  a189=(a189+a200);
  a64=(a189+a64);
  a64=(a95*a64);
  a201=(a201-a64);
  a202=(a159*a202);
  a189=(a147*a189);
  a202=(a202-a189);
  a201=(a201-a202);
  a202=(a142*a201);
  a156=(a156+a202);
  a204=(a204-a156);
  a152=(a152+a204);
  a156=(a136*a195);
  a202=(a131*a169);
  a156=(a156+a202);
  a204=(a204+a156);
  a156=(a165*a204);
  a66=(a66*a138);
  a202=(a27*a193);
  a189=(a141*a202);
  a64=(a163*a193);
  a189=(a189+a64);
  a66=(a66-a189);
  a189=(a66/a128);
  a124=(a124*a66);
  a189=(a189+a124);
  a124=(a168*a189);
  a156=(a156-a124);
  a124=(a153*a189);
  a64=(a165*a66);
  a124=(a124+a64);
  a124=(a66+a124);
  a64=(a174*a124);
  a200=(a131*a169);
  a195=(a136*a195);
  a200=(a200+a195);
  a195=(a132*a200);
  a64=(a64+a195);
  a195=(a163*a138);
  a202=(a142*a202);
  a195=(a195-a202);
  a202=(a141*a138);
  a149=(a142*a193);
  a202=(a202-a149);
  a195=(a195-a202);
  a202=(a165*a195);
  a149=(a179*a189);
  a202=(a202-a149);
  a202=(a195+a202);
  a149=(a140*a202);
  a119=(a143*a169);
  a61=(a136*a54);
  a119=(a119-a61);
  a61=(a181*a119);
  a149=(a149+a61);
  a64=(a64+a149);
  a156=(a156-a64);
  a152=(a152+a156);
  a152=(a120*a152);
  a156=(a166*a178);
  a152=(a152-a156);
  a156=(a176*a177);
  a64=(a167*a169);
  a54=(a54+a169);
  a54=(a136*a54);
  a64=(a64-a54);
  a54=(a151*a138);
  a171=(a142*a171);
  a54=(a54+a171);
  a201=(a141*a201);
  a171=(a162*a193);
  a201=(a201-a171);
  a54=(a54+a201);
  a64=(a64+a54);
  a54=(a27*a138);
  a201=(a141*a54);
  a171=(a180*a193);
  a201=(a201-a171);
  a171=(a141*a138);
  a169=(a142*a193);
  a171=(a171-a169);
  a201=(a201-a171);
  a171=(a195/a128);
  a194=(a194*a66);
  a171=(a171-a194);
  a194=(a153*a171);
  a169=(a184*a66);
  a194=(a194-a169);
  a201=(a201+a194);
  a194=(a174*a201);
  a169=(a183*a200);
  a194=(a194+a169);
  a54=(a142*a54);
  a169=(a180*a138);
  a54=(a54+a169);
  a197=(a197*a193);
  a54=(a54-a197);
  a197=(a179*a171);
  a195=(a184*a195);
  a197=(a197+a195);
  a54=(a54-a197);
  a197=(a140*a54);
  a195=(a186*a119);
  a197=(a197+a195);
  a194=(a194+a197);
  a197=(a168*a171);
  a195=(a184*a204);
  a197=(a197+a195);
  a194=(a194+a197);
  a64=(a64-a194);
  a64=(a58*a64);
  a156=(a156+a64);
  a152=(a152-a156);
  a152=(a152/a187);
  a156=(a120*a124);
  a64=(a132*a178);
  a156=(a156-a64);
  a64=(a183*a177);
  a194=(a58*a201);
  a64=(a64+a194);
  a156=(a156-a64);
  a156=(a120*a156);
  a64=(a185*a178);
  a156=(a156-a64);
  a64=(a120*a202);
  a194=(a181*a178);
  a64=(a64-a194);
  a194=(a186*a177);
  a197=(a58*a54);
  a194=(a194+a197);
  a64=(a64-a194);
  a64=(a58*a64);
  a194=(a188*a177);
  a64=(a64+a194);
  a156=(a156-a64);
  a139=(a139*a156);
  a152=(a152+a139);
  a139=(a132*a177);
  a124=(a58*a124);
  a139=(a139+a124);
  a201=(a120*a201);
  a124=(a183*a178);
  a201=(a201-a124);
  a139=(a139+a201);
  a139=(a120*a139);
  a201=(a164*a178);
  a139=(a139-a201);
  a201=(a181*a177);
  a202=(a58*a202);
  a201=(a201+a202);
  a54=(a120*a54);
  a202=(a186*a178);
  a54=(a54-a202);
  a201=(a201+a54);
  a201=(a58*a201);
  a54=(a122*a177);
  a201=(a201+a54);
  a139=(a139-a201);
  a139=(a139/a187);
  a173=(a173*a156);
  a139=(a139-a173);
  a139=(a60*a139);
  a152=(a152+a139);
  a139=(a2*a152);
  a157=(a157+a139);
  a157=(a3*a157);
  a157=(a2*a157);
  a157=(-a157);
  if (res[1]!=0) res[1][6]=a157;
  a170=(a5*a170);
  a170=(a4*a170);
  a150=(a56*a150);
  a150=(a4*a150);
  a170=(a170+a150);
  a204=(a204/a128);
  a137=(a137*a66);
  a204=(a204-a137);
  a137=(a60*a177);
  a66=(a192*a178);
  a150=(a120*a152);
  a66=(a66+a150);
  a137=(a137-a66);
  a137=(a137-a200);
  a200=(a165*a137);
  a189=(a191*a189);
  a200=(a200-a189);
  a171=(a172*a171);
  a178=(a60*a178);
  a177=(a192*a177);
  a152=(a58*a152);
  a177=(a177-a152);
  a178=(a178+a177);
  a178=(a178+a119);
  a119=(a184*a178);
  a171=(a171-a119);
  a200=(a200-a171);
  a204=(a204-a200);
  a200=(a2*a204);
  a170=(a170+a200);
  a170=(a3*a170);
  a170=(a2*a170);
  if (res[1]!=0) res[1][7]=a170;
  a196=(a5*a196);
  a196=(a0+a196);
  a196=(a4*a196);
  a196=(a0+a196);
  a118=(a56*a118);
  a118=(a0+a118);
  a118=(a4*a118);
  a196=(a196+a118);
  a154=(a27*a154);
  a137=(a137-a204);
  a137=(a141*a137);
  a193=(a65*a193);
  a137=(a137-a193);
  a138=(a172*a138);
  a178=(a142*a178);
  a138=(a138-a178);
  a137=(a137+a138);
  a137=(a137-a198);
  a137=(a23*a137);
  a137=(a137+a204);
  a154=(a154-a137);
  a154=(a2*a154);
  a154=(a0+a154);
  a196=(a196+a154);
  a196=(a3*a196);
  a196=(a2*a196);
  if (res[1]!=0) res[1][8]=a196;
  a196=(a5/a52);
  a196=(a4*a196);
  a154=(a73/a52);
  a137=(a80*a154);
  a204=(a79*a137);
  a198=(a8/a52);
  a138=(a37*a198);
  a178=(a10/a52);
  a193=(a48*a178);
  a138=(a138+a193);
  a193=(a73*a138);
  a118=(a82*a193);
  a204=(a204-a118);
  a154=(a72*a154);
  a118=(a154+a193);
  a170=(a88*a118);
  a200=(a85*a137);
  a170=(a170+a200);
  a200=(a28*a170);
  a198=(a198+a138);
  a198=(a15*a198);
  a178=(a18*a178);
  a198=(a198-a178);
  a198=(a23*a198);
  a198=(a198-a138);
  a178=(a73*a198);
  a171=(a178+a193);
  a119=(a91*a171);
  a200=(a200-a119);
  a119=(a28*a170);
  a177=(a91*a171);
  a119=(a119-a177);
  a177=(a23*a119);
  a170=(a87*a170);
  a152=(a91*a178);
  a170=(a170-a152);
  a152=(a27*a170);
  a177=(a177-a152);
  a200=(a200+a177);
  a177=(a85*a200);
  a118=(a85*a118);
  a152=(a88*a137);
  a118=(a118-a152);
  a152=(a118+a171);
  a152=(a28*a152);
  a171=(a97*a171);
  a152=(a152-a171);
  a118=(a87*a118);
  a178=(a96*a178);
  a118=(a118-a178);
  a152=(a152-a118);
  a118=(a88*a152);
  a177=(a177-a118);
  a204=(a204+a177);
  a118=(a79*a137);
  a178=(a82*a193);
  a118=(a118-a178);
  a177=(a177+a118);
  a118=(a103*a177);
  a137=(a79*a137);
  a178=(a82*a193);
  a137=(a137-a178);
  a178=(a100*a137);
  a171=(a79*a154);
  a189=(a89*a193);
  a171=(a171-a189);
  a189=(a108*a171);
  a178=(a178+a189);
  a118=(a118-a178);
  a204=(a204+a118);
  a204=(a72*a204);
  a154=(a154+a193);
  a154=(a79*a154);
  a193=(a106*a193);
  a154=(a154-a193);
  a200=(a88*a200);
  a152=(a85*a152);
  a200=(a200+a152);
  a154=(a154+a200);
  a200=(a112*a137);
  a152=(a115*a171);
  a200=(a200+a152);
  a152=(a113*a177);
  a200=(a200+a152);
  a154=(a154-a200);
  a154=(a80*a154);
  a204=(a204-a154);
  a204=(a0-a204);
  a204=(a204/a116);
  a154=(a56*a204);
  a154=(a4*a154);
  a196=(a196+a154);
  a154=sin(a77);
  a200=(a5*a138);
  a200=(a55*a200);
  a152=(a154*a200);
  a193=(a166*a152);
  a177=(a177/a102);
  a118=(a72*a204);
  a118=(a118-a137);
  a137=(a103*a118);
  a178=(a80*a204);
  a178=(a178+a171);
  a171=(a113*a178);
  a137=(a137+a171);
  a177=(a177-a137);
  a137=(a59*a177);
  a171=(a131*a137);
  a204=(a59*a204);
  a189=(a58*a204);
  a66=cos(a77);
  a200=(a66*a200);
  a150=(a130*a200);
  a189=(a189-a150);
  a150=(a136*a189);
  a171=(a171+a150);
  a150=sin(a25);
  a157=(a5*a198);
  a157=(a55*a157);
  a139=(a150*a157);
  a173=(a151*a139);
  a119=(a27*a119);
  a118=(a118-a177);
  a118=(a85*a118);
  a178=(a88*a178);
  a118=(a118-a178);
  a118=(a118-a170);
  a118=(a23*a118);
  a118=(a118+a177);
  a119=(a119-a118);
  a118=(a59*a119);
  a170=(a118+a137);
  a178=(a145*a170);
  a156=(a130*a152);
  a204=(a120*a204);
  a156=(a156+a204);
  a204=(a156-a137);
  a201=(a142*a204);
  a54=cos(a25);
  a157=(a54*a157);
  a202=(a144*a157);
  a201=(a201-a202);
  a202=(a131*a139);
  a124=(a141*a189);
  a202=(a202+a124);
  a201=(a201+a202);
  a202=(a95*a201);
  a178=(a178+a202);
  a202=(a95*a201);
  a124=(a145*a170);
  a202=(a202+a124);
  a124=(a23*a202);
  a64=(a145*a118);
  a201=(a147*a201);
  a64=(a64+a201);
  a201=(a27*a64);
  a124=(a124-a201);
  a178=(a178+a124);
  a124=(a141*a178);
  a173=(a173+a124);
  a124=(a161*a170);
  a201=(a144*a139);
  a204=(a141*a204);
  a201=(a201+a204);
  a204=(a142*a189);
  a194=(a131*a157);
  a204=(a204-a194);
  a201=(a201-a204);
  a170=(a201-a170);
  a170=(a95*a170);
  a124=(a124+a170);
  a118=(a159*a118);
  a201=(a147*a201);
  a118=(a118+a201);
  a124=(a124-a118);
  a118=(a142*a124);
  a201=(a162*a157);
  a118=(a118-a201);
  a173=(a173-a118);
  a171=(a171+a173);
  a118=(a136*a189);
  a201=(a131*a137);
  a118=(a118+a201);
  a173=(a173+a118);
  a118=(a165*a173);
  a201=(a27*a139);
  a170=(a141*a201);
  a204=(a163*a139);
  a170=(a170+a204);
  a204=(a142+a142);
  a194=(a204*a157);
  a170=(a170-a194);
  a194=(a170/a128);
  a197=(a165/a128);
  a195=(a197*a170);
  a194=(a194+a195);
  a195=(a168*a194);
  a118=(a118-a195);
  a195=(a153*a194);
  a169=(a165*a170);
  a195=(a195+a169);
  a195=(a170+a195);
  a169=(a174*a195);
  a149=(a131*a137);
  a189=(a136*a189);
  a149=(a149+a189);
  a189=(a132*a149);
  a169=(a169+a189);
  a201=(a142*a201);
  a189=(a163*a157);
  a201=(a201-a189);
  a189=(a142*a139);
  a61=(a141*a157);
  a189=(a189-a61);
  a201=(a201-a189);
  a189=(a165*a201);
  a61=(a179*a194);
  a189=(a189-a61);
  a189=(a201+a189);
  a61=(a140*a189);
  a148=(a143*a137);
  a182=(a136*a156);
  a148=(a148+a182);
  a182=(a181*a148);
  a61=(a61+a182);
  a169=(a169+a61);
  a118=(a118-a169);
  a171=(a171+a118);
  a171=(a120*a171);
  a193=(a193+a171);
  a171=(a167*a137);
  a156=(a156-a137);
  a156=(a136*a156);
  a171=(a171+a156);
  a178=(a142*a178);
  a156=(a151*a157);
  a178=(a178-a156);
  a156=(a162*a139);
  a124=(a141*a124);
  a156=(a156+a124);
  a178=(a178+a156);
  a171=(a171+a178);
  a178=(a180*a139);
  a156=(a27*a157);
  a124=(a141*a156);
  a178=(a178-a124);
  a124=(a142*a139);
  a137=(a141*a157);
  a124=(a124-a137);
  a178=(a178-a124);
  a124=(a201/a128);
  a137=(a184/a128);
  a118=(a137*a170);
  a124=(a124-a118);
  a118=(a153*a124);
  a169=(a184*a170);
  a118=(a118-a169);
  a178=(a178+a118);
  a118=(a174*a178);
  a169=(a183*a149);
  a118=(a118+a169);
  a169=(a141+a141);
  a61=(a169*a139);
  a156=(a142*a156);
  a182=(a180*a157);
  a156=(a156+a182);
  a61=(a61-a156);
  a156=(a179*a124);
  a201=(a184*a201);
  a156=(a156+a201);
  a61=(a61-a156);
  a156=(a140*a61);
  a201=(a186*a148);
  a156=(a156+a201);
  a118=(a118+a156);
  a156=(a168*a124);
  a201=(a184*a173);
  a156=(a156+a201);
  a118=(a118+a156);
  a171=(a171-a118);
  a171=(a58*a171);
  a118=(a176*a200);
  a171=(a171-a118);
  a193=(a193-a171);
  a193=(a0-a193);
  a193=(a193/a187);
  a171=(a190/a187);
  a118=(a132*a152);
  a156=(a120*a195);
  a118=(a118+a156);
  a156=(a58*a178);
  a201=(a183*a200);
  a156=(a156-a201);
  a118=(a118-a156);
  a118=(a120*a118);
  a156=(a185*a152);
  a118=(a118+a156);
  a156=(a181*a152);
  a201=(a120*a189);
  a156=(a156+a201);
  a201=(a58*a61);
  a182=(a186*a200);
  a201=(a201-a182);
  a156=(a156-a201);
  a156=(a58*a156);
  a201=(a188*a200);
  a156=(a156-a201);
  a118=(a118-a156);
  a156=(a171*a118);
  a193=(a193-a156);
  a195=(a58*a195);
  a156=(a132*a200);
  a195=(a195-a156);
  a156=(a183*a152);
  a178=(a120*a178);
  a156=(a156+a178);
  a195=(a195+a156);
  a195=(a120*a195);
  a156=(a164*a152);
  a195=(a195+a156);
  a189=(a58*a189);
  a156=(a181*a200);
  a189=(a189-a156);
  a156=(a186*a152);
  a61=(a120*a61);
  a156=(a156+a61);
  a189=(a189+a156);
  a189=(a58*a189);
  a156=(a122*a200);
  a189=(a189-a156);
  a195=(a195-a189);
  a195=(a195/a187);
  a189=(a175/a187);
  a118=(a189*a118);
  a195=(a195-a118);
  a195=(a60*a195);
  a193=(a193-a195);
  a195=(a2*a193);
  a196=(a196+a195);
  a196=(a3*a196);
  a196=(a2*a196);
  if (res[2]!=0) res[2][0]=a196;
  a177=(a56*a177);
  a177=(a4*a177);
  a138=(a5*a138);
  a138=(a4*a138);
  a177=(a177-a138);
  a173=(a173/a128);
  a138=(a127/a128);
  a170=(a138*a170);
  a173=(a173-a170);
  a170=(a192*a152);
  a196=(a120*a193);
  a170=(a170+a196);
  a196=(a60*a200);
  a170=(a170-a196);
  a170=(a170-a149);
  a149=(a165*a170);
  a194=(a191*a194);
  a149=(a149-a194);
  a124=(a172*a124);
  a152=(a60*a152);
  a193=(a58*a193);
  a200=(a192*a200);
  a193=(a193-a200);
  a152=(a152-a193);
  a152=(a152-a148);
  a148=(a184*a152);
  a124=(a124+a148);
  a149=(a149-a124);
  a173=(a173-a149);
  a149=(a2*a173);
  a177=(a177+a149);
  a177=(a3*a177);
  a177=(a2*a177);
  if (res[2]!=0) res[2][1]=a177;
  a119=(a56*a119);
  a119=(a4*a119);
  a198=(a5*a198);
  a198=(a4*a198);
  a119=(a119-a198);
  a202=(a27*a202);
  a139=(a65*a139);
  a170=(a170-a173);
  a170=(a141*a170);
  a139=(a139+a170);
  a152=(a142*a152);
  a157=(a172*a157);
  a152=(a152-a157);
  a139=(a139+a152);
  a139=(a139-a64);
  a139=(a23*a139);
  a139=(a139+a173);
  a202=(a202-a139);
  a202=(a2*a202);
  a119=(a119+a202);
  a119=(a3*a119);
  a119=(a2*a119);
  if (res[2]!=0) res[2][2]=a119;
  a119=(a8*a37);
  a202=(a10*a48);
  a119=(a119+a202);
  a119=(a119/a52);
  a202=(a5*a119);
  a202=(a4*a202);
  a139=(1./a36);
  a173=(a8*a119);
  a64=(a37*a173);
  a152=(a10*a119);
  a157=(a48*a152);
  a64=(a64+a157);
  a139=(a139+a64);
  a64=(a73*a139);
  a157=(a82*a64);
  a119=(a73*a119);
  a170=(a80*a119);
  a198=(a79*a170);
  a157=(a157-a198);
  a152=(a18*a152);
  a173=(a173+a139);
  a173=(a15*a173);
  a152=(a152-a173);
  a152=(a23*a152);
  a152=(a152+a139);
  a173=(a73*a152);
  a198=(a64-a173);
  a177=(a91*a198);
  a119=(a72*a119);
  a149=(a119+a64);
  a124=(a88*a149);
  a148=(a85*a170);
  a124=(a124+a148);
  a148=(a28*a124);
  a177=(a177-a148);
  a148=(a91*a198);
  a193=(a28*a124);
  a148=(a148-a193);
  a193=(a23*a148);
  a200=(a91*a173);
  a124=(a87*a124);
  a200=(a200+a124);
  a124=(a27*a200);
  a193=(a193+a124);
  a177=(a177+a193);
  a193=(a85*a177);
  a124=(a97*a198);
  a194=(a88*a170);
  a149=(a85*a149);
  a194=(a194-a149);
  a198=(a194-a198);
  a198=(a28*a198);
  a124=(a124+a198);
  a194=(a87*a194);
  a173=(a96*a173);
  a194=(a194-a173);
  a124=(a124-a194);
  a194=(a88*a124);
  a193=(a193-a194);
  a157=(a157+a193);
  a194=(a82*a64);
  a173=(a79*a170);
  a194=(a194-a173);
  a193=(a193+a194);
  a193=(a0+a193);
  a194=(a103*a193);
  a173=(a82*a64);
  a170=(a79*a170);
  a173=(a173-a170);
  a170=(a100*a173);
  a198=(a89*a64);
  a149=(a79*a119);
  a198=(a198-a149);
  a149=(a108*a198);
  a170=(a170+a149);
  a194=(a194-a170);
  a157=(a157+a194);
  a157=(a72*a157);
  a194=(a106*a64);
  a119=(a119+a64);
  a119=(a79*a119);
  a194=(a194-a119);
  a177=(a88*a177);
  a124=(a85*a124);
  a177=(a177+a124);
  a194=(a194+a177);
  a177=(a112*a173);
  a124=(a115*a198);
  a177=(a177+a124);
  a124=(a113*a193);
  a177=(a177+a124);
  a194=(a194-a177);
  a194=(a80*a194);
  a157=(a157-a194);
  a157=(a157/a116);
  a194=(a56*a157);
  a194=(a4*a194);
  a202=(a202+a194);
  a193=(a193/a102);
  a194=(a72*a157);
  a194=(a194+a173);
  a173=(a103*a194);
  a177=(a80*a157);
  a177=(a177-a198);
  a198=(a113*a177);
  a173=(a173+a198);
  a193=(a193+a173);
  a173=(a59*a193);
  a198=(a131*a173);
  a124=(a5*a139);
  a124=(a55*a124);
  a119=(a66*a124);
  a64=(a130*a119);
  a157=(a59*a157);
  a170=(a58*a157);
  a64=(a64-a170);
  a170=(a136*a64);
  a198=(a198+a170);
  a170=(a5*a152);
  a170=(a55*a170);
  a149=(a150*a170);
  a196=(a151*a149);
  a148=(a27*a148);
  a177=(a88*a177);
  a194=(a194+a193);
  a194=(a85*a194);
  a177=(a177-a194);
  a177=(a177+a200);
  a177=(a23*a177);
  a177=(a177+a193);
  a148=(a148-a177);
  a177=(a59*a148);
  a200=(a177+a173);
  a194=(a145*a200);
  a195=(a131*a149);
  a118=(a141*a64);
  a195=(a195+a118);
  a170=(a54*a170);
  a118=(a144*a170);
  a124=(a154*a124);
  a156=(a130*a124);
  a157=(a120*a157);
  a156=(a156+a157);
  a157=(a156+a173);
  a61=(a142*a157);
  a118=(a118+a61);
  a195=(a195-a118);
  a118=(a95*a195);
  a194=(a194+a118);
  a118=(a95*a195);
  a61=(a145*a200);
  a118=(a118+a61);
  a61=(a23*a118);
  a178=(a145*a177);
  a195=(a147*a195);
  a178=(a178+a195);
  a195=(a27*a178);
  a61=(a61-a195);
  a194=(a194+a61);
  a61=(a141*a194);
  a196=(a196+a61);
  a61=(a161*a200);
  a195=(a144*a149);
  a157=(a141*a157);
  a195=(a195-a157);
  a157=(a142*a64);
  a201=(a131*a170);
  a157=(a157-a201);
  a195=(a195-a157);
  a200=(a195-a200);
  a200=(a95*a200);
  a61=(a61+a200);
  a177=(a159*a177);
  a195=(a147*a195);
  a177=(a177+a195);
  a61=(a61-a177);
  a177=(a142*a61);
  a195=(a162*a170);
  a177=(a177-a195);
  a196=(a196-a177);
  a198=(a198+a196);
  a177=(a136*a64);
  a195=(a131*a173);
  a177=(a177+a195);
  a196=(a196+a177);
  a196=(a0+a196);
  a177=(a165*a196);
  a195=(a27*a149);
  a200=(a141*a195);
  a157=(a163*a149);
  a200=(a200+a157);
  a157=(a204*a170);
  a200=(a200-a157);
  a157=(a200/a128);
  a201=(a197*a200);
  a157=(a157+a201);
  a201=(a168*a157);
  a177=(a177-a201);
  a201=(a153*a157);
  a182=(a165*a200);
  a201=(a201+a182);
  a201=(a200+a201);
  a182=(a174*a201);
  a68=(a131*a173);
  a64=(a136*a64);
  a68=(a68+a64);
  a64=(a132*a68);
  a182=(a182+a64);
  a195=(a142*a195);
  a64=(a163*a170);
  a195=(a195-a64);
  a64=(a142*a149);
  a199=(a141*a170);
  a64=(a64-a199);
  a195=(a195-a64);
  a64=(a165*a195);
  a199=(a179*a157);
  a64=(a64-a199);
  a64=(a195+a64);
  a199=(a140*a64);
  a125=(a143*a173);
  a203=(a136*a156);
  a125=(a125-a203);
  a203=(a181*a125);
  a199=(a199+a203);
  a182=(a182+a199);
  a177=(a177-a182);
  a198=(a198+a177);
  a198=(a120*a198);
  a177=(a166*a124);
  a198=(a198-a177);
  a177=(a176*a119);
  a182=(a167*a173);
  a156=(a156+a173);
  a156=(a136*a156);
  a182=(a182-a156);
  a194=(a142*a194);
  a156=(a151*a170);
  a194=(a194-a156);
  a156=(a162*a149);
  a61=(a141*a61);
  a156=(a156+a61);
  a194=(a194+a156);
  a182=(a182+a194);
  a194=(a180*a149);
  a156=(a27*a170);
  a61=(a141*a156);
  a194=(a194-a61);
  a61=(a142*a149);
  a173=(a141*a170);
  a61=(a61-a173);
  a194=(a194-a61);
  a61=(a195/a128);
  a173=(a137*a200);
  a61=(a61-a173);
  a173=(a153*a61);
  a199=(a184*a200);
  a173=(a173-a199);
  a194=(a194+a173);
  a173=(a174*a194);
  a199=(a183*a68);
  a173=(a173+a199);
  a199=(a169*a149);
  a156=(a142*a156);
  a203=(a180*a170);
  a156=(a156+a203);
  a199=(a199-a156);
  a156=(a179*a61);
  a195=(a184*a195);
  a156=(a156+a195);
  a199=(a199-a156);
  a156=(a140*a199);
  a195=(a186*a125);
  a156=(a156+a195);
  a173=(a173+a156);
  a156=(a168*a61);
  a195=(a184*a196);
  a156=(a156+a195);
  a173=(a173+a156);
  a182=(a182-a173);
  a182=(a58*a182);
  a177=(a177+a182);
  a198=(a198-a177);
  a198=(a198/a187);
  a177=(a120*a201);
  a182=(a132*a124);
  a177=(a177-a182);
  a182=(a183*a119);
  a173=(a58*a194);
  a182=(a182+a173);
  a177=(a177-a182);
  a177=(a120*a177);
  a182=(a185*a124);
  a177=(a177-a182);
  a182=(a120*a64);
  a173=(a181*a124);
  a182=(a182-a173);
  a173=(a186*a119);
  a156=(a58*a199);
  a173=(a173+a156);
  a182=(a182-a173);
  a182=(a58*a182);
  a173=(a188*a119);
  a182=(a182+a173);
  a177=(a177-a182);
  a182=(a171*a177);
  a198=(a198+a182);
  a182=(a132*a119);
  a201=(a58*a201);
  a182=(a182+a201);
  a194=(a120*a194);
  a201=(a183*a124);
  a194=(a194-a201);
  a182=(a182+a194);
  a182=(a120*a182);
  a194=(a164*a124);
  a182=(a182-a194);
  a194=(a181*a119);
  a64=(a58*a64);
  a194=(a194+a64);
  a199=(a120*a199);
  a64=(a186*a124);
  a199=(a199-a64);
  a194=(a194+a199);
  a194=(a58*a194);
  a199=(a122*a119);
  a194=(a194+a199);
  a182=(a182-a194);
  a182=(a182/a187);
  a177=(a189*a177);
  a182=(a182-a177);
  a182=(a60*a182);
  a198=(a198+a182);
  a182=(a2*a198);
  a202=(a202+a182);
  a202=(a3*a202);
  a202=(a2*a202);
  a202=(-a202);
  if (res[2]!=0) res[2][3]=a202;
  a139=(a5*a139);
  a139=(a4*a139);
  a193=(a56*a193);
  a193=(a4*a193);
  a139=(a139+a193);
  a196=(a196/a128);
  a200=(a138*a200);
  a196=(a196-a200);
  a200=(a60*a119);
  a193=(a192*a124);
  a202=(a120*a198);
  a193=(a193+a202);
  a200=(a200-a193);
  a200=(a200-a68);
  a68=(a165*a200);
  a157=(a191*a157);
  a68=(a68-a157);
  a61=(a172*a61);
  a124=(a60*a124);
  a119=(a192*a119);
  a198=(a58*a198);
  a119=(a119-a198);
  a124=(a124+a119);
  a124=(a124+a125);
  a125=(a184*a124);
  a61=(a61-a125);
  a68=(a68-a61);
  a196=(a196-a68);
  a68=(a2*a196);
  a139=(a139+a68);
  a139=(a3*a139);
  a139=(a2*a139);
  if (res[2]!=0) res[2][4]=a139;
  a148=(a56*a148);
  a148=(a4*a148);
  a152=(a5*a152);
  a152=(a4*a152);
  a148=(a148-a152);
  a118=(a27*a118);
  a149=(a65*a149);
  a200=(a200-a196);
  a200=(a141*a200);
  a149=(a149+a200);
  a170=(a172*a170);
  a124=(a142*a124);
  a170=(a170+a124);
  a149=(a149-a170);
  a149=(a149-a178);
  a149=(a23*a149);
  a149=(a149+a196);
  a118=(a118-a149);
  a118=(a2*a118);
  a148=(a148+a118);
  a148=(a3*a148);
  a148=(a2*a148);
  if (res[2]!=0) res[2][5]=a148;
  a148=(a23*a15);
  a118=(a0-a148);
  a149=(a37*a118);
  a148=(a148-a149);
  a148=(a8*a148);
  a149=(a23*a18);
  a196=(a48*a118);
  a149=(a149+a196);
  a149=(a10*a149);
  a148=(a148-a149);
  a148=(a148/a52);
  a149=(a5*a148);
  a149=(a4*a149);
  a196=(a8*a148);
  a178=(a37*a196);
  a170=(a10*a148);
  a124=(a48*a170);
  a178=(a178+a124);
  a118=(a118/a36);
  a178=(a178-a118);
  a118=(a73*a178);
  a124=(a82*a118);
  a148=(a73*a148);
  a200=(a80*a148);
  a152=(a79*a200);
  a124=(a124-a152);
  a170=(a18*a170);
  a196=(a196+a178);
  a196=(a15*a196);
  a170=(a170-a196);
  a170=(a23*a170);
  a170=(a170+a178);
  a170=(a27-a170);
  a196=(a73*a170);
  a152=(a196+a118);
  a139=(a91*a152);
  a148=(a72*a148);
  a68=(a148+a118);
  a61=(a88*a68);
  a125=(a85*a200);
  a61=(a61+a125);
  a125=(a28*a61);
  a139=(a139-a125);
  a125=(a91*a152);
  a119=(a28*a61);
  a125=(a125-a119);
  a125=(a0+a125);
  a119=(a23*a125);
  a198=(a91*a196);
  a61=(a87*a61);
  a198=(a198-a61);
  a61=(a27*a198);
  a119=(a119-a61);
  a139=(a139+a119);
  a119=(a85*a139);
  a61=(a97*a152);
  a157=(a88*a200);
  a68=(a85*a68);
  a157=(a157-a68);
  a152=(a157-a152);
  a152=(a28*a152);
  a61=(a61+a152);
  a196=(a96*a196);
  a157=(a87*a157);
  a196=(a196+a157);
  a61=(a61-a196);
  a196=(a88*a61);
  a119=(a119-a196);
  a124=(a124+a119);
  a119=(a0-a119);
  a196=(a82*a118);
  a157=(a79*a200);
  a196=(a196-a157);
  a119=(a119-a196);
  a196=(a103*a119);
  a157=(a82*a118);
  a200=(a79*a200);
  a157=(a157-a200);
  a200=(a100*a157);
  a152=(a89*a118);
  a68=(a79*a148);
  a152=(a152-a68);
  a68=(a108*a152);
  a200=(a200+a68);
  a196=(a196+a200);
  a124=(a124-a196);
  a124=(a72*a124);
  a196=(a106*a118);
  a148=(a148+a118);
  a148=(a79*a148);
  a196=(a196-a148);
  a139=(a88*a139);
  a61=(a85*a61);
  a139=(a139+a61);
  a196=(a196+a139);
  a139=(a112*a157);
  a61=(a115*a152);
  a139=(a139+a61);
  a61=(a113*a119);
  a139=(a139-a61);
  a196=(a196-a139);
  a196=(a80*a196);
  a124=(a124-a196);
  a124=(a124/a116);
  a196=(a56*a124);
  a196=(a4*a196);
  a149=(a149+a196);
  a196=(a72*a124);
  a196=(a196+a157);
  a157=(a103*a196);
  a139=(a80*a124);
  a139=(a139-a152);
  a152=(a113*a139);
  a157=(a157+a152);
  a119=(a119/a102);
  a157=(a157-a119);
  a119=(a59*a157);
  a152=(a131*a119);
  a61=(a5*a178);
  a61=(a55*a61);
  a66=(a66*a61);
  a148=(a130*a66);
  a124=(a59*a124);
  a118=(a58*a124);
  a148=(a148-a118);
  a118=(a136*a148);
  a152=(a152+a118);
  a125=(a27*a125);
  a139=(a88*a139);
  a196=(a196+a157);
  a196=(a85*a196);
  a139=(a139-a196);
  a139=(a139-a198);
  a139=(a23*a139);
  a139=(a139+a157);
  a125=(a125-a139);
  a139=(a59*a125);
  a198=(a139+a119);
  a196=(a145*a198);
  a118=(a5*a170);
  a118=(a55*a118);
  a54=(a54*a118);
  a200=(a144*a54);
  a154=(a154*a61);
  a61=(a130*a154);
  a124=(a120*a124);
  a61=(a61+a124);
  a124=(a61+a119);
  a68=(a142*a124);
  a200=(a200-a68);
  a68=(a141*a148);
  a150=(a150*a118);
  a118=(a131*a150);
  a68=(a68-a118);
  a200=(a200+a68);
  a68=(a95*a200);
  a196=(a196+a68);
  a68=(a95*a200);
  a118=(a145*a198);
  a68=(a68+a118);
  a68=(a0+a68);
  a118=(a23*a68);
  a193=(a145*a139);
  a200=(a147*a200);
  a193=(a193+a200);
  a200=(a27*a193);
  a118=(a118-a200);
  a196=(a196+a118);
  a118=(a141*a196);
  a200=(a151*a150);
  a118=(a118-a200);
  a200=(a162*a54);
  a202=(a161*a198);
  a182=(a144*a150);
  a124=(a141*a124);
  a182=(a182+a124);
  a124=(a131*a54);
  a177=(a142*a148);
  a124=(a124+a177);
  a182=(a182+a124);
  a198=(a182+a198);
  a198=(a95*a198);
  a202=(a202-a198);
  a139=(a159*a139);
  a182=(a147*a182);
  a139=(a139-a182);
  a202=(a202-a139);
  a139=(a142*a202);
  a200=(a200+a139);
  a118=(a118-a200);
  a152=(a152+a118);
  a204=(a204*a54);
  a200=(a27*a150);
  a139=(a141*a200);
  a182=(a163*a150);
  a139=(a139+a182);
  a204=(a204-a139);
  a139=(a204/a128);
  a197=(a197*a204);
  a139=(a139+a197);
  a197=(a168*a139);
  a118=(a0-a118);
  a182=(a136*a148);
  a198=(a131*a119);
  a182=(a182+a198);
  a118=(a118-a182);
  a182=(a165*a118);
  a197=(a197+a182);
  a182=(a153*a139);
  a198=(a165*a204);
  a182=(a182+a198);
  a182=(a204+a182);
  a198=(a174*a182);
  a124=(a131*a119);
  a148=(a136*a148);
  a124=(a124+a148);
  a148=(a132*a124);
  a198=(a198+a148);
  a148=(a163*a54);
  a200=(a142*a200);
  a148=(a148-a200);
  a200=(a141*a54);
  a177=(a142*a150);
  a200=(a200-a177);
  a148=(a148-a200);
  a200=(a165*a148);
  a177=(a179*a139);
  a200=(a200-a177);
  a200=(a148+a200);
  a177=(a140*a200);
  a194=(a143*a119);
  a199=(a136*a61);
  a194=(a194-a199);
  a199=(a181*a194);
  a177=(a177+a199);
  a198=(a198+a177);
  a197=(a197+a198);
  a152=(a152-a197);
  a152=(a120*a152);
  a197=(a166*a154);
  a152=(a152-a197);
  a197=(a176*a66);
  a198=(a167*a119);
  a61=(a61+a119);
  a61=(a136*a61);
  a198=(a198-a61);
  a61=(a151*a54);
  a196=(a142*a196);
  a61=(a61+a196);
  a202=(a141*a202);
  a196=(a162*a150);
  a202=(a202-a196);
  a61=(a61+a202);
  a198=(a198+a61);
  a61=(a27*a54);
  a202=(a141*a61);
  a196=(a180*a150);
  a202=(a202-a196);
  a196=(a141*a54);
  a119=(a142*a150);
  a196=(a196-a119);
  a202=(a202-a196);
  a196=(a148/a128);
  a137=(a137*a204);
  a196=(a196-a137);
  a137=(a153*a196);
  a119=(a184*a204);
  a137=(a137-a119);
  a202=(a202+a137);
  a137=(a174*a202);
  a119=(a183*a124);
  a137=(a137+a119);
  a61=(a142*a61);
  a119=(a180*a54);
  a61=(a61+a119);
  a169=(a169*a150);
  a61=(a61-a169);
  a169=(a179*a196);
  a148=(a184*a148);
  a169=(a169+a148);
  a61=(a61-a169);
  a169=(a140*a61);
  a148=(a186*a194);
  a169=(a169+a148);
  a137=(a137+a169);
  a169=(a168*a196);
  a148=(a184*a118);
  a169=(a169-a148);
  a137=(a137+a169);
  a198=(a198-a137);
  a198=(a58*a198);
  a197=(a197+a198);
  a152=(a152-a197);
  a152=(a152/a187);
  a197=(a120*a182);
  a198=(a132*a154);
  a197=(a197-a198);
  a198=(a183*a66);
  a137=(a58*a202);
  a198=(a198+a137);
  a197=(a197-a198);
  a197=(a120*a197);
  a198=(a185*a154);
  a197=(a197-a198);
  a198=(a120*a200);
  a137=(a181*a154);
  a198=(a198-a137);
  a137=(a186*a66);
  a169=(a58*a61);
  a137=(a137+a169);
  a198=(a198-a137);
  a198=(a58*a198);
  a137=(a188*a66);
  a198=(a198+a137);
  a197=(a197-a198);
  a171=(a171*a197);
  a152=(a152+a171);
  a171=(a132*a66);
  a182=(a58*a182);
  a171=(a171+a182);
  a202=(a120*a202);
  a182=(a183*a154);
  a202=(a202-a182);
  a171=(a171+a202);
  a171=(a120*a171);
  a202=(a164*a154);
  a171=(a171-a202);
  a202=(a181*a66);
  a200=(a58*a200);
  a202=(a202+a200);
  a61=(a120*a61);
  a200=(a186*a154);
  a61=(a61-a200);
  a202=(a202+a61);
  a202=(a58*a202);
  a61=(a122*a66);
  a202=(a202+a61);
  a171=(a171-a202);
  a171=(a171/a187);
  a189=(a189*a197);
  a171=(a171-a189);
  a171=(a60*a171);
  a152=(a152+a171);
  a171=(a2*a152);
  a149=(a149+a171);
  a149=(a3*a149);
  a149=(a2*a149);
  a149=(-a149);
  if (res[2]!=0) res[2][6]=a149;
  a178=(a5*a178);
  a178=(a4*a178);
  a157=(a56*a157);
  a157=(a4*a157);
  a178=(a178+a157);
  a118=(a118/a128);
  a138=(a138*a204);
  a118=(a118+a138);
  a138=(a60*a66);
  a204=(a192*a154);
  a157=(a120*a152);
  a204=(a204+a157);
  a138=(a138-a204);
  a138=(a138-a124);
  a124=(a165*a138);
  a139=(a191*a139);
  a124=(a124-a139);
  a196=(a172*a196);
  a154=(a60*a154);
  a66=(a192*a66);
  a152=(a58*a152);
  a66=(a66-a152);
  a154=(a154+a66);
  a154=(a154+a194);
  a194=(a184*a154);
  a196=(a196-a194);
  a124=(a124-a196);
  a118=(a118+a124);
  a124=(a2*a118);
  a178=(a178-a124);
  a178=(a3*a178);
  a178=(a2*a178);
  if (res[2]!=0) res[2][7]=a178;
  a170=(a5*a170);
  a170=(a4*a170);
  a125=(a56*a125);
  a125=(a4*a125);
  a170=(a170+a125);
  a68=(a27*a68);
  a138=(a138+a118);
  a138=(a141*a138);
  a150=(a65*a150);
  a138=(a138-a150);
  a54=(a172*a54);
  a154=(a142*a154);
  a54=(a54-a154);
  a138=(a138+a54);
  a138=(a138-a193);
  a138=(a23*a138);
  a138=(a138-a118);
  a68=(a68-a138);
  a68=(a2*a68);
  a170=(a170+a68);
  a170=(a3*a170);
  a170=(a2*a170);
  if (res[2]!=0) res[2][8]=a170;
  if (res[3]!=0) res[3][0]=a1;
  if (res[3]!=0) res[3][1]=a1;
  if (res[3]!=0) res[3][2]=a1;
  a39=(a39/a52);
  a1=sin(a7);
  a170=(a34*a1);
  a68=cos(a7);
  a138=(a47*a68);
  a170=(a170+a138);
  a170=(a8*a170);
  a51=(a51*a1);
  a170=(a170+a51);
  a53=(a53*a68);
  a51=(a43*a1);
  a138=(a50*a68);
  a51=(a51+a138);
  a51=(a10*a51);
  a53=(a53-a51);
  a170=(a170+a53);
  a53=(a39*a170);
  a51=(a11*a68);
  a138=(a9*a51);
  a118=(a15*a51);
  a193=(a11*a1);
  a54=(a18*a193);
  a118=(a118-a54);
  a54=(a17*a118);
  a154=(a17*a118);
  a150=(a23*a154);
  a118=(a16*a118);
  a125=(a27*a118);
  a150=(a150-a125);
  a54=(a54+a150);
  a150=(a15*a54);
  a125=(a15*a193);
  a178=(a18*a51);
  a125=(a125+a178);
  a178=(a16*a125);
  a125=(a17*a125);
  a178=(a178-a125);
  a125=(a18*a178);
  a150=(a150-a125);
  a138=(a138+a150);
  a125=(a9*a51);
  a150=(a150+a125);
  a125=(a37*a150);
  a51=(a9*a51);
  a124=(a34*a51);
  a196=(a9*a193);
  a194=(a43*a196);
  a124=(a124-a194);
  a125=(a125-a124);
  a138=(a138+a125);
  a138=(a8*a138);
  a13=(a13*a1);
  a138=(a138-a13);
  a45=(a45*a68);
  a54=(a18*a54);
  a178=(a15*a178);
  a54=(a54+a178);
  a193=(a9*a193);
  a54=(a54-a193);
  a193=(a47*a51);
  a178=(a50*a196);
  a193=(a193-a178);
  a178=(a48*a150);
  a193=(a193+a178);
  a54=(a54-a193);
  a54=(a10*a54);
  a45=(a45+a54);
  a138=(a138-a45);
  a138=(a138/a52);
  a53=(a53-a138);
  a138=(a34*a68);
  a45=(a47*a1);
  a138=(a138-a45);
  a138=(a8*a138);
  a63=(a63*a1);
  a138=(a138-a63);
  a63=(a43*a68);
  a45=(a50*a1);
  a63=(a63-a45);
  a63=(a10*a63);
  a67=(a67*a68);
  a63=(a63+a67);
  a138=(a138-a63);
  a138=(a138/a52);
  a62=(a62/a52);
  a170=(a62*a170);
  a138=(a138+a170);
  a138=(a60*a138);
  a53=(a53-a138);
  a138=(a104/a116);
  a170=sin(a71);
  a63=(a100*a170);
  a67=cos(a71);
  a45=(a112*a67);
  a63=(a63+a45);
  a63=(a72*a63);
  a45=(a114*a170);
  a63=(a63+a45);
  a45=(a117*a67);
  a54=(a108*a170);
  a193=(a115*a67);
  a54=(a54+a193);
  a54=(a80*a54);
  a45=(a45-a54);
  a63=(a63+a45);
  a45=(a138*a63);
  a150=(a150/a36);
  a54=(a8*a53);
  a193=(a75*a1);
  a54=(a54-a193);
  a193=(a60*a68);
  a54=(a54+a193);
  a54=(a54-a51);
  a51=(a37*a54);
  a1=(a60*a1);
  a75=(a75*a68);
  a68=(a10*a53);
  a75=(a75+a68);
  a1=(a1+a75);
  a196=(a196-a1);
  a1=(a48*a196);
  a51=(a51-a1);
  a150=(a150-a51);
  a51=(a73*a150);
  a1=(a82*a51);
  a75=(a81*a67);
  a68=(a73*a53);
  a193=(a80*a68);
  a75=(a75+a193);
  a193=(a79*a75);
  a1=(a1+a193);
  a154=(a27*a154);
  a54=(a54-a150);
  a54=(a15*a54);
  a196=(a18*a196);
  a54=(a54+a196);
  a54=(a54-a118);
  a54=(a23*a54);
  a54=(a54+a150);
  a154=(a154-a54);
  a54=(a73*a154);
  a118=(a54+a51);
  a196=(a91*a118);
  a68=(a72*a68);
  a193=(a81*a170);
  a68=(a68-a193);
  a193=(a68-a51);
  a178=(a88*a193);
  a13=(a85*a75);
  a178=(a178+a13);
  a13=(a28*a178);
  a196=(a196+a13);
  a13=(a28*a178);
  a125=(a91*a118);
  a13=(a13+a125);
  a125=(a23*a13);
  a124=(a91*a54);
  a178=(a87*a178);
  a124=(a124+a178);
  a178=(a27*a124);
  a125=(a125-a178);
  a196=(a196+a125);
  a125=(a85*a196);
  a178=(a97*a118);
  a193=(a85*a193);
  a194=(a88*a75);
  a193=(a193-a194);
  a118=(a193-a118);
  a118=(a28*a118);
  a178=(a178+a118);
  a54=(a96*a54);
  a193=(a87*a193);
  a54=(a54+a193);
  a178=(a178-a54);
  a54=(a88*a178);
  a125=(a125-a54);
  a1=(a1+a125);
  a54=(a79*a75);
  a193=(a82*a51);
  a54=(a54+a193);
  a125=(a125+a54);
  a54=(a103*a125);
  a193=(a82*a51);
  a75=(a79*a75);
  a193=(a193+a75);
  a75=(a100*a193);
  a118=(a89*a51);
  a194=(a79*a68);
  a118=(a118+a194);
  a194=(a108*a118);
  a75=(a75+a194);
  a54=(a54-a75);
  a1=(a1+a54);
  a1=(a72*a1);
  a54=(a83*a170);
  a1=(a1-a54);
  a54=(a110*a67);
  a75=(a106*a51);
  a68=(a68-a51);
  a68=(a79*a68);
  a75=(a75+a68);
  a196=(a88*a196);
  a178=(a85*a178);
  a196=(a196+a178);
  a75=(a75+a196);
  a196=(a112*a193);
  a178=(a115*a118);
  a196=(a196+a178);
  a178=(a113*a125);
  a196=(a196+a178);
  a75=(a75-a196);
  a75=(a80*a75);
  a54=(a54+a75);
  a1=(a1-a54);
  a1=(a1/a116);
  a45=(a45-a1);
  a1=(a100*a67);
  a54=(a112*a170);
  a1=(a1-a54);
  a1=(a72*a1);
  a54=(a123*a170);
  a1=(a1-a54);
  a54=(a108*a67);
  a75=(a115*a170);
  a54=(a54-a75);
  a54=(a80*a54);
  a75=(a69*a67);
  a54=(a54+a75);
  a1=(a1-a54);
  a1=(a1/a116);
  a54=(a57/a116);
  a63=(a54*a63);
  a1=(a1+a63);
  a1=(a60*a1);
  a45=(a45-a1);
  a1=(a4*a45);
  a53=(a53+a1);
  a125=(a125/a102);
  a1=(a72*a45);
  a63=(a129*a170);
  a1=(a1-a63);
  a63=(a60*a67);
  a1=(a1+a63);
  a1=(a1-a193);
  a193=(a103*a1);
  a170=(a60*a170);
  a67=(a129*a67);
  a63=(a80*a45);
  a67=(a67+a63);
  a170=(a170+a67);
  a170=(a170+a118);
  a118=(a113*a170);
  a193=(a193+a118);
  a125=(a125-a193);
  a193=(a59*a125);
  a118=(a131*a193);
  a67=cos(a77);
  a63=(a5*a150);
  a63=(a55*a63);
  a63=(a0+a63);
  a75=(a67*a63);
  a196=(a130*a75);
  a45=(a59*a45);
  a178=(a58*a45);
  a196=(a196+a178);
  a178=(a136*a196);
  a118=(a118+a178);
  a13=(a27*a13);
  a1=(a1-a125);
  a1=(a85*a1);
  a170=(a88*a170);
  a1=(a1-a170);
  a1=(a1-a124);
  a1=(a23*a1);
  a1=(a1+a125);
  a13=(a13-a1);
  a1=(a59*a13);
  a124=(a1+a193);
  a170=(a145*a124);
  a178=cos(a25);
  a68=(a5*a154);
  a68=(a55*a68);
  a51=(a178*a68);
  a194=(a144*a51);
  a45=(a120*a45);
  a66=sin(a77);
  a63=(a66*a63);
  a152=(a130*a63);
  a45=(a45-a152);
  a152=(a45-a193);
  a139=(a142*a152);
  a194=(a194+a139);
  a139=(a141*a196);
  a204=sin(a25);
  a68=(a204*a68);
  a157=(a131*a68);
  a139=(a139-a157);
  a194=(a194+a139);
  a139=(a95*a194);
  a170=(a170+a139);
  a139=(a95*a194);
  a157=(a145*a124);
  a139=(a139+a157);
  a157=(a23*a139);
  a149=(a145*a1);
  a194=(a147*a194);
  a149=(a149+a194);
  a194=(a27*a149);
  a157=(a157-a194);
  a170=(a170+a157);
  a157=(a141*a170);
  a194=(a151*a68);
  a157=(a157-a194);
  a194=(a162*a51);
  a171=(a161*a124);
  a152=(a141*a152);
  a189=(a144*a68);
  a152=(a152-a189);
  a189=(a131*a51);
  a197=(a142*a196);
  a189=(a189+a197);
  a152=(a152-a189);
  a124=(a152-a124);
  a124=(a95*a124);
  a171=(a171+a124);
  a1=(a159*a1);
  a152=(a147*a152);
  a1=(a1+a152);
  a171=(a171-a1);
  a1=(a142*a171);
  a194=(a194+a1);
  a157=(a157-a194);
  a118=(a118+a157);
  a194=(a136*a196);
  a1=(a131*a193);
  a194=(a194+a1);
  a157=(a157+a194);
  a194=(a165*a157);
  a1=(a142+a142);
  a152=(a1*a51);
  a124=(a27*a68);
  a189=(a141*a124);
  a197=(a163*a68);
  a189=(a189+a197);
  a152=(a152-a189);
  a189=(a152/a128);
  a197=(a165/a128);
  a202=(a197*a152);
  a189=(a189+a202);
  a202=(a168*a189);
  a194=(a194-a202);
  a202=(a153*a189);
  a61=(a165*a152);
  a202=(a202+a61);
  a202=(a152+a202);
  a61=(a174*a202);
  a200=(a131*a193);
  a196=(a136*a196);
  a200=(a200+a196);
  a196=(a132*a200);
  a61=(a61+a196);
  a196=(a163*a51);
  a124=(a142*a124);
  a196=(a196-a124);
  a124=(a141*a51);
  a182=(a142*a68);
  a124=(a124-a182);
  a196=(a196-a124);
  a124=(a165*a196);
  a182=(a179*a189);
  a124=(a124-a182);
  a124=(a196+a124);
  a182=(a140*a124);
  a198=(a143*a193);
  a137=(a136*a45);
  a198=(a198+a137);
  a137=(a181*a198);
  a182=(a182+a137);
  a61=(a61+a182);
  a194=(a194-a61);
  a118=(a118+a194);
  a118=(a120*a118);
  a194=(a166*a63);
  a118=(a118-a194);
  a194=(a176*a75);
  a61=(a167*a193);
  a45=(a45-a193);
  a45=(a136*a45);
  a61=(a61+a45);
  a45=(a151*a51);
  a170=(a142*a170);
  a45=(a45+a170);
  a171=(a141*a171);
  a170=(a162*a68);
  a171=(a171-a170);
  a45=(a45+a171);
  a61=(a61+a45);
  a45=(a27*a51);
  a171=(a141*a45);
  a170=(a180*a68);
  a171=(a171-a170);
  a170=(a141*a51);
  a193=(a142*a68);
  a170=(a170-a193);
  a171=(a171-a170);
  a170=(a196/a128);
  a193=(a184/a128);
  a182=(a193*a152);
  a170=(a170-a182);
  a182=(a153*a170);
  a137=(a184*a152);
  a182=(a182-a137);
  a171=(a171+a182);
  a182=(a174*a171);
  a137=(a183*a200);
  a182=(a182+a137);
  a45=(a142*a45);
  a137=(a180*a51);
  a45=(a45+a137);
  a137=(a141+a141);
  a169=(a137*a68);
  a45=(a45-a169);
  a169=(a179*a170);
  a196=(a184*a196);
  a169=(a169+a196);
  a45=(a45-a169);
  a169=(a140*a45);
  a196=(a186*a198);
  a169=(a169+a196);
  a182=(a182+a169);
  a169=(a168*a170);
  a196=(a184*a157);
  a169=(a169+a196);
  a182=(a182+a169);
  a61=(a61-a182);
  a61=(a58*a61);
  a194=(a194+a61);
  a118=(a118-a194);
  a118=(a118/a187);
  a194=(a190/a187);
  a61=(a120*a202);
  a182=(a132*a63);
  a61=(a61-a182);
  a182=(a183*a75);
  a169=(a58*a171);
  a182=(a182+a169);
  a61=(a61-a182);
  a61=(a120*a61);
  a182=(a185*a63);
  a61=(a61-a182);
  a182=(a120*a124);
  a169=(a181*a63);
  a182=(a182-a169);
  a169=(a186*a75);
  a196=(a58*a45);
  a169=(a169+a196);
  a182=(a182-a169);
  a182=(a58*a182);
  a169=(a188*a75);
  a182=(a182+a169);
  a61=(a61-a182);
  a182=(a194*a61);
  a118=(a118+a182);
  a182=(a132*a75);
  a202=(a58*a202);
  a182=(a182+a202);
  a171=(a120*a171);
  a202=(a183*a63);
  a171=(a171-a202);
  a182=(a182+a171);
  a182=(a120*a182);
  a171=(a164*a63);
  a182=(a182-a171);
  a171=(a181*a75);
  a124=(a58*a124);
  a171=(a171+a124);
  a45=(a120*a45);
  a124=(a186*a63);
  a45=(a45-a124);
  a171=(a171+a45);
  a171=(a58*a171);
  a45=(a122*a75);
  a171=(a171+a45);
  a182=(a182-a171);
  a182=(a182/a187);
  a171=(a175/a187);
  a61=(a171*a61);
  a182=(a182-a61);
  a182=(a60*a182);
  a118=(a118+a182);
  a182=(a4*a118);
  a53=(a53-a182);
  a134=(a56*a134);
  a134=(a9+a134);
  a134=(a2*a134);
  a7=(a7+a134);
  a134=cos(a7);
  a182=sin(a7);
  a61=(a2*a192);
  a11=(a11+a61);
  a61=(a182*a11);
  a157=(a157/a128);
  a45=(a127/a128);
  a152=(a45*a152);
  a157=(a157-a152);
  a152=(a60*a75);
  a124=(a192*a63);
  a202=(a120*a118);
  a124=(a124+a202);
  a152=(a152-a124);
  a152=(a152-a200);
  a200=(a165*a152);
  a189=(a191*a189);
  a200=(a200-a189);
  a170=(a172*a170);
  a63=(a60*a63);
  a75=(a192*a75);
  a189=(a58*a118);
  a75=(a75-a189);
  a63=(a63+a75);
  a63=(a63+a198);
  a198=(a184*a63);
  a170=(a170-a198);
  a200=(a200-a170);
  a157=(a157-a200);
  a200=(a2*a157);
  a170=(a61*a200);
  a198=(a2*a126);
  a198=(a9+a198);
  a75=cos(a7);
  a189=(a56*a125);
  a189=(a2*a189);
  a189=(a0+a189);
  a124=(a75*a189);
  a202=(a11*a124);
  a118=(a2*a118);
  a169=(a182*a118);
  a202=(a202-a169);
  a169=(a198*a202);
  a170=(a170+a169);
  a93=(a56*a93);
  a93=(a16+a93);
  a93=(a2*a93);
  a93=(a14+a93);
  a169=cos(a93);
  a196=sin(a93);
  a148=(a134*a11);
  a119=(a148-a198);
  a177=(a196*a119);
  a199=(a169*a61);
  a177=(a177+a199);
  a139=(a27*a139);
  a152=(a152-a157);
  a152=(a141*a152);
  a68=(a65*a68);
  a152=(a152-a68);
  a51=(a172*a51);
  a63=(a142*a63);
  a51=(a51-a63);
  a152=(a152+a51);
  a152=(a152-a149);
  a152=(a23*a152);
  a152=(a152+a157);
  a139=(a139-a152);
  a152=(a2*a139);
  a149=(a152+a200);
  a51=(a177*a149);
  a158=(a27*a158);
  a63=(a141*a65);
  a68=(a142*a172);
  a63=(a63+a68);
  a63=(a63-a160);
  a63=(a23*a63);
  a63=(a63+a126);
  a158=(a158-a63);
  a158=(a2*a158);
  a158=(a16+a158);
  a63=(a158+a198);
  a126=cos(a93);
  a160=(a56*a13);
  a160=(a2*a160);
  a68=(a126*a160);
  a199=(a119*a68);
  a64=sin(a7);
  a189=(a64*a189);
  a201=(a11*a189);
  a118=(a134*a118);
  a201=(a201+a118);
  a118=(a201+a200);
  a173=(a196*a118);
  a199=(a199-a173);
  a173=(a169*a202);
  a156=sin(a93);
  a160=(a156*a160);
  a195=(a61*a160);
  a173=(a173-a195);
  a199=(a199+a173);
  a173=(a63*a199);
  a51=(a51+a173);
  a173=(a63*a199);
  a195=(a177*a149);
  a173=(a173+a195);
  a195=(a23*a173);
  a203=(a177*a152);
  a199=(a158*a199);
  a203=(a203+a199);
  a199=(a27*a203);
  a195=(a195-a199);
  a51=(a51+a195);
  a195=(a169*a51);
  a199=(a63*a177);
  a155=(a177*a63);
  a155=(a24+a155);
  a155=(a23*a155);
  a205=(a158*a177);
  a205=(a27*a205);
  a155=(a155-a205);
  a199=(a199+a155);
  a155=(a199*a160);
  a195=(a195-a155);
  a155=(a169*a119);
  a205=(a196*a61);
  a155=(a155-a205);
  a205=(a155-a63);
  a206=(a63*a205);
  a207=(a158*a155);
  a206=(a206-a207);
  a207=(a206*a68);
  a208=(a205*a149);
  a209=(a119*a160);
  a118=(a169*a118);
  a209=(a209+a118);
  a118=(a61*a68);
  a210=(a196*a202);
  a118=(a118+a210);
  a209=(a209+a118);
  a149=(a209+a149);
  a149=(a63*a149);
  a208=(a208-a149);
  a152=(a155*a152);
  a209=(a158*a209);
  a152=(a152-a209);
  a208=(a208-a152);
  a152=(a196*a208);
  a207=(a207+a152);
  a195=(a195-a207);
  a170=(a170+a195);
  a207=(a27*a169);
  a152=(a207*a169);
  a209=casadi_sq(a196);
  a152=(a152+a209);
  a209=(a32-a152);
  a149=(a4+a152);
  a118=(a209/a149);
  a210=(a198*a202);
  a211=(a61*a200);
  a210=(a210+a211);
  a195=(a195+a210);
  a210=(a118*a195);
  a211=(a169*a199);
  a212=(a196*a206);
  a211=(a211-a212);
  a24=(a24-a211);
  a212=(a61*a198);
  a24=(a24-a212);
  a38=(a38-a24);
  a24=(a196+a196);
  a212=(a24*a68);
  a213=(a27*a160);
  a214=(a169*a213);
  a215=(a207*a160);
  a214=(a214+a215);
  a212=(a212-a214);
  a214=(a212/a149);
  a215=(a118/a149);
  a216=(a215*a212);
  a214=(a214+a216);
  a216=(a38*a214);
  a210=(a210-a216);
  a216=(a198*a61);
  a217=(a209*a214);
  a218=(a118*a212);
  a217=(a217+a218);
  a217=(a212+a217);
  a218=(a216*a217);
  a152=(a0+a152);
  a219=(a118*a209);
  a152=(a152-a219);
  a219=(a61*a200);
  a202=(a198*a202);
  a219=(a219+a202);
  a202=(a152*a219);
  a218=(a218+a202);
  a202=(a198*a148);
  a220=(a207*a68);
  a213=(a196*a213);
  a220=(a220-a213);
  a213=(a169*a68);
  a221=(a196*a160);
  a213=(a213-a221);
  a220=(a220-a213);
  a213=(a118*a220);
  a221=(a207*a196);
  a222=(a196*a169);
  a221=(a221-a222);
  a222=(a221*a214);
  a213=(a213-a222);
  a213=(a220+a213);
  a222=(a202*a213);
  a223=(a118*a221);
  a223=(a221+a223);
  a224=(a148*a200);
  a225=(a198*a201);
  a224=(a224-a225);
  a225=(a223*a224);
  a222=(a222+a225);
  a218=(a218+a222);
  a210=(a210-a218);
  a170=(a170+a210);
  a170=(a134*a170);
  a210=(a198*a61);
  a210=(a210+a211);
  a211=(a118*a38);
  a218=(a152*a216);
  a222=(a223*a202);
  a218=(a218+a222);
  a211=(a211-a218);
  a210=(a210+a211);
  a211=(a210*a189);
  a170=(a170-a211);
  a211=(a148-a198);
  a218=(a198*a211);
  a222=(a196*a199);
  a225=(a169*a206);
  a222=(a222+a225);
  a218=(a218+a222);
  a222=(a27*a196);
  a225=(a222*a169);
  a226=(a169*a196);
  a225=(a225-a226);
  a226=(a221/a149);
  a227=(a226*a209);
  a225=(a225+a227);
  a227=(a225*a216);
  a228=(a222*a196);
  a229=casadi_sq(a169);
  a228=(a228+a229);
  a228=(a0+a228);
  a229=(a226*a221);
  a228=(a228-a229);
  a229=(a228*a202);
  a227=(a227+a229);
  a229=(a226*a38);
  a227=(a227+a229);
  a218=(a218-a227);
  a227=(a218*a124);
  a229=(a211*a200);
  a201=(a201+a200);
  a201=(a198*a201);
  a229=(a229-a201);
  a201=(a199*a68);
  a51=(a196*a51);
  a201=(a201+a51);
  a208=(a169*a208);
  a51=(a206*a160);
  a208=(a208-a51);
  a201=(a201+a208);
  a229=(a229+a201);
  a201=(a27*a68);
  a208=(a169*a201);
  a51=(a222*a160);
  a208=(a208-a51);
  a51=(a169*a68);
  a200=(a196*a160);
  a51=(a51-a200);
  a208=(a208-a51);
  a51=(a220/a149);
  a200=(a226/a149);
  a230=(a200*a212);
  a51=(a51-a230);
  a230=(a209*a51);
  a231=(a226*a212);
  a230=(a230-a231);
  a208=(a208+a230);
  a230=(a216*a208);
  a231=(a225*a219);
  a230=(a230+a231);
  a201=(a196*a201);
  a231=(a222*a68);
  a201=(a201+a231);
  a231=(a169+a169);
  a232=(a231*a160);
  a201=(a201-a232);
  a232=(a221*a51);
  a220=(a226*a220);
  a232=(a232+a220);
  a201=(a201-a232);
  a232=(a202*a201);
  a220=(a228*a224);
  a232=(a232+a220);
  a230=(a230+a232);
  a232=(a38*a51);
  a220=(a226*a195);
  a232=(a232+a220);
  a230=(a230+a232);
  a229=(a229-a230);
  a229=(a182*a229);
  a227=(a227+a229);
  a170=(a170-a227);
  a227=(a134*a152);
  a229=(a182*a225);
  a227=(a227-a229);
  a229=(a227*a134);
  a230=(a134*a223);
  a232=(a182*a228);
  a230=(a230-a232);
  a232=(a230*a182);
  a229=(a229-a232);
  a49=(a49+a229);
  a170=(a170/a49);
  a229=(a134*a210);
  a232=(a182*a218);
  a229=(a229-a232);
  a6=(a6-a229);
  a6=(a6/a49);
  a229=(a6/a49);
  a232=(a134*a217);
  a220=(a152*a189);
  a232=(a232-a220);
  a220=(a225*a124);
  a233=(a182*a208);
  a220=(a220+a233);
  a232=(a232-a220);
  a232=(a134*a232);
  a220=(a227*a189);
  a232=(a232-a220);
  a220=(a134*a213);
  a233=(a223*a189);
  a220=(a220-a233);
  a233=(a228*a124);
  a234=(a182*a201);
  a233=(a233+a234);
  a220=(a220-a233);
  a220=(a182*a220);
  a233=(a230*a124);
  a220=(a220+a233);
  a232=(a232-a220);
  a220=(a229*a232);
  a170=(a170+a220);
  a220=(a152*a124);
  a217=(a182*a217);
  a220=(a220+a217);
  a208=(a134*a208);
  a217=(a225*a189);
  a208=(a208-a217);
  a220=(a220+a208);
  a220=(a134*a220);
  a208=(a182*a152);
  a217=(a134*a225);
  a208=(a208+a217);
  a217=(a208*a189);
  a220=(a220-a217);
  a217=(a223*a124);
  a213=(a182*a213);
  a217=(a217+a213);
  a201=(a134*a201);
  a213=(a228*a189);
  a201=(a201-a213);
  a217=(a217+a201);
  a217=(a182*a217);
  a201=(a182*a223);
  a213=(a134*a228);
  a201=(a201+a213);
  a213=(a201*a124);
  a217=(a217+a213);
  a220=(a220-a217);
  a220=(a220/a49);
  a217=(a208*a134);
  a213=(a201*a182);
  a217=(a217-a213);
  a217=(a217/a49);
  a213=(a217/a49);
  a232=(a213*a232);
  a220=(a220-a232);
  a220=(a60*a220);
  a170=(a170+a220);
  a53=(a53-a170);
  a53=(a3*a53);
  a53=(a2*a53);
  if (res[3]!=0) res[3][3]=a53;
  a125=(a4*a125);
  a150=(a150+a125);
  a157=(a4*a157);
  a150=(a150+a157);
  a195=(a195/a149);
  a157=(a38/a149);
  a125=(a157/a149);
  a212=(a125*a212);
  a195=(a195-a212);
  a212=(a60*a124);
  a53=(a60*a217);
  a53=(a6-a53);
  a220=(a53*a189);
  a232=(a134*a170);
  a220=(a220+a232);
  a212=(a212-a220);
  a212=(a212-a219);
  a219=(a118*a212);
  a220=(a134*a53);
  a232=(a60*a182);
  a220=(a220+a232);
  a220=(a220-a216);
  a214=(a220*a214);
  a219=(a219-a214);
  a214=(a60*a134);
  a232=(a182*a53);
  a214=(a214-a232);
  a214=(a214-a202);
  a51=(a214*a51);
  a189=(a60*a189);
  a124=(a53*a124);
  a170=(a182*a170);
  a124=(a124-a170);
  a189=(a189+a124);
  a189=(a189+a224);
  a224=(a226*a189);
  a51=(a51-a224);
  a219=(a219-a51);
  a195=(a195-a219);
  a150=(a150+a195);
  a150=(a3*a150);
  a150=(a2*a150);
  if (res[3]!=0) res[3][4]=a150;
  a13=(a4*a13);
  a154=(a154+a13);
  a139=(a4*a139);
  a154=(a154+a139);
  a173=(a27*a173);
  a212=(a212-a195);
  a212=(a169*a212);
  a139=(a118*a220);
  a13=(a226*a214);
  a139=(a139-a13);
  a139=(a157-a139);
  a139=(a220-a139);
  a160=(a139*a160);
  a212=(a212-a160);
  a68=(a214*a68);
  a189=(a196*a189);
  a68=(a68-a189);
  a212=(a212+a68);
  a212=(a212-a203);
  a212=(a23*a212);
  a212=(a212+a195);
  a173=(a173-a212);
  a154=(a154+a173);
  a154=(a3*a154);
  a154=(a2*a154);
  if (res[3]!=0) res[3][5]=a154;
  a154=cos(a14);
  a173=(a20*a154);
  a14=sin(a14);
  a212=(a12*a14);
  a173=(a173-a212);
  a212=(a17*a173);
  a195=(a17*a173);
  a203=(a23*a195);
  a173=(a16*a173);
  a68=(a27*a173);
  a203=(a203-a68);
  a212=(a212+a203);
  a203=(a15*a212);
  a68=(a22*a14);
  a203=(a203-a68);
  a68=(a31*a154);
  a20=(a20*a14);
  a189=(a12*a154);
  a20=(a20+a189);
  a189=(a16*a20);
  a20=(a17*a20);
  a189=(a189-a20);
  a20=(a18*a189);
  a68=(a68+a20);
  a203=(a203-a68);
  a68=(a37*a203);
  a20=(a18+a18);
  a20=(a20*a154);
  a160=(a27*a14);
  a13=(a15*a160);
  a150=(a33*a14);
  a13=(a13+a150);
  a20=(a20-a13);
  a13=(a20/a36);
  a150=(a37/a36);
  a150=(a150*a20);
  a13=(a13+a150);
  a150=(a26*a13);
  a68=(a68-a150);
  a150=(a35*a13);
  a219=(a37*a20);
  a150=(a150+a219);
  a150=(a20+a150);
  a219=(a40*a150);
  a33=(a33*a154);
  a160=(a18*a160);
  a33=(a33-a160);
  a160=casadi_sq(a15);
  a51=casadi_sq(a18);
  a160=(a160-a51);
  a33=(a33-a160);
  a160=(a37*a33);
  a51=(a42*a13);
  a160=(a160-a51);
  a160=(a33+a160);
  a51=(a44*a160);
  a219=(a219+a51);
  a68=(a68-a219);
  a68=(a203+a68);
  a68=(a8*a68);
  a22=(a22*a154);
  a212=(a18*a212);
  a22=(a22+a212);
  a189=(a15*a189);
  a31=(a31*a14);
  a189=(a189-a31);
  a22=(a22+a189);
  a189=(a27*a154);
  a31=(a15*a189);
  a212=(a46*a14);
  a31=(a31-a212);
  a212=casadi_sq(a15);
  a219=casadi_sq(a18);
  a212=(a212-a219);
  a31=(a31-a212);
  a212=(a33/a36);
  a219=(a48/a36);
  a219=(a219*a20);
  a212=(a212-a219);
  a35=(a35*a212);
  a219=(a48*a20);
  a35=(a35-a219);
  a31=(a31+a35);
  a40=(a40*a31);
  a189=(a18*a189);
  a46=(a46*a154);
  a189=(a189+a46);
  a46=(a15+a15);
  a46=(a46*a14);
  a189=(a189-a46);
  a42=(a42*a212);
  a33=(a48*a33);
  a42=(a42+a33);
  a189=(a189-a42);
  a44=(a44*a189);
  a40=(a40+a44);
  a26=(a26*a212);
  a44=(a48*a203);
  a26=(a26+a44);
  a40=(a40+a26);
  a22=(a22-a40);
  a22=(a10*a22);
  a68=(a68-a22);
  a68=(a68/a52);
  a22=(a8*a150);
  a40=(a10*a31);
  a22=(a22-a40);
  a22=(a8*a22);
  a40=(a8*a160);
  a26=(a10*a189);
  a40=(a40-a26);
  a40=(a10*a40);
  a22=(a22-a40);
  a39=(a39*a22);
  a68=(a68+a39);
  a150=(a10*a150);
  a31=(a8*a31);
  a150=(a150+a31);
  a150=(a8*a150);
  a160=(a10*a160);
  a189=(a8*a189);
  a160=(a160+a189);
  a160=(a10*a160);
  a150=(a150-a160);
  a150=(a150/a52);
  a62=(a62*a22);
  a150=(a150-a62);
  a150=(a60*a150);
  a68=(a68+a150);
  a203=(a203/a36);
  a74=(a74/a36);
  a74=(a74*a20);
  a203=(a203-a74);
  a76=(a76*a13);
  a13=(a8*a68);
  a74=(a37*a13);
  a76=(a76+a74);
  a212=(a78*a212);
  a74=(a10*a68);
  a20=(a48*a74);
  a212=(a212+a20);
  a76=(a76+a212);
  a203=(a203+a76);
  a76=(a73*a203);
  a212=(a82*a76);
  a20=(a73*a68);
  a150=(a80*a20);
  a62=(a79*a150);
  a212=(a212-a62);
  a195=(a27*a195);
  a78=(a78*a154);
  a74=(a18*a74);
  a78=(a78+a74);
  a86=(a86*a14);
  a13=(a13+a203);
  a13=(a15*a13);
  a86=(a86+a13);
  a78=(a78-a86);
  a78=(a78-a173);
  a78=(a23*a78);
  a78=(a78+a203);
  a195=(a195-a78);
  a78=(a73*a195);
  a173=(a78+a76);
  a86=(a91*a173);
  a13=cos(a84);
  a14=(a90*a13);
  a20=(a72*a20);
  a74=(a20+a76);
  a154=(a88*a74);
  a14=(a14-a154);
  a154=sin(a84);
  a62=(a82*a154);
  a22=(a85*a150);
  a62=(a62+a22);
  a14=(a14-a62);
  a62=(a28*a14);
  a86=(a86+a62);
  a62=(a28*a14);
  a22=(a91*a173);
  a62=(a62+a22);
  a22=(a23*a62);
  a160=(a91*a78);
  a14=(a87*a14);
  a160=(a160+a14);
  a14=(a27*a160);
  a22=(a22-a14);
  a86=(a86+a22);
  a22=(a85*a86);
  a14=(a92*a154);
  a22=(a22-a14);
  a14=(a98*a13);
  a189=(a97*a173);
  a31=(a90*a154);
  a74=(a85*a74);
  a31=(a31+a74);
  a74=(a82*a13);
  a39=(a88*a150);
  a74=(a74-a39);
  a31=(a31+a74);
  a173=(a31+a173);
  a173=(a28*a173);
  a189=(a189-a173);
  a78=(a96*a78);
  a31=(a87*a31);
  a78=(a78-a31);
  a189=(a189-a78);
  a78=(a88*a189);
  a14=(a14+a78);
  a22=(a22-a14);
  a212=(a212+a22);
  a14=(a82*a76);
  a78=(a79*a150);
  a14=(a14-a78);
  a22=(a22+a14);
  a14=(a103*a22);
  a78=(a88+a88);
  a78=(a78*a13);
  a31=(a27*a154);
  a173=(a85*a31);
  a74=(a99*a154);
  a173=(a173+a74);
  a78=(a78-a173);
  a173=(a78/a102);
  a74=(a103/a102);
  a74=(a74*a78);
  a173=(a173+a74);
  a74=(a94*a173);
  a14=(a14-a74);
  a74=(a101*a173);
  a39=(a103*a78);
  a74=(a74+a39);
  a74=(a78+a74);
  a39=(a105*a74);
  a40=(a82*a76);
  a150=(a79*a150);
  a40=(a40-a150);
  a150=(a100*a40);
  a39=(a39+a150);
  a150=(a99*a13);
  a31=(a88*a31);
  a150=(a150-a31);
  a31=casadi_sq(a85);
  a26=casadi_sq(a88);
  a31=(a31-a26);
  a150=(a150-a31);
  a31=(a103*a150);
  a26=(a107*a173);
  a31=(a31-a26);
  a31=(a150+a31);
  a26=(a109*a31);
  a44=(a89*a76);
  a42=(a79*a20);
  a44=(a44-a42);
  a42=(a108*a44);
  a26=(a26+a42);
  a39=(a39+a26);
  a14=(a14-a39);
  a212=(a212+a14);
  a212=(a72*a212);
  a14=(a106*a76);
  a20=(a20+a76);
  a20=(a79*a20);
  a14=(a14-a20);
  a20=(a92*a13);
  a86=(a88*a86);
  a20=(a20+a86);
  a189=(a85*a189);
  a86=(a98*a154);
  a189=(a189-a86);
  a20=(a20+a189);
  a14=(a14+a20);
  a20=(a27*a13);
  a189=(a85*a20);
  a86=(a111*a154);
  a189=(a189-a86);
  a86=casadi_sq(a85);
  a76=casadi_sq(a88);
  a86=(a86-a76);
  a189=(a189-a86);
  a86=(a150/a102);
  a76=(a113/a102);
  a76=(a76*a78);
  a86=(a86-a76);
  a76=(a101*a86);
  a39=(a113*a78);
  a76=(a76-a39);
  a189=(a189+a76);
  a76=(a105*a189);
  a39=(a112*a40);
  a76=(a76+a39);
  a20=(a88*a20);
  a39=(a111*a13);
  a20=(a20+a39);
  a39=(a85+a85);
  a39=(a39*a154);
  a20=(a20-a39);
  a39=(a107*a86);
  a150=(a113*a150);
  a39=(a39+a150);
  a20=(a20-a39);
  a39=(a109*a20);
  a150=(a115*a44);
  a39=(a39+a150);
  a76=(a76+a39);
  a39=(a94*a86);
  a150=(a113*a22);
  a39=(a39+a150);
  a76=(a76+a39);
  a14=(a14-a76);
  a14=(a80*a14);
  a212=(a212-a14);
  a212=(a212/a116);
  a14=(a72*a74);
  a76=(a80*a189);
  a14=(a14-a76);
  a14=(a72*a14);
  a76=(a72*a31);
  a39=(a80*a20);
  a76=(a76-a39);
  a76=(a80*a76);
  a14=(a14-a76);
  a138=(a138*a14);
  a212=(a212+a138);
  a74=(a80*a74);
  a189=(a72*a189);
  a74=(a74+a189);
  a74=(a72*a74);
  a31=(a80*a31);
  a20=(a72*a20);
  a31=(a31+a20);
  a31=(a80*a31);
  a74=(a74-a31);
  a74=(a74/a116);
  a54=(a54*a14);
  a74=(a74-a54);
  a74=(a60*a74);
  a212=(a212+a74);
  a74=(a4*a212);
  a68=(a68+a74);
  a22=(a22/a102);
  a74=(a121/a102);
  a74=(a74*a78);
  a22=(a22-a74);
  a173=(a133*a173);
  a74=(a72*a212);
  a74=(a74+a40);
  a40=(a103*a74);
  a173=(a173+a40);
  a86=(a135*a86);
  a40=(a80*a212);
  a40=(a40-a44);
  a44=(a113*a40);
  a86=(a86+a44);
  a173=(a173+a86);
  a22=(a22+a173);
  a173=(a59*a22);
  a86=(a131*a173);
  a44=(a5*a203);
  a44=(a55*a44);
  a67=(a67*a44);
  a78=(a130*a67);
  a212=(a59*a212);
  a54=(a58*a212);
  a78=(a78-a54);
  a54=(a136*a78);
  a86=(a86+a54);
  a62=(a27*a62);
  a13=(a135*a13);
  a40=(a88*a40);
  a13=(a13+a40);
  a154=(a146*a154);
  a74=(a74+a22);
  a74=(a85*a74);
  a154=(a154+a74);
  a13=(a13-a154);
  a13=(a13-a160);
  a13=(a23*a13);
  a13=(a13+a22);
  a62=(a62-a13);
  a13=(a59*a62);
  a160=(a13+a173);
  a154=(a145*a160);
  a74=(a5*a195);
  a74=(a55*a74);
  a74=(a0+a74);
  a178=(a178*a74);
  a40=(a144*a178);
  a66=(a66*a44);
  a44=(a130*a66);
  a212=(a120*a212);
  a44=(a44+a212);
  a212=(a44+a173);
  a54=(a142*a212);
  a40=(a40-a54);
  a54=(a141*a78);
  a204=(a204*a74);
  a74=(a131*a204);
  a54=(a54-a74);
  a40=(a40+a54);
  a54=(a95*a40);
  a154=(a154+a54);
  a54=(a95*a40);
  a74=(a145*a160);
  a54=(a54+a74);
  a74=(a23*a54);
  a14=(a145*a13);
  a40=(a147*a40);
  a14=(a14+a40);
  a40=(a27*a14);
  a74=(a74-a40);
  a154=(a154+a74);
  a74=(a141*a154);
  a40=(a151*a204);
  a74=(a74-a40);
  a40=(a162*a178);
  a31=(a161*a160);
  a20=(a144*a204);
  a212=(a141*a212);
  a20=(a20+a212);
  a212=(a131*a178);
  a189=(a142*a78);
  a212=(a212+a189);
  a20=(a20+a212);
  a160=(a20+a160);
  a160=(a95*a160);
  a31=(a31-a160);
  a13=(a159*a13);
  a20=(a147*a20);
  a13=(a13-a20);
  a31=(a31-a13);
  a13=(a142*a31);
  a40=(a40+a13);
  a74=(a74-a40);
  a86=(a86+a74);
  a40=(a136*a78);
  a13=(a131*a173);
  a40=(a40+a13);
  a74=(a74+a40);
  a40=(a165*a74);
  a1=(a1*a178);
  a13=(a27*a204);
  a20=(a141*a13);
  a160=(a163*a204);
  a20=(a20+a160);
  a1=(a1-a20);
  a20=(a1/a128);
  a197=(a197*a1);
  a20=(a20+a197);
  a197=(a168*a20);
  a40=(a40-a197);
  a197=(a153*a20);
  a160=(a165*a1);
  a197=(a197+a160);
  a197=(a1+a197);
  a160=(a174*a197);
  a212=(a131*a173);
  a78=(a136*a78);
  a212=(a212+a78);
  a78=(a132*a212);
  a160=(a160+a78);
  a78=(a163*a178);
  a13=(a142*a13);
  a78=(a78-a13);
  a13=(a141*a178);
  a189=(a142*a204);
  a13=(a13-a189);
  a78=(a78-a13);
  a13=(a165*a78);
  a189=(a179*a20);
  a13=(a13-a189);
  a13=(a78+a13);
  a189=(a140*a13);
  a138=(a143*a173);
  a76=(a136*a44);
  a138=(a138-a76);
  a76=(a181*a138);
  a189=(a189+a76);
  a160=(a160+a189);
  a40=(a40-a160);
  a86=(a86+a40);
  a86=(a120*a86);
  a40=(a166*a66);
  a86=(a86-a40);
  a40=(a176*a67);
  a160=(a167*a173);
  a44=(a44+a173);
  a44=(a136*a44);
  a160=(a160-a44);
  a44=(a151*a178);
  a154=(a142*a154);
  a44=(a44+a154);
  a31=(a141*a31);
  a154=(a162*a204);
  a31=(a31-a154);
  a44=(a44+a31);
  a160=(a160+a44);
  a44=(a27*a178);
  a31=(a141*a44);
  a154=(a180*a204);
  a31=(a31-a154);
  a154=(a141*a178);
  a173=(a142*a204);
  a154=(a154-a173);
  a31=(a31-a154);
  a154=(a78/a128);
  a193=(a193*a1);
  a154=(a154-a193);
  a193=(a153*a154);
  a173=(a184*a1);
  a193=(a193-a173);
  a31=(a31+a193);
  a193=(a174*a31);
  a173=(a183*a212);
  a193=(a193+a173);
  a44=(a142*a44);
  a173=(a180*a178);
  a44=(a44+a173);
  a137=(a137*a204);
  a44=(a44-a137);
  a137=(a179*a154);
  a78=(a184*a78);
  a137=(a137+a78);
  a44=(a44-a137);
  a137=(a140*a44);
  a78=(a186*a138);
  a137=(a137+a78);
  a193=(a193+a137);
  a137=(a168*a154);
  a78=(a184*a74);
  a137=(a137+a78);
  a193=(a193+a137);
  a160=(a160-a193);
  a160=(a58*a160);
  a40=(a40+a160);
  a86=(a86-a40);
  a86=(a86/a187);
  a40=(a120*a197);
  a160=(a132*a66);
  a40=(a40-a160);
  a160=(a183*a67);
  a193=(a58*a31);
  a160=(a160+a193);
  a40=(a40-a160);
  a40=(a120*a40);
  a160=(a185*a66);
  a40=(a40-a160);
  a160=(a120*a13);
  a193=(a181*a66);
  a160=(a160-a193);
  a193=(a186*a67);
  a137=(a58*a44);
  a193=(a193+a137);
  a160=(a160-a193);
  a160=(a58*a160);
  a193=(a188*a67);
  a160=(a160+a193);
  a40=(a40-a160);
  a194=(a194*a40);
  a86=(a86+a194);
  a194=(a132*a67);
  a197=(a58*a197);
  a194=(a194+a197);
  a31=(a120*a31);
  a197=(a183*a66);
  a31=(a31-a197);
  a194=(a194+a31);
  a194=(a120*a194);
  a31=(a164*a66);
  a194=(a194-a31);
  a31=(a181*a67);
  a13=(a58*a13);
  a31=(a31+a13);
  a44=(a120*a44);
  a13=(a186*a66);
  a44=(a44-a13);
  a31=(a31+a44);
  a31=(a58*a31);
  a44=(a122*a67);
  a31=(a31+a44);
  a194=(a194-a31);
  a194=(a194/a187);
  a171=(a171*a40);
  a194=(a194-a171);
  a194=(a60*a194);
  a86=(a86+a194);
  a194=(a4*a86);
  a68=(a68+a194);
  a74=(a74/a128);
  a45=(a45*a1);
  a74=(a74-a45);
  a45=(a60*a67);
  a1=(a192*a66);
  a194=(a120*a86);
  a1=(a1+a194);
  a45=(a45-a1);
  a45=(a45-a212);
  a212=(a165*a45);
  a20=(a191*a20);
  a212=(a212-a20);
  a154=(a172*a154);
  a66=(a60*a66);
  a67=(a192*a67);
  a20=(a58*a86);
  a67=(a67-a20);
  a66=(a66+a67);
  a66=(a66+a138);
  a138=(a184*a66);
  a154=(a154-a138);
  a212=(a212-a154);
  a74=(a74-a212);
  a212=(a2*a74);
  a154=(a61*a212);
  a138=(a56*a22);
  a138=(a2*a138);
  a75=(a75*a138);
  a67=(a11*a75);
  a86=(a2*a86);
  a20=(a182*a86);
  a67=(a67-a20);
  a20=(a198*a67);
  a154=(a154+a20);
  a54=(a27*a54);
  a45=(a45-a74);
  a45=(a141*a45);
  a204=(a65*a204);
  a45=(a45-a204);
  a178=(a172*a178);
  a66=(a142*a66);
  a178=(a178-a66);
  a45=(a45+a178);
  a45=(a45-a14);
  a45=(a23*a45);
  a45=(a45+a74);
  a54=(a54-a45);
  a45=(a2*a54);
  a14=(a45+a212);
  a178=(a177*a14);
  a66=(a56*a62);
  a66=(a2*a66);
  a66=(a0+a66);
  a126=(a126*a66);
  a204=(a119*a126);
  a64=(a64*a138);
  a138=(a11*a64);
  a86=(a134*a86);
  a138=(a138+a86);
  a86=(a138+a212);
  a20=(a196*a86);
  a204=(a204-a20);
  a20=(a169*a67);
  a156=(a156*a66);
  a66=(a61*a156);
  a20=(a20-a66);
  a204=(a204+a20);
  a20=(a63*a204);
  a178=(a178+a20);
  a20=(a63*a204);
  a66=(a177*a14);
  a20=(a20+a66);
  a66=(a23*a20);
  a1=(a177*a45);
  a204=(a158*a204);
  a1=(a1+a204);
  a204=(a27*a1);
  a66=(a66-a204);
  a178=(a178+a66);
  a66=(a169*a178);
  a204=(a199*a156);
  a66=(a66-a204);
  a204=(a206*a126);
  a194=(a205*a14);
  a171=(a119*a156);
  a86=(a169*a86);
  a171=(a171+a86);
  a86=(a61*a126);
  a40=(a196*a67);
  a86=(a86+a40);
  a171=(a171+a86);
  a14=(a171+a14);
  a14=(a63*a14);
  a194=(a194-a14);
  a45=(a155*a45);
  a171=(a158*a171);
  a45=(a45-a171);
  a194=(a194-a45);
  a45=(a196*a194);
  a204=(a204+a45);
  a66=(a66-a204);
  a154=(a154+a66);
  a204=(a198*a67);
  a45=(a61*a212);
  a204=(a204+a45);
  a66=(a66+a204);
  a204=(a118*a66);
  a24=(a24*a126);
  a45=(a27*a156);
  a171=(a169*a45);
  a14=(a207*a156);
  a171=(a171+a14);
  a24=(a24-a171);
  a171=(a24/a149);
  a215=(a215*a24);
  a171=(a171+a215);
  a215=(a38*a171);
  a204=(a204-a215);
  a215=(a209*a171);
  a14=(a118*a24);
  a215=(a215+a14);
  a215=(a24+a215);
  a14=(a216*a215);
  a86=(a61*a212);
  a67=(a198*a67);
  a86=(a86+a67);
  a67=(a152*a86);
  a14=(a14+a67);
  a67=(a207*a126);
  a45=(a196*a45);
  a67=(a67-a45);
  a45=(a169*a126);
  a40=(a196*a156);
  a45=(a45-a40);
  a67=(a67-a45);
  a45=(a118*a67);
  a40=(a221*a171);
  a45=(a45-a40);
  a45=(a67+a45);
  a40=(a202*a45);
  a31=(a148*a212);
  a44=(a198*a138);
  a31=(a31-a44);
  a44=(a223*a31);
  a40=(a40+a44);
  a14=(a14+a40);
  a204=(a204-a14);
  a154=(a154+a204);
  a154=(a134*a154);
  a204=(a210*a64);
  a154=(a154-a204);
  a204=(a218*a75);
  a14=(a211*a212);
  a138=(a138+a212);
  a138=(a198*a138);
  a14=(a14-a138);
  a138=(a199*a126);
  a178=(a196*a178);
  a138=(a138+a178);
  a194=(a169*a194);
  a178=(a206*a156);
  a194=(a194-a178);
  a138=(a138+a194);
  a14=(a14+a138);
  a138=(a27*a126);
  a194=(a169*a138);
  a178=(a222*a156);
  a194=(a194-a178);
  a178=(a169*a126);
  a212=(a196*a156);
  a178=(a178-a212);
  a194=(a194-a178);
  a178=(a67/a149);
  a200=(a200*a24);
  a178=(a178-a200);
  a200=(a209*a178);
  a212=(a226*a24);
  a200=(a200-a212);
  a194=(a194+a200);
  a200=(a216*a194);
  a212=(a225*a86);
  a200=(a200+a212);
  a138=(a196*a138);
  a212=(a222*a126);
  a138=(a138+a212);
  a231=(a231*a156);
  a138=(a138-a231);
  a231=(a221*a178);
  a67=(a226*a67);
  a231=(a231+a67);
  a138=(a138-a231);
  a231=(a202*a138);
  a67=(a228*a31);
  a231=(a231+a67);
  a200=(a200+a231);
  a231=(a38*a178);
  a67=(a226*a66);
  a231=(a231+a67);
  a200=(a200+a231);
  a14=(a14-a200);
  a14=(a182*a14);
  a204=(a204+a14);
  a154=(a154-a204);
  a154=(a154/a49);
  a204=(a134*a215);
  a14=(a152*a64);
  a204=(a204-a14);
  a14=(a225*a75);
  a200=(a182*a194);
  a14=(a14+a200);
  a204=(a204-a14);
  a204=(a134*a204);
  a14=(a227*a64);
  a204=(a204-a14);
  a14=(a134*a45);
  a200=(a223*a64);
  a14=(a14-a200);
  a200=(a228*a75);
  a231=(a182*a138);
  a200=(a200+a231);
  a14=(a14-a200);
  a14=(a182*a14);
  a200=(a230*a75);
  a14=(a14+a200);
  a204=(a204-a14);
  a229=(a229*a204);
  a154=(a154+a229);
  a229=(a152*a75);
  a215=(a182*a215);
  a229=(a229+a215);
  a194=(a134*a194);
  a215=(a225*a64);
  a194=(a194-a215);
  a229=(a229+a194);
  a229=(a134*a229);
  a194=(a208*a64);
  a229=(a229-a194);
  a194=(a223*a75);
  a45=(a182*a45);
  a194=(a194+a45);
  a138=(a134*a138);
  a45=(a228*a64);
  a138=(a138-a45);
  a194=(a194+a138);
  a194=(a182*a194);
  a138=(a201*a75);
  a194=(a194+a138);
  a229=(a229-a194);
  a229=(a229/a49);
  a213=(a213*a204);
  a229=(a229-a213);
  a229=(a60*a229);
  a154=(a154+a229);
  a68=(a68+a154);
  a68=(a3*a68);
  a68=(a2*a68);
  a68=(-a68);
  if (res[3]!=0) res[3][6]=a68;
  a22=(a4*a22);
  a203=(a203+a22);
  a74=(a4*a74);
  a203=(a203+a74);
  a66=(a66/a149);
  a125=(a125*a24);
  a66=(a66-a125);
  a125=(a60*a75);
  a24=(a53*a64);
  a74=(a134*a154);
  a24=(a24+a74);
  a125=(a125-a24);
  a125=(a125-a86);
  a86=(a118*a125);
  a171=(a220*a171);
  a86=(a86-a171);
  a178=(a214*a178);
  a64=(a60*a64);
  a75=(a53*a75);
  a154=(a182*a154);
  a75=(a75-a154);
  a64=(a64+a75);
  a64=(a64+a31);
  a31=(a226*a64);
  a178=(a178-a31);
  a86=(a86-a178);
  a66=(a66-a86);
  a203=(a203+a66);
  a203=(a3*a203);
  a203=(a2*a203);
  if (res[3]!=0) res[3][7]=a203;
  a62=(a4*a62);
  a195=(a195+a62);
  a54=(a4*a54);
  a195=(a195+a54);
  a20=(a27*a20);
  a125=(a125-a66);
  a125=(a169*a125);
  a156=(a139*a156);
  a125=(a125-a156);
  a126=(a214*a126);
  a64=(a196*a64);
  a126=(a126-a64);
  a125=(a125+a126);
  a125=(a125-a1);
  a125=(a23*a125);
  a125=(a125+a66);
  a20=(a20-a125);
  a195=(a195+a20);
  a195=(a3*a195);
  a195=(a2*a195);
  if (res[3]!=0) res[3][8]=a195;
  a195=(a9*a10);
  a20=(a18*a8);
  a125=(a15*a10);
  a20=(a20+a125);
  a125=(a17*a20);
  a66=(a17*a20);
  a1=(a23*a66);
  a20=(a16*a20);
  a126=(a27*a20);
  a1=(a1-a126);
  a125=(a125+a1);
  a1=(a15*a125);
  a126=(a15*a8);
  a64=(a18*a10);
  a126=(a126-a64);
  a64=(a17*a126);
  a126=(a16*a126);
  a64=(a64-a126);
  a126=(a18*a64);
  a1=(a1-a126);
  a195=(a195+a1);
  a126=(a9*a10);
  a1=(a1+a126);
  a126=(a37*a1);
  a156=(a9*a10);
  a54=(a34*a156);
  a62=(a9*a8);
  a203=(a43*a62);
  a54=(a54+a203);
  a126=(a126-a54);
  a195=(a195+a126);
  a195=(a8*a195);
  a126=(a9*a8);
  a125=(a18*a125);
  a64=(a15*a64);
  a125=(a125+a64);
  a126=(a126+a125);
  a125=(a47*a156);
  a64=(a50*a62);
  a125=(a125+a64);
  a64=(a48*a1);
  a125=(a125+a64);
  a126=(a126-a125);
  a126=(a10*a126);
  a195=(a195-a126);
  a195=(a195/a52);
  a1=(a1/a36);
  a126=(a8*a195);
  a126=(a126+a156);
  a156=(a37*a126);
  a125=(a10*a195);
  a125=(a125-a62);
  a62=(a48*a125);
  a156=(a156+a62);
  a1=(a1+a156);
  a156=(a73*a1);
  a62=(a82*a156);
  a64=(a73*a195);
  a64=(a0-a64);
  a54=(a80*a64);
  a203=(a79*a54);
  a62=(a62+a203);
  a66=(a27*a66);
  a125=(a18*a125);
  a126=(a126+a1);
  a126=(a15*a126);
  a125=(a125-a126);
  a125=(a125-a20);
  a125=(a23*a125);
  a125=(a125+a1);
  a66=(a66-a125);
  a125=(a73*a66);
  a20=(a125+a156);
  a126=(a91*a20);
  a64=(a72*a64);
  a203=(a64-a156);
  a86=(a88*a203);
  a178=(a85*a54);
  a86=(a86+a178);
  a178=(a28*a86);
  a126=(a126+a178);
  a178=(a28*a86);
  a31=(a91*a20);
  a178=(a178+a31);
  a31=(a23*a178);
  a75=(a91*a125);
  a86=(a87*a86);
  a75=(a75+a86);
  a86=(a27*a75);
  a31=(a31-a86);
  a126=(a126+a31);
  a31=(a85*a126);
  a86=(a97*a20);
  a203=(a85*a203);
  a154=(a88*a54);
  a203=(a203-a154);
  a20=(a203-a20);
  a20=(a28*a20);
  a86=(a86+a20);
  a125=(a96*a125);
  a203=(a87*a203);
  a125=(a125+a203);
  a86=(a86-a125);
  a125=(a88*a86);
  a31=(a31-a125);
  a62=(a62+a31);
  a125=(a79*a54);
  a203=(a82*a156);
  a125=(a125+a203);
  a31=(a31+a125);
  a125=(a103*a31);
  a203=(a82*a156);
  a54=(a79*a54);
  a203=(a203+a54);
  a54=(a100*a203);
  a20=(a89*a156);
  a154=(a79*a64);
  a20=(a20+a154);
  a154=(a108*a20);
  a54=(a54+a154);
  a125=(a125-a54);
  a62=(a62+a125);
  a62=(a72*a62);
  a125=(a106*a156);
  a64=(a64-a156);
  a64=(a79*a64);
  a125=(a125+a64);
  a126=(a88*a126);
  a86=(a85*a86);
  a126=(a126+a86);
  a125=(a125+a126);
  a126=(a112*a203);
  a86=(a115*a20);
  a126=(a126+a86);
  a86=(a113*a31);
  a126=(a126+a86);
  a125=(a125-a126);
  a125=(a80*a125);
  a62=(a62-a125);
  a62=(a62/a116);
  a125=(a4*a62);
  a195=(a195+a125);
  a31=(a31/a102);
  a125=(a72*a62);
  a125=(a125+a203);
  a203=(a103*a125);
  a126=(a80*a62);
  a126=(a126-a20);
  a20=(a113*a126);
  a203=(a203+a20);
  a31=(a31+a203);
  a203=(a59*a31);
  a20=(a131*a203);
  a86=cos(a77);
  a64=(a5*a1);
  a64=(a55*a64);
  a156=(a86*a64);
  a54=(a130*a156);
  a62=(a59*a62);
  a62=(a0-a62);
  a154=(a58*a62);
  a54=(a54+a154);
  a154=(a136*a54);
  a20=(a20+a154);
  a178=(a27*a178);
  a126=(a88*a126);
  a125=(a125+a31);
  a125=(a85*a125);
  a126=(a126-a125);
  a126=(a126-a75);
  a126=(a23*a126);
  a126=(a126+a31);
  a178=(a178-a126);
  a126=(a59*a178);
  a75=(a126+a203);
  a125=(a145*a75);
  a154=cos(a25);
  a171=(a5*a66);
  a171=(a55*a171);
  a24=(a154*a171);
  a74=(a144*a24);
  a62=(a120*a62);
  a22=sin(a77);
  a64=(a22*a64);
  a68=(a130*a64);
  a62=(a62-a68);
  a68=(a62-a203);
  a229=(a142*a68);
  a74=(a74+a229);
  a229=(a141*a54);
  a213=sin(a25);
  a171=(a213*a171);
  a204=(a131*a171);
  a229=(a229-a204);
  a74=(a74+a229);
  a229=(a95*a74);
  a125=(a125+a229);
  a229=(a95*a74);
  a204=(a145*a75);
  a229=(a229+a204);
  a204=(a23*a229);
  a194=(a145*a126);
  a74=(a147*a74);
  a194=(a194+a74);
  a74=(a27*a194);
  a204=(a204-a74);
  a125=(a125+a204);
  a204=(a141*a125);
  a74=(a151*a171);
  a204=(a204-a74);
  a74=(a162*a24);
  a138=(a161*a75);
  a68=(a141*a68);
  a45=(a144*a171);
  a68=(a68-a45);
  a45=(a131*a24);
  a215=(a142*a54);
  a45=(a45+a215);
  a68=(a68-a45);
  a75=(a68-a75);
  a75=(a95*a75);
  a138=(a138+a75);
  a126=(a159*a126);
  a68=(a147*a68);
  a126=(a126+a68);
  a138=(a138-a126);
  a126=(a142*a138);
  a74=(a74+a126);
  a204=(a204-a74);
  a20=(a20+a204);
  a74=(a136*a54);
  a126=(a131*a203);
  a74=(a74+a126);
  a204=(a204+a74);
  a74=(a165*a204);
  a126=(a142+a142);
  a68=(a126*a24);
  a75=(a27*a171);
  a45=(a141*a75);
  a215=(a163*a171);
  a45=(a45+a215);
  a68=(a68-a45);
  a45=(a68/a128);
  a215=(a165/a128);
  a14=(a215*a68);
  a45=(a45+a14);
  a14=(a168*a45);
  a74=(a74-a14);
  a14=(a153*a45);
  a200=(a165*a68);
  a14=(a14+a200);
  a14=(a68+a14);
  a200=(a174*a14);
  a231=(a131*a203);
  a54=(a136*a54);
  a231=(a231+a54);
  a54=(a132*a231);
  a200=(a200+a54);
  a54=(a163*a24);
  a75=(a142*a75);
  a54=(a54-a75);
  a75=(a141*a24);
  a67=(a142*a171);
  a75=(a75-a67);
  a54=(a54-a75);
  a75=(a165*a54);
  a67=(a179*a45);
  a75=(a75-a67);
  a75=(a54+a75);
  a67=(a140*a75);
  a212=(a143*a203);
  a40=(a136*a62);
  a212=(a212+a40);
  a40=(a181*a212);
  a67=(a67+a40);
  a200=(a200+a67);
  a74=(a74-a200);
  a20=(a20+a74);
  a20=(a120*a20);
  a74=(a166*a64);
  a20=(a20-a74);
  a74=(a176*a156);
  a200=(a167*a203);
  a62=(a62-a203);
  a62=(a136*a62);
  a200=(a200+a62);
  a62=(a151*a24);
  a125=(a142*a125);
  a62=(a62+a125);
  a138=(a141*a138);
  a125=(a162*a171);
  a138=(a138-a125);
  a62=(a62+a138);
  a200=(a200+a62);
  a62=(a27*a24);
  a138=(a141*a62);
  a125=(a180*a171);
  a138=(a138-a125);
  a125=(a141*a24);
  a203=(a142*a171);
  a125=(a125-a203);
  a138=(a138-a125);
  a125=(a54/a128);
  a203=(a184/a128);
  a67=(a203*a68);
  a125=(a125-a67);
  a67=(a153*a125);
  a40=(a184*a68);
  a67=(a67-a40);
  a138=(a138+a67);
  a67=(a174*a138);
  a40=(a183*a231);
  a67=(a67+a40);
  a62=(a142*a62);
  a40=(a180*a24);
  a62=(a62+a40);
  a40=(a141+a141);
  a44=(a40*a171);
  a62=(a62-a44);
  a44=(a179*a125);
  a54=(a184*a54);
  a44=(a44+a54);
  a62=(a62-a44);
  a44=(a140*a62);
  a54=(a186*a212);
  a44=(a44+a54);
  a67=(a67+a44);
  a44=(a168*a125);
  a54=(a184*a204);
  a44=(a44+a54);
  a67=(a67+a44);
  a200=(a200-a67);
  a200=(a58*a200);
  a74=(a74+a200);
  a20=(a20-a74);
  a20=(a20/a187);
  a74=(a190/a187);
  a200=(a120*a14);
  a67=(a132*a64);
  a200=(a200-a67);
  a67=(a183*a156);
  a44=(a58*a138);
  a67=(a67+a44);
  a200=(a200-a67);
  a200=(a120*a200);
  a67=(a185*a64);
  a200=(a200-a67);
  a67=(a120*a75);
  a44=(a181*a64);
  a67=(a67-a44);
  a44=(a186*a156);
  a54=(a58*a62);
  a44=(a44+a54);
  a67=(a67-a44);
  a67=(a58*a67);
  a44=(a188*a156);
  a67=(a67+a44);
  a200=(a200-a67);
  a67=(a74*a200);
  a20=(a20+a67);
  a67=(a132*a156);
  a14=(a58*a14);
  a67=(a67+a14);
  a138=(a120*a138);
  a14=(a183*a64);
  a138=(a138-a14);
  a67=(a67+a138);
  a67=(a120*a67);
  a138=(a164*a64);
  a67=(a67-a138);
  a138=(a181*a156);
  a75=(a58*a75);
  a138=(a138+a75);
  a62=(a120*a62);
  a75=(a186*a64);
  a62=(a62-a75);
  a138=(a138+a62);
  a138=(a58*a138);
  a62=(a122*a156);
  a138=(a138+a62);
  a67=(a67-a138);
  a67=(a67/a187);
  a138=(a175/a187);
  a200=(a138*a200);
  a67=(a67-a200);
  a67=(a60*a67);
  a20=(a20+a67);
  a67=(a4*a20);
  a195=(a195+a67);
  a204=(a204/a128);
  a67=(a127/a128);
  a68=(a67*a68);
  a204=(a204-a68);
  a68=(a60*a156);
  a200=(a192*a64);
  a62=(a120*a20);
  a200=(a200+a62);
  a68=(a68-a200);
  a68=(a68-a231);
  a231=(a165*a68);
  a45=(a191*a45);
  a231=(a231-a45);
  a125=(a172*a125);
  a64=(a60*a64);
  a156=(a192*a156);
  a45=(a58*a20);
  a156=(a156-a45);
  a64=(a64+a156);
  a64=(a64+a212);
  a212=(a184*a64);
  a125=(a125-a212);
  a231=(a231-a125);
  a204=(a204-a231);
  a231=(a2*a204);
  a125=(a61*a231);
  a212=cos(a7);
  a156=(a56*a31);
  a156=(a2*a156);
  a45=(a212*a156);
  a200=(a11*a45);
  a20=(a2*a20);
  a20=(a0-a20);
  a62=(a182*a20);
  a200=(a200+a62);
  a62=(a198*a200);
  a125=(a125+a62);
  a229=(a27*a229);
  a68=(a68-a204);
  a68=(a141*a68);
  a171=(a65*a171);
  a68=(a68-a171);
  a24=(a172*a24);
  a64=(a142*a64);
  a24=(a24-a64);
  a68=(a68+a24);
  a68=(a68-a194);
  a68=(a23*a68);
  a68=(a68+a204);
  a229=(a229-a68);
  a68=(a2*a229);
  a194=(a68+a231);
  a24=(a177*a194);
  a64=cos(a93);
  a171=(a56*a178);
  a171=(a2*a171);
  a62=(a64*a171);
  a75=(a119*a62);
  a20=(a134*a20);
  a14=sin(a7);
  a156=(a14*a156);
  a44=(a11*a156);
  a20=(a20-a44);
  a44=(a20-a231);
  a54=(a196*a44);
  a75=(a75+a54);
  a54=(a169*a200);
  a13=sin(a93);
  a171=(a13*a171);
  a197=(a61*a171);
  a54=(a54-a197);
  a75=(a75+a54);
  a54=(a63*a75);
  a24=(a24+a54);
  a54=(a63*a75);
  a197=(a177*a194);
  a54=(a54+a197);
  a197=(a23*a54);
  a160=(a177*a68);
  a75=(a158*a75);
  a160=(a160+a75);
  a75=(a27*a160);
  a197=(a197-a75);
  a24=(a24+a197);
  a197=(a169*a24);
  a75=(a199*a171);
  a197=(a197-a75);
  a75=(a206*a62);
  a193=(a205*a194);
  a44=(a169*a44);
  a137=(a119*a171);
  a44=(a44-a137);
  a137=(a61*a62);
  a78=(a196*a200);
  a137=(a137+a78);
  a44=(a44-a137);
  a194=(a44-a194);
  a194=(a63*a194);
  a193=(a193+a194);
  a68=(a155*a68);
  a44=(a158*a44);
  a68=(a68+a44);
  a193=(a193-a68);
  a68=(a196*a193);
  a75=(a75+a68);
  a197=(a197-a75);
  a125=(a125+a197);
  a75=(a198*a200);
  a68=(a61*a231);
  a75=(a75+a68);
  a197=(a197+a75);
  a75=(a118*a197);
  a68=(a196+a196);
  a44=(a68*a62);
  a194=(a27*a171);
  a137=(a169*a194);
  a78=(a207*a171);
  a137=(a137+a78);
  a44=(a44-a137);
  a137=(a44/a149);
  a78=(a118/a149);
  a173=(a78*a44);
  a137=(a137+a173);
  a173=(a38*a137);
  a75=(a75-a173);
  a173=(a209*a137);
  a189=(a118*a44);
  a173=(a173+a189);
  a173=(a44+a173);
  a189=(a216*a173);
  a76=(a61*a231);
  a200=(a198*a200);
  a76=(a76+a200);
  a200=(a152*a76);
  a189=(a189+a200);
  a200=(a207*a62);
  a194=(a196*a194);
  a200=(a200-a194);
  a194=(a169*a62);
  a39=(a196*a171);
  a194=(a194-a39);
  a200=(a200-a194);
  a194=(a118*a200);
  a39=(a221*a137);
  a194=(a194-a39);
  a194=(a200+a194);
  a39=(a202*a194);
  a150=(a148*a231);
  a26=(a198*a20);
  a150=(a150+a26);
  a26=(a223*a150);
  a39=(a39+a26);
  a189=(a189+a39);
  a75=(a75-a189);
  a125=(a125+a75);
  a125=(a134*a125);
  a75=(a210*a156);
  a125=(a125-a75);
  a75=(a218*a45);
  a189=(a211*a231);
  a20=(a20-a231);
  a20=(a198*a20);
  a189=(a189+a20);
  a20=(a199*a62);
  a24=(a196*a24);
  a20=(a20+a24);
  a193=(a169*a193);
  a24=(a206*a171);
  a193=(a193-a24);
  a20=(a20+a193);
  a189=(a189+a20);
  a20=(a27*a62);
  a193=(a169*a20);
  a24=(a222*a171);
  a193=(a193-a24);
  a24=(a169*a62);
  a231=(a196*a171);
  a24=(a24-a231);
  a193=(a193-a24);
  a24=(a200/a149);
  a231=(a226/a149);
  a39=(a231*a44);
  a24=(a24-a39);
  a39=(a209*a24);
  a26=(a226*a44);
  a39=(a39-a26);
  a193=(a193+a39);
  a39=(a216*a193);
  a26=(a225*a76);
  a39=(a39+a26);
  a20=(a196*a20);
  a26=(a222*a62);
  a20=(a20+a26);
  a26=(a169+a169);
  a42=(a26*a171);
  a20=(a20-a42);
  a42=(a221*a24);
  a200=(a226*a200);
  a42=(a42+a200);
  a20=(a20-a42);
  a42=(a202*a20);
  a200=(a228*a150);
  a42=(a42+a200);
  a39=(a39+a42);
  a42=(a38*a24);
  a200=(a226*a197);
  a42=(a42+a200);
  a39=(a39+a42);
  a189=(a189-a39);
  a189=(a182*a189);
  a75=(a75+a189);
  a125=(a125-a75);
  a125=(a125/a49);
  a75=(a6/a49);
  a189=(a134*a173);
  a39=(a152*a156);
  a189=(a189-a39);
  a39=(a225*a45);
  a42=(a182*a193);
  a39=(a39+a42);
  a189=(a189-a39);
  a189=(a134*a189);
  a39=(a227*a156);
  a189=(a189-a39);
  a39=(a134*a194);
  a42=(a223*a156);
  a39=(a39-a42);
  a42=(a228*a45);
  a200=(a182*a20);
  a42=(a42+a200);
  a39=(a39-a42);
  a39=(a182*a39);
  a42=(a230*a45);
  a39=(a39+a42);
  a189=(a189-a39);
  a39=(a75*a189);
  a125=(a125+a39);
  a39=(a152*a45);
  a173=(a182*a173);
  a39=(a39+a173);
  a193=(a134*a193);
  a173=(a225*a156);
  a193=(a193-a173);
  a39=(a39+a193);
  a39=(a134*a39);
  a193=(a208*a156);
  a39=(a39-a193);
  a193=(a223*a45);
  a194=(a182*a194);
  a193=(a193+a194);
  a20=(a134*a20);
  a194=(a228*a156);
  a20=(a20-a194);
  a193=(a193+a20);
  a193=(a182*a193);
  a20=(a201*a45);
  a193=(a193+a20);
  a39=(a39-a193);
  a39=(a39/a49);
  a193=(a217/a49);
  a189=(a193*a189);
  a39=(a39-a189);
  a39=(a60*a39);
  a125=(a125+a39);
  a195=(a195+a125);
  a195=(a3*a195);
  a195=(a2*a195);
  a195=(a0-a195);
  if (res[4]!=0) res[4][0]=a195;
  a31=(a4*a31);
  a1=(a1+a31);
  a204=(a4*a204);
  a1=(a1+a204);
  a197=(a197/a149);
  a204=(a157/a149);
  a44=(a204*a44);
  a197=(a197-a44);
  a44=(a60*a45);
  a31=(a53*a156);
  a195=(a134*a125);
  a31=(a31+a195);
  a44=(a44-a31);
  a44=(a44-a76);
  a76=(a118*a44);
  a137=(a220*a137);
  a76=(a76-a137);
  a24=(a214*a24);
  a156=(a60*a156);
  a45=(a53*a45);
  a125=(a182*a125);
  a45=(a45-a125);
  a156=(a156+a45);
  a156=(a156+a150);
  a150=(a226*a156);
  a24=(a24-a150);
  a76=(a76-a24);
  a197=(a197-a76);
  a1=(a1+a197);
  a1=(a3*a1);
  a1=(a2*a1);
  if (res[4]!=0) res[4][1]=a1;
  a178=(a4*a178);
  a66=(a66+a178);
  a229=(a4*a229);
  a66=(a66+a229);
  a54=(a27*a54);
  a44=(a44-a197);
  a44=(a169*a44);
  a171=(a139*a171);
  a44=(a44-a171);
  a62=(a214*a62);
  a156=(a196*a156);
  a62=(a62-a156);
  a44=(a44+a62);
  a44=(a44-a160);
  a44=(a23*a44);
  a44=(a44+a197);
  a54=(a54-a44);
  a66=(a66+a54);
  a66=(a3*a66);
  a66=(a2*a66);
  if (res[4]!=0) res[4][2]=a66;
  a104=(a104/a116);
  a66=sin(a71);
  a66=(a66*a70);
  a54=(a100*a66);
  a71=cos(a71);
  a71=(a71*a70);
  a44=(a112*a71);
  a54=(a54+a44);
  a54=(a72*a54);
  a114=(a114*a66);
  a54=(a54+a114);
  a117=(a117*a71);
  a114=(a108*a66);
  a44=(a115*a71);
  a114=(a114+a44);
  a114=(a80*a114);
  a117=(a117-a114);
  a54=(a54+a117);
  a117=(a104*a54);
  a114=(a17*a18);
  a114=(a21-a114);
  a44=(a17*a18);
  a44=(a21-a44);
  a197=(a23*a44);
  a160=(a16*a18);
  a62=(a27*a160);
  a197=(a197+a62);
  a114=(a114+a197);
  a197=(a15*a114);
  a32=(a32-a15);
  a32=(a17*a32);
  a32=(a30+a32);
  a16=(a16*a15);
  a32=(a32+a16);
  a16=(a18*a32);
  a197=(a197-a16);
  a16=(a197+a12);
  a62=(a16/a36);
  a197=(a12+a197);
  a156=(a37*a16);
  a34=(a34*a12);
  a43=(a43*a19);
  a34=(a34+a43);
  a156=(a156-a34);
  a197=(a197+a156);
  a197=(a8*a197);
  a41=(a41-a9);
  a114=(a18*a114);
  a32=(a15*a32);
  a114=(a114+a32);
  a41=(a41+a114);
  a47=(a47*a12);
  a50=(a50*a19);
  a47=(a47+a50);
  a16=(a48*a16);
  a47=(a47+a16);
  a41=(a41-a47);
  a41=(a10*a41);
  a197=(a197-a41);
  a197=(a197/a52);
  a41=(a8*a197);
  a41=(a41+a12);
  a12=(a37*a41);
  a47=(a10*a197);
  a47=(a47-a19);
  a19=(a48*a47);
  a12=(a12+a19);
  a62=(a62+a12);
  a12=(a73*a62);
  a12=(a0+a12);
  a19=(a82*a12);
  a16=(a81*a71);
  a50=(a73*a197);
  a114=(a80*a50);
  a16=(a16-a114);
  a114=(a79*a16);
  a19=(a19+a114);
  a44=(a27*a44);
  a47=(a18*a47);
  a41=(a41+a62);
  a41=(a15*a41);
  a47=(a47-a41);
  a47=(a47+a160);
  a47=(a23*a47);
  a47=(a47+a62);
  a44=(a44-a47);
  a47=(a73*a44);
  a160=(a47+a12);
  a41=(a91*a160);
  a114=(a85*a16);
  a81=(a81*a66);
  a50=(a72*a50);
  a81=(a81+a50);
  a50=(a81+a12);
  a32=(a88*a50);
  a114=(a114-a32);
  a32=(a28*a114);
  a41=(a41+a32);
  a32=(a28*a114);
  a9=(a91*a160);
  a32=(a32+a9);
  a9=(a23*a32);
  a156=(a91*a47);
  a114=(a87*a114);
  a156=(a156+a114);
  a114=(a27*a156);
  a9=(a9-a114);
  a41=(a41+a9);
  a9=(a85*a41);
  a114=(a97*a160);
  a50=(a85*a50);
  a34=(a88*a16);
  a50=(a50+a34);
  a160=(a50+a160);
  a160=(a28*a160);
  a114=(a114-a160);
  a47=(a96*a47);
  a50=(a87*a50);
  a47=(a47-a50);
  a114=(a114-a47);
  a47=(a88*a114);
  a9=(a9-a47);
  a19=(a19+a9);
  a47=(a79*a16);
  a50=(a82*a12);
  a47=(a47+a50);
  a9=(a9+a47);
  a47=(a103*a9);
  a50=(a82*a12);
  a16=(a79*a16);
  a50=(a50+a16);
  a16=(a100*a50);
  a160=(a89*a12);
  a34=(a79*a81);
  a160=(a160-a34);
  a34=(a108*a160);
  a16=(a16+a34);
  a47=(a47-a16);
  a19=(a19+a47);
  a19=(a72*a19);
  a83=(a83*a66);
  a19=(a19-a83);
  a110=(a110*a71);
  a83=(a106*a12);
  a81=(a81+a12);
  a81=(a79*a81);
  a83=(a83-a81);
  a41=(a88*a41);
  a114=(a85*a114);
  a41=(a41+a114);
  a83=(a83+a41);
  a41=(a112*a50);
  a114=(a115*a160);
  a41=(a41+a114);
  a114=(a113*a9);
  a41=(a41+a114);
  a83=(a83-a41);
  a83=(a80*a83);
  a110=(a110+a83);
  a19=(a19-a110);
  a19=(a19/a116);
  a117=(a117-a19);
  a19=(a100*a71);
  a110=(a112*a66);
  a19=(a19-a110);
  a19=(a72*a19);
  a123=(a123*a66);
  a19=(a19-a123);
  a123=(a108*a71);
  a110=(a115*a66);
  a123=(a123-a110);
  a123=(a80*a123);
  a69=(a69*a71);
  a123=(a123+a69);
  a19=(a19-a123);
  a19=(a19/a116);
  a57=(a57/a116);
  a54=(a57*a54);
  a19=(a19+a54);
  a19=(a60*a19);
  a117=(a117-a19);
  a19=(a4*a117);
  a19=(a19-a197);
  a9=(a9/a102);
  a197=(a72*a117);
  a54=(a129*a66);
  a197=(a197-a54);
  a54=(a60*a71);
  a197=(a197+a54);
  a197=(a197-a50);
  a50=(a103*a197);
  a66=(a60*a66);
  a129=(a129*a71);
  a71=(a80*a117);
  a129=(a129+a71);
  a66=(a66+a129);
  a66=(a66+a160);
  a160=(a113*a66);
  a50=(a50+a160);
  a9=(a9-a50);
  a50=(a59*a9);
  a50=(a0+a50);
  a160=(a131*a50);
  a129=(a5*a62);
  a129=(a0+a129);
  a129=(a55*a129);
  a71=(a86*a129);
  a54=(a130*a71);
  a117=(a59*a117);
  a123=(a58*a117);
  a54=(a54+a123);
  a123=(a136*a54);
  a160=(a160+a123);
  a32=(a27*a32);
  a197=(a197-a9);
  a197=(a85*a197);
  a66=(a88*a66);
  a197=(a197-a66);
  a197=(a197-a156);
  a197=(a23*a197);
  a197=(a197+a9);
  a32=(a32-a197);
  a197=(a59*a32);
  a156=(a197+a50);
  a66=(a145*a156);
  a123=(a5*a44);
  a123=(a55*a123);
  a69=(a154*a123);
  a110=(a144*a69);
  a117=(a120*a117);
  a129=(a22*a129);
  a83=(a130*a129);
  a117=(a117-a83);
  a83=(a117-a50);
  a41=(a142*a83);
  a110=(a110+a41);
  a41=(a141*a54);
  a123=(a213*a123);
  a114=(a131*a123);
  a41=(a41-a114);
  a110=(a110+a41);
  a41=(a95*a110);
  a66=(a66+a41);
  a41=(a95*a110);
  a114=(a145*a156);
  a41=(a41+a114);
  a114=(a23*a41);
  a81=(a145*a197);
  a110=(a147*a110);
  a81=(a81+a110);
  a110=(a27*a81);
  a114=(a114-a110);
  a66=(a66+a114);
  a114=(a141*a66);
  a110=(a151*a123);
  a114=(a114-a110);
  a110=(a162*a69);
  a12=(a161*a156);
  a83=(a141*a83);
  a47=(a144*a123);
  a83=(a83-a47);
  a47=(a131*a69);
  a16=(a142*a54);
  a47=(a47+a16);
  a83=(a83-a47);
  a156=(a83-a156);
  a156=(a95*a156);
  a12=(a12+a156);
  a197=(a159*a197);
  a83=(a147*a83);
  a197=(a197+a83);
  a12=(a12-a197);
  a197=(a142*a12);
  a110=(a110+a197);
  a114=(a114-a110);
  a160=(a160+a114);
  a110=(a136*a54);
  a197=(a131*a50);
  a110=(a110+a197);
  a114=(a114+a110);
  a110=(a165*a114);
  a197=(a126*a69);
  a83=(a27*a123);
  a156=(a141*a83);
  a47=(a163*a123);
  a156=(a156+a47);
  a197=(a197-a156);
  a156=(a197/a128);
  a47=(a215*a197);
  a156=(a156+a47);
  a47=(a168*a156);
  a110=(a110-a47);
  a47=(a153*a156);
  a16=(a165*a197);
  a47=(a47+a16);
  a47=(a197+a47);
  a16=(a174*a47);
  a34=(a131*a50);
  a54=(a136*a54);
  a34=(a34+a54);
  a54=(a132*a34);
  a16=(a16+a54);
  a54=(a163*a69);
  a83=(a142*a83);
  a54=(a54-a83);
  a83=(a141*a69);
  a43=(a142*a123);
  a83=(a83-a43);
  a54=(a54-a83);
  a83=(a165*a54);
  a43=(a179*a156);
  a83=(a83-a43);
  a83=(a54+a83);
  a43=(a140*a83);
  a171=(a143*a50);
  a229=(a136*a117);
  a171=(a171+a229);
  a229=(a181*a171);
  a43=(a43+a229);
  a16=(a16+a43);
  a110=(a110-a16);
  a160=(a160+a110);
  a160=(a120*a160);
  a110=(a166*a129);
  a160=(a160-a110);
  a110=(a176*a71);
  a16=(a167*a50);
  a117=(a117-a50);
  a117=(a136*a117);
  a16=(a16+a117);
  a117=(a151*a69);
  a66=(a142*a66);
  a117=(a117+a66);
  a12=(a141*a12);
  a66=(a162*a123);
  a12=(a12-a66);
  a117=(a117+a12);
  a16=(a16+a117);
  a117=(a27*a69);
  a12=(a141*a117);
  a66=(a180*a123);
  a12=(a12-a66);
  a66=(a141*a69);
  a50=(a142*a123);
  a66=(a66-a50);
  a12=(a12-a66);
  a66=(a54/a128);
  a50=(a203*a197);
  a66=(a66-a50);
  a50=(a153*a66);
  a43=(a184*a197);
  a50=(a50-a43);
  a12=(a12+a50);
  a50=(a174*a12);
  a43=(a183*a34);
  a50=(a50+a43);
  a117=(a142*a117);
  a43=(a180*a69);
  a117=(a117+a43);
  a43=(a40*a123);
  a117=(a117-a43);
  a43=(a179*a66);
  a54=(a184*a54);
  a43=(a43+a54);
  a117=(a117-a43);
  a43=(a140*a117);
  a54=(a186*a171);
  a43=(a43+a54);
  a50=(a50+a43);
  a43=(a168*a66);
  a54=(a184*a114);
  a43=(a43+a54);
  a50=(a50+a43);
  a16=(a16-a50);
  a16=(a58*a16);
  a110=(a110+a16);
  a160=(a160-a110);
  a160=(a160/a187);
  a110=(a120*a47);
  a16=(a132*a129);
  a110=(a110-a16);
  a16=(a183*a71);
  a50=(a58*a12);
  a16=(a16+a50);
  a110=(a110-a16);
  a110=(a120*a110);
  a16=(a185*a129);
  a110=(a110-a16);
  a16=(a120*a83);
  a50=(a181*a129);
  a16=(a16-a50);
  a50=(a186*a71);
  a43=(a58*a117);
  a50=(a50+a43);
  a16=(a16-a50);
  a16=(a58*a16);
  a50=(a188*a71);
  a16=(a16+a50);
  a110=(a110-a16);
  a16=(a74*a110);
  a160=(a160+a16);
  a16=(a132*a71);
  a47=(a58*a47);
  a16=(a16+a47);
  a12=(a120*a12);
  a47=(a183*a129);
  a12=(a12-a47);
  a16=(a16+a12);
  a16=(a120*a16);
  a12=(a164*a129);
  a16=(a16-a12);
  a12=(a181*a71);
  a83=(a58*a83);
  a12=(a12+a83);
  a117=(a120*a117);
  a83=(a186*a129);
  a117=(a117-a83);
  a12=(a12+a117);
  a12=(a58*a12);
  a117=(a122*a71);
  a12=(a12+a117);
  a16=(a16-a12);
  a16=(a16/a187);
  a110=(a138*a110);
  a16=(a16-a110);
  a16=(a60*a16);
  a160=(a160+a16);
  a16=(a4*a160);
  a19=(a19-a16);
  a114=(a114/a128);
  a197=(a67*a197);
  a114=(a114-a197);
  a197=(a60*a71);
  a16=(a192*a129);
  a110=(a120*a160);
  a16=(a16+a110);
  a197=(a197-a16);
  a197=(a197-a34);
  a34=(a165*a197);
  a156=(a191*a156);
  a34=(a34-a156);
  a66=(a172*a66);
  a129=(a60*a129);
  a71=(a192*a71);
  a156=(a58*a160);
  a71=(a71-a156);
  a129=(a129+a71);
  a129=(a129+a171);
  a171=(a184*a129);
  a66=(a66-a171);
  a34=(a34-a66);
  a114=(a114-a34);
  a34=(a2*a114);
  a34=(a0+a34);
  a66=(a61*a34);
  a171=(a56*a9);
  a171=(a0+a171);
  a171=(a2*a171);
  a71=(a212*a171);
  a156=(a11*a71);
  a160=(a2*a160);
  a16=(a182*a160);
  a156=(a156-a16);
  a16=(a198*a156);
  a66=(a66+a16);
  a41=(a27*a41);
  a197=(a197-a114);
  a197=(a141*a197);
  a123=(a65*a123);
  a197=(a197-a123);
  a69=(a172*a69);
  a129=(a142*a129);
  a69=(a69-a129);
  a197=(a197+a69);
  a197=(a197-a81);
  a197=(a23*a197);
  a197=(a197+a114);
  a41=(a41-a197);
  a197=(a2*a41);
  a81=(a197+a34);
  a69=(a177*a81);
  a129=(a56*a32);
  a129=(a2*a129);
  a123=(a64*a129);
  a16=(a119*a123);
  a171=(a14*a171);
  a110=(a11*a171);
  a160=(a134*a160);
  a110=(a110+a160);
  a160=(a110+a34);
  a12=(a196*a160);
  a16=(a16-a12);
  a12=(a169*a156);
  a129=(a13*a129);
  a117=(a61*a129);
  a12=(a12-a117);
  a16=(a16+a12);
  a12=(a63*a16);
  a69=(a69+a12);
  a12=(a63*a16);
  a117=(a177*a81);
  a12=(a12+a117);
  a117=(a23*a12);
  a83=(a177*a197);
  a16=(a158*a16);
  a83=(a83+a16);
  a16=(a27*a83);
  a117=(a117-a16);
  a69=(a69+a117);
  a117=(a169*a69);
  a16=(a199*a129);
  a117=(a117-a16);
  a16=(a206*a123);
  a47=(a205*a81);
  a50=(a119*a129);
  a160=(a169*a160);
  a50=(a50+a160);
  a160=(a61*a123);
  a43=(a196*a156);
  a160=(a160+a43);
  a50=(a50+a160);
  a81=(a50+a81);
  a81=(a63*a81);
  a47=(a47-a81);
  a197=(a155*a197);
  a50=(a158*a50);
  a197=(a197-a50);
  a47=(a47-a197);
  a197=(a196*a47);
  a16=(a16+a197);
  a117=(a117-a16);
  a66=(a66+a117);
  a16=(a198*a156);
  a197=(a61*a34);
  a16=(a16+a197);
  a117=(a117+a16);
  a16=(a118*a117);
  a197=(a68*a123);
  a50=(a27*a129);
  a81=(a169*a50);
  a160=(a207*a129);
  a81=(a81+a160);
  a197=(a197-a81);
  a81=(a197/a149);
  a160=(a78*a197);
  a81=(a81+a160);
  a160=(a38*a81);
  a16=(a16-a160);
  a160=(a209*a81);
  a43=(a118*a197);
  a160=(a160+a43);
  a160=(a197+a160);
  a43=(a216*a160);
  a54=(a61*a34);
  a156=(a198*a156);
  a54=(a54+a156);
  a156=(a152*a54);
  a43=(a43+a156);
  a156=(a207*a123);
  a50=(a196*a50);
  a156=(a156-a50);
  a50=(a169*a123);
  a229=(a196*a129);
  a50=(a50-a229);
  a156=(a156-a50);
  a50=(a118*a156);
  a229=(a221*a81);
  a50=(a50-a229);
  a50=(a156+a50);
  a229=(a202*a50);
  a178=(a148*a34);
  a1=(a198*a110);
  a178=(a178-a1);
  a1=(a223*a178);
  a229=(a229+a1);
  a43=(a43+a229);
  a16=(a16-a43);
  a66=(a66+a16);
  a66=(a134*a66);
  a16=(a210*a171);
  a66=(a66-a16);
  a16=(a218*a71);
  a43=(a211*a34);
  a110=(a110+a34);
  a110=(a198*a110);
  a43=(a43-a110);
  a110=(a199*a123);
  a69=(a196*a69);
  a110=(a110+a69);
  a47=(a169*a47);
  a69=(a206*a129);
  a47=(a47-a69);
  a110=(a110+a47);
  a43=(a43+a110);
  a110=(a27*a123);
  a47=(a169*a110);
  a69=(a222*a129);
  a47=(a47-a69);
  a69=(a169*a123);
  a34=(a196*a129);
  a69=(a69-a34);
  a47=(a47-a69);
  a69=(a156/a149);
  a34=(a231*a197);
  a69=(a69-a34);
  a34=(a209*a69);
  a229=(a226*a197);
  a34=(a34-a229);
  a47=(a47+a34);
  a34=(a216*a47);
  a229=(a225*a54);
  a34=(a34+a229);
  a110=(a196*a110);
  a229=(a222*a123);
  a110=(a110+a229);
  a229=(a26*a129);
  a110=(a110-a229);
  a229=(a221*a69);
  a156=(a226*a156);
  a229=(a229+a156);
  a110=(a110-a229);
  a229=(a202*a110);
  a156=(a228*a178);
  a229=(a229+a156);
  a34=(a34+a229);
  a229=(a38*a69);
  a156=(a226*a117);
  a229=(a229+a156);
  a34=(a34+a229);
  a43=(a43-a34);
  a43=(a182*a43);
  a16=(a16+a43);
  a66=(a66-a16);
  a66=(a66/a49);
  a16=(a134*a160);
  a43=(a152*a171);
  a16=(a16-a43);
  a43=(a225*a71);
  a34=(a182*a47);
  a43=(a43+a34);
  a16=(a16-a43);
  a16=(a134*a16);
  a43=(a227*a171);
  a16=(a16-a43);
  a43=(a134*a50);
  a34=(a223*a171);
  a43=(a43-a34);
  a34=(a228*a71);
  a229=(a182*a110);
  a34=(a34+a229);
  a43=(a43-a34);
  a43=(a182*a43);
  a34=(a230*a71);
  a43=(a43+a34);
  a16=(a16-a43);
  a43=(a75*a16);
  a66=(a66+a43);
  a43=(a152*a71);
  a160=(a182*a160);
  a43=(a43+a160);
  a47=(a134*a47);
  a160=(a225*a171);
  a47=(a47-a160);
  a43=(a43+a47);
  a43=(a134*a43);
  a47=(a208*a171);
  a43=(a43-a47);
  a47=(a223*a71);
  a50=(a182*a50);
  a47=(a47+a50);
  a110=(a134*a110);
  a50=(a228*a171);
  a110=(a110-a50);
  a47=(a47+a110);
  a47=(a182*a47);
  a110=(a201*a71);
  a47=(a47+a110);
  a43=(a43-a47);
  a43=(a43/a49);
  a16=(a193*a16);
  a43=(a43-a16);
  a43=(a60*a43);
  a66=(a66+a43);
  a19=(a19-a66);
  a19=(a3*a19);
  a19=(a2*a19);
  if (res[4]!=0) res[4][3]=a19;
  a9=(a4*a9);
  a62=(a62+a9);
  a114=(a4*a114);
  a62=(a62+a114);
  a117=(a117/a149);
  a197=(a204*a197);
  a117=(a117-a197);
  a197=(a60*a71);
  a114=(a53*a171);
  a9=(a134*a66);
  a114=(a114+a9);
  a197=(a197-a114);
  a197=(a197-a54);
  a54=(a118*a197);
  a81=(a220*a81);
  a54=(a54-a81);
  a69=(a214*a69);
  a171=(a60*a171);
  a71=(a53*a71);
  a66=(a182*a66);
  a71=(a71-a66);
  a171=(a171+a71);
  a171=(a171+a178);
  a178=(a226*a171);
  a69=(a69-a178);
  a54=(a54-a69);
  a117=(a117-a54);
  a62=(a62+a117);
  a62=(a3*a62);
  a62=(a2*a62);
  a62=(a0+a62);
  if (res[4]!=0) res[4][4]=a62;
  a32=(a4*a32);
  a44=(a44+a32);
  a41=(a4*a41);
  a44=(a44+a41);
  a12=(a27*a12);
  a197=(a197-a117);
  a197=(a169*a197);
  a129=(a139*a129);
  a197=(a197-a129);
  a123=(a214*a123);
  a171=(a196*a171);
  a123=(a123-a171);
  a197=(a197+a123);
  a197=(a197-a83);
  a197=(a23*a197);
  a197=(a197+a117);
  a12=(a12-a197);
  a44=(a44+a12);
  a44=(a3*a44);
  a44=(a2*a44);
  if (res[4]!=0) res[4][5]=a44;
  a44=(a23*a21);
  a12=(a27*a21);
  a44=(a44-a12);
  a44=(a21+a44);
  a12=(a15*a44);
  a30=(a30-a17);
  a30=(a30-a29);
  a29=(a18*a30);
  a12=(a12-a29);
  a29=(a37*a12);
  a29=(a12+a29);
  a29=(a8*a29);
  a44=(a18*a44);
  a30=(a15*a30);
  a44=(a44+a30);
  a30=(a48*a12);
  a44=(a44-a30);
  a44=(a10*a44);
  a29=(a29-a44);
  a29=(a29/a52);
  a12=(a12/a36);
  a44=(a8*a29);
  a30=(a37*a44);
  a17=(a10*a29);
  a197=(a48*a17);
  a30=(a30+a197);
  a12=(a12+a30);
  a30=(a73*a12);
  a197=(a82*a30);
  a117=(a73*a29);
  a83=(a80*a117);
  a123=(a79*a83);
  a197=(a197-a123);
  a123=(a27*a21);
  a17=(a18*a17);
  a44=(a44+a12);
  a44=(a15*a44);
  a17=(a17-a44);
  a17=(a17-a21);
  a17=(a23*a17);
  a17=(a17+a12);
  a123=(a123-a17);
  a17=(a73*a123);
  a17=(a0+a17);
  a21=(a17+a30);
  a44=(a91*a21);
  a171=cos(a84);
  a171=(a171*a70);
  a129=(a90*a171);
  a117=(a72*a117);
  a41=(a117+a30);
  a32=(a88*a41);
  a129=(a129-a32);
  a84=sin(a84);
  a84=(a84*a70);
  a70=(a82*a84);
  a32=(a85*a83);
  a70=(a70+a32);
  a129=(a129-a70);
  a70=(a28*a129);
  a44=(a44+a70);
  a70=(a28*a129);
  a32=(a91*a21);
  a70=(a70+a32);
  a32=(a23*a70);
  a62=(a91*a17);
  a129=(a87*a129);
  a62=(a62+a129);
  a129=(a27*a62);
  a32=(a32-a129);
  a44=(a44+a32);
  a32=(a85*a44);
  a129=(a92*a84);
  a32=(a32-a129);
  a129=(a98*a171);
  a54=(a97*a21);
  a90=(a90*a84);
  a41=(a85*a41);
  a90=(a90+a41);
  a41=(a82*a171);
  a69=(a88*a83);
  a41=(a41-a69);
  a90=(a90+a41);
  a21=(a90+a21);
  a21=(a28*a21);
  a54=(a54-a21);
  a17=(a96*a17);
  a90=(a87*a90);
  a17=(a17-a90);
  a54=(a54-a17);
  a17=(a88*a54);
  a129=(a129+a17);
  a32=(a32-a129);
  a197=(a197+a32);
  a129=(a82*a30);
  a17=(a79*a83);
  a129=(a129-a17);
  a32=(a32+a129);
  a129=(a103*a32);
  a17=(a88+a88);
  a17=(a17*a171);
  a90=(a27*a84);
  a21=(a85*a90);
  a41=(a99*a84);
  a21=(a21+a41);
  a17=(a17-a21);
  a21=(a17/a102);
  a41=(a103/a102);
  a41=(a41*a17);
  a21=(a21+a41);
  a41=(a94*a21);
  a129=(a129-a41);
  a41=(a101*a21);
  a69=(a103*a17);
  a41=(a41+a69);
  a41=(a17+a41);
  a69=(a105*a41);
  a178=(a82*a30);
  a83=(a79*a83);
  a178=(a178-a83);
  a83=(a100*a178);
  a69=(a69+a83);
  a99=(a99*a171);
  a90=(a88*a90);
  a99=(a99-a90);
  a90=(a85*a171);
  a83=(a88*a84);
  a90=(a90-a83);
  a99=(a99-a90);
  a90=(a103*a99);
  a83=(a107*a21);
  a90=(a90-a83);
  a90=(a99+a90);
  a83=(a109*a90);
  a71=(a89*a30);
  a66=(a79*a117);
  a71=(a71-a66);
  a66=(a108*a71);
  a83=(a83+a66);
  a69=(a69+a83);
  a129=(a129-a69);
  a197=(a197+a129);
  a197=(a72*a197);
  a129=(a106*a30);
  a117=(a117+a30);
  a117=(a79*a117);
  a129=(a129-a117);
  a92=(a92*a171);
  a44=(a88*a44);
  a92=(a92+a44);
  a54=(a85*a54);
  a98=(a98*a84);
  a54=(a54-a98);
  a92=(a92+a54);
  a129=(a129+a92);
  a92=(a27*a171);
  a54=(a85*a92);
  a98=(a111*a84);
  a54=(a54-a98);
  a98=(a85*a171);
  a44=(a88*a84);
  a98=(a98-a44);
  a54=(a54-a98);
  a98=(a99/a102);
  a44=(a113/a102);
  a44=(a44*a17);
  a98=(a98-a44);
  a101=(a101*a98);
  a44=(a113*a17);
  a101=(a101-a44);
  a54=(a54+a101);
  a105=(a105*a54);
  a101=(a112*a178);
  a105=(a105+a101);
  a92=(a88*a92);
  a111=(a111*a171);
  a92=(a92+a111);
  a111=(a85+a85);
  a111=(a111*a84);
  a92=(a92-a111);
  a107=(a107*a98);
  a99=(a113*a99);
  a107=(a107+a99);
  a92=(a92-a107);
  a109=(a109*a92);
  a107=(a115*a71);
  a109=(a109+a107);
  a105=(a105+a109);
  a94=(a94*a98);
  a109=(a113*a32);
  a94=(a94+a109);
  a105=(a105+a94);
  a129=(a129-a105);
  a129=(a80*a129);
  a197=(a197-a129);
  a197=(a197/a116);
  a129=(a72*a41);
  a105=(a80*a54);
  a129=(a129-a105);
  a129=(a72*a129);
  a105=(a72*a90);
  a94=(a80*a92);
  a105=(a105-a94);
  a105=(a80*a105);
  a129=(a129-a105);
  a104=(a104*a129);
  a197=(a197+a104);
  a41=(a80*a41);
  a54=(a72*a54);
  a41=(a41+a54);
  a41=(a72*a41);
  a90=(a80*a90);
  a92=(a72*a92);
  a90=(a90+a92);
  a90=(a80*a90);
  a41=(a41-a90);
  a41=(a41/a116);
  a57=(a57*a129);
  a41=(a41-a57);
  a41=(a60*a41);
  a197=(a197+a41);
  a41=(a4*a197);
  a29=(a29+a41);
  a32=(a32/a102);
  a121=(a121/a102);
  a121=(a121*a17);
  a32=(a32-a121);
  a133=(a133*a21);
  a21=(a72*a197);
  a21=(a21+a178);
  a178=(a103*a21);
  a133=(a133+a178);
  a98=(a135*a98);
  a178=(a80*a197);
  a178=(a178-a71);
  a71=(a113*a178);
  a98=(a98+a71);
  a133=(a133+a98);
  a32=(a32+a133);
  a133=(a59*a32);
  a98=(a131*a133);
  a71=(a5*a12);
  a71=(a55*a71);
  a86=(a86*a71);
  a121=(a130*a86);
  a197=(a59*a197);
  a17=(a58*a197);
  a121=(a121-a17);
  a17=(a136*a121);
  a98=(a98+a17);
  a70=(a27*a70);
  a135=(a135*a171);
  a178=(a88*a178);
  a135=(a135+a178);
  a146=(a146*a84);
  a21=(a21+a32);
  a21=(a85*a21);
  a146=(a146+a21);
  a135=(a135-a146);
  a135=(a135-a62);
  a135=(a23*a135);
  a135=(a135+a32);
  a70=(a70-a135);
  a135=(a59*a70);
  a135=(a0+a135);
  a62=(a135+a133);
  a146=(a145*a62);
  a21=(a5*a123);
  a21=(a0+a21);
  a21=(a55*a21);
  a154=(a154*a21);
  a84=(a144*a154);
  a22=(a22*a71);
  a71=(a130*a22);
  a197=(a120*a197);
  a71=(a71+a197);
  a197=(a71+a133);
  a178=(a142*a197);
  a84=(a84-a178);
  a178=(a141*a121);
  a213=(a213*a21);
  a21=(a131*a213);
  a178=(a178-a21);
  a84=(a84+a178);
  a178=(a95*a84);
  a146=(a146+a178);
  a178=(a95*a84);
  a21=(a145*a62);
  a178=(a178+a21);
  a21=(a23*a178);
  a171=(a145*a135);
  a84=(a147*a84);
  a171=(a171+a84);
  a84=(a27*a171);
  a21=(a21-a84);
  a146=(a146+a21);
  a21=(a141*a146);
  a84=(a151*a213);
  a21=(a21-a84);
  a84=(a162*a154);
  a17=(a161*a62);
  a41=(a144*a213);
  a197=(a141*a197);
  a41=(a41+a197);
  a197=(a131*a154);
  a57=(a142*a121);
  a197=(a197+a57);
  a41=(a41+a197);
  a62=(a41+a62);
  a62=(a95*a62);
  a17=(a17-a62);
  a135=(a159*a135);
  a41=(a147*a41);
  a135=(a135-a41);
  a17=(a17-a135);
  a135=(a142*a17);
  a84=(a84+a135);
  a21=(a21-a84);
  a98=(a98+a21);
  a84=(a136*a121);
  a135=(a131*a133);
  a84=(a84+a135);
  a21=(a21+a84);
  a84=(a165*a21);
  a126=(a126*a154);
  a135=(a27*a213);
  a41=(a141*a135);
  a62=(a163*a213);
  a41=(a41+a62);
  a126=(a126-a41);
  a41=(a126/a128);
  a215=(a215*a126);
  a41=(a41+a215);
  a215=(a168*a41);
  a84=(a84-a215);
  a215=(a153*a41);
  a62=(a165*a126);
  a215=(a215+a62);
  a215=(a126+a215);
  a62=(a174*a215);
  a197=(a131*a133);
  a121=(a136*a121);
  a197=(a197+a121);
  a121=(a132*a197);
  a62=(a62+a121);
  a121=(a163*a154);
  a135=(a142*a135);
  a121=(a121-a135);
  a135=(a141*a154);
  a57=(a142*a213);
  a135=(a135-a57);
  a121=(a121-a135);
  a135=(a165*a121);
  a57=(a179*a41);
  a135=(a135-a57);
  a135=(a121+a135);
  a57=(a140*a135);
  a129=(a143*a133);
  a90=(a136*a71);
  a129=(a129-a90);
  a90=(a181*a129);
  a57=(a57+a90);
  a62=(a62+a57);
  a84=(a84-a62);
  a98=(a98+a84);
  a98=(a120*a98);
  a84=(a166*a22);
  a98=(a98-a84);
  a84=(a176*a86);
  a62=(a167*a133);
  a71=(a71+a133);
  a71=(a136*a71);
  a62=(a62-a71);
  a71=(a151*a154);
  a146=(a142*a146);
  a71=(a71+a146);
  a17=(a141*a17);
  a146=(a162*a213);
  a17=(a17-a146);
  a71=(a71+a17);
  a62=(a62+a71);
  a71=(a27*a154);
  a17=(a141*a71);
  a146=(a180*a213);
  a17=(a17-a146);
  a146=(a141*a154);
  a133=(a142*a213);
  a146=(a146-a133);
  a17=(a17-a146);
  a146=(a121/a128);
  a203=(a203*a126);
  a146=(a146-a203);
  a203=(a153*a146);
  a133=(a184*a126);
  a203=(a203-a133);
  a17=(a17+a203);
  a203=(a174*a17);
  a133=(a183*a197);
  a203=(a203+a133);
  a71=(a142*a71);
  a133=(a180*a154);
  a71=(a71+a133);
  a40=(a40*a213);
  a71=(a71-a40);
  a40=(a179*a146);
  a121=(a184*a121);
  a40=(a40+a121);
  a71=(a71-a40);
  a40=(a140*a71);
  a121=(a186*a129);
  a40=(a40+a121);
  a203=(a203+a40);
  a40=(a168*a146);
  a121=(a184*a21);
  a40=(a40+a121);
  a203=(a203+a40);
  a62=(a62-a203);
  a62=(a58*a62);
  a84=(a84+a62);
  a98=(a98-a84);
  a98=(a98/a187);
  a84=(a120*a215);
  a62=(a132*a22);
  a84=(a84-a62);
  a62=(a183*a86);
  a203=(a58*a17);
  a62=(a62+a203);
  a84=(a84-a62);
  a84=(a120*a84);
  a62=(a185*a22);
  a84=(a84-a62);
  a62=(a120*a135);
  a203=(a181*a22);
  a62=(a62-a203);
  a203=(a186*a86);
  a40=(a58*a71);
  a203=(a203+a40);
  a62=(a62-a203);
  a62=(a58*a62);
  a203=(a188*a86);
  a62=(a62+a203);
  a84=(a84-a62);
  a74=(a74*a84);
  a98=(a98+a74);
  a74=(a132*a86);
  a215=(a58*a215);
  a74=(a74+a215);
  a17=(a120*a17);
  a215=(a183*a22);
  a17=(a17-a215);
  a74=(a74+a17);
  a74=(a120*a74);
  a17=(a164*a22);
  a74=(a74-a17);
  a17=(a181*a86);
  a135=(a58*a135);
  a17=(a17+a135);
  a71=(a120*a71);
  a135=(a186*a22);
  a71=(a71-a135);
  a17=(a17+a71);
  a17=(a58*a17);
  a71=(a122*a86);
  a17=(a17+a71);
  a74=(a74-a17);
  a74=(a74/a187);
  a138=(a138*a84);
  a74=(a74-a138);
  a74=(a60*a74);
  a98=(a98+a74);
  a74=(a4*a98);
  a29=(a29+a74);
  a21=(a21/a128);
  a67=(a67*a126);
  a21=(a21-a67);
  a67=(a60*a86);
  a126=(a192*a22);
  a74=(a120*a98);
  a126=(a126+a74);
  a67=(a67-a126);
  a67=(a67-a197);
  a197=(a165*a67);
  a41=(a191*a41);
  a197=(a197-a41);
  a146=(a172*a146);
  a22=(a60*a22);
  a86=(a192*a86);
  a41=(a58*a98);
  a86=(a86-a41);
  a22=(a22+a86);
  a22=(a22+a129);
  a129=(a184*a22);
  a146=(a146-a129);
  a197=(a197-a146);
  a21=(a21-a197);
  a197=(a2*a21);
  a146=(a61*a197);
  a129=(a56*a32);
  a129=(a2*a129);
  a212=(a212*a129);
  a86=(a11*a212);
  a98=(a2*a98);
  a41=(a182*a98);
  a86=(a86-a41);
  a41=(a198*a86);
  a146=(a146+a41);
  a178=(a27*a178);
  a67=(a67-a21);
  a67=(a141*a67);
  a213=(a65*a213);
  a67=(a67-a213);
  a154=(a172*a154);
  a22=(a142*a22);
  a154=(a154-a22);
  a67=(a67+a154);
  a67=(a67-a171);
  a67=(a23*a67);
  a67=(a67+a21);
  a178=(a178-a67);
  a67=(a2*a178);
  a67=(a0+a67);
  a171=(a67+a197);
  a154=(a177*a171);
  a22=(a56*a70);
  a22=(a0+a22);
  a22=(a2*a22);
  a64=(a64*a22);
  a213=(a119*a64);
  a14=(a14*a129);
  a129=(a11*a14);
  a98=(a134*a98);
  a129=(a129+a98);
  a98=(a129+a197);
  a41=(a196*a98);
  a213=(a213-a41);
  a41=(a169*a86);
  a13=(a13*a22);
  a22=(a61*a13);
  a41=(a41-a22);
  a213=(a213+a41);
  a41=(a63*a213);
  a154=(a154+a41);
  a41=(a63*a213);
  a22=(a177*a171);
  a41=(a41+a22);
  a22=(a23*a41);
  a126=(a177*a67);
  a213=(a158*a213);
  a126=(a126+a213);
  a213=(a27*a126);
  a22=(a22-a213);
  a154=(a154+a22);
  a22=(a169*a154);
  a213=(a199*a13);
  a22=(a22-a213);
  a213=(a206*a64);
  a74=(a205*a171);
  a138=(a119*a13);
  a98=(a169*a98);
  a138=(a138+a98);
  a98=(a61*a64);
  a84=(a196*a86);
  a98=(a98+a84);
  a138=(a138+a98);
  a171=(a138+a171);
  a171=(a63*a171);
  a74=(a74-a171);
  a67=(a155*a67);
  a138=(a158*a138);
  a67=(a67-a138);
  a74=(a74-a67);
  a67=(a196*a74);
  a213=(a213+a67);
  a22=(a22-a213);
  a146=(a146+a22);
  a213=(a198*a86);
  a67=(a61*a197);
  a213=(a213+a67);
  a22=(a22+a213);
  a213=(a118*a22);
  a68=(a68*a64);
  a67=(a27*a13);
  a138=(a169*a67);
  a171=(a207*a13);
  a138=(a138+a171);
  a68=(a68-a138);
  a138=(a68/a149);
  a78=(a78*a68);
  a138=(a138+a78);
  a78=(a38*a138);
  a213=(a213-a78);
  a78=(a209*a138);
  a171=(a118*a68);
  a78=(a78+a171);
  a78=(a68+a78);
  a171=(a216*a78);
  a98=(a61*a197);
  a86=(a198*a86);
  a98=(a98+a86);
  a86=(a152*a98);
  a171=(a171+a86);
  a86=(a207*a64);
  a67=(a196*a67);
  a86=(a86-a67);
  a67=(a169*a64);
  a84=(a196*a13);
  a67=(a67-a84);
  a86=(a86-a67);
  a67=(a118*a86);
  a84=(a221*a138);
  a67=(a67-a84);
  a67=(a86+a67);
  a84=(a202*a67);
  a17=(a148*a197);
  a71=(a198*a129);
  a17=(a17-a71);
  a71=(a223*a17);
  a84=(a84+a71);
  a171=(a171+a84);
  a213=(a213-a171);
  a146=(a146+a213);
  a146=(a134*a146);
  a213=(a210*a14);
  a146=(a146-a213);
  a213=(a218*a212);
  a171=(a211*a197);
  a129=(a129+a197);
  a129=(a198*a129);
  a171=(a171-a129);
  a129=(a199*a64);
  a154=(a196*a154);
  a129=(a129+a154);
  a74=(a169*a74);
  a154=(a206*a13);
  a74=(a74-a154);
  a129=(a129+a74);
  a171=(a171+a129);
  a129=(a27*a64);
  a74=(a169*a129);
  a154=(a222*a13);
  a74=(a74-a154);
  a154=(a169*a64);
  a197=(a196*a13);
  a154=(a154-a197);
  a74=(a74-a154);
  a154=(a86/a149);
  a231=(a231*a68);
  a154=(a154-a231);
  a231=(a209*a154);
  a197=(a226*a68);
  a231=(a231-a197);
  a74=(a74+a231);
  a231=(a216*a74);
  a197=(a225*a98);
  a231=(a231+a197);
  a129=(a196*a129);
  a197=(a222*a64);
  a129=(a129+a197);
  a26=(a26*a13);
  a129=(a129-a26);
  a26=(a221*a154);
  a86=(a226*a86);
  a26=(a26+a86);
  a129=(a129-a26);
  a26=(a202*a129);
  a86=(a228*a17);
  a26=(a26+a86);
  a231=(a231+a26);
  a26=(a38*a154);
  a86=(a226*a22);
  a26=(a26+a86);
  a231=(a231+a26);
  a171=(a171-a231);
  a171=(a182*a171);
  a213=(a213+a171);
  a146=(a146-a213);
  a146=(a146/a49);
  a213=(a134*a78);
  a171=(a152*a14);
  a213=(a213-a171);
  a171=(a225*a212);
  a231=(a182*a74);
  a171=(a171+a231);
  a213=(a213-a171);
  a213=(a134*a213);
  a171=(a227*a14);
  a213=(a213-a171);
  a171=(a134*a67);
  a231=(a223*a14);
  a171=(a171-a231);
  a231=(a228*a212);
  a26=(a182*a129);
  a231=(a231+a26);
  a171=(a171-a231);
  a171=(a182*a171);
  a231=(a230*a212);
  a171=(a171+a231);
  a213=(a213-a171);
  a75=(a75*a213);
  a146=(a146+a75);
  a75=(a152*a212);
  a78=(a182*a78);
  a75=(a75+a78);
  a74=(a134*a74);
  a78=(a225*a14);
  a74=(a74-a78);
  a75=(a75+a74);
  a75=(a134*a75);
  a74=(a208*a14);
  a75=(a75-a74);
  a74=(a223*a212);
  a67=(a182*a67);
  a74=(a74+a67);
  a129=(a134*a129);
  a67=(a228*a14);
  a129=(a129-a67);
  a74=(a74+a129);
  a74=(a182*a74);
  a129=(a201*a212);
  a74=(a74+a129);
  a75=(a75-a74);
  a75=(a75/a49);
  a193=(a193*a213);
  a75=(a75-a193);
  a75=(a60*a75);
  a146=(a146+a75);
  a29=(a29+a146);
  a29=(a3*a29);
  a29=(a2*a29);
  a29=(-a29);
  if (res[4]!=0) res[4][6]=a29;
  a32=(a4*a32);
  a12=(a12+a32);
  a21=(a4*a21);
  a12=(a12+a21);
  a22=(a22/a149);
  a204=(a204*a68);
  a22=(a22-a204);
  a204=(a60*a212);
  a68=(a53*a14);
  a21=(a134*a146);
  a68=(a68+a21);
  a204=(a204-a68);
  a204=(a204-a98);
  a98=(a118*a204);
  a138=(a220*a138);
  a98=(a98-a138);
  a154=(a214*a154);
  a14=(a60*a14);
  a212=(a53*a212);
  a146=(a182*a146);
  a212=(a212-a146);
  a14=(a14+a212);
  a14=(a14+a17);
  a17=(a226*a14);
  a154=(a154-a17);
  a98=(a98-a154);
  a22=(a22-a98);
  a12=(a12+a22);
  a12=(a3*a12);
  a12=(a2*a12);
  if (res[4]!=0) res[4][7]=a12;
  a70=(a4*a70);
  a123=(a123+a70);
  a178=(a4*a178);
  a123=(a123+a178);
  a41=(a27*a41);
  a204=(a204-a22);
  a204=(a169*a204);
  a13=(a139*a13);
  a204=(a204-a13);
  a64=(a214*a64);
  a14=(a196*a14);
  a64=(a64-a14);
  a204=(a204+a64);
  a204=(a204-a126);
  a204=(a23*a204);
  a204=(a204+a22);
  a41=(a41-a204);
  a123=(a123+a41);
  a123=(a3*a123);
  a123=(a2*a123);
  a123=(a0+a123);
  if (res[4]!=0) res[4][8]=a123;
  a123=(1./a52);
  a41=(a73/a52);
  a204=(a80*a41);
  a22=(a79*a204);
  a126=(a8/a52);
  a64=(a37*a126);
  a14=(a10/a52);
  a13=(a48*a14);
  a64=(a64+a13);
  a13=(a73*a64);
  a178=(a82*a13);
  a22=(a22-a178);
  a41=(a72*a41);
  a178=(a41+a13);
  a70=(a88*a178);
  a12=(a85*a204);
  a70=(a70+a12);
  a12=(a28*a70);
  a126=(a126+a64);
  a126=(a15*a126);
  a14=(a18*a14);
  a126=(a126-a14);
  a126=(a23*a126);
  a126=(a126-a64);
  a14=(a73*a126);
  a98=(a14+a13);
  a154=(a91*a98);
  a12=(a12-a154);
  a154=(a28*a70);
  a17=(a91*a98);
  a154=(a154-a17);
  a17=(a23*a154);
  a70=(a87*a70);
  a212=(a91*a14);
  a70=(a70-a212);
  a212=(a27*a70);
  a17=(a17-a212);
  a12=(a12+a17);
  a17=(a85*a12);
  a178=(a85*a178);
  a212=(a88*a204);
  a178=(a178-a212);
  a212=(a178+a98);
  a212=(a28*a212);
  a98=(a97*a98);
  a212=(a212-a98);
  a178=(a87*a178);
  a14=(a96*a14);
  a178=(a178-a14);
  a212=(a212-a178);
  a178=(a88*a212);
  a17=(a17-a178);
  a22=(a22+a17);
  a178=(a79*a204);
  a14=(a82*a13);
  a178=(a178-a14);
  a17=(a17+a178);
  a178=(a103*a17);
  a204=(a79*a204);
  a14=(a82*a13);
  a204=(a204-a14);
  a14=(a100*a204);
  a98=(a79*a41);
  a146=(a89*a13);
  a98=(a98-a146);
  a146=(a108*a98);
  a14=(a14+a146);
  a178=(a178-a14);
  a22=(a22+a178);
  a22=(a72*a22);
  a41=(a41+a13);
  a41=(a79*a41);
  a13=(a106*a13);
  a41=(a41-a13);
  a12=(a88*a12);
  a212=(a85*a212);
  a12=(a12+a212);
  a41=(a41+a12);
  a12=(a112*a204);
  a212=(a115*a98);
  a12=(a12+a212);
  a212=(a113*a17);
  a12=(a12+a212);
  a41=(a41-a12);
  a41=(a80*a41);
  a22=(a22-a41);
  a22=(a0-a22);
  a22=(a22/a116);
  a41=(a4*a22);
  a123=(a123+a41);
  a41=sin(a77);
  a12=(a5*a64);
  a12=(a55*a12);
  a212=(a41*a12);
  a13=(a166*a212);
  a17=(a17/a102);
  a178=(a72*a22);
  a178=(a178-a204);
  a204=(a103*a178);
  a14=(a80*a22);
  a14=(a14+a98);
  a98=(a113*a14);
  a204=(a204+a98);
  a17=(a17-a204);
  a204=(a59*a17);
  a98=(a131*a204);
  a22=(a59*a22);
  a146=(a58*a22);
  a77=cos(a77);
  a12=(a77*a12);
  a138=(a130*a12);
  a146=(a146-a138);
  a138=(a136*a146);
  a98=(a98+a138);
  a138=sin(a25);
  a68=(a5*a126);
  a68=(a55*a68);
  a21=(a138*a68);
  a32=(a151*a21);
  a154=(a27*a154);
  a178=(a178-a17);
  a178=(a85*a178);
  a14=(a88*a14);
  a178=(a178-a14);
  a178=(a178-a70);
  a178=(a23*a178);
  a178=(a178+a17);
  a154=(a154-a178);
  a178=(a59*a154);
  a70=(a178+a204);
  a14=(a145*a70);
  a29=(a130*a212);
  a22=(a120*a22);
  a29=(a29+a22);
  a22=(a29-a204);
  a75=(a142*a22);
  a25=cos(a25);
  a68=(a25*a68);
  a193=(a144*a68);
  a75=(a75-a193);
  a193=(a131*a21);
  a213=(a141*a146);
  a193=(a193+a213);
  a75=(a75+a193);
  a193=(a95*a75);
  a14=(a14+a193);
  a193=(a95*a75);
  a213=(a145*a70);
  a193=(a193+a213);
  a213=(a23*a193);
  a74=(a145*a178);
  a75=(a147*a75);
  a74=(a74+a75);
  a75=(a27*a74);
  a213=(a213-a75);
  a14=(a14+a213);
  a213=(a141*a14);
  a32=(a32+a213);
  a213=(a161*a70);
  a75=(a144*a21);
  a22=(a141*a22);
  a75=(a75+a22);
  a22=(a142*a146);
  a129=(a131*a68);
  a22=(a22-a129);
  a75=(a75-a22);
  a70=(a75-a70);
  a70=(a95*a70);
  a213=(a213+a70);
  a178=(a159*a178);
  a75=(a147*a75);
  a178=(a178+a75);
  a213=(a213-a178);
  a178=(a142*a213);
  a75=(a162*a68);
  a178=(a178-a75);
  a32=(a32-a178);
  a98=(a98+a32);
  a178=(a136*a146);
  a75=(a131*a204);
  a178=(a178+a75);
  a32=(a32+a178);
  a178=(a165*a32);
  a75=(a27*a21);
  a70=(a141*a75);
  a22=(a163*a21);
  a70=(a70+a22);
  a22=(a142+a142);
  a129=(a22*a68);
  a70=(a70-a129);
  a129=(a70/a128);
  a67=(a165/a128);
  a78=(a67*a70);
  a129=(a129+a78);
  a78=(a168*a129);
  a178=(a178-a78);
  a78=(a153*a129);
  a171=(a165*a70);
  a78=(a78+a171);
  a78=(a70+a78);
  a171=(a174*a78);
  a231=(a131*a204);
  a146=(a136*a146);
  a231=(a231+a146);
  a146=(a132*a231);
  a171=(a171+a146);
  a75=(a142*a75);
  a146=(a163*a68);
  a75=(a75-a146);
  a146=(a142*a21);
  a26=(a141*a68);
  a146=(a146-a26);
  a75=(a75-a146);
  a146=(a165*a75);
  a26=(a179*a129);
  a146=(a146-a26);
  a146=(a75+a146);
  a26=(a140*a146);
  a86=(a143*a204);
  a197=(a136*a29);
  a86=(a86+a197);
  a197=(a181*a86);
  a26=(a26+a197);
  a171=(a171+a26);
  a178=(a178-a171);
  a98=(a98+a178);
  a98=(a120*a98);
  a13=(a13+a98);
  a98=(a167*a204);
  a29=(a29-a204);
  a29=(a136*a29);
  a98=(a98+a29);
  a14=(a142*a14);
  a29=(a151*a68);
  a14=(a14-a29);
  a29=(a162*a21);
  a213=(a141*a213);
  a29=(a29+a213);
  a14=(a14+a29);
  a98=(a98+a14);
  a14=(a180*a21);
  a29=(a27*a68);
  a213=(a141*a29);
  a14=(a14-a213);
  a213=(a142*a21);
  a204=(a141*a68);
  a213=(a213-a204);
  a14=(a14-a213);
  a213=(a75/a128);
  a204=(a184/a128);
  a178=(a204*a70);
  a213=(a213-a178);
  a178=(a153*a213);
  a171=(a184*a70);
  a178=(a178-a171);
  a14=(a14+a178);
  a178=(a174*a14);
  a171=(a183*a231);
  a178=(a178+a171);
  a171=(a141+a141);
  a26=(a171*a21);
  a29=(a142*a29);
  a197=(a180*a68);
  a29=(a29+a197);
  a26=(a26-a29);
  a29=(a179*a213);
  a75=(a184*a75);
  a29=(a29+a75);
  a26=(a26-a29);
  a29=(a140*a26);
  a75=(a186*a86);
  a29=(a29+a75);
  a178=(a178+a29);
  a29=(a168*a213);
  a75=(a184*a32);
  a29=(a29+a75);
  a178=(a178+a29);
  a98=(a98-a178);
  a98=(a58*a98);
  a178=(a176*a12);
  a98=(a98-a178);
  a13=(a13-a98);
  a13=(a0-a13);
  a13=(a13/a187);
  a190=(a190/a187);
  a98=(a132*a212);
  a178=(a120*a78);
  a98=(a98+a178);
  a178=(a58*a14);
  a29=(a183*a12);
  a178=(a178-a29);
  a98=(a98-a178);
  a98=(a120*a98);
  a178=(a185*a212);
  a98=(a98+a178);
  a178=(a181*a212);
  a29=(a120*a146);
  a178=(a178+a29);
  a29=(a58*a26);
  a75=(a186*a12);
  a29=(a29-a75);
  a178=(a178-a29);
  a178=(a58*a178);
  a29=(a188*a12);
  a178=(a178-a29);
  a98=(a98-a178);
  a178=(a190*a98);
  a13=(a13-a178);
  a78=(a58*a78);
  a178=(a132*a12);
  a78=(a78-a178);
  a178=(a183*a212);
  a14=(a120*a14);
  a178=(a178+a14);
  a78=(a78+a178);
  a78=(a120*a78);
  a178=(a164*a212);
  a78=(a78+a178);
  a146=(a58*a146);
  a178=(a181*a12);
  a146=(a146-a178);
  a178=(a186*a212);
  a26=(a120*a26);
  a178=(a178+a26);
  a146=(a146+a178);
  a146=(a58*a146);
  a178=(a122*a12);
  a146=(a146-a178);
  a78=(a78-a146);
  a78=(a78/a187);
  a175=(a175/a187);
  a98=(a175*a98);
  a78=(a78-a98);
  a78=(a60*a78);
  a13=(a13-a78);
  a78=(a4*a13);
  a123=(a123+a78);
  a32=(a32/a128);
  a127=(a127/a128);
  a70=(a127*a70);
  a32=(a32-a70);
  a70=(a192*a212);
  a78=(a120*a13);
  a70=(a70+a78);
  a78=(a60*a12);
  a70=(a70-a78);
  a70=(a70-a231);
  a231=(a165*a70);
  a129=(a191*a129);
  a231=(a231-a129);
  a213=(a172*a213);
  a212=(a60*a212);
  a129=(a58*a13);
  a12=(a192*a12);
  a129=(a129-a12);
  a212=(a212-a129);
  a212=(a212-a86);
  a86=(a184*a212);
  a213=(a213+a86);
  a231=(a231-a213);
  a32=(a32-a231);
  a231=(a2*a32);
  a213=(a61*a231);
  a86=cos(a7);
  a129=(a56*a17);
  a129=(a2*a129);
  a12=(a86*a129);
  a78=(a11*a12);
  a13=(a2*a13);
  a98=(a182*a13);
  a78=(a78+a98);
  a98=(a198*a78);
  a213=(a213+a98);
  a193=(a27*a193);
  a21=(a65*a21);
  a70=(a70-a32);
  a70=(a141*a70);
  a21=(a21+a70);
  a212=(a142*a212);
  a68=(a172*a68);
  a212=(a212-a68);
  a21=(a21+a212);
  a21=(a21-a74);
  a21=(a23*a21);
  a21=(a21+a32);
  a193=(a193-a21);
  a21=(a2*a193);
  a74=(a21+a231);
  a212=(a177*a74);
  a68=cos(a93);
  a70=(a56*a154);
  a70=(a2*a70);
  a98=(a68*a70);
  a146=(a119*a98);
  a13=(a134*a13);
  a7=sin(a7);
  a129=(a7*a129);
  a178=(a11*a129);
  a13=(a13-a178);
  a178=(a13-a231);
  a26=(a196*a178);
  a146=(a146+a26);
  a26=(a169*a78);
  a93=sin(a93);
  a70=(a93*a70);
  a14=(a61*a70);
  a26=(a26-a14);
  a146=(a146+a26);
  a26=(a63*a146);
  a212=(a212+a26);
  a26=(a63*a146);
  a14=(a177*a74);
  a26=(a26+a14);
  a14=(a23*a26);
  a29=(a177*a21);
  a146=(a158*a146);
  a29=(a29+a146);
  a146=(a27*a29);
  a14=(a14-a146);
  a212=(a212+a14);
  a14=(a169*a212);
  a146=(a199*a70);
  a14=(a14-a146);
  a146=(a206*a98);
  a75=(a205*a74);
  a178=(a169*a178);
  a197=(a119*a70);
  a178=(a178-a197);
  a197=(a61*a98);
  a84=(a196*a78);
  a197=(a197+a84);
  a178=(a178-a197);
  a74=(a178-a74);
  a74=(a63*a74);
  a75=(a75+a74);
  a21=(a155*a21);
  a178=(a158*a178);
  a21=(a21+a178);
  a75=(a75-a21);
  a21=(a196*a75);
  a146=(a146+a21);
  a14=(a14-a146);
  a213=(a213+a14);
  a146=(a198*a78);
  a21=(a61*a231);
  a146=(a146+a21);
  a14=(a14+a146);
  a146=(a118*a14);
  a21=(a196+a196);
  a178=(a21*a98);
  a74=(a27*a70);
  a197=(a169*a74);
  a84=(a207*a70);
  a197=(a197+a84);
  a178=(a178-a197);
  a197=(a178/a149);
  a84=(a118/a149);
  a71=(a84*a178);
  a197=(a197+a71);
  a71=(a38*a197);
  a146=(a146-a71);
  a71=(a209*a197);
  a135=(a118*a178);
  a71=(a71+a135);
  a71=(a178+a71);
  a135=(a216*a71);
  a215=(a61*a231);
  a78=(a198*a78);
  a215=(a215+a78);
  a78=(a152*a215);
  a135=(a135+a78);
  a78=(a207*a98);
  a74=(a196*a74);
  a78=(a78-a74);
  a74=(a169*a98);
  a62=(a196*a70);
  a74=(a74-a62);
  a78=(a78-a74);
  a74=(a118*a78);
  a62=(a221*a197);
  a74=(a74-a62);
  a74=(a78+a74);
  a62=(a202*a74);
  a203=(a148*a231);
  a40=(a198*a13);
  a203=(a203+a40);
  a40=(a223*a203);
  a62=(a62+a40);
  a135=(a135+a62);
  a146=(a146-a135);
  a213=(a213+a146);
  a213=(a134*a213);
  a146=(a210*a129);
  a213=(a213-a146);
  a146=(a218*a12);
  a135=(a211*a231);
  a13=(a13-a231);
  a13=(a198*a13);
  a135=(a135+a13);
  a13=(a199*a98);
  a212=(a196*a212);
  a13=(a13+a212);
  a75=(a169*a75);
  a212=(a206*a70);
  a75=(a75-a212);
  a13=(a13+a75);
  a135=(a135+a13);
  a13=(a27*a98);
  a75=(a169*a13);
  a212=(a222*a70);
  a75=(a75-a212);
  a212=(a169*a98);
  a231=(a196*a70);
  a212=(a212-a231);
  a75=(a75-a212);
  a212=(a78/a149);
  a231=(a226/a149);
  a62=(a231*a178);
  a212=(a212-a62);
  a62=(a209*a212);
  a40=(a226*a178);
  a62=(a62-a40);
  a75=(a75+a62);
  a62=(a216*a75);
  a40=(a225*a215);
  a62=(a62+a40);
  a13=(a196*a13);
  a40=(a222*a98);
  a13=(a13+a40);
  a40=(a169+a169);
  a121=(a40*a70);
  a13=(a13-a121);
  a121=(a221*a212);
  a78=(a226*a78);
  a121=(a121+a78);
  a13=(a13-a121);
  a121=(a202*a13);
  a78=(a228*a203);
  a121=(a121+a78);
  a62=(a62+a121);
  a121=(a38*a212);
  a78=(a226*a14);
  a121=(a121+a78);
  a62=(a62+a121);
  a135=(a135-a62);
  a135=(a182*a135);
  a146=(a146+a135);
  a213=(a213-a146);
  a213=(a0-a213);
  a213=(a213/a49);
  a6=(a6/a49);
  a146=(a134*a71);
  a135=(a152*a129);
  a146=(a146-a135);
  a135=(a225*a12);
  a62=(a182*a75);
  a135=(a135+a62);
  a146=(a146-a135);
  a146=(a134*a146);
  a135=(a227*a129);
  a146=(a146-a135);
  a135=(a134*a74);
  a62=(a223*a129);
  a135=(a135-a62);
  a62=(a228*a12);
  a121=(a182*a13);
  a62=(a62+a121);
  a135=(a135-a62);
  a135=(a182*a135);
  a62=(a230*a12);
  a135=(a135+a62);
  a146=(a146-a135);
  a135=(a6*a146);
  a213=(a213-a135);
  a135=(a152*a12);
  a71=(a182*a71);
  a135=(a135+a71);
  a75=(a134*a75);
  a71=(a225*a129);
  a75=(a75-a71);
  a135=(a135+a75);
  a135=(a134*a135);
  a75=(a208*a129);
  a135=(a135-a75);
  a75=(a223*a12);
  a74=(a182*a74);
  a75=(a75+a74);
  a13=(a134*a13);
  a74=(a228*a129);
  a13=(a13-a74);
  a75=(a75+a13);
  a75=(a182*a75);
  a13=(a201*a12);
  a75=(a75+a13);
  a135=(a135-a75);
  a135=(a135/a49);
  a217=(a217/a49);
  a146=(a217*a146);
  a135=(a135-a146);
  a135=(a60*a135);
  a213=(a213-a135);
  a123=(a123+a213);
  a123=(a3*a123);
  a123=(a2*a123);
  if (res[5]!=0) res[5][0]=a123;
  a17=(a4*a17);
  a17=(a17-a64);
  a32=(a4*a32);
  a17=(a17+a32);
  a14=(a14/a149);
  a157=(a157/a149);
  a178=(a157*a178);
  a14=(a14-a178);
  a178=(a134*a213);
  a32=(a53*a129);
  a178=(a178-a32);
  a32=(a60*a12);
  a178=(a178+a32);
  a178=(a178-a215);
  a215=(a118*a178);
  a197=(a220*a197);
  a215=(a215-a197);
  a212=(a214*a212);
  a129=(a60*a129);
  a12=(a53*a12);
  a213=(a182*a213);
  a12=(a12+a213);
  a129=(a129+a12);
  a129=(a129+a203);
  a203=(a226*a129);
  a212=(a212-a203);
  a215=(a215-a212);
  a14=(a14-a215);
  a17=(a17+a14);
  a17=(a3*a17);
  a17=(a2*a17);
  if (res[5]!=0) res[5][1]=a17;
  a154=(a4*a154);
  a154=(a154-a126);
  a193=(a4*a193);
  a154=(a154+a193);
  a26=(a27*a26);
  a178=(a178-a14);
  a178=(a169*a178);
  a70=(a139*a70);
  a178=(a178-a70);
  a98=(a214*a98);
  a129=(a196*a129);
  a98=(a98-a129);
  a178=(a178+a98);
  a178=(a178-a29);
  a178=(a23*a178);
  a178=(a178+a14);
  a26=(a26-a178);
  a154=(a154+a26);
  a154=(a3*a154);
  a154=(a2*a154);
  if (res[5]!=0) res[5][2]=a154;
  a154=(a8*a37);
  a26=(a10*a48);
  a154=(a154+a26);
  a154=(a154/a52);
  a26=(1./a36);
  a178=(a8*a154);
  a14=(a37*a178);
  a29=(a10*a154);
  a98=(a48*a29);
  a14=(a14+a98);
  a26=(a26+a14);
  a14=(a73*a26);
  a98=(a82*a14);
  a129=(a73*a154);
  a70=(a80*a129);
  a193=(a79*a70);
  a98=(a98-a193);
  a29=(a18*a29);
  a178=(a178+a26);
  a178=(a15*a178);
  a29=(a29-a178);
  a29=(a23*a29);
  a29=(a29+a26);
  a178=(a73*a29);
  a193=(a14-a178);
  a126=(a91*a193);
  a129=(a72*a129);
  a17=(a129+a14);
  a215=(a88*a17);
  a212=(a85*a70);
  a215=(a215+a212);
  a212=(a28*a215);
  a126=(a126-a212);
  a212=(a91*a193);
  a203=(a28*a215);
  a212=(a212-a203);
  a203=(a23*a212);
  a12=(a91*a178);
  a215=(a87*a215);
  a12=(a12+a215);
  a215=(a27*a12);
  a203=(a203+a215);
  a126=(a126+a203);
  a203=(a85*a126);
  a215=(a97*a193);
  a213=(a88*a70);
  a17=(a85*a17);
  a213=(a213-a17);
  a193=(a213-a193);
  a193=(a28*a193);
  a215=(a215+a193);
  a213=(a87*a213);
  a178=(a96*a178);
  a213=(a213-a178);
  a215=(a215-a213);
  a213=(a88*a215);
  a203=(a203-a213);
  a98=(a98+a203);
  a213=(a82*a14);
  a178=(a79*a70);
  a213=(a213-a178);
  a203=(a203+a213);
  a203=(a0+a203);
  a213=(a103*a203);
  a178=(a82*a14);
  a70=(a79*a70);
  a178=(a178-a70);
  a70=(a100*a178);
  a193=(a89*a14);
  a17=(a79*a129);
  a193=(a193-a17);
  a17=(a108*a193);
  a70=(a70+a17);
  a213=(a213-a70);
  a98=(a98+a213);
  a98=(a72*a98);
  a213=(a106*a14);
  a129=(a129+a14);
  a129=(a79*a129);
  a213=(a213-a129);
  a126=(a88*a126);
  a215=(a85*a215);
  a126=(a126+a215);
  a213=(a213+a126);
  a126=(a112*a178);
  a215=(a115*a193);
  a126=(a126+a215);
  a215=(a113*a203);
  a126=(a126+a215);
  a213=(a213-a126);
  a213=(a80*a213);
  a98=(a98-a213);
  a98=(a98/a116);
  a213=(a4*a98);
  a154=(a154+a213);
  a203=(a203/a102);
  a213=(a72*a98);
  a213=(a213+a178);
  a178=(a103*a213);
  a126=(a80*a98);
  a126=(a126-a193);
  a193=(a113*a126);
  a178=(a178+a193);
  a203=(a203+a178);
  a178=(a59*a203);
  a193=(a131*a178);
  a215=(a5*a26);
  a215=(a55*a215);
  a129=(a77*a215);
  a14=(a130*a129);
  a98=(a59*a98);
  a70=(a58*a98);
  a14=(a14-a70);
  a70=(a136*a14);
  a193=(a193+a70);
  a70=(a5*a29);
  a70=(a55*a70);
  a17=(a138*a70);
  a197=(a151*a17);
  a212=(a27*a212);
  a126=(a88*a126);
  a213=(a213+a203);
  a213=(a85*a213);
  a126=(a126-a213);
  a126=(a126+a12);
  a126=(a23*a126);
  a126=(a126+a203);
  a212=(a212-a126);
  a126=(a59*a212);
  a12=(a126+a178);
  a213=(a145*a12);
  a32=(a131*a17);
  a64=(a141*a14);
  a32=(a32+a64);
  a70=(a25*a70);
  a64=(a144*a70);
  a215=(a41*a215);
  a123=(a130*a215);
  a98=(a120*a98);
  a123=(a123+a98);
  a98=(a123+a178);
  a135=(a142*a98);
  a64=(a64+a135);
  a32=(a32-a64);
  a64=(a95*a32);
  a213=(a213+a64);
  a64=(a95*a32);
  a135=(a145*a12);
  a64=(a64+a135);
  a135=(a23*a64);
  a146=(a145*a126);
  a32=(a147*a32);
  a146=(a146+a32);
  a32=(a27*a146);
  a135=(a135-a32);
  a213=(a213+a135);
  a135=(a141*a213);
  a197=(a197+a135);
  a135=(a161*a12);
  a32=(a144*a17);
  a98=(a141*a98);
  a32=(a32-a98);
  a98=(a142*a14);
  a75=(a131*a70);
  a98=(a98-a75);
  a32=(a32-a98);
  a12=(a32-a12);
  a12=(a95*a12);
  a135=(a135+a12);
  a126=(a159*a126);
  a32=(a147*a32);
  a126=(a126+a32);
  a135=(a135-a126);
  a126=(a142*a135);
  a32=(a162*a70);
  a126=(a126-a32);
  a197=(a197-a126);
  a193=(a193+a197);
  a126=(a136*a14);
  a32=(a131*a178);
  a126=(a126+a32);
  a197=(a197+a126);
  a197=(a0+a197);
  a126=(a165*a197);
  a32=(a27*a17);
  a12=(a141*a32);
  a98=(a163*a17);
  a12=(a12+a98);
  a98=(a22*a70);
  a12=(a12-a98);
  a98=(a12/a128);
  a75=(a67*a12);
  a98=(a98+a75);
  a75=(a168*a98);
  a126=(a126-a75);
  a75=(a153*a98);
  a13=(a165*a12);
  a75=(a75+a13);
  a75=(a12+a75);
  a13=(a174*a75);
  a74=(a131*a178);
  a14=(a136*a14);
  a74=(a74+a14);
  a14=(a132*a74);
  a13=(a13+a14);
  a32=(a142*a32);
  a14=(a163*a70);
  a32=(a32-a14);
  a14=(a142*a17);
  a71=(a141*a70);
  a14=(a14-a71);
  a32=(a32-a14);
  a14=(a165*a32);
  a71=(a179*a98);
  a14=(a14-a71);
  a14=(a32+a14);
  a71=(a140*a14);
  a62=(a143*a178);
  a121=(a136*a123);
  a62=(a62-a121);
  a121=(a181*a62);
  a71=(a71+a121);
  a13=(a13+a71);
  a126=(a126-a13);
  a193=(a193+a126);
  a193=(a120*a193);
  a126=(a166*a215);
  a193=(a193-a126);
  a126=(a176*a129);
  a13=(a167*a178);
  a123=(a123+a178);
  a123=(a136*a123);
  a13=(a13-a123);
  a213=(a142*a213);
  a123=(a151*a70);
  a213=(a213-a123);
  a123=(a162*a17);
  a135=(a141*a135);
  a123=(a123+a135);
  a213=(a213+a123);
  a13=(a13+a213);
  a213=(a180*a17);
  a123=(a27*a70);
  a135=(a141*a123);
  a213=(a213-a135);
  a135=(a142*a17);
  a178=(a141*a70);
  a135=(a135-a178);
  a213=(a213-a135);
  a135=(a32/a128);
  a178=(a204*a12);
  a135=(a135-a178);
  a178=(a153*a135);
  a71=(a184*a12);
  a178=(a178-a71);
  a213=(a213+a178);
  a178=(a174*a213);
  a71=(a183*a74);
  a178=(a178+a71);
  a71=(a171*a17);
  a123=(a142*a123);
  a121=(a180*a70);
  a123=(a123+a121);
  a71=(a71-a123);
  a123=(a179*a135);
  a32=(a184*a32);
  a123=(a123+a32);
  a71=(a71-a123);
  a123=(a140*a71);
  a32=(a186*a62);
  a123=(a123+a32);
  a178=(a178+a123);
  a123=(a168*a135);
  a32=(a184*a197);
  a123=(a123+a32);
  a178=(a178+a123);
  a13=(a13-a178);
  a13=(a58*a13);
  a126=(a126+a13);
  a193=(a193-a126);
  a193=(a193/a187);
  a126=(a120*a75);
  a13=(a132*a215);
  a126=(a126-a13);
  a13=(a183*a129);
  a178=(a58*a213);
  a13=(a13+a178);
  a126=(a126-a13);
  a126=(a120*a126);
  a13=(a185*a215);
  a126=(a126-a13);
  a13=(a120*a14);
  a178=(a181*a215);
  a13=(a13-a178);
  a178=(a186*a129);
  a123=(a58*a71);
  a178=(a178+a123);
  a13=(a13-a178);
  a13=(a58*a13);
  a178=(a188*a129);
  a13=(a13+a178);
  a126=(a126-a13);
  a13=(a190*a126);
  a193=(a193+a13);
  a13=(a132*a129);
  a75=(a58*a75);
  a13=(a13+a75);
  a213=(a120*a213);
  a75=(a183*a215);
  a213=(a213-a75);
  a13=(a13+a213);
  a13=(a120*a13);
  a213=(a164*a215);
  a13=(a13-a213);
  a213=(a181*a129);
  a14=(a58*a14);
  a213=(a213+a14);
  a71=(a120*a71);
  a14=(a186*a215);
  a71=(a71-a14);
  a213=(a213+a71);
  a213=(a58*a213);
  a71=(a122*a129);
  a213=(a213+a71);
  a13=(a13-a213);
  a13=(a13/a187);
  a126=(a175*a126);
  a13=(a13-a126);
  a13=(a60*a13);
  a193=(a193+a13);
  a13=(a4*a193);
  a154=(a154+a13);
  a197=(a197/a128);
  a12=(a127*a12);
  a197=(a197-a12);
  a12=(a60*a129);
  a13=(a192*a215);
  a126=(a120*a193);
  a13=(a13+a126);
  a12=(a12-a13);
  a12=(a12-a74);
  a74=(a165*a12);
  a98=(a191*a98);
  a74=(a74-a98);
  a135=(a172*a135);
  a215=(a60*a215);
  a129=(a192*a129);
  a98=(a58*a193);
  a129=(a129-a98);
  a215=(a215+a129);
  a215=(a215+a62);
  a62=(a184*a215);
  a135=(a135-a62);
  a74=(a74-a135);
  a197=(a197-a74);
  a74=(a2*a197);
  a135=(a61*a74);
  a62=(a56*a203);
  a62=(a2*a62);
  a129=(a86*a62);
  a98=(a11*a129);
  a193=(a2*a193);
  a13=(a182*a193);
  a98=(a98-a13);
  a13=(a198*a98);
  a135=(a135+a13);
  a64=(a27*a64);
  a17=(a65*a17);
  a12=(a12-a197);
  a12=(a141*a12);
  a17=(a17+a12);
  a70=(a172*a70);
  a215=(a142*a215);
  a70=(a70+a215);
  a17=(a17-a70);
  a17=(a17-a146);
  a17=(a23*a17);
  a17=(a17+a197);
  a64=(a64-a17);
  a17=(a2*a64);
  a146=(a17+a74);
  a70=(a177*a146);
  a215=(a56*a212);
  a215=(a2*a215);
  a12=(a68*a215);
  a13=(a119*a12);
  a62=(a7*a62);
  a126=(a11*a62);
  a193=(a134*a193);
  a126=(a126+a193);
  a193=(a126+a74);
  a213=(a196*a193);
  a13=(a13-a213);
  a213=(a169*a98);
  a215=(a93*a215);
  a71=(a61*a215);
  a213=(a213-a71);
  a13=(a13+a213);
  a213=(a63*a13);
  a70=(a70+a213);
  a213=(a63*a13);
  a71=(a177*a146);
  a213=(a213+a71);
  a71=(a23*a213);
  a14=(a177*a17);
  a13=(a158*a13);
  a14=(a14+a13);
  a13=(a27*a14);
  a71=(a71-a13);
  a70=(a70+a71);
  a71=(a169*a70);
  a13=(a199*a215);
  a71=(a71-a13);
  a13=(a206*a12);
  a75=(a205*a146);
  a178=(a119*a215);
  a193=(a169*a193);
  a178=(a178+a193);
  a193=(a61*a12);
  a123=(a196*a98);
  a193=(a193+a123);
  a178=(a178+a193);
  a146=(a178+a146);
  a146=(a63*a146);
  a75=(a75-a146);
  a17=(a155*a17);
  a178=(a158*a178);
  a17=(a17-a178);
  a75=(a75-a17);
  a17=(a196*a75);
  a13=(a13+a17);
  a71=(a71-a13);
  a135=(a135+a71);
  a13=(a198*a98);
  a17=(a61*a74);
  a13=(a13+a17);
  a71=(a71+a13);
  a71=(a0+a71);
  a13=(a118*a71);
  a17=(a21*a12);
  a178=(a27*a215);
  a146=(a169*a178);
  a193=(a207*a215);
  a146=(a146+a193);
  a17=(a17-a146);
  a146=(a17/a149);
  a193=(a84*a17);
  a146=(a146+a193);
  a193=(a38*a146);
  a13=(a13-a193);
  a193=(a209*a146);
  a123=(a118*a17);
  a193=(a193+a123);
  a193=(a17+a193);
  a123=(a216*a193);
  a32=(a61*a74);
  a98=(a198*a98);
  a32=(a32+a98);
  a98=(a152*a32);
  a123=(a123+a98);
  a98=(a207*a12);
  a178=(a196*a178);
  a98=(a98-a178);
  a178=(a169*a12);
  a121=(a196*a215);
  a178=(a178-a121);
  a98=(a98-a178);
  a178=(a118*a98);
  a121=(a221*a146);
  a178=(a178-a121);
  a178=(a98+a178);
  a121=(a202*a178);
  a78=(a148*a74);
  a133=(a198*a126);
  a78=(a78-a133);
  a133=(a223*a78);
  a121=(a121+a133);
  a123=(a123+a121);
  a13=(a13-a123);
  a135=(a135+a13);
  a135=(a134*a135);
  a13=(a210*a62);
  a135=(a135-a13);
  a13=(a218*a129);
  a123=(a211*a74);
  a126=(a126+a74);
  a126=(a198*a126);
  a123=(a123-a126);
  a126=(a199*a12);
  a70=(a196*a70);
  a126=(a126+a70);
  a75=(a169*a75);
  a70=(a206*a215);
  a75=(a75-a70);
  a126=(a126+a75);
  a123=(a123+a126);
  a126=(a27*a12);
  a75=(a169*a126);
  a70=(a222*a215);
  a75=(a75-a70);
  a70=(a169*a12);
  a74=(a196*a215);
  a70=(a70-a74);
  a75=(a75-a70);
  a70=(a98/a149);
  a74=(a231*a17);
  a70=(a70-a74);
  a74=(a209*a70);
  a121=(a226*a17);
  a74=(a74-a121);
  a75=(a75+a74);
  a74=(a216*a75);
  a121=(a225*a32);
  a74=(a74+a121);
  a126=(a196*a126);
  a121=(a222*a12);
  a126=(a126+a121);
  a121=(a40*a215);
  a126=(a126-a121);
  a121=(a221*a70);
  a98=(a226*a98);
  a121=(a121+a98);
  a126=(a126-a121);
  a121=(a202*a126);
  a98=(a228*a78);
  a121=(a121+a98);
  a74=(a74+a121);
  a121=(a38*a70);
  a98=(a226*a71);
  a121=(a121+a98);
  a74=(a74+a121);
  a123=(a123-a74);
  a123=(a182*a123);
  a13=(a13+a123);
  a135=(a135-a13);
  a135=(a135/a49);
  a13=(a134*a193);
  a123=(a152*a62);
  a13=(a13-a123);
  a123=(a225*a129);
  a74=(a182*a75);
  a123=(a123+a74);
  a13=(a13-a123);
  a13=(a134*a13);
  a123=(a227*a62);
  a13=(a13-a123);
  a123=(a134*a178);
  a74=(a223*a62);
  a123=(a123-a74);
  a74=(a228*a129);
  a121=(a182*a126);
  a74=(a74+a121);
  a123=(a123-a74);
  a123=(a182*a123);
  a74=(a230*a129);
  a123=(a123+a74);
  a13=(a13-a123);
  a123=(a6*a13);
  a135=(a135+a123);
  a123=(a152*a129);
  a193=(a182*a193);
  a123=(a123+a193);
  a75=(a134*a75);
  a193=(a225*a62);
  a75=(a75-a193);
  a123=(a123+a75);
  a123=(a134*a123);
  a75=(a208*a62);
  a123=(a123-a75);
  a75=(a223*a129);
  a178=(a182*a178);
  a75=(a75+a178);
  a126=(a134*a126);
  a178=(a228*a62);
  a126=(a126-a178);
  a75=(a75+a126);
  a75=(a182*a75);
  a126=(a201*a129);
  a75=(a75+a126);
  a123=(a123-a75);
  a123=(a123/a49);
  a13=(a217*a13);
  a123=(a123-a13);
  a123=(a60*a123);
  a135=(a135+a123);
  a154=(a154+a135);
  a154=(a3*a154);
  a154=(a2*a154);
  a154=(-a154);
  if (res[5]!=0) res[5][3]=a154;
  a203=(a4*a203);
  a26=(a26+a203);
  a197=(a4*a197);
  a26=(a26+a197);
  a71=(a71/a149);
  a17=(a157*a17);
  a71=(a71-a17);
  a17=(a60*a129);
  a197=(a53*a62);
  a203=(a134*a135);
  a197=(a197+a203);
  a17=(a17-a197);
  a17=(a17-a32);
  a32=(a118*a17);
  a146=(a220*a146);
  a32=(a32-a146);
  a70=(a214*a70);
  a62=(a60*a62);
  a129=(a53*a129);
  a135=(a182*a135);
  a129=(a129-a135);
  a62=(a62+a129);
  a62=(a62+a78);
  a78=(a226*a62);
  a70=(a70-a78);
  a32=(a32-a70);
  a71=(a71-a32);
  a26=(a26+a71);
  a26=(a3*a26);
  a26=(a2*a26);
  if (res[5]!=0) res[5][4]=a26;
  a212=(a4*a212);
  a212=(a212-a29);
  a64=(a4*a64);
  a212=(a212+a64);
  a213=(a27*a213);
  a17=(a17-a71);
  a17=(a169*a17);
  a215=(a139*a215);
  a17=(a17-a215);
  a12=(a214*a12);
  a62=(a196*a62);
  a12=(a12-a62);
  a17=(a17+a12);
  a17=(a17-a14);
  a17=(a23*a17);
  a17=(a17+a71);
  a213=(a213-a17);
  a212=(a212+a213);
  a212=(a3*a212);
  a212=(a2*a212);
  if (res[5]!=0) res[5][5]=a212;
  a212=(a23*a15);
  a213=(a0-a212);
  a17=(a37*a213);
  a212=(a212-a17);
  a212=(a8*a212);
  a17=(a23*a18);
  a71=(a48*a213);
  a17=(a17+a71);
  a17=(a10*a17);
  a212=(a212-a17);
  a212=(a212/a52);
  a8=(a8*a212);
  a37=(a37*a8);
  a10=(a10*a212);
  a48=(a48*a10);
  a37=(a37+a48);
  a213=(a213/a36);
  a37=(a37-a213);
  a213=(a73*a37);
  a36=(a82*a213);
  a48=(a73*a212);
  a52=(a80*a48);
  a17=(a79*a52);
  a36=(a36-a17);
  a18=(a18*a10);
  a8=(a8+a37);
  a15=(a15*a8);
  a18=(a18-a15);
  a18=(a23*a18);
  a18=(a18+a37);
  a18=(a27-a18);
  a73=(a73*a18);
  a15=(a73+a213);
  a8=(a91*a15);
  a48=(a72*a48);
  a10=(a48+a213);
  a17=(a88*a10);
  a71=(a85*a52);
  a17=(a17+a71);
  a71=(a28*a17);
  a8=(a8-a71);
  a71=(a91*a15);
  a14=(a28*a17);
  a71=(a71-a14);
  a71=(a0+a71);
  a14=(a23*a71);
  a91=(a91*a73);
  a17=(a87*a17);
  a91=(a91-a17);
  a17=(a27*a91);
  a14=(a14-a17);
  a8=(a8+a14);
  a14=(a85*a8);
  a97=(a97*a15);
  a17=(a88*a52);
  a10=(a85*a10);
  a17=(a17-a10);
  a15=(a17-a15);
  a28=(a28*a15);
  a97=(a97+a28);
  a96=(a96*a73);
  a87=(a87*a17);
  a96=(a96+a87);
  a97=(a97-a96);
  a96=(a88*a97);
  a14=(a14-a96);
  a36=(a36+a14);
  a14=(a0-a14);
  a96=(a82*a213);
  a87=(a79*a52);
  a96=(a96-a87);
  a14=(a14-a96);
  a96=(a103*a14);
  a82=(a82*a213);
  a52=(a79*a52);
  a82=(a82-a52);
  a100=(a100*a82);
  a89=(a89*a213);
  a52=(a79*a48);
  a89=(a89-a52);
  a108=(a108*a89);
  a100=(a100+a108);
  a96=(a96+a100);
  a36=(a36-a96);
  a36=(a72*a36);
  a106=(a106*a213);
  a48=(a48+a213);
  a79=(a79*a48);
  a106=(a106-a79);
  a8=(a88*a8);
  a97=(a85*a97);
  a8=(a8+a97);
  a106=(a106+a8);
  a112=(a112*a82);
  a115=(a115*a89);
  a112=(a112+a115);
  a115=(a113*a14);
  a112=(a112-a115);
  a106=(a106-a112);
  a106=(a80*a106);
  a36=(a36-a106);
  a36=(a36/a116);
  a116=(a4*a36);
  a212=(a212+a116);
  a72=(a72*a36);
  a72=(a72+a82);
  a103=(a103*a72);
  a80=(a80*a36);
  a80=(a80-a89);
  a113=(a113*a80);
  a103=(a103+a113);
  a14=(a14/a102);
  a103=(a103-a14);
  a14=(a59*a103);
  a102=(a131*a14);
  a113=(a5*a37);
  a113=(a55*a113);
  a77=(a77*a113);
  a89=(a130*a77);
  a36=(a59*a36);
  a82=(a58*a36);
  a89=(a89-a82);
  a82=(a136*a89);
  a102=(a102+a82);
  a71=(a27*a71);
  a88=(a88*a80);
  a72=(a72+a103);
  a85=(a85*a72);
  a88=(a88-a85);
  a88=(a88-a91);
  a88=(a23*a88);
  a88=(a88+a103);
  a71=(a71-a88);
  a59=(a59*a71);
  a88=(a59+a14);
  a91=(a145*a88);
  a5=(a5*a18);
  a55=(a55*a5);
  a25=(a25*a55);
  a5=(a144*a25);
  a41=(a41*a113);
  a130=(a130*a41);
  a36=(a120*a36);
  a130=(a130+a36);
  a36=(a130+a14);
  a113=(a142*a36);
  a5=(a5-a113);
  a113=(a141*a89);
  a138=(a138*a55);
  a55=(a131*a138);
  a113=(a113-a55);
  a5=(a5+a113);
  a113=(a95*a5);
  a91=(a91+a113);
  a113=(a95*a5);
  a55=(a145*a88);
  a113=(a113+a55);
  a113=(a0+a113);
  a55=(a23*a113);
  a145=(a145*a59);
  a5=(a147*a5);
  a145=(a145+a5);
  a5=(a27*a145);
  a55=(a55-a5);
  a91=(a91+a55);
  a55=(a141*a91);
  a5=(a151*a138);
  a55=(a55-a5);
  a5=(a162*a25);
  a161=(a161*a88);
  a144=(a144*a138);
  a36=(a141*a36);
  a144=(a144+a36);
  a36=(a131*a25);
  a85=(a142*a89);
  a36=(a36+a85);
  a144=(a144+a36);
  a88=(a144+a88);
  a95=(a95*a88);
  a161=(a161-a95);
  a159=(a159*a59);
  a147=(a147*a144);
  a159=(a159-a147);
  a161=(a161-a159);
  a159=(a142*a161);
  a5=(a5+a159);
  a55=(a55-a5);
  a102=(a102+a55);
  a22=(a22*a25);
  a5=(a27*a138);
  a159=(a141*a5);
  a147=(a163*a138);
  a159=(a159+a147);
  a22=(a22-a159);
  a159=(a22/a128);
  a67=(a67*a22);
  a159=(a159+a67);
  a67=(a168*a159);
  a55=(a0-a55);
  a147=(a136*a89);
  a144=(a131*a14);
  a147=(a147+a144);
  a55=(a55-a147);
  a147=(a165*a55);
  a67=(a67+a147);
  a147=(a153*a159);
  a144=(a165*a22);
  a147=(a147+a144);
  a147=(a22+a147);
  a144=(a174*a147);
  a131=(a131*a14);
  a89=(a136*a89);
  a131=(a131+a89);
  a89=(a132*a131);
  a144=(a144+a89);
  a163=(a163*a25);
  a5=(a142*a5);
  a163=(a163-a5);
  a5=(a141*a25);
  a89=(a142*a138);
  a5=(a5-a89);
  a163=(a163-a5);
  a5=(a165*a163);
  a89=(a179*a159);
  a5=(a5-a89);
  a5=(a163+a5);
  a89=(a140*a5);
  a143=(a143*a14);
  a59=(a136*a130);
  a143=(a143-a59);
  a59=(a181*a143);
  a89=(a89+a59);
  a144=(a144+a89);
  a67=(a67+a144);
  a102=(a102-a67);
  a102=(a120*a102);
  a166=(a166*a41);
  a102=(a102-a166);
  a176=(a176*a77);
  a167=(a167*a14);
  a130=(a130+a14);
  a136=(a136*a130);
  a167=(a167-a136);
  a151=(a151*a25);
  a91=(a142*a91);
  a151=(a151+a91);
  a161=(a141*a161);
  a162=(a162*a138);
  a161=(a161-a162);
  a151=(a151+a161);
  a167=(a167+a151);
  a151=(a27*a25);
  a161=(a141*a151);
  a162=(a180*a138);
  a161=(a161-a162);
  a162=(a141*a25);
  a91=(a142*a138);
  a162=(a162-a91);
  a161=(a161-a162);
  a162=(a163/a128);
  a204=(a204*a22);
  a162=(a162-a204);
  a153=(a153*a162);
  a204=(a184*a22);
  a153=(a153-a204);
  a161=(a161+a153);
  a174=(a174*a161);
  a153=(a183*a131);
  a174=(a174+a153);
  a151=(a142*a151);
  a180=(a180*a25);
  a151=(a151+a180);
  a171=(a171*a138);
  a151=(a151-a171);
  a179=(a179*a162);
  a163=(a184*a163);
  a179=(a179+a163);
  a151=(a151-a179);
  a140=(a140*a151);
  a179=(a186*a143);
  a140=(a140+a179);
  a174=(a174+a140);
  a168=(a168*a162);
  a140=(a184*a55);
  a168=(a168-a140);
  a174=(a174+a168);
  a167=(a167-a174);
  a167=(a58*a167);
  a176=(a176+a167);
  a102=(a102-a176);
  a102=(a102/a187);
  a176=(a120*a147);
  a167=(a132*a41);
  a176=(a176-a167);
  a167=(a183*a77);
  a174=(a58*a161);
  a167=(a167+a174);
  a176=(a176-a167);
  a176=(a120*a176);
  a185=(a185*a41);
  a176=(a176-a185);
  a185=(a120*a5);
  a167=(a181*a41);
  a185=(a185-a167);
  a167=(a186*a77);
  a174=(a58*a151);
  a167=(a167+a174);
  a185=(a185-a167);
  a185=(a58*a185);
  a188=(a188*a77);
  a185=(a185+a188);
  a176=(a176-a185);
  a190=(a190*a176);
  a102=(a102+a190);
  a132=(a132*a77);
  a147=(a58*a147);
  a132=(a132+a147);
  a161=(a120*a161);
  a183=(a183*a41);
  a161=(a161-a183);
  a132=(a132+a161);
  a132=(a120*a132);
  a164=(a164*a41);
  a132=(a132-a164);
  a181=(a181*a77);
  a5=(a58*a5);
  a181=(a181+a5);
  a151=(a120*a151);
  a186=(a186*a41);
  a151=(a151-a186);
  a181=(a181+a151);
  a181=(a58*a181);
  a122=(a122*a77);
  a181=(a181+a122);
  a132=(a132-a181);
  a132=(a132/a187);
  a175=(a175*a176);
  a132=(a132-a175);
  a132=(a60*a132);
  a102=(a102+a132);
  a132=(a4*a102);
  a212=(a212+a132);
  a132=(a56*a103);
  a132=(a2*a132);
  a86=(a86*a132);
  a175=(a11*a86);
  a176=(a2*a102);
  a187=(a182*a176);
  a175=(a175-a187);
  a187=(a198*a175);
  a55=(a55/a128);
  a127=(a127*a22);
  a55=(a55+a127);
  a127=(a60*a77);
  a22=(a192*a41);
  a120=(a120*a102);
  a22=(a22+a120);
  a127=(a127-a22);
  a127=(a127-a131);
  a165=(a165*a127);
  a191=(a191*a159);
  a165=(a165-a191);
  a162=(a172*a162);
  a41=(a60*a41);
  a192=(a192*a77);
  a58=(a58*a102);
  a192=(a192-a58);
  a41=(a41+a192);
  a41=(a41+a143);
  a184=(a184*a41);
  a162=(a162-a184);
  a165=(a165-a162);
  a55=(a55+a165);
  a165=(a2*a55);
  a162=(a61*a165);
  a187=(a187-a162);
  a113=(a27*a113);
  a127=(a127+a55);
  a141=(a141*a127);
  a65=(a65*a138);
  a141=(a141-a65);
  a172=(a172*a25);
  a142=(a142*a41);
  a172=(a172-a142);
  a141=(a141+a172);
  a141=(a141-a145);
  a141=(a23*a141);
  a141=(a141-a55);
  a113=(a113-a141);
  a141=(a2*a113);
  a145=(a141-a165);
  a172=(a177*a145);
  a56=(a56*a71);
  a56=(a2*a56);
  a68=(a68*a56);
  a142=(a119*a68);
  a7=(a7*a132);
  a11=(a11*a7);
  a176=(a134*a176);
  a11=(a11+a176);
  a176=(a165-a11);
  a132=(a196*a176);
  a142=(a142+a132);
  a132=(a169*a175);
  a93=(a93*a56);
  a56=(a61*a93);
  a132=(a132-a56);
  a142=(a142+a132);
  a132=(a63*a142);
  a172=(a172+a132);
  a132=(a63*a142);
  a56=(a177*a145);
  a132=(a132+a56);
  a132=(a0+a132);
  a56=(a23*a132);
  a177=(a177*a141);
  a142=(a158*a142);
  a177=(a177+a142);
  a142=(a27*a177);
  a56=(a56-a142);
  a172=(a172+a56);
  a56=(a169*a172);
  a142=(a199*a93);
  a56=(a56-a142);
  a142=(a206*a68);
  a205=(a205*a145);
  a176=(a169*a176);
  a119=(a119*a93);
  a176=(a176-a119);
  a119=(a61*a68);
  a41=(a196*a175);
  a119=(a119+a41);
  a176=(a176-a119);
  a145=(a176-a145);
  a63=(a63*a145);
  a205=(a205+a63);
  a155=(a155*a141);
  a158=(a158*a176);
  a155=(a155+a158);
  a205=(a205-a155);
  a155=(a196*a205);
  a142=(a142+a155);
  a56=(a56-a142);
  a187=(a187+a56);
  a21=(a21*a68);
  a142=(a27*a93);
  a155=(a169*a142);
  a158=(a207*a93);
  a155=(a155+a158);
  a21=(a21-a155);
  a155=(a21/a149);
  a84=(a84*a21);
  a155=(a155+a84);
  a84=(a38*a155);
  a0=(a0-a56);
  a56=(a198*a175);
  a158=(a61*a165);
  a56=(a56-a158);
  a0=(a0-a56);
  a56=(a118*a0);
  a84=(a84+a56);
  a56=(a209*a155);
  a158=(a118*a21);
  a56=(a56+a158);
  a56=(a21+a56);
  a158=(a216*a56);
  a175=(a198*a175);
  a61=(a61*a165);
  a175=(a175-a61);
  a61=(a152*a175);
  a158=(a158+a61);
  a207=(a207*a68);
  a142=(a196*a142);
  a207=(a207-a142);
  a142=(a169*a68);
  a61=(a196*a93);
  a142=(a142-a61);
  a207=(a207-a142);
  a142=(a118*a207);
  a61=(a221*a155);
  a142=(a142-a61);
  a142=(a207+a142);
  a61=(a202*a142);
  a148=(a148*a165);
  a176=(a198*a11);
  a148=(a148+a176);
  a176=(a223*a148);
  a61=(a61-a176);
  a158=(a158+a61);
  a84=(a84+a158);
  a187=(a187-a84);
  a187=(a134*a187);
  a210=(a210*a7);
  a187=(a187-a210);
  a218=(a218*a86);
  a11=(a165-a11);
  a198=(a198*a11);
  a211=(a211*a165);
  a198=(a198-a211);
  a199=(a199*a68);
  a172=(a196*a172);
  a199=(a199+a172);
  a205=(a169*a205);
  a206=(a206*a93);
  a205=(a205-a206);
  a199=(a199+a205);
  a198=(a198+a199);
  a199=(a27*a68);
  a205=(a169*a199);
  a206=(a222*a93);
  a205=(a205-a206);
  a206=(a169*a68);
  a172=(a196*a93);
  a206=(a206-a172);
  a205=(a205-a206);
  a206=(a207/a149);
  a231=(a231*a21);
  a206=(a206-a231);
  a209=(a209*a206);
  a231=(a226*a21);
  a209=(a209-a231);
  a205=(a205+a209);
  a216=(a216*a205);
  a209=(a225*a175);
  a216=(a216+a209);
  a199=(a196*a199);
  a222=(a222*a68);
  a199=(a199+a222);
  a40=(a40*a93);
  a199=(a199-a40);
  a221=(a221*a206);
  a207=(a226*a207);
  a221=(a221+a207);
  a199=(a199-a221);
  a202=(a202*a199);
  a221=(a228*a148);
  a202=(a202-a221);
  a216=(a216+a202);
  a38=(a38*a206);
  a202=(a226*a0);
  a38=(a38-a202);
  a216=(a216+a38);
  a198=(a198-a216);
  a198=(a182*a198);
  a218=(a218+a198);
  a187=(a187-a218);
  a187=(a187/a49);
  a218=(a134*a56);
  a198=(a152*a7);
  a218=(a218-a198);
  a198=(a225*a86);
  a216=(a182*a205);
  a198=(a198+a216);
  a218=(a218-a198);
  a218=(a134*a218);
  a227=(a227*a7);
  a218=(a218-a227);
  a227=(a134*a142);
  a198=(a223*a7);
  a227=(a227-a198);
  a198=(a228*a86);
  a216=(a182*a199);
  a198=(a198+a216);
  a227=(a227-a198);
  a227=(a182*a227);
  a230=(a230*a86);
  a227=(a227+a230);
  a218=(a218-a227);
  a6=(a6*a218);
  a187=(a187+a6);
  a152=(a152*a86);
  a56=(a182*a56);
  a152=(a152+a56);
  a205=(a134*a205);
  a225=(a225*a7);
  a205=(a205-a225);
  a152=(a152+a205);
  a152=(a134*a152);
  a208=(a208*a7);
  a152=(a152-a208);
  a223=(a223*a86);
  a142=(a182*a142);
  a223=(a223+a142);
  a199=(a134*a199);
  a228=(a228*a7);
  a199=(a199-a228);
  a223=(a223+a199);
  a223=(a182*a223);
  a201=(a201*a86);
  a223=(a223+a201);
  a152=(a152-a223);
  a152=(a152/a49);
  a217=(a217*a218);
  a152=(a152-a217);
  a152=(a60*a152);
  a187=(a187+a152);
  a212=(a212+a187);
  a212=(a3*a212);
  a212=(a2*a212);
  a212=(-a212);
  if (res[5]!=0) res[5][6]=a212;
  a103=(a4*a103);
  a37=(a37+a103);
  a55=(a4*a55);
  a37=(a37-a55);
  a0=(a0/a149);
  a157=(a157*a21);
  a0=(a0+a157);
  a157=(a60*a86);
  a21=(a53*a7);
  a134=(a134*a187);
  a21=(a21+a134);
  a157=(a157-a21);
  a157=(a157-a175);
  a118=(a118*a157);
  a220=(a220*a155);
  a118=(a118-a220);
  a206=(a214*a206);
  a60=(a60*a7);
  a53=(a53*a86);
  a182=(a182*a187);
  a53=(a53-a182);
  a60=(a60+a53);
  a148=(a148-a60);
  a226=(a226*a148);
  a206=(a206+a226);
  a118=(a118-a206);
  a0=(a0+a118);
  a37=(a37-a0);
  a37=(a3*a37);
  a37=(a2*a37);
  if (res[5]!=0) res[5][7]=a37;
  a71=(a4*a71);
  a18=(a18+a71);
  a4=(a4*a113);
  a18=(a18+a4);
  a27=(a27*a132);
  a157=(a157+a0);
  a169=(a169*a157);
  a139=(a139*a93);
  a169=(a169-a139);
  a214=(a214*a68);
  a196=(a196*a148);
  a214=(a214+a196);
  a169=(a169+a214);
  a169=(a169-a177);
  a23=(a23*a169);
  a23=(a23-a0);
  a27=(a27-a23);
  a18=(a18+a27);
  a3=(a3*a18);
  a2=(a2*a3);
  if (res[5]!=0) res[5][8]=a2;
}

// Multi-threaded GPU code
template <typename scalar_t>
__global__ void dynamics_kernel_gpu(const scalar_t *q_in_ptr, const scalar_t *qdot_in_ptr, const scalar_t *tau_in_ptr, const scalar_t *h_in_ptr,
                                    scalar_t *q_out_ptr, scalar_t *qdot_out_ptr,
                                    int q_size, int num_threads)
{
  GPU_1D_KERNEL_LOOP(b, num_threads)
  {
    _dynamics_gpu(q_in_ptr + b * q_size, qdot_in_ptr + b * q_size, tau_in_ptr + b * q_size, h_in_ptr + b,
                  q_out_ptr + b * q_size, qdot_out_ptr + b * q_size);
  }
}

template <typename scalar_t>
__global__ void derivatives_kernel_gpu(const scalar_t *q_in_ptr, const scalar_t *qdot_in_ptr, const scalar_t *tau_in_ptr, const scalar_t *h_in_ptr,
                                       scalar_t *q_jac_q_ptr, scalar_t *q_jac_qdot_ptr, scalar_t *q_jac_tau_ptr,
                                       scalar_t *qdot_jac_q_ptr, scalar_t *qdot_jac_qdot_ptr, scalar_t *qdot_jac_tau_ptr,
                                       int q_size, int num_threads)
{
  GPU_1D_KERNEL_LOOP(b, num_threads)
  {
    _derivatives_gpu(q_in_ptr + b * q_size, qdot_in_ptr + b * q_size, tau_in_ptr + b * q_size, h_in_ptr + b,
                     q_jac_q_ptr + b * q_size * q_size, q_jac_qdot_ptr + b * q_size * q_size, q_jac_tau_ptr + b * q_size * q_size,
                     qdot_jac_q_ptr + b * q_size * q_size, qdot_jac_qdot_ptr + b * q_size * q_size, qdot_jac_tau_ptr + b * q_size * q_size);
  }
}

// Torch CPU wrapper
std::vector<torch::Tensor> dynamics_gpu(torch::Tensor q_in, torch::Tensor qdot_in, torch::Tensor tau_in, torch::Tensor h_in)
{
  int batch_size = q_in.size(0);
  int q_size = q_in.size(1);
  torch::Tensor q_out = torch::zeros_like(q_in);
  torch::Tensor qdot_out = torch::zeros_like(q_in);
  using scalar_t = double;

  dynamics_kernel_gpu<scalar_t><<<NUM_BLOCKS(batch_size), NUM_THREADS>>>(
      q_in.data_ptr<scalar_t>(),
      qdot_in.data_ptr<scalar_t>(),
      tau_in.data_ptr<scalar_t>(),
      h_in.data_ptr<scalar_t>(),
      q_out.data_ptr<scalar_t>(),
      qdot_out.data_ptr<scalar_t>(),
      q_size,
      batch_size);

  return {q_out, qdot_out};
}

std::vector<torch::Tensor> derivatives_gpu(torch::Tensor q_in, torch::Tensor qdot_in, torch::Tensor tau_in, torch::Tensor h_in)
{
  int batch_size = q_in.size(0);
  int q_size = q_in.size(1);
  torch::Tensor q_jac_q = torch::zeros({batch_size, q_size, q_size}, q_in.options());
  torch::Tensor q_jac_qdot = torch::zeros({batch_size, q_size, q_size}, q_in.options());
  torch::Tensor q_jac_tau = torch::zeros({batch_size, q_size, q_size}, q_in.options());
  torch::Tensor qdot_jac_q = torch::zeros({batch_size, q_size, q_size}, q_in.options());
  torch::Tensor qdot_jac_qdot = torch::zeros({batch_size, q_size, q_size}, q_in.options());
  torch::Tensor qdot_jac_tau = torch::zeros({batch_size, q_size, q_size}, q_in.options());
  using scalar_t = double;

  derivatives_kernel_gpu<scalar_t><<<NUM_BLOCKS(batch_size), NUM_THREADS>>>(
      q_in.data_ptr<scalar_t>(),
      qdot_in.data_ptr<scalar_t>(),
      tau_in.data_ptr<scalar_t>(),
      h_in.data_ptr<scalar_t>(),
      q_jac_q.data_ptr<scalar_t>(),
      q_jac_qdot.data_ptr<scalar_t>(),
      q_jac_tau.data_ptr<scalar_t>(),
      qdot_jac_q.data_ptr<scalar_t>(),
      qdot_jac_qdot.data_ptr<scalar_t>(),
      qdot_jac_tau.data_ptr<scalar_t>(),
      q_size,
      batch_size);

  return {q_jac_q, q_jac_qdot, q_jac_tau, qdot_jac_q, qdot_jac_qdot, qdot_jac_tau};
}
