# utils.py
import random
import numpy as np
import torch
import pytorch_lightning as pl

def set_seed(seed_value):
    """
    Set the seed for various random number generators to ensure reproducibility.
    
    Args:
        seed_value (int): The random seed value.
    """
    # Set Python random seed
    random.seed(seed_value)
    
    # Set NumPy random seed
    np.random.seed(seed_value)
    
    # Set PyTorch random seed for CPU and CUDA (if available)
    torch.manual_seed(seed_value)
    torch.cuda.manual_seed(seed_value)
    torch.cuda.manual_seed_all(seed_value)  # For multiple GPUs

    # Set PyTorch Lightning seed
    pl.seed_everything(seed_value)

    # Ensure CUDNN is deterministic for reproducibility
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False