from utils.seed import set_seed
from runs.ssl.pretrain import pretrain_motion_encoder
from runs.hyperparameter_search import hyperparameter_optimization, model_configurations

if __name__ == "__main__":

    devices = [
        # 0,
        # 1,
        # 2,
        # 3,
        # 4,
        5,
        # 6,
        # 7,
    ]

    seed = 2002
    set_seed(seed)
    accelerator = "cuda"

    batch_scale_rate = 1

    options = {
        #"pretrain", "finetune", "joint"
        "mode": "pretrain",
        "batch_size": {"device_batch_size":int(32/batch_scale_rate), 
                       "accumulation_steps": int(16*batch_scale_rate)
                       },
        "random_state": seed,
        "dataset_name": [
            "pamap2",
            "dsads",
            "mhealth",
            "realworld2016",
            "ucihar",
            # "uschad",
        ],
        "split_strategy":"by_dataset",
        "split_dataset_assignments": {
            "train": [
            "pamap2",
            "dsads",
            "mhealth",
            "realworld2016",
            "ucihar",
            # "uschad",
        ],
            # "train": ["realworld2016"],
            "val": [],
            "test": [],
        },
        # "allowed_activity_labels": [0, 1, 2, 3, 4, 5],
    }

pretrain_motion_encoder(
        model_name="MoVQFormer",
        options=options,
        devices=devices,
        accelerator=accelerator,
)