import os

def get_project_root():
    """
    Retrieve the project root directory by moving up three levels from the current script.
    This function is useful for standard project directory structures where the code
    is nested within subdirectories of the project root.

    Returns:
        str: The absolute path to the project's root directory.
    """
    current_path = os.path.realpath(__file__)
    return os.path.dirname(os.path.dirname(os.path.dirname(current_path)))

def get_directory_path(directory_name):
    """
    General function to compute the path to a directory named `directory_name`
    that resides in the project root directory. This function reduces redundancy
    by leveraging the `get_project_root` function.

    Args:
        directory_name (str): The name of the directory within the project root.

    Returns:
        str: The absolute path to the specified directory within the project.
    """
    root_path = get_project_root()
    return os.path.join(root_path, directory_name)

# Usage example:
if __name__ == '__main__':
    print("Project root directory:", get_project_root())
    print("Model outputs directory:", get_directory_path("model_outputs"))
    print("Configs directory:", get_directory_path("configs"))
