#!/bin/bash

pushd src/dataset/plugin
cmake -B build -DCMAKE_BUILD_TYPE=Release -GNinja
cmake --build build --parallel
# Compiled extension is hard coded, this may change in different environments
filename=$(ls build | grep -m 1 -E ".*\.cpython-[0-9]{3}-.*\.so")
pybind11-stubgen dataset_utils -o=build --module-path=build/$filename
black build/dataset_utils.pyi
cp build/dataset_utils* ../
popd
