from konductor.init import ExperimentInitConfig
from konductor.metadata.base_statistic import Statistic

from .gym_statistics import GoalAccuracy, Occupancy
from .sc2_statistics import SC2Accuracy


def get_statistics(exp_cfg: ExperimentInitConfig):
    """Get statistics used in experiment based on the configuration of the dataset and model type"""
    model_type = exp_cfg.model[0].type
    data_type = exp_cfg.data[0].dataset.type

    statistics: dict[str, Statistic]
    if data_type == "gym-predict":
        if model_type == "motion-perceiver":
            statistics = {"occupancy": Occupancy.from_config(exp_cfg)}
        elif model_type == "goal-perceiver":
            statistics = {"goal": GoalAccuracy.from_config(exp_cfg)}
        else:
            raise KeyError(f"Unknown {model_type=}")
    elif data_type == "sc2-battle":
        statistics = {"sc2-accuracy": SC2Accuracy.from_config(exp_cfg)}
    else:
        raise KeyError(f"Unknown {data_type=}")

    return statistics
