"""
Deep into training, I always get some stupid NAN, I need
to determine the root cause of this annoying issue.
"""

from pathlib import Path

import numpy as np
import typer
from konductor.init import ExperimentInitConfig
from numpy.lib.npyio import NpzFile


def search_npz(npz_file: Path):
    """Find array in npz file that contains nan"""
    npz_data: NpzFile = np.load(npz_file)
    for name in npz_data.files:
        data = npz_data[name]
        if not np.isfinite(data).all():
            print(f"Nan found {npz_file.stem}/{name}")


def find_nans(exp_path: Path):
    """Run over saved tensors and find where NAN begins"""
    npz_files = [p for p in exp_path.iterdir() if p.suffix == ".npz"]
    npz_files.sort(key=lambda x: x.stem.split("_")[0])
    for npz_file in npz_files:
        search_npz(npz_file)


app = typer.Typer()


@app.command()
def main(run_path: Path):
    config = ExperimentInitConfig.from_run(run_path)
    find_nans(config.exp_path)


if __name__ == "__main__":
    app()
