from __future__ import annotations
import numpy
import os
import sc2_serializer._sc2_serializer
import typing

__all__ = [
    "ItemsView",
    "KeysView",
    "UnitTypeToContiguous",
    "ValuesView",
    "create_replay_subsequence",
    "create_unit_type_to_contiguous_map",
    "gather_unique_unit_types",
    "get_target_coordinates",
    "get_unique_target_coordinates",
    "get_unit_coordinate_indices",
    "get_unit_target_indices",
    "in_bounds_2d",
    "make_unit_type_contiguous",
    "normalize_coordinates_inplace",
]

class ItemsView:
    def __iter__(self: typing.ItemsView) -> typing.Iterator: ...
    def __len__(self: typing.ItemsView) -> int: ...

class KeysView:
    def __contains__(self: typing.KeysView, arg0: typing.Any) -> bool: ...
    def __iter__(self: typing.KeysView) -> typing.Iterator: ...
    def __len__(self: typing.KeysView) -> int: ...

class UnitTypeToContiguous:
    def __bool__(self) -> bool:
        """
        Check whether the map is nonempty
        """

    @typing.overload
    def __contains__(self, arg0: int) -> bool: ...
    @typing.overload
    def __contains__(self, arg0: typing.Any) -> bool: ...
    def __delitem__(self, arg0: int) -> None: ...
    def __getitem__(self, arg0: int) -> int: ...
    def __init__(self) -> None: ...
    def __iter__(self) -> typing.Iterator[int]: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str:
        """
        Return the canonical string representation of this map.
        """

    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    def items(self) -> typing.ItemsView: ...
    def keys(self) -> typing.KeysView: ...
    def values(self) -> typing.ValuesView: ...

class ValuesView:
    def __iter__(self: typing.ValuesView) -> typing.Iterator: ...
    def __len__(self: typing.ValuesView) -> int: ...

def create_replay_subsequence(
    replay_data: sc2_serializer._sc2_serializer.ReplayDataAll, offset: int, nelem: int
) -> sc2_serializer._sc2_serializer.ReplayDataAll:
    """
    Creates replay that is a subsequence of an existing replay given the new beginning (offset) and length (nelem) of the subrange.
    """

def create_unit_type_to_contiguous_map(filepath: os.PathLike) -> UnitTypeToContiguous:
    """
    Read the unit type ids from a file, sort in order for consistency, then create mapping from id to idx into sorted array
    """

def gather_unique_unit_types(
    replay: sc2_serializer._sc2_serializer.StepDataSoA,
) -> set[int]:
    """
    Get the unique unit types from replay data
    """

def get_target_coordinates(
    replay_data: sc2_serializer._sc2_serializer.StepDataSoA, index: int
) -> numpy.ndarray[numpy.int32]:
    """
    Get the target coordinates of order0 of the units, units without target coordinates are filled with (-1,-1).
    """

def get_unique_target_coordinates(
    replay_data: sc2_serializer._sc2_serializer.StepDataSoA, index: int
) -> numpy.ndarray[numpy.int32]:
    """
    Gather the set of unique target position coordinates that units are assigned.
    """

def get_unit_coordinate_indices(
    replay_data: sc2_serializer._sc2_serializer.StepDataSoA,
    index: int,
    coordinates: numpy.ndarray[numpy.int32],
) -> numpy.ndarray[numpy.int64]:
    """
    Returns array that maps units to the index in the array of unique coordinate targets, -1 for no mapping.
    """

def get_unit_target_indices(
    replay_data: sc2_serializer._sc2_serializer.StepDataSoA, index: int
) -> numpy.ndarray[numpy.int64]:
    """
    Returns array that maps units to the index of their target unit, -1 for no mapping.
    """

def in_bounds_2d(
    data: numpy.ndarray[numpy.float32], lower: float, upper: float
) -> numpy.ndarray[bool]:
    """
    Check if position coodinates of 2D array [N, [x,y,...]] are within lower and upper bounds.
    """

def make_unit_type_contiguous(
    data: numpy.ndarray[numpy.float32], index: int, mapping: UnitTypeToContiguous
) -> None:
    """
    Inplace remap original sc2 unit type id to contiguous id. data is an extracted feature tensor where the type id is the last element of the last dimension.
    """

def normalize_coordinates_inplace(
    sequence: list,
    center: numpy.ndarray[numpy.float32],
    size: numpy.ndarray[numpy.float32],
) -> None:
    """
    Inplace apply normalization to coordinates [-1,1] assumes [x,y] are first two elements of last dimension.
    """
