import os
from transformers import AutoModelForCausalLM, AutoTokenizer

checkpoint = "bigcode/starcoder2-15b"

# Get absolute path for cache directory
cache_dir = os.path.abspath("workspace/models/")

# Ensure the cache directory exists
os.makedirs(cache_dir, exist_ok=True)

# Write export line to ~/.bashrc
bashrc_path = os.path.expanduser("~/.bashrc")
export_line = f'export TRANSFORMERS_CACHE="{cache_dir}"\n'

# Avoid duplicate entries
with open(bashrc_path, "r") as f:
    bashrc_contents = f.read()

if export_line.strip() not in bashrc_contents:
    with open(bashrc_path, "a") as f:
        f.write(f"\n# Hugging Face cache path\n{export_line}")
    print(f"Added to {bashrc_path}: {export_line.strip()}")
    print("Please run `source ~/.bashrc` or restart your terminal to activate it globally.")
else:
    print("TRANSFORMERS_CACHE already set in ~/.bashrc")

# Set it for current script
os.environ["TRANSFORMERS_CACHE"] = cache_dir

# Load tokenizer and model using the custom cache
tokenizer = AutoTokenizer.from_pretrained(checkpoint, cache_dir=cache_dir)
model = AutoModelForCausalLM.from_pretrained(checkpoint, cache_dir=cache_dir)

print(f"Cache directory set to: {cache_dir}")
