class array_with_i(list):
    'class of float number with inner attribute i'
    def __init__(self, v):
        super().__init__(v)
        self.i = None
        return None


def ContinuousAgentsMaker(DiscreteAgents):
    '''The function convert two agents for a discrete action space 
    to the agents for the continuous action space'''

    class ContinuousAgents(DiscreteAgents):
        def __init__(self, *args, u_action_values, v_action_values, **kwargs):
            super().__init__(*args, **kwargs)
            self.u_action_values = u_action_values
            self.v_action_values = v_action_values

            if super().fit.__code__.co_argcount==2:
                self.fit = self.fit_by_sessions
            elif super().fit.__code__.co_argcount==7:
                self.fit = self.fit_by_sixes

            return None

        def get_u_action(self, state):
            u_action_i = super().get_u_action(state)
            u_action = array_with_i(self.u_action_values[u_action_i])
            u_action.i = u_action_i
            return u_action

        def get_v_action(self, state):
            v_action_i = super().get_v_action(state)
            v_action = array_with_i(self.v_action_values[v_action_i])
            v_action.i = v_action_i
            return v_action

        def fit_by_sessions(self, sessions):
            for session in sessions:

                u_actions = []
                for u_action in session['u_actions']:
                    u_actions.append(u_action.i)
                session['u_actions'] = u_actions

                v_actions = []
                for v_action in session['v_actions']:
                    v_actions.append(v_action.i)
                session['v_actions'] = v_actions

            super().fit(sessions)
            return None

        def fit_by_sixes(self, state, u_action, v_action, reward, done, next_action):
            super().fit(state, u_action.i, v_action.i, reward, done, next_action)
            return None

    return ContinuousAgents
