import argparse, os, json, shlex, subprocess, shutil
from running.prepare_folders import prepare_folders


def run(config_path, cluster):

    config_file = open(config_path)
    config = json.load(config_file)
    
    result_path = config['result_path']
    if not os.path.exists(result_path):
        os.mkdir(result_path)

    shutil.copy2(config_path, os.path.join(result_path, 'config.json'))
    
    learning_paths, learning_skips = prepare_folders(result_path, folder_type='learning')
    for learning_path, learning_skip in zip(learning_paths, learning_skips):
        if cluster == 'uran':
            cmd = 'srun -n 1 -t 720 --mem-per-cpu 10000 python3.9 running/run_learning.py'
            cmd += f' --path {learning_path} --skip {int(learning_skip)} --cluster {cluster}'
            with open(os.path.join(result_path, 'log.txt'), "a") as outfile:
                subprocess.Popen(shlex.split(cmd), stdout=outfile)
            
        elif cluster == 'local_parallel':
            cmd = 'python3 running/run_learning.py'
            cmd += f' --path {learning_path} --skip {int(learning_skip)} --cluster {cluster}'
            with open(os.path.join(result_path, 'log.txt'), "a") as outfile:
                subprocess.Popen(shlex.split(cmd), stdout=outfile)
            
        elif cluster == 'local_sequentially':
            from running.run_learning import run_learning
            run_learning(path=learning_path, learning_skip=learning_skip, cluster=cluster)
            
        else:
            print('Need to set cluster argument')


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('--config_path', type=str)
    parser.add_argument('--cluster', type=str, default='local_sequentially')
    args = parser.parse_args()
    run(args.config_path, args.cluster)
