import argparse, os, sys, json, inspect, subprocess, shlex, shutil, importlib, time
sys.path.insert(0, os.path.abspath('running/'))
from utils import set_seed, init_env
from prepare_folders import prepare_folders
from run_testing import run_testing


def run_learning(path, learning_skip, cluster):
    
    try:
        if learning_skip:
            print(f'\nLearning has skipped in {path}')
        else:
            start_time = time.time()
            config_file = open(os.path.join(path, 'config.json'))
            config = json.load(config_file)

            set_seed(config['seeds'][0])

            timesteps = int(config['envs'].pop('timestaps'))

            env = init_env(config['envs'])

            alg_name = config['learning'].pop('alg_name')
            learning_setup = importlib.import_module(f'learning_setups.{alg_name}_setup')
            agents, info = learning_setup.learn(env, timesteps, config['learning'])
            learning_setup.save(agents, info, path)

            print(f'\nLearning has finished for {int(time.time() - start_time)}sec in {path}')

    except Exception as exception:
        folder_path = os.path.abspath(os.path.join(path, './'))
        shutil.rmtree(folder_path, ignore_errors=True)
        print(exception)
        print(f'!!!Folder {folder_path} was deleted')
        
    else:
        start_time = time.time()
        sub_paths, testing_skips = prepare_folders(path, folder_type='testing')
        for sub_path, testing_skip in zip(sub_paths, testing_skips):
            if testing_skip:
                print(f'Testing has skipped in {sub_path}')
            else:
                run_testing(sub_path, testing_skip)
        print(f'All testing has finished for {int(time.time() - start_time)}sec in {path}')


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('--path', type=str)
    parser.add_argument('--skip', type=int, default=0)
    parser.add_argument('--cluster', type=str)
    args = parser.parse_args()
    run_learning(args.path, args.skip, args.cluster)
