import argparse, os, sys, json, importlib, shutil, time
from utils import set_seed, init_env
from envs.EnvironmentsWithFixedAgent import EnvironmentsWithFixedAgent


def run_testing(path, skip):
    
    try:
        if not skip:
            start_time = time.time()
            config_file = open(os.path.join(path, 'config.json'))
            config = json.load(config_file)
            
            set_seed(config['testing']['dt_multiplier'])

            timesteps = int(config['envs'].pop('timestaps'))

            env = init_env(config['envs'])

            alg_name = config['learning'].pop('alg_name')
            learning_setup = importlib.import_module(f'learning_setups.{alg_name}_setup')
            learning_path = os.path.abspath(os.path.join(path, '../'))
            u_agent, v_agent = learning_setup.load(env, config['learning'], learning_path)

            dt_multiplier = config['testing'].pop('dt_multiplier')
            opponent_index = list({'u','v'} - {config['agent_index']})[0]
            opponent_agent = eval(f'{opponent_index}_agent')
            opponent_env = EnvironmentsWithFixedAgent(env, opponent_index, opponent_agent, dt_multiplier)

            testing_setup = importlib.import_module('testing_setups.testing_setups')

            info = testing_setup.learn(opponent_env, timesteps, config['testing'])
            testing_setup.save(info, opponent_index, path)

            print(f'Testing has finished for {int(time.time() - start_time)}sec in {path}')
            
    except Exception as exception:
        if os.path.exists(path):
            shutil.rmtree(path, ignore_errors=True)
        print(exception)
        print(f'!!!Folder {path} was deleted')   
    

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('--path', type=str)
    parser.add_argument('--skip', type=int, default=0)
    args = parser.parse_args()
    run_testing(args.path, args.skip)