# 文件结构
```
/code_executor_fastapi
├── Dockerfile         # dockerfile
├── readme.md
├── requirements.txt
└── app
    ├── code_run_test.py     # 测试文件
    └── executor_fastapi.py  #  主文件
```

# 作为服务启动，测试环境
## 环境安装
```bash
conda create -n code_executor_fastapi python=3.11
conda activate code_executor_fastapi
cd code_executor_fastapi
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

## 主要代码
./app/executor_fastapi.py

### 直接作为服务启动
命令启动：
`uvicorn app.executor_fastapi:app --host 0.0.0.0 --port 4323 --timeout-keep-alive 1800`

文件启动：
`python ./app/executor_fastapi.py`

## 测试文件
./app/code_run_test.py

### 
启动方式：
`python ./app/code_run_test.py`


# 作为docker启动，生产环境
## 构建容器命令
`docker build  -t code-executor-fastapi-py310-v1.2 .`


## 查看镜像
```
docker image inspect code-executor-fastapi-py310-v1.2
```

## 安装docker
```
docker run -d \
  -p 4323:4323 \
  -e TIMEOUT=360 \
  --memory="96g" \
  --cpus="16" \
  --security-opt no-new-privileges \
  --cap-drop ALL \
  --read-only \
  --tmpfs /tmp:rw,noexec,nosuid,size=500m \
  --name code-executor-fastapi-py310-v1.2 \
  code-executor-fastapi-py310-v1.2
```

## 启动、停止和删除
```
# 启动docker
docker start code-executor-fastapi-py310-v1.2

# 停止docker
docker stop code-executor-fastapi-py310-v1.2

# 删除已停止的docker
docker rm code-executor-fastapi-py311

# 删除指定镜像
docker rmi code-executor-fastapi-py311
```
