from fastapi import FastAPI, Request
from pydantic import BaseModel
from typing import Optional, Dict, Any
import uvicorn
import json
import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)))
from run_gradio_api import process_question

app = FastAPI()

class QuestionRequest(BaseModel):
    question: str
    default_params_config: dict


@app.post("/v1/chat/completions")
def process_question_api(req: QuestionRequest):

    text, final_answer = process_question(req.question, req.default_params_config)
    return {"answer": text, "final_answer": final_answer}

if __name__ == "__main__":
    uvicorn.run(app, host="0.0.0.0", port=8008) 