from transformers import AutoTokenizer


if __name__ == "__main__":
    tokenizer=AutoTokenizer.from_pretrained("Qwen3-8B")
    messages = [
        {"role": "system", "content": """
    You are a helpful assistant that can solve the given question step by step with the help of the wikipedia search tool and python interpreter tool. \
    Given a question, you need to first think about the reasoning process in the mind and then provide the answer. \
    During thinking, you can invoke the wikipedia search tool to search and python interpreter tool to calculate the math problem for fact information about specific topics if needed. \
    The reasoning process and answer are enclosed within <think> </think> and <answer> </answer> tags respectively, \
    and the search query and result are enclosed within <search> </search> and <result> </result> tags respectively. \
    For example, <think> This is the reasoning process. </think> <search> search query here </search> <result> search result here </result> \
    <think> This is the reasoning process. </think> <python> python code here </python> <result> python interpreter result here </result> \
    <think> This is the reasoning process. </think> <answer> The final answer is \\[ \\boxed{answer here} \\] </answer>. \
    In the last part of the answer, the final exact answer is enclosed within \\boxed{} with latex format.
    """},
    {"role": "user", "content": "Optimize the molecule CC(C)n1c(CNC(=O)c2ccc(Cl)cc2)n[nH]c1=S to have a lower QED value."}
    ]
    text = tokenizer.apply_chat_template(messages, tokenize=False, add_generation_prompt=True)
    print(text)
    token_num = len(tokenizer(text)["input_ids"])
    print(token_num)