import json
import sys
sys.path.append("/xxx/verl/verl/workers/rollout/vllm_rollout")
from urllib.parse import urljoin
import time 
from argparse import Namespace
# from web_search.bing_search import bing_web_search
import re
import asyncio
from openai import OpenAI
# from deep_search_dgt import deep_search_dgt
from transformers import AutoTokenizer
from Tea.exceptions import TeaException
from alibabacloud_iqs20241111 import models
from alibabacloud_iqs20241111.client import Client
from alibabacloud_tea_openapi import models as open_api_models
from typing import List, Dict, Any

def create_client() -> Client:
        config = open_api_models.Config(
            # 推荐使用环境变量方式管理 AK/SK
            access_key_id="xxx",
            access_key_secret="xxx"
        )
        config.endpoint = 'iqs.cn-zhangjiakou.aliyuncs.com'
        return Client(config)

client = create_client()

def quark_search(query) -> List[Dict[str, Any]]:
    """
    使用阿里云 IQS 接口进行统一搜索，返回搜索结果列表。
    :param query: 搜索关键词，例如"杭州美食"
    :return: 包含搜索结果的字典列表
    """
    if query == "":
        return []
    query = query[:100]
    
    run_instances_request = models.UnifiedSearchRequest(
        body=models.UnifiedSearchInput(
            query=query,
            time_range='NoLimit',
            contents=models.RequestContents(
                summary=True,
                main_text=True,
            )
        )
    )

    try:
        response = client.unified_search(run_instances_request)
        # logger.info(
        #     "API 成功, Request ID: %s, 结果数量: %d, 搜索耗时: %s",
        #     response.body.request_id,
        #     len(response.body.page_items),
        #     response.body.search_information.search_time
        # )
        results = []
        # 遍历搜索结果
        for item in response.body.page_items:
            # 处理每个搜索结果
            results.append(item.__dict__)
        return results

    except TeaException as e:
        print(e)
        return []
    

def extract_relevant_info(search_results):
    """
    Extract relevant information from Bing search results.

    Args:
        search_results (dict): JSON response from the Bing Web Search API.

    Returns:
        list: A list of dictionaries containing the extracted information.
    """
    useful_info = []

    for id, result in enumerate(search_results):
        info = {
            'id': id + 1,
            'title': result.get('title', ''),
            'url': result.get('link', ''),
            'site_name': result.get('hostname', ''),
            'date': result.get('published_time', ''),
            'snippet': result.get('snippet', ''),
            'summary': result.get('summary', ''),
            'context': result.get('main_text', '')
        }
        useful_info.append(info)

    
    return useful_info

def deep_search_snippet(search_query, top_k=5, use_jina=False, jina_api_key="empty", bing_subscription_key="your bing api key", bing_endpoint="https://api.bing.microsoft.com/v7.0/search"):
    # 根据函数参数构建 args
    args = Namespace(
        dataset_name='qa',
        split='test',
        subset_num=-1,
        max_search_limit=15,
        top_k=top_k,  # 使用函数参数
        use_jina=use_jina,  # 使用函数参数
        jina_api_key=jina_api_key,  # 使用函数参数
        temperature=0.7,
        top_p=0.8,
        min_p=0.05,
        top_k_sampling=20,
        repetition_penalty=1.05,
        max_tokens=4096,
        bing_subscription_key=bing_subscription_key,  # 使用函数参数
        bing_endpoint=bing_endpoint,  # 使用函数参数
        eval=False,
        seed=1742208600,
        concurrent_limit=200
    )
    # print(args)
    
    search_cache = {}
    url_cache = {}

    question = search_query

    try:
        # 调用必应搜索API
        # results = bing_web_search(question, args.bing_subscription_key, args.bing_endpoint) 
        results = quark_search(question)
        search_cache[question] = results
    except Exception as e:
        print(f"Error during search query '{question}': {e}")
        results = {}
    
    # 提取相关信息并限制结果数量
 
    relevant_info = extract_relevant_info(results)[:args.top_k]
    print("--------------------------------Search Bing Result--------------------------------")

    result = ""
    for info in relevant_info:
        id = info['id']
        title = info['title']
        context = info['summary']
        clean_context = re.sub('<[^<]+?>', '', context)  
        result+= f"搜索结果{id}-标题：{title}\n内容：{clean_context}\n"

    extracted_info = result

    return extracted_info





if __name__ == "__main__":

    extracted_info = ''
    
    
    question = "三角形的勾股定理是什么"


    # result = deep_search_snippet(question)
    result = quark_search(question)
    print('-------------------------------------')
    print(result)
    print('-------------------------------------')

   