
# Open-World Test-Time Training: Self-Training with Contrastive Learning
Traditional test-time training (TTT) methods, while addressing domain shifts, often assume a consistent class set that limits their applicability in real-world scenarios with infinite variety. Open-World Test-Time Training (OWTTT) addresses the challenge of generalizing deep learning models to unknown target domain distributions, especially in the presence of strong Out-of-Distribution (OOD) data. Existing TTT methods often struggle to maintain performance when confronted with strong OOD data. In OWTTT, the primary focus has been on distinguishing between strong and weak OOD data. However, during the early stages of TTT, initial feature extraction is hampered by interference from strong OOD and corruptions, leading to reduced contrast and premature classification of certain classes as strong OOD. To handle this problem, we introduce Open World Dynamic Contrastive Learning (OWDCL), an innovative approach that leverage contrastive learning to augment positive sample pairs. This strategy not only enhances contrast in the early stages but also significantly enhances model robustness in later stages. In comparison datasets, our OWDCL model achieves state-of-the-art performance.


## OWDCL on CIFAR10-C/100-C
Ours method and the baseline method TEST (direct test without adaptation) on CIFAR-10-C/100-C under common corruptions or natural shifts. Our implementation is based on [repo](https://github.com/Gorilla-Lab-SCUT/TTAC/tree/master/cifar) and therefore requires some similar preparation processes.


### Requirements

To install requirements:

```
pip install -r requirements.txt
```

To download datasets:

```
export DATADIR=/data/cifar
mkdir -p ${DATADIR} && cd ${DATADIR}
wget -O CIFAR-10-C.tar https://zenodo.org/record/2535967/files/CIFAR-10-C.tar?download=1
tar -xvf CIFAR-10-C.tar
wget -O CIFAR-100-C.tar https://zenodo.org/record/3555552/files/CIFAR-100-C.tar?download=1
tar -xvf CIFAR-100-C.tar
wget -O tiny-imagenet-200.zip http://cs231n.stanford.edu/tiny-imagenet-200.zip
unzip tiny-imagenet-200.zip
```

### Pre-trained Models

The checkpoints of pre-train Resnet-50 can be downloaded (214MB) using the following command:

```
mkdir -p results/cifar10_joint_resnet50 && cd results/cifar10_joint_resnet50
gdown https://drive.google.com/uc?id=1TWiFJY_q5uKvNr9x3Z4CiK2w9Giqk9Dx && cd ../..
mkdir -p results/cifar100_joint_resnet50 && cd results/cifar100_joint_resnet50
gdown https://drive.google.com/uc?id=1-8KNUXXVzJIPvao-GxMp2DiArYU9NBRs && cd ../..
```

These models are obtained by training on the clean CIFAR10/100 images using semi-supervised SimCLR.

### Open-World Test-Time Training:

We present our method and the baseline method TEST (direct test without adaptation) on CIFAR10-C/100-C.

- run OURS method or the baeline method TEST on CIFAR10-C under the OWTTT protocol.

    ```
    # OURS: 
    bash scripts/ours_cifar10.sh "corruption_type" "strong_ood_type" 

    # TEST: 
    bash scripts/test_cifar10.sh "corruption_type" "strong_ood_type" 
    ```
    Where "corruption_type" is the corruption type in CIFAR10-C, and "strong_ood_type" is the strong OOD type in [noise, MNIST, SVHN, Tiny, cifar100]. 
    
    For example, to run OURS or TEST on CIFAR10-C under the snow corruption with MNIST as strong OOD, we can use the following command:

    ```
    # OURS:
    bash scripts/ours_cifar10.sh snow MNIST 

    # TEST:
    bash scripts/test_cifar10.sh snow MNIST
    ```

    The following results are yielded by the above scripts (%) under the snow corruption, and with MNIST as strong OOD:

    | Method | ACC_S | ACC_N | ACC_H |
    |:------:|:-------:|:-------:|:-------:|
    |  TEST  |   66.36   |    91.56   |   76.95  |
    |  OURS  |   84.05    |    97.46   | 90.26|

- run OURS method or the baeline method TEST on CIFAR100-C under the OWTTT protocol.
    
    ```
    # OURS: 
    bash scripts/ours_cifar100.sh "corruption_type" "strong_ood_type" 

    # TEST: 
    bash scripts/test_cifar100.sh "corruption_type" "strong_ood_type" 
    ```
    Where "corruption_type" is the corruption type in CIFAR100-C, and "strong_ood_type" is the strong OOD type in [noise, MNIST, SVHN, Tiny, cifar10]. 
    
    For example, to run OURS or TEST on CIFAR100-C under the snow corruption with MNIST as strong OOD, we can use the following command:

    ```
    # OURS:
    bash scripts/ours_cifar100.sh snow MNIST 

    # TEST:
    bash scripts/test_cifar100.sh snow MNIST
    ```

    The following results are yielded by the above scripts (%) under the snow corruption, and with MNIST as strong OOD:

    | Method | ACC_S | ACC_N | ACC_H |
    |:------:|:-------:|:-------:|:-------:|
    |  TEST  |   29.2   |    53.27   |   37.72  |
    |  OURS  |   44.78    |    93.56   |  60.57 |


### Acknowledgements

Our code is built upon the public code of the [OWTTT](https://github.com/Yushu-Li/OWTTT/tree/master).