import sys
import time
import argparse
import threading
import webbrowser
from http.server import HTTPServer, SimpleHTTPRequestHandler

parser = argparse.ArgumentParser()
parser.add_argument("-p", "--port", type=int, default=8080)
args = parser.parse_args()

ip = "127.0.0.1"
port = args.port
url = f"http://{ip}:{port}"

def start_server():
    server_address = (ip, port)
    httpd = HTTPServer(server_address, SimpleHTTPRequestHandler)
    httpd.serve_forever()


threading.Thread(target=start_server).start()
webbrowser.open_new(url)

while True:
    try:
        time.sleep(1)
    except KeyboardInterrupt:
        sys.exit(0)
