GPU_ID=0
PROJ_DIR=$(pwd)

# data
cd $PROJ_DIR/data
python mesh_sampler.py -s indhouse/mesh/industry_house.obj -d indhouse/indhouse.npz --n_surf 5000000
DATA_PATH=$PROJ_DIR/data/indhouse/indhouse.npz
echo $DATA_PATH


# train
cd $PROJ_DIR/src
DATA_TAG=$(basename $DATA_PATH .npz)
EXP_DIR=checkpoints/$DATA_TAG
echo $EXP_DIR

python train.py \
    --tag $EXP_DIR \
    --data_path $DATA_PATH \
    --predict_xstart True \
    --enc_net_type skip \
    --enc_lr_decay 0.1 \
    --enc_lr_split 0.2 \
    --gpu_id $GPU_ID


# sample
python sample.py \
    --tag $EXP_DIR \
    --n_samples 10 \
    --n_faces 50000 \
    --output results10 \
    --gpu_id $GPU_ID
