from .fno1d import FNO1D
from .unet1d_2 import UNet1D_2
from .unet1d import UNet1D
from .pde_refiner import PDERefiner
from .pde_refiner import PDERefiner_2
from .deq_fno import DEQFNO
from .ddpm import DiffusionModel
# Dictionary mapping model names to their classes
MODEL_REGISTRY = {
    'fno1d': FNO1D, 
    'unet1d': UNet1D,
    'PDERefiner': PDERefiner,
    'PDERefiner_2': PDERefiner_2,
    'deq_fno': DEQFNO,
    'ddpm': DiffusionModel,
} 

__all__ = ['MODEL_REGISTRY'] 