from .architectures import _ARCHITECTURE_REGISTRY
from .wrappers import _WRAPPER_REGISTRY

_MODEL_REGISTRY = {
    **_ARCHITECTURE_REGISTRY,
    **_WRAPPER_REGISTRY,
}

def get_model(name: str):
    return _MODEL_REGISTRY[name]

__all__ = [
    'get_model',
]